# QCMDB::Config -- Config handles the configuration for the QCMDB
#
# Written by Digant C Kasundra <digant@stanford.edu>
# Copyright 2009 Board of Trustees, Leland Stanford Jr. University
#
# See LICENSE for licensing terms.

#############################################################################
# Modules and declarations
#############################################################################

package QCMDB::Config;

use strict;
use vars qw($VERSION);

use AppConfig;

$VERSION = '0.01';


##############################################################################
# Constructor, destructor, and accessors
##############################################################################

# Create a new config object that loads information from the config file
sub new {
    my ($class, $cfgfile) = @_;
    # database setup values.
    # We use CREATE=true b/c we reuse this config file in various areas and
    # only want to pull out the variables we care about
    my $DBCONF = AppConfig->new({CREATE=>1}, 'database=s', 'host=s', 'port=d', 
        'username=s', 'password=s');
    if (!$DBCONF->file($cfgfile)) {
        return;
    }
    our $DBNAME = $DBCONF->database();
    our $DBHOST = $DBCONF->host();
    our $DBPORT = $DBCONF->port();
    our $DBUSER = $DBCONF->username();
    our $DBPW   = $DBCONF->password();

    my $self = {
        dbname => $DBCONF->database(),
        dbhost => $DBCONF->host(),
        dbport => $DBCONF->port(),
        dbuser => $DBCONF->username(),
        dbpw   => $DBCONF->password(),
    };

    bless ($self, $class);
    return $self;
}
