SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";


CREATE TABLE IF NOT EXISTS `cmdb_itemprops` (
  `iid` int(11) NOT NULL COMMENT 'Item ID',
  `pid` int(11) NOT NULL COMMENT 'Property name ID',
  `value` varchar(512) NOT NULL,
  PRIMARY KEY  (`iid`,`pid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


CREATE TABLE IF NOT EXISTS `cmdb_items` (
  `id` int(11) NOT NULL auto_increment,
  `type` int(11) NOT NULL,
  `mdrId` varchar(128) NOT NULL,
  `localId` varchar(512) NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1;


CREATE TABLE IF NOT EXISTS `cmdb_propnames` (
  `id` int(11) NOT NULL auto_increment COMMENT 'Property''s ID',
  `name` varchar(255) NOT NULL COMMENT 'Property name',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 COMMENT='Translates property ids into names';

CREATE TABLE IF NOT EXISTS `cmdb_relprops` (
  `rid` int(11) NOT NULL COMMENT 'Relationship ID',
  `pid` int(11) NOT NULL COMMENT 'Prop name ID',
  `value` varchar(512) NOT NULL,
  PRIMARY KEY  (`rid`,`pid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


CREATE TABLE IF NOT EXISTS `cmdb_rels` (
  `id` int(11) NOT NULL auto_increment,
  `type` int(11) NOT NULL,
  `name` varchar(128) NOT NULL,
  `mdrId` varchar(128) NOT NULL,
  `localId` varchar(512) NOT NULL,
  `source` int(11) NOT NULL,
  `target` int(11) NOT NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1;


CREATE TABLE IF NOT EXISTS `cmdb_typenames` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(128) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1;

