import tempfile
import os
import subprocess
from subprocess import call

class CSR(object):

  country      = 'US'
  state        = 'California'
  locality     = 'Stanford'
  organization = 'Stanford University'
  organizationalUnit = 'IT Services'
  commonName   = None

  csr_string   = None

  ###   ###   ###   ###   ###   ###   ###   ###   ###   ###   ###
  def to_s(self):

    return """
common name:        %s
country:            %s
state:              %s
locality:           %s
organization:       %s
organizationalUnit: %s
csr_string:
%s
""" % (
       self.commonName,
       self.country,
       self.state,
       self.locality,
       self.organization,
       self.organizationalUnit,
       self.csr_string,
      )
  ###   ###   ###   ###   ###   ###   ###   ###   ###   ###   ###
  def make(self):
    if (self.commonName is None):
      raise Exception("cannot create a CSR without a common name")

    # 1. Make some temporary files
    (temp_config_fd, temp_config_filename) = tempfile.mkstemp(suffix=".tmpcsr")
    (temp_csr_fd, temp_csr_filename)       = tempfile.mkstemp(suffix=".tmpcsr")
    (temp_key_fd, temp_key_filename)       = tempfile.mkstemp(suffix=".tmpcsr")

    # 2. Write the template to the config temporary file.
    os.write(temp_config_fd, self.template())
    os.close(temp_config_fd)

    # 3. Set up the openssl command
    openssl_args = [
                    '/usr/bin/openssl',
                    'req',
                    '-new',
                    '-nodes',
                    '-newkey', 'rsa:2048',
                    '-config', temp_config_filename,
                    '-keyout', temp_key_filename,
                    '-out',    temp_csr_filename,
                    '-batch',
                   ]

    FNULL = open('/dev/null', 'w')
    retcode = call(openssl_args, stdout=FNULL, stderr=FNULL)
    FNULL.close()

    # Grab the csr string
    # From https://stackoverflow.com/questions/1631897/python-file-slurp
    with open(temp_csr_filename) as x: self.csr_string = x.read()

    # 4. Clean up
    os.unlink(temp_config_filename)
    os.unlink(temp_csr_filename)
    os.unlink(temp_key_filename)

    return self.template

  ###   ###   ###   ###   ###   ###   ###   ###   ###   ###   ###
  def template(self):
    return """
[req]
distinguished_name = req_distinguished_name

[req_distinguished_name]
countryName                     = Country Name (2 letter code)
stateOrProvinceName             = State or Province Name (full name)
localityName                    = Locality Name (city, district)
organizationName                = Organization Name (company)
organizationalUnitName          = Organizational Unit Name (department, division)
commonName                      = Common Name (hostname, IP, or your name)

countryName_default             = %s
stateOrProvinceName_default     = %s
localityName_default            = %s
organizationName_default        = %s
organizationalUnitName_default  = %s
commonName_default              = %s
""" % (self.country, self.state, self.locality, self.organization,
     self.organizationalUnit, self.commonName)
