# NAME

puppetca-backend - remctl interface for the Puppet Certificate Authority

# SYNOPSIS

**puppetca-backend** --help|-h

**puppetca-backend** --manual|-m

**puppetca-backend** \[-v\] \[-k\] ( sign | revoke | clean ) _hostname_

**puppetca-backend** \[-v\] \[-k\] ( list-signed | list-unsigned | list-all )

# DESCRIPTION

This is a Perl wrapper script for some operations and tools useful for
maintaining the puppet cert authority. Use the `-k` option when running
in a Kubernetes context.

# ACTIONS

- list-unsigned

    List of certificates waiting to be signed.

- list-all

    List of all certificates (signed, unsigned, revoked, etc).

- sign _hostname_

    Sign certificate with server name _hostname_.

- revoke _hostname_

    Revoke the certificate of a client.

- clean _hostname_

    Revoke a host's certificate (if applicable) and remove all files
    related to that host from puppet cert's storage.

# OPTIONS

- **--kubectl|-k**

    Use kubetctl rather than running the commands directly. Thus,
    `puppetca-backend -k list` is equivalent to
    `kubectl exec $HOSTNAME -- puppetserver ca list --all`.

# AUTHOR

Digant C Kasundra <digant@stanford.edu>

Updated by Adam H. Lewenberg <adamhl@stanford.edu>

# COPYRIGHT

Copyright 2007, 2010, 2017, 2021 Board of Trustees, Leland Stanford Jr. University.
