# NAME

pdb-backend - query and interact with PuppetDB using PQL

# SYNOPSIS

**pdb-backend** help

**pdb-backend** manual

**pdb-backend** \[options\] listnodes

**pdb-backend** \[options\] listnodes-raw

**pdb-backend** \[options\] listfacts

**pdb-backend** \[options\] query &lt;query>

**pdb-backend** \[options\] delnode &lt;fqdn>

# DESCRIPTION

The main purpose for this script is to run PQL queries against the
PuppetDB database using `puppetdb-cli`; see also
https://puppet.com/blog/introducing-puppet-query-language-pql and
https://github.com/puppetlabs/puppetdb-cli

## **help**

Display the short help string and exit.

## **manual**

Display man page and exit.

## **listnodes**

The **listnodes** command lists the fully-qualified domain name of
every node in the Puppet DB.

## **listnodes-raw**

The **listnodes-raw** command displays a list of node certnames in the
format that Puppet DB returns without attempting to parse. Use
**listnodes-raw** when the **listnodes** command gives you a JSON parse
error.

## **query**

Run a PQL query against the PuppetDB. For details on PQL, see
https://puppet.com/blog/introducing-puppet-query-language-pql

All results are returned as a JSON string. Use the `jq` command-line
utility to parse the returned results. If you pipe to `jq` and see an
error like "parse error: Invalid string: control characters from U+0000
through U+001F must be escaped" try piping first through `tr`:

    $ pdb-backend query <query> | tr '\r\n' ' ' | jq '.'

To retrieve facts, use the **facts** query. Each fact
is a four-tuple consisting of `certname` (the server name),
`environment` (e.g., "production"), `name` (the
name of the fact), and `value` (the value of the fact).
Note that `certname` is usually fully-qualified.

If you need to descend into structured facts, use the
**fact\_contents** action.

You can also use the **nodes** action to get Puppet-related information on
nodes.

### OPTIONS

- **-v|--verbose**

    Show extra information useful when debugging script.

- **-c|--config** PATH

    Specify the path to the puppetdb\_cli configuration. Defaults to
    **/etc/puppetdb\_cli.conf**. If the environment variable
    `PUPPET_QUERY_CONFIG_PATH` is set then the value of
    `PUPPET_QUERY_CONFIG_PATH` will be used as the configuration file
    path. Note that if the **--config** option is used AND the
    `PUPPET_QUERY_CONFIG_PATH` environment variable is set, the environment
    variable value "wins".

### EXAMPLES

    # Show all facts for host 'puppetservice6.stanford.edu'
    pdb-backend query 'facts { certname = "puppetservice6.stanford.edu" }'

    # Return the 'kernel' fact for all nodes
    pdb-backend query 'facts { name = "kernel" }'

    # Return the 'kernel' fact for host 'puppetservice6.stanford.edu'
    pdb-backend query 'facts { certname ~ "puppetservice6.stanford.edu" and name = "kernel" }'

    # Return just the value of the 'kernel' fact for host 'puppetservice6.stanford.edu'
    pdb-backend query 'facts[value] { certname ~ "puppetservice6.stanford.edu" and name = "kernel" }'

    # Return all nodes that whose major distro release number is "10".
    pdb-backend query 'fact_contents[certname] { (path ~> ["os", "distro", "release", "major"]) and (value = "10") }'

    # Return all nodes running in the "production" environment.
    pdb-backend query 'nodes[certname] { report_environment = "production" }'

    # Subqueries are supported.
    # Return all nodes running in the "production" environment whose
    # kernel is 4.1.12
    pdb-backend query 'nodes[certname] { report_environment = "production" and certname in facts[certname] {name = "kernelrelease" and value ~ "4.1.12"} }'

## **delnode**

To remove a node from the PuppetDB, use the `delnode` command. The
argument to this command should be the full-qualified domain name of the
node to delete. This command does a "node clean" (remove certificates and
PuppetDB data) followed by a "node deactivate".

# AUTHOR

Adam H. Lewenberg <adamhl@stanford.edu>

# SEE ALSO

puppet(8)
