# NAME

git-info - Show Puppet Git repository commit information

# SYNOPSIS

git-info _action_ \[options\] \[regular-expression\]

# DESCRIPTION

**git-info** displays the last commit information for Puppet Git
repositories on a Puppet server. The **git-info** script supports both
Puppet Enterprise and Puppet Open Source. That is, for each Git repository
on the Puppet server, it finds the latest commit date among all
that repository's branches and displays that date. Note that the only
commit information provided by this utility is commit hash, author name,
and commit date.

The repositories returned will be those that match the Perl-compatible
**regular-expression**.  If **regular-expression** is omitted all
repositories will be returned.

For Puppet Enterprise the output will show the number of seconds behind
the live repository is from the repository source.

You must supply an _action_ as the first argument. This should be
one of the following:

    list
    help
    manual

See the EXAMPLES section below for more information.

# OPTIONS

- **-x|--extra-info**

    Rather than showing just the commit date show the commit hash, date, and author.

- **-l|--long**

    Show the full repository name (includes the remote Git repository host).

- **--sync-seconds**

    This option will show each repo followed by the number of seconds it is
    out of sync. If the repo is in sync the number shown will be "0". This
    option cannot be used when running against Puppet Open Source.

- **--max-seconds-behind**

    Look at all repositories and for each find out how many seconds behind the
    repository's live directory from the repository's last commit. Return the
    maximum of all these numbers. If all repositories are in sync will
    output "0".

- **--nagios**

    Calculate the maximum number of seconds behind the live directories are as
    per the `--max-seconds-behind` option. Output a Nagios compatible exit
    code and system message based on the `--warning` and `--critical`
    values.

- **--critical** warning\_seconds

    This option is only used with the `--nagios` option and sets the
    "critical" threshold in seconds. Thus, passing in `--critical 420` means
    to generate a Nagios critical exit code if the max-seconds-behind exceeds
    420.
    If `--critical` is not greater than `--warning` **git-info** will abort.
    Default value: 240

- **--warning** warning\_seconds

    This option is only used with the `--nagios` option and sets the
    "warning" threshold in seconds. Thus, passing in `--warning 300` means to
    generate a Nagios warning exit code if the max-seconds-behind exceeds 300
    but does not exceed the value of `--critical`.
    If `--critical` is not greater than `--warning` **git-info** will abort.
    Default value: 120

- **-v|--verbose**

    Show debugging information.

- **-h|--help**

    Show short help screen and exit.

# EXIT STATUS

The script will exit with 0 if the script completes and there were no
failures, 1 for any other reason.

# NOTES

Later.

# EXAMPLES

Display the last commit information for all Git repositories on the Puppet
Enterprise server:

    git-info list

Same as previous but only show more commit information:

    git-info list --extra-info

Show the last commit information for all Git repositories matching a
supplied PCRE:

    git-info list 'idg.*'

Generate a Nagios-compatible exit code and message if there is any
repository which is more than 5 minutes out-of-sync (critical) or 3
minutes out-of-sync (warning):

    git-info list --nagios --critical=300 --warning=180

Show a short help screen::

    git-info help

Display the man page:

    git-info manual

# SEE ALSO

git(1)

# AUTHOR

Adam Lewenberg <adamhl@stanford.edu>

# COPYRIGHT AND LICENSE

Copyright 2018, 2020, 2021 The Board of Trustees of the Leland Stanford Junior
University.  All rights reserved.

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation, and that the name of Stanford University not be used in
advertising or publicity pertaining to distribution of the software
without specific, written prior permission.  Stanford University makes no
representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.

THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
