[[_TOC_]]

# Puppet Backend Tools

This is a collection of scripts that interface with the Puppet service
yielding information and managing Puppet client certificates.

## `git-info`
[`git-info` man page](docs/git-info.md)

## `puppetca-backend`
[`puppetca-backend` man page](docs/puppetca-backend.md)

## `puppetca-backend-kubectl`
[`puppetca-backend-kubectl` man page](docs/puppetca-backend-kubectl.md)


## `pdb-backend`
The `pdb-backend` script is intended to be run on a Puppet Enterprise server and
accessed via remctl.

### Installation

There is a single script: `pdb-backend`. It expects to find a
configuration file containing PuppetDB credentials in
`/etc/puppetdb/conf.d/database.ini` with this format:

    [database]
    username = pdbro
    password = secretsecret
    subname  = //127.0.0.1:5432/pe-puppetdb

The user credentials in the file above should have read-only access to the
Puppet database `pe-puppetdb`.

You will also need Erik Dalen's `puppet-puppetdbquery` Puppet module. To
install by hand:

    puppet module install dalen-puppetdbquery

### Running `pdb-backend`

To see the man page, run `pdb-backend manual`.
