/* A Bison parser, made by GNU Bison 2.5.  */

/* Bison implementation for Yacc-like parsers in C
   
      Copyright (C) 1984, 1989-1990, 2000-2011 Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.5"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Copy the first part of user declarations.  */

/* Line 268 of yacc.c  */
#line 1 "cfgparse.y"

/*
 * Parse the configuration file.
 *
 * Our end product is a linked list of log classes, which the rest of
 * newsyslog will use as data to do the actual work (see logs.h for the
 * definitions of all of the relevant structs).  The input stream comes from
 * the lexer.
 *
 * Written by Russ Allbery <rra@stanford.edu>
 * Copyright 1998, 1999, 2000, 2002, 2011
 *     The Board of Trustees of the Leland Stanford Junior University
 *
 * See LICENSE for licensing terms.
 */

#include <config.h>
#include <portable/system.h>

#include <grp.h>
#include <pwd.h>

#include <internal.h>
#include <util/messages.h>
#include <util/xmalloc.h>

/* We want to have verbose parse error messages. */
#define YYERROR_VERBOSE 1

/* These two functions need to be externally visible. */
void cfgdie(const char *format, ...);
void yyerror(const char *error);

/* This comes from cfgtoken.l and lex. */ 
int yylex(void); 

/* Stuff for internal use only. */
static struct archive *archive(char *template, int count);
static char *cfgexpand(char *string, const char *name);
static char *lookup(char *path);
static void set(char *name, const char *content);
static struct log *merge(struct log *logs, struct log *actions);

/* The FILE that our lexer will read from. */
extern FILE *yyin;

/* The current line of our configuration file (maintained by the lexer). */
extern int cfgline; 

/* Struct to store variable content mappings from set commands. */
struct variable {
    char *name;
    const char *content;
    struct variable *next;
};

/* Stores a linked list of all variables that have been set. */
static struct variable *variables = NULL;
  
/* The final result of our parsing, a linked list of classes. */
static struct class *class;


/* Line 268 of yacc.c  */
#line 135 "cfgparse.c"

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     ANALYZE = 258,
     ARCHIVE = 259,
     COPY = 260,
     EOL = 261,
     FILTER = 262,
     HUP = 263,
     LOG = 264,
     RESTART = 265,
     RUN = 266,
     SET = 267,
     STOP = 268,
     TRUNCATE = 269,
     EQ = 270,
     LBRACE = 271,
     RBRACE = 272,
     LABEL = 273,
     STRING = 274,
     VALUE = 275,
     VARIABLE = 276,
     NUMBER = 277
   };
#endif
/* Tokens.  */
#define ANALYZE 258
#define ARCHIVE 259
#define COPY 260
#define EOL 261
#define FILTER 262
#define HUP 263
#define LOG 264
#define RESTART 265
#define RUN 266
#define SET 267
#define STOP 268
#define TRUNCATE 269
#define EQ 270
#define LBRACE 271
#define RBRACE 272
#define LABEL 273
#define STRING 274
#define VALUE 275
#define VARIABLE 276
#define NUMBER 277




#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{

/* Line 293 of yacc.c  */
#line 66 "cfgparse.y"

    char *string;
    int number;
    struct command *command;
    struct process *process;
    struct log *log;
    struct class *class;



/* Line 293 of yacc.c  */
#line 226 "cfgparse.c"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif


/* Copy the second part of user declarations.  */


/* Line 343 of yacc.c  */
#line 238 "cfgparse.c"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  11
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   54

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  23
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  22
/* YYNRULES -- Number of rules.  */
#define YYNRULES  36
/* YYNRULES -- Number of states.  */
#define YYNSTATES  73

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   277

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint8 yyprhs[] =
{
       0,     0,     3,     9,    12,    15,    16,    19,    21,    23,
      27,    28,    32,    33,    35,    37,    39,    41,    43,    52,
      53,    58,    63,    69,    74,    78,    80,    82,    84,    86,
      88,    91,    92,   100,   103,   106,   107
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int8 yyrhs[] =
{
      44,     0,    -1,    12,    21,    15,    19,     6,    -1,     8,
      19,    -1,    26,    19,    -1,    -1,    11,    26,    -1,    25,
      -1,    27,    -1,    13,    28,     6,    -1,    -1,    10,    28,
       6,    -1,    -1,    22,    -1,    19,    -1,    22,    -1,    19,
      -1,    19,    -1,     9,    33,    19,    31,    32,    22,     6,
      34,    -1,    -1,     3,    33,    26,     6,    -1,     7,    33,
      26,     6,    -1,     4,    33,    19,    22,     6,    -1,     5,
      33,    19,     6,    -1,    14,    33,     6,    -1,    35,    -1,
      37,    -1,    36,    -1,    38,    -1,    39,    -1,    40,    41,
      -1,    -1,    18,    16,    29,    30,    34,    41,    17,    -1,
      24,    43,    -1,    42,    43,    -1,    -1,    43,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,   145,   145,   148,   183,   211,   223,   234,   235,   238,
     239,   242,   243,   246,   247,   261,   262,   281,   296,   324,
     327,   337,   347,   358,   368,   378,   379,   380,   381,   382,
     385,   393,   396,   414,   415,   423,   426
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ANALYZE", "ARCHIVE", "COPY", "EOL",
  "FILTER", "HUP", "LOG", "RESTART", "RUN", "SET", "STOP", "TRUNCATE",
  "\"=\"", "\"{\"", "\"}\"", "LABEL", "STRING", "VALUE", "VARIABLE",
  "NUMBER", "$accept", "set", "hup", "arguments", "run", "process", "stop",
  "restart", "uid", "gid", "log", "logs", "analyze", "filter", "archive",
  "copy", "truncate", "action", "actions", "block", "class", "file", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,    23,    24,    25,    26,    26,    27,    28,    28,    29,
      29,    30,    30,    31,    31,    32,    32,    33,    34,    34,
      35,    36,    37,    38,    39,    40,    40,    40,    40,    40,
      41,    41,    42,    43,    43,    43,    44
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     5,     2,     2,     0,     2,     1,     1,     3,
       0,     3,     0,     1,     1,     1,     1,     1,     8,     0,
       4,     4,     5,     4,     3,     1,     1,     1,     1,     1,
       2,     0,     7,     2,     2,     0,     1
};

/* YYDEFACT[STATE-NAME] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
      35,     0,     0,    35,    35,    36,     0,     0,    10,    33,
      34,     1,     0,     0,    12,     0,     0,     5,     7,     8,
       0,     0,    19,     2,     3,     6,     9,     0,     0,    31,
       4,    11,    17,     0,     0,     0,     0,     0,     0,    25,
      27,    26,    28,    29,    31,     0,     0,     5,     0,     0,
       5,     0,    30,    32,    14,    13,     0,     0,     0,     0,
       0,    24,    16,    15,     0,    20,     0,    23,    21,     0,
      22,    19,    18
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int8 yydefgoto[] =
{
      -1,     3,    18,    25,    19,    20,    14,    22,    56,    64,
      33,    29,    39,    40,    41,    42,    43,    44,    45,     4,
       5,     6
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -25
static const yytype_int8 yypact[] =
{
      -9,   -19,    11,    -9,    -9,   -25,    28,    14,    17,   -25,
     -25,   -25,    12,    -1,    22,    27,    15,   -25,   -25,   -25,
      29,    -1,    30,   -25,   -25,    18,   -25,    32,    21,     1,
     -25,   -25,   -25,    23,    21,    21,    21,    21,    21,   -25,
     -25,   -25,   -25,   -25,     1,    19,     2,   -25,    24,    25,
     -25,    35,   -25,   -25,   -25,   -25,     3,    -6,    26,    39,
      -5,   -25,   -25,   -25,    31,   -25,    40,   -25,   -25,    41,
     -25,    30,   -25
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int8 yypgoto[] =
{
     -25,   -25,   -25,   -24,   -25,    33,   -25,   -25,   -25,   -25,
     -18,   -22,   -25,   -25,   -25,   -25,   -25,   -25,     6,   -25,
       8,   -25
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1
static const yytype_uint8 yytable[] =
{
      65,    68,     7,     1,    34,    35,    36,    16,    37,     2,
      17,     9,    10,    30,    30,    38,    47,    48,    49,    50,
      51,    54,    62,    57,    55,    63,    60,     8,    11,    12,
      13,    15,    21,    23,    24,    26,    53,    30,    31,    28,
      32,    61,    46,    58,    59,    67,    70,    71,    66,    72,
      52,     0,     0,    69,    27
};

#define yypact_value_is_default(yystate) \
  ((yystate) == (-25))

#define yytable_value_is_error(yytable_value) \
  YYID (0)

static const yytype_int8 yycheck[] =
{
       6,     6,    21,    12,     3,     4,     5,     8,     7,    18,
      11,     3,     4,    19,    19,    14,    34,    35,    36,    37,
      38,    19,    19,    47,    22,    22,    50,    16,     0,    15,
      13,    19,    10,     6,    19,     6,    17,    19,     6,     9,
      19,     6,    19,    19,    19,     6,     6,     6,    22,    71,
      44,    -1,    -1,    22,    21
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,    12,    18,    24,    42,    43,    44,    21,    16,    43,
      43,     0,    15,    13,    29,    19,     8,    11,    25,    27,
      28,    10,    30,     6,    19,    26,     6,    28,     9,    34,
      19,     6,    19,    33,     3,     4,     5,     7,    14,    35,
      36,    37,    38,    39,    40,    41,    19,    33,    33,    33,
      33,    33,    41,    17,    19,    22,    31,    26,    19,    19,
      26,     6,    19,    22,    32,     6,    22,     6,     6,    22,
       6,     6,    34
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  However,
   YYFAIL appears to be in use.  Nevertheless, it is formally deprecated
   in Bison 2.4.2's NEWS entry, where a plan to phase it out is
   discussed.  */

#define YYFAIL		goto yyerrlab
#if defined YYFAIL
  /* This is here to suppress warnings from the GCC cpp's
     -Wunused-macros.  Normally we don't worry about that warning, but
     some users do, and we want to make it easy for users to remove
     YYFAIL uses, which will produce warnings from Bison 2.5.  */
#endif

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      YYPOPSTACK (1);						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (YYID (N))                                                    \
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (YYID (0))
#endif


/* This macro is provided for backward compatibility. */

#ifndef YY_LOCATION_PRINT
# define YY_LOCATION_PRINT(File, Loc) ((void) 0)
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
	break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
#else
static void
yy_stack_print (yybottom, yytop)
    yytype_int16 *yybottom;
    yytype_int16 *yytop;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, int yyrule)
#else
static void
yy_reduce_print (yyvsp, yyrule)
    YYSTYPE *yyvsp;
    int yyrule;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       		       );
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, Rule); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYSIZE_T *yymsg_alloc, char **yymsg,
                yytype_int16 *yyssp, int yytoken)
{
  YYSIZE_T yysize0 = yytnamerr (0, yytname[yytoken]);
  YYSIZE_T yysize = yysize0;
  YYSIZE_T yysize1;
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = 0;
  /* Arguments of yyformat. */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Number of reported tokens (one for the "unexpected", one per
     "expected"). */
  int yycount = 0;

  /* There are many possibilities here to consider:
     - Assume YYFAIL is not used.  It's too flawed to consider.  See
       <http://lists.gnu.org/archive/html/bison-patches/2009-12/msg00024.html>
       for details.  YYERROR is fine as it does not invoke this
       function.
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[*yyssp];
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                yysize1 = yysize + yytnamerr (0, yytname[yyx]);
                if (! (yysize <= yysize1
                       && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
                  return 2;
                yysize = yysize1;
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  yysize1 = yysize + yystrlen (yyformat);
  if (! (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
    return 2;
  yysize = yysize1;

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          yyp++;
          yyformat++;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  YYUSE (yyvaluep);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
	break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */
#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */


/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;


/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       `yyss': related to states.
       `yyvs': related to semantic values.

       Refer to the stacks thru separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yytoken = 0;
  yyss = yyssa;
  yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */
  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss_alloc, yyss);
	YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  *++yyvsp = yylval;

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:

/* Line 1806 of yacc.c  */
#line 145 "cfgparse.y"
    { set((yyvsp[(2) - (5)].string), (yyvsp[(4) - (5)].string)); }
    break;

  case 3:

/* Line 1806 of yacc.c  */
#line 149 "cfgparse.y"
    {
                      struct process *process;
                    
                      process = xmalloc(sizeof(struct process));
                      process->command = NULL;
                      process->pidfile = cfgexpand((yyvsp[(2) - (2)].string), "");
                      (yyval.process) = process;
                  }
    break;

  case 4:

/* Line 1806 of yacc.c  */
#line 184 "cfgparse.y"
    {
                      struct command *command = (yyvsp[(1) - (2)].command);
                      int size;

                      /*
                       * Check to see if we need to grow our array.  Note that
                       * the size has to be *larger* than argc so that we have
                       * room for the terminating NULL.
                       */
                      command->argc++;
                      if (command->argc >= command->size) {
                          command->size *= 2;
                          size = command->size * sizeof(char *);
                          command->argv = xrealloc(command->argv, size);
                      }

                      /*
                       * Aesthetically, the "name" argument of expand() should
                       * probably be the block label, but we don't have easy
                       * access to that here and my sense of aesthetics isn't
                       * strong enough to get me to restructure code to get at
                       * it....
                       */
                      command->argv[command->argc - 1] = cfgexpand((yyvsp[(2) - (2)].string), "");
                      command->argv[command->argc] = NULL;
                  }
    break;

  case 5:

/* Line 1806 of yacc.c  */
#line 211 "cfgparse.y"
    {
                      struct command *command;
                    
                      command = xmalloc(sizeof(struct command));
                      command->argc = 0;
                      command->size = 3;
                      command->argv = xmalloc(3 * sizeof (char *));
                      command->next = NULL;
                      (yyval.command) = command;
                  }
    break;

  case 6:

/* Line 1806 of yacc.c  */
#line 224 "cfgparse.y"
    {
                    struct process *process;
                  
                    process = xmalloc(sizeof(struct process));
                    process->command = (yyvsp[(2) - (2)].command);
                    process->pidfile = NULL;
                    (yyval.process) = process;
                }
    break;

  case 7:

/* Line 1806 of yacc.c  */
#line 234 "cfgparse.y"
    { (yyval.process) = (yyvsp[(1) - (1)].process); }
    break;

  case 8:

/* Line 1806 of yacc.c  */
#line 235 "cfgparse.y"
    { (yyval.process) = (yyvsp[(1) - (1)].process); }
    break;

  case 9:

/* Line 1806 of yacc.c  */
#line 238 "cfgparse.y"
    { (yyval.process) = (yyvsp[(2) - (3)].process); }
    break;

  case 10:

/* Line 1806 of yacc.c  */
#line 239 "cfgparse.y"
    { (yyval.process) = NULL; }
    break;

  case 11:

/* Line 1806 of yacc.c  */
#line 242 "cfgparse.y"
    { (yyval.process) = (yyvsp[(2) - (3)].process); }
    break;

  case 12:

/* Line 1806 of yacc.c  */
#line 243 "cfgparse.y"
    { (yyval.process) = NULL; }
    break;

  case 13:

/* Line 1806 of yacc.c  */
#line 246 "cfgparse.y"
    { (yyval.number) = (yyvsp[(1) - (1)].number); }
    break;

  case 14:

/* Line 1806 of yacc.c  */
#line 248 "cfgparse.y"
    {
                      struct passwd *pw;

                      pw = getpwnam((yyvsp[(1) - (1)].string));
                      if (pw != NULL) {
                          free((yyvsp[(1) - (1)].string));
                          (yyval.number) = pw->pw_uid;
                      } else {
                          cfgdie("Unknown user %s", (yyvsp[(1) - (1)].string));
                      }
                  }
    break;

  case 15:

/* Line 1806 of yacc.c  */
#line 261 "cfgparse.y"
    { (yyval.number) = (yyvsp[(1) - (1)].number); }
    break;

  case 16:

/* Line 1806 of yacc.c  */
#line 263 "cfgparse.y"
    {
                      struct group *gr;

                      gr = getgrnam((yyvsp[(1) - (1)].string));
                      if (gr != NULL) {
                          free((yyvsp[(1) - (1)].string));
                          (yyval.number) = gr->gr_gid;
                      } else {
                          cfgdie("Unknown group %s", (yyvsp[(1) - (1)].string));
                      }
                  }
    break;

  case 17:

/* Line 1806 of yacc.c  */
#line 282 "cfgparse.y"
    {
                      struct log *log;

                      log = xmalloc(sizeof(struct log));
                      log->name = (yyvsp[(1) - (1)].string);
                      log->rotate = false;
                      log->truncate = false;
                      log->analyze = NULL;
                      log->archive = NULL;
                      log->filter = NULL;
                      (yyval.log) = log;
                  }
    break;

  case 18:

/* Line 1806 of yacc.c  */
#line 297 "cfgparse.y"
    {
                      struct log *log;
                      int mode, factor;

                      log = (yyvsp[(2) - (8)].log);
                      log->path = cfgexpand(lookup((yyvsp[(3) - (8)].string)), log->name);
                      log->tmppath = NULL;
                      log->owner = (uid_t) (yyvsp[(4) - (8)].number);
                      log->group = (gid_t) (yyvsp[(5) - (8)].number);
                      mode = (yyvsp[(6) - (8)].number);

                      /*
                       * Interpret the permissions as octal.  Roll our own
                       * converter to avoid needless weird library calls.
                       */
                      factor = 1;
                      log->mode = 0;
                      while (mode > 0) {
                          log->mode += (mode % 10) * factor;
                          factor *= 8;
                          mode /= 10;
                      }

                      /* Return a linked list of what we've seen so far. */
                      log->next = (yyvsp[(8) - (8)].log);
                      (yyval.log) = log;
                  }
    break;

  case 19:

/* Line 1806 of yacc.c  */
#line 324 "cfgparse.y"
    { (yyval.log) = NULL; }
    break;

  case 20:

/* Line 1806 of yacc.c  */
#line 328 "cfgparse.y"
    {
                      struct log *log;

                      log = (yyvsp[(2) - (4)].log);
                      log->analyze = (yyvsp[(3) - (4)].command);
                      (yyval.log) = log;
                  }
    break;

  case 21:

/* Line 1806 of yacc.c  */
#line 338 "cfgparse.y"
    {
                      struct log *log;

                      log = (yyvsp[(2) - (4)].log);
                      log->filter = (yyvsp[(3) - (4)].command);
                      (yyval.log) = log;
                  }
    break;

  case 22:

/* Line 1806 of yacc.c  */
#line 348 "cfgparse.y"
    {
                      struct log *log;

                      log = (yyvsp[(2) - (5)].log);
                      log->archive = archive((yyvsp[(3) - (5)].string), (yyvsp[(4) - (5)].number));
                      log->rotate = true;
                      (yyval.log) = log;
                  }
    break;

  case 23:

/* Line 1806 of yacc.c  */
#line 359 "cfgparse.y"
    {
                      struct log *log;

                      log = (yyvsp[(2) - (4)].log);
                      log->archive = archive((yyvsp[(3) - (4)].string), -1);
                      (yyval.log) = log;
                  }
    break;

  case 24:

/* Line 1806 of yacc.c  */
#line 369 "cfgparse.y"
    {
                      struct log *log;

                      log = (yyvsp[(2) - (3)].log);
                      log->truncate = true;
                      (yyval.log) = log;
                  }
    break;

  case 25:

/* Line 1806 of yacc.c  */
#line 378 "cfgparse.y"
    { (yyval.log) = (yyvsp[(1) - (1)].log); }
    break;

  case 26:

/* Line 1806 of yacc.c  */
#line 379 "cfgparse.y"
    { (yyval.log) = (yyvsp[(1) - (1)].log); }
    break;

  case 27:

/* Line 1806 of yacc.c  */
#line 380 "cfgparse.y"
    { (yyval.log) = (yyvsp[(1) - (1)].log); }
    break;

  case 28:

/* Line 1806 of yacc.c  */
#line 381 "cfgparse.y"
    { (yyval.log) = (yyvsp[(1) - (1)].log); }
    break;

  case 29:

/* Line 1806 of yacc.c  */
#line 382 "cfgparse.y"
    { (yyval.log) = (yyvsp[(1) - (1)].log); }
    break;

  case 30:

/* Line 1806 of yacc.c  */
#line 386 "cfgparse.y"
    {
                      struct log *log;

                      log = (yyvsp[(1) - (2)].log);
                      log->next = (yyvsp[(2) - (2)].log);
                      (yyval.log) = log;
                  }
    break;

  case 31:

/* Line 1806 of yacc.c  */
#line 393 "cfgparse.y"
    { (yyval.log) = NULL; }
    break;

  case 32:

/* Line 1806 of yacc.c  */
#line 397 "cfgparse.y"
    {
                      struct class *block;

                      block = xmalloc(sizeof(struct class));
                      block->name = (yyvsp[(1) - (7)].string);
                      block->stop = (yyvsp[(3) - (7)].process);
                      block->restart = (yyvsp[(4) - (7)].process);
                      block->logs = merge((yyvsp[(5) - (7)].log), (yyvsp[(6) - (7)].log));
                      (yyval.class) = block;
                  }
    break;

  case 33:

/* Line 1806 of yacc.c  */
#line 414 "cfgparse.y"
    { (yyval.class) = (yyvsp[(2) - (2)].class); }
    break;

  case 34:

/* Line 1806 of yacc.c  */
#line 416 "cfgparse.y"
    {
                      struct class *block;

                      block = (yyvsp[(1) - (2)].class);
                      block->next = (yyvsp[(2) - (2)].class);
                      (yyval.class) = block;
                  }
    break;

  case 35:

/* Line 1806 of yacc.c  */
#line 423 "cfgparse.y"
    { (yyval.class) = NULL; }
    break;

  case 36:

/* Line 1806 of yacc.c  */
#line 426 "cfgparse.y"
    { class = (yyvsp[(1) - (1)].class); }
    break;



/* Line 1806 of yacc.c  */
#line 1914 "cfgparse.c"
      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYEMPTY : YYTRANSLATE (yychar);

  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
# define YYSYNTAX_ERROR yysyntax_error (&yymsg_alloc, &yymsg, \
                                        yyssp, yytoken)
      {
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = YYSYNTAX_ERROR;
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == 1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = (char *) YYSTACK_ALLOC (yymsg_alloc);
            if (!yymsg)
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = 2;
              }
            else
              {
                yysyntax_error_status = YYSYNTAX_ERROR;
                yymsgp = yymsg;
              }
          }
        yyerror (yymsgp);
        if (yysyntax_error_status == 2)
          goto yyexhaustedlab;
      }
# undef YYSYNTAX_ERROR
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
	{
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
	}
      else
	{
	  yydestruct ("Error: discarding",
		      yytoken, &yylval);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule which action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;


      yydestruct ("Error: popping",
		  yystos[yystate], yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  *++yyvsp = yylval;


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined(yyoverflow) || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule which action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  /* Make sure YYID is used.  */
  return YYID (yyresult);
}



/* Line 2067 of yacc.c  */
#line 429 "cfgparse.y"


/*
 * yyerror(), called by yacc code, is just a simple wrapper around cfgdie().
 */
void
yyerror(const char *error)
{
    cfgdie(error);
}


/*
 * Prepend the current line number to the error message before dying.  This
 * needs to not be a static function so that the lexer can pull it in and use
 * it as well.
 */
void
cfgdie(const char *format, ...)
{
    va_list message;

    fprintf(stderr, "config line %d: ", cfgline);
    va_start(message, format);
    vfprintf(stderr, format, message);
    va_end(message);
    fprintf(stderr, "\n");
    exit(1);
}

   
/*
 * We maintain a linked list of variables that have been set, which is used
 * later by lookup() when it does variable expansion.  Note that we don't
 * check for duplicates; this is intentional, as we want to allow people to
 * redefine variables.  We add all new definitions onto the *beginning* of the
 * linked list, and then any subsequent lookups will always find the latest
 * definition of a variable.
 */
static void
set(char *name, const char *content)
{
    struct variable *variable;

    variable = xmalloc(sizeof(struct variable));
    variable->name = name;
    variable->content = content;
    variable->next = variables ? variables : NULL;
    variables = variable;
}


/*
 * Given an argument that's supposed to be a path, run it through variable
 * expansion if it doesn't start with a slash.  Stuff starting with a slash
 * bypasses this entirely; it's somewhat counterintuitive that we still call
 * lookup for things that we're not going to look up in the variable table,
 * but it made the code neater.  We're being passed in a malloc'd string; if
 * we return a variable value (also a malloc'd string, stored in the linked
 * list of variables), be sure to free our argument.
 */
static char *
lookup(char *path)
{
    struct variable *variable;
    char *value;
  
    if (path[0] != '/' && strncmp(path, "./", 2) != 0) {
        for (variable = variables; variable != NULL; variable = variable->next)
            if (strcmp(variable->name, path) == 0)
                break;
        if (variable == NULL)
            cfgdie("Undefined variable %s", path);
        free(path);
        value = xstrdup(variable->content);
        return value;
    } else {
        return path;
    }
}


/*
 * Check over a string for the invalid %s escape and then pass it along to
 * expand() so that % expansion can be done.  The time passed to it will be 0
 * (indicating to use the current time).  Returns NULL on error.  We free the
 * string passed in and return the malloc'd string that expand() returns.
 */
static char *
cfgexpand(char *string, const char *name)
{
    char *p;

    /* Check for invalid % escapes. */
    for (p = string; *p; p++)
        if (*p == '%' && !(*(++p) && strchr("%dmnDMY", *p)))
            cfgdie("Invalid %% escape");

    /* Okay, valid format.  Send it through the real expand(). */
    p = expand(string, name, 0);
    if (p == NULL)
        cfgdie("Unable to expand string");
    free(string);
    return p;
}


/*
 * Construct an archive struct, given a template or variable containing a
 * template and the number of old logs to save as arguments.  We allocate a
 * new struct archive and return it.
 */
static struct archive *
archive(char *template, int count)
{
    struct archive *new;

    /* Allocate a new archive struct and initialize it. */
    new = xmalloc(sizeof(struct archive));
    new->count = count;
    new->path = NULL;
    new->next = NULL;

    /* Now massage the template according to rotation policy. */
    if (template == NULL) {
        new->template = NULL;
        new->ext = NULL;
    } else {
        new->template = lookup(template);
        new->ext = use_bzip2 ? "bz2" : "gz";
    }

    /* Return the completed archive struct. */
    return new;
}


/*
 * When we originally generated the list of logs and the list of actions, we
 * did so as two separate linked lists of logs, as it was easier to convince
 * yacc/bison to cope with that.  See the long comments at the top of the
 * grammer.  This merges them back together.
 *
 * We take two pointers to linked lists of logs; the first will be correct for
 * path, owner, group, and mode, and the second will have archive, rotate,
 * analyze, and filter elements filled in.  We return a single pointer to a
 * linked list of logs with no duplicates that has everything merged together.
 *
 * We have not previously checked to see if we have any duplicate log
 * definitions, so we also check this while we're at it.  We call cfgdie() on
 * any errors (rather than yyerror(), which can't take variable arguments).
 */
static struct log *
merge(struct log *logs, struct log *actions)
{
    struct log *current, *log, *old;
    struct archive *last;
    struct command *command;
  
    /* Scan logs and make sure that there aren't any duplicates. */
    for (current = logs; current != NULL && current->next != NULL;
         current = current->next)
        for (log = current->next; log != NULL; log = log->next)
            if (strcmp(current->name, log->name) == 0)
                cfgdie("Duplicate log definition for %s", current->name);

    /*
     * Now, step through the actions one at a time, merging their contents
     * into logs and freeing the memory used by the actions.  Here's where we
     * detect people assigning actions to logs that were never existed, so
     * those errors will show up as being at the end of the log class block
     * rather than at the archive line itself.  Hurm.
     */
    for (current = actions; current != NULL; ) {
        for (log = logs; log != NULL; log = log->next)
            if (strcmp(log->name, current->name) == 0)
                break;
        if (log == NULL)
            cfgdie("Unknown log %s", current->name);
        if (log->archive == NULL)
            log->archive = current->archive;
        else {
            for (last = log->archive; last->next != NULL; last = last->next)
                ;
            last->next = current->archive;
        }
        if (log->analyze == NULL) {
            log->analyze = current->analyze;
        } else {
            for (command = log->analyze; command->next != NULL;
                 command = command->next)
                ;
            command->next = current->analyze;
        }
        if (log->filter != NULL)
            cfgdie("Duplicate filter actions for %s", current->name);
        else
            log->filter = current->filter;
        log->rotate = current->rotate || log->rotate;
        log->truncate = current->truncate || log->truncate;
        if (log->truncate && log->rotate)
            cfgdie("Cannot both archive and truncate %s", current->name);
        old = current;
        current = current->next;
        free(old->name);
        free(old);
    }

    /* Return the linked list of combined log structs. */
    return logs;
}


/*
 * This is the function that the rest of the world gets to call.  It takes
 * in the name of the configuration file, and returns a pointer to a linked
 * list of class structs.
 */
struct class *
read_config(const char *filename)
{
    FILE *config;

    /* Attempt to open our configuration file. */
    config = fopen(filename, "r");
    if (config == NULL)
        die("Cannot open configuration file %s", filename);

    /* Point our lexer at the right file, and then let magic happen. */
    yyin = config;
    if (yyparse())
        die("Parsing of %s failed", filename);
    fclose(config);
    return class;
}

