/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.util;

import com.sun.security.auth.callback.TextCallbackHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import stanford.netdb.exceptions.Exception_Formatter;
import stanford.netdb.util.Property;

public class Kerberos
extends Configuration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String CONTEXT_NAME = "Kerberos";
    private static final String KRB5_CONF_PROP = "java.security.krb5.conf";
    private static final String DEFAULT_KRB5_PATH = "/etc/krb5.conf";
    private static String KRB5_CONF = null;
    private static String ORIGINAL_KRB5_CONF = null;
    private Logger logger = null;
    private Subject sub = null;
    private KerberosTicket ticket = null;
    private String keytab = null;
    private String principal = null;
    private Boolean modified = false;
    private File temp_conf = null;

    public Kerberos() throws Exception {
    }

    public Kerberos(String string, String string2) throws Exception {
        this.keytab(string);
        this.principal(string2);
    }

    public static void krb5_conf(String string) {
        KRB5_CONF = string;
    }

    public Kerberos logger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public Kerberos keytab(String string) {
        if (this.keytab != null && !this.keytab.equals(string)) {
            this.modified = true;
        }
        this.keytab = string;
        return this;
    }

    public Kerberos principal(String string) {
        if (this.principal != null && !this.principal.equals(string)) {
            this.modified = true;
        }
        this.principal = string;
        return this;
    }

    public static String krb5_conf() {
        return KRB5_CONF;
    }

    public Logger logger() {
        return this.logger;
    }

    public String keytab() {
        return this.keytab;
    }

    public String principal() {
        return this.principal;
    }

    public void modify_conf() {
        block13: {
            try {
                Comparable<File> comparable;
                if (this.temp_conf != null && !((File)(comparable = new File(System.getProperty(KRB5_CONF_PROP)))).exists()) {
                    this.temp_conf = null;
                    System.setProperty(KRB5_CONF_PROP, ORIGINAL_KRB5_CONF);
                }
                if (this.temp_conf == null) {
                    comparable = Property.fetch_as_Boolean("rmi.kerberos.force_tcp", "false");
                    File file = new File(System.getProperty(KRB5_CONF_PROP));
                    if (!file.exists() || !file.canRead()) {
                        return;
                    }
                    this.temp_conf = File.createTempFile("rmi_krb5_", ".conf");
                    this.temp_conf.deleteOnExit();
                    this.temp_conf.setReadable(true, true);
                    this.temp_conf.setWritable(true);
                    FileReader fileReader = new FileReader(file);
                    FileWriter fileWriter = new FileWriter(this.temp_conf);
                    BufferedReader bufferedReader = new BufferedReader(fileReader);
                    BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                    String string = "";
                    while (string != null) {
                        String string2 = string.toLowerCase();
                        Boolean bl = true;
                        if (((Boolean)comparable).booleanValue()) {
                            if (string2.matches("^\\s*udp_preference_limit\\s*=.+")) {
                                bl = false;
                            } else if (string2.matches("^\\s*.libdefaults.*")) {
                                string = string + "\n    udp_preference_limit = 1";
                            }
                        }
                        if (string2.matches("^\\s*forwardable\\s*=.+")) {
                            string = "    forwardable = false";
                        }
                        if (bl.booleanValue()) {
                            bufferedWriter.write(string);
                            bufferedWriter.newLine();
                        }
                        bufferedWriter.flush();
                        string = bufferedReader.readLine();
                    }
                    fileReader.close();
                    fileWriter.close();
                    bufferedReader.close();
                    bufferedWriter.close();
                    if (ORIGINAL_KRB5_CONF == null) {
                        ORIGINAL_KRB5_CONF = System.getProperty(KRB5_CONF_PROP);
                    }
                    System.setProperty(KRB5_CONF_PROP, this.temp_conf.getAbsolutePath());
                }
            }
            catch (Exception exception) {
                if (this.logger == null) break block13;
                this.logger.severe("Failed to copy kerberos configuration:\n" + Exception_Formatter.stack_trace(exception));
            }
        }
    }

    public Subject certify() throws Exception {
        if (this.still_valid().booleanValue()) {
            this.debug("Skipping authentication.  Client has already authenticated.");
            return this.sub;
        }
        LoginContext loginContext = null;
        try {
            loginContext = new LoginContext(CONTEXT_NAME, null, new TextCallbackHandler(), this);
        }
        catch (Exception exception) {
            this.error("Cannot create LoginContext. " + exception.getMessage());
        }
        try {
            this.modify_conf();
            this.debug("Attempting to authenticate");
            this.debug(System.getProperty(KRB5_CONF_PROP));
            loginContext.login();
            this.debug("Authentication complete");
        }
        catch (AccountExpiredException accountExpiredException) {
            this.error("Your account has expired.  Please notify your administrator.");
        }
        catch (CredentialExpiredException credentialExpiredException) {
            this.error("Your credentials have expired.");
        }
        catch (FailedLoginException failedLoginException) {
            this.error("Authentication Failed");
        }
        catch (Exception exception) {
            if (this.logger != null) {
                this.logger.severe(Exception_Formatter.stack_trace(exception));
            }
            throw exception;
        }
        this.sub = loginContext.getSubject();
        for (Object object : this.sub.getPrivateCredentials()) {
            if (!(object instanceof KerberosTicket)) continue;
            this.ticket = (KerberosTicket)object;
        }
        this.modified = false;
        return this.sub;
    }

    public Boolean still_valid() {
        if (this.ticket == null || this.modified.booleanValue()) {
            return false;
        }
        return this.ticket.isCurrent();
    }

    public String certified_principal() {
        if (this.ticket == null) {
            return null;
        }
        KerberosPrincipal kerberosPrincipal = this.ticket.getClient();
        if (kerberosPrincipal == null) {
            return null;
        }
        return kerberosPrincipal.getName();
    }

    public static String clean_principal(String string, String string2, String string3) {
        Pattern pattern = Pattern.compile("(.*?)(/.*?)?(@.*?)?");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            String string4 = matcher.group(1);
            if (string2 != null) {
                if (!string2.startsWith("/")) {
                    string2 = "/" + string2;
                }
                if (matcher.group(2) != null && !string2.equals(matcher.group(2))) {
                    string4 = string4 + matcher.group(2);
                }
            }
            if (string3 != null) {
                if (!string3.startsWith("@")) {
                    string3 = "@" + string3;
                }
                if (matcher.group(3) != null && !string3.equals(matcher.group(3))) {
                    string4 = string4 + matcher.group(3);
                }
            }
            return string4;
        }
        return string;
    }

    public Boolean isForwardable() {
        if (this.ticket == null) {
            return false;
        }
        return this.ticket.isForwardable();
    }

    private void debug(String string) {
        if (this.logger != null) {
            this.logger.fine("DEBUG: " + string);
        }
    }

    private void error(String string) throws Exception {
        if (this.logger != null) {
            this.logger.severe("ERROR: " + string);
        }
        throw new Exception(string);
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String string) {
        AppConfigurationEntry[] appConfigurationEntryArray;
        if (string == null || !string.equals(CONTEXT_NAME)) {
            return null;
        }
        String string2 = "com.sun.security.auth.module.Krb5LoginModule";
        AppConfigurationEntry.LoginModuleControlFlag loginModuleControlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("debug", "false");
        hashtable.put("doNotPrompt", "true");
        hashtable.put("useTicketCache", "true");
        String string3 = System.getProperty("KRB5CCNAME", "");
        if (string3.length() > 0) {
            hashtable.put("ticketCache", string3);
        } else {
            appConfigurationEntryArray = System.getenv("KRB5CCNAME");
            if (appConfigurationEntryArray != null && appConfigurationEntryArray.length() > 0) {
                hashtable.put("ticketCache", appConfigurationEntryArray);
            }
        }
        if (this.keytab != null && !this.keytab.equals("") && this.principal != null && !this.principal.equals("")) {
            hashtable.put("useKeyTab", "true");
            hashtable.put("storeKey", "true");
            hashtable.put("keyTab", this.keytab);
            hashtable.put("principal", this.principal);
        }
        appConfigurationEntryArray = new AppConfigurationEntry[]{new AppConfigurationEntry(string2, loginModuleControlFlag, hashtable)};
        return appConfigurationEntryArray;
    }

    @Override
    public void refresh() {
    }

    static {
        if (System.getProperty(KRB5_CONF_PROP) == null) {
            if (KRB5_CONF != null && new File(KRB5_CONF).exists()) {
                System.setProperty(KRB5_CONF_PROP, KRB5_CONF);
            } else if (new File(DEFAULT_KRB5_PATH).exists()) {
                System.setProperty(KRB5_CONF_PROP, DEFAULT_KRB5_PATH);
            }
        }
    }
}

