/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Date_Formatter {
    public static String[] FORMATS = new String[]{"MM/dd/yy", "MM-dd-yy", "MMM-dd-yy", "dd-MMM-yy", "yyyy-MM-dd", "yyyy-MMM-dd", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MMM-dd'T'HH:mm:ss"};
    private static SimpleDateFormat[] FORMATTERS = null;
    private static String sync_lock = "lock";

    public static Timestamp to_timestamp(String string) throws ParseException {
        Date date = Date_Formatter.to_date(string);
        return new Timestamp(date.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date to_date(String string) throws ParseException {
        for (int i = 0; i < FORMATTERS.length; ++i) {
            try {
                String string2 = sync_lock;
                synchronized (string2) {
                    return FORMATTERS[i].parse(string);
                }
            }
            catch (Exception exception) {
                continue;
            }
        }
        throw new ParseException("Unable to recognize date in string \"" + string + "\".", 0);
    }

    public static String format(String string, Object object) throws ParseException {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            object = Date_Formatter.to_date((String)object);
        }
        return new SimpleDateFormat(string).format(object);
    }

    static {
        FORMATTERS = new SimpleDateFormat[FORMATS.length];
        for (int i = 0; i < FORMATS.length; ++i) {
            Date_Formatter.FORMATTERS[i] = new SimpleDateFormat(FORMATS[i]);
            FORMATTERS[i].setLenient(false);
        }
    }
}

