/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Properties;

public class Config_Loader {
    protected Config_Loader() {
    }

    public static void read_file(String string) throws Exception {
        Config_Loader.read_file(string, false);
    }

    public static void read_file(String string, Boolean bl) throws Exception {
        Properties properties = new Properties();
        FileInputStream fileInputStream = new FileInputStream(string);
        properties.load(fileInputStream);
        fileInputStream.close();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!bl.booleanValue() && (bl.booleanValue() || System.getProperty(string2) != null)) continue;
            System.setProperty(string2, properties.getProperty(string2));
        }
    }

    public static void read_directory(String string) throws Exception {
        Config_Loader.read_directory(new File(string));
    }

    private static void read_directory(File file) throws Exception {
        if (!file.isDirectory()) {
            return;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (!file2.getName().endsWith(System.getProperty("config.suffix", ".config"))) continue;
            Config_Loader.read_file(file2.getAbsolutePath());
        }
    }

    public static void load_all() throws Exception {
        Config_Loader.load_config("config");
        Config_Loader.load_config("config.1");
        Config_Loader.load_config("config.2");
        Config_Loader.load_config("config.3");
        Config_Loader.load_config("config.4");
        Config_Loader.load_config("config.5");
        Config_Loader.load_config("config.6");
        Config_Loader.load_config("config.7");
        Config_Loader.load_config("config.8");
        Config_Loader.load_config("config.9");
        Config_Loader.check_loaded_configs();
    }

    private static void load_config(String string) throws Exception {
        String string2 = System.getProperty(string);
        if (string2 == null) {
            return;
        }
        File file = new File(string2);
        if (file.isDirectory()) {
            Config_Loader.read_directory(file);
        } else {
            Config_Loader.read_file(file.getAbsolutePath());
        }
    }

    public static void check_loaded_configs() throws Exception {
        Config_Loader.check_connection();
        Config_Loader.check_directory();
    }

    private static void check_connection() throws Exception {
        if (!Config_Loader.database_connection_defined().booleanValue() && !Config_Loader.rmi_connection_defined().booleanValue()) {
            throw new Exception("No connection information has been defined.");
        }
    }

    private static Boolean database_connection_defined() {
        if (System.getProperty("database.type") != null && System.getProperty("database.host") != null && System.getProperty("database.port") != null && System.getProperty("database.user") != null && System.getProperty("database.password") != null && System.getProperty("database.schema") != null) {
            return true;
        }
        return false;
    }

    private static Boolean rmi_connection_defined() {
        if (System.getProperty("rmi.host") != null && System.getProperty("rmi.port") != null) {
            return true;
        }
        return false;
    }

    private static void check_directory() throws Exception {
        String string = System.getProperty("directory.class", "No Class Defined");
        String string2 = "";
        String string3 = "";
        if (string.endsWith("LDAP")) {
            string2 = "LDAP";
            if (System.getProperty("directory.url") == null) {
                string3 = string3.concat("   Property.DIRECTORY_URL\n");
            }
            if (System.getProperty("directory.kerberos.keytab") == null) {
                string3 = string3.concat("   Property.DIRECTORY_KERBEROS_KEYTAB\n");
            }
            if (System.getProperty("directory.kerberos.principal") == null) {
                string3 = string3.concat("   Property.DIRECTORY_KERBEROS_PRINCIPAL\n");
            }
        } else if (string.endsWith("Flat_File")) {
            string2 = "Flat_File";
            if (System.getProperty("directory.file") == null) {
                string3 = string3.concat("   Property.DIRECTORY_FILE\n");
            }
        } else {
            if (string.endsWith("No Class Defined")) {
                throw new Exception("No Directory class was specified.");
            }
            System.err.println("Unknown directory class '" + string + "'.  Update Config_Loader.check_directory ().");
        }
        if (!string3.equals("")) {
            throw new Exception("The '" + string2 + "' directory requires the following properties:\n" + string3);
        }
    }
}

