/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.util;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.Hashtable;

public class Cache<T> {
    private T cache = null;
    private Date last_update = null;
    private long age = 600000L;
    private static Hashtable<String, Cache> shared_cache = new Hashtable();

    public Cache() {
    }

    public Cache(long l) {
        if (l > 0L) {
            this.age = l * 1000L;
        }
    }

    public synchronized Date last_update() {
        return this.last_update;
    }

    public synchronized long age() {
        return this.age;
    }

    public synchronized Cache<T> age(long l) {
        this.age = l;
        return this;
    }

    public synchronized T data() {
        return this.cache;
    }

    public synchronized Cache<T> data(T t) {
        this.cache = t;
        this.last_update = new Date();
        return this;
    }

    public synchronized Boolean is_old() {
        if (this.last_update == null || new Date().getTime() - this.last_update.getTime() > this.age) {
            return true;
        }
        return false;
    }

    public synchronized void invalidate() {
        this.last_update = null;
    }

    public synchronized Long size() {
        if (this.cache != null) {
            try {
                for (Class<?> clazz = this.cache.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                    for (Method method : clazz.getDeclaredMethods()) {
                        if (!"size".equals(method.getName())) continue;
                        Object object = method.invoke(this.cache, new Object[0]);
                        return new Long(object.toString());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static synchronized void shared(String string, Cache cache) {
        shared_cache.put(string, cache);
    }

    public static synchronized Cache shared(String string) {
        return shared_cache.get(string);
    }

    public static synchronized Cache delete(String string) {
        return shared_cache.remove(string);
    }

    public static synchronized Boolean is_old(String string) {
        Cache cache = shared_cache.get(string);
        if (cache != null) {
            return cache.is_old();
        }
        return true;
    }

    public static synchronized Cache<Hashtable<String, String>> fetch_hashtable_cache(String string) {
        return Cache.fetch_hashtable_cache(string, -1L);
    }

    public static synchronized Cache<Hashtable<String, String>> fetch_hashtable_cache(String string, long l) {
        Cache cache = Cache.shared(string);
        if (cache == null) {
            cache = new Cache(l);
            Cache.shared(string, cache);
        }
        return cache;
    }
}

