/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.middleware;

import java.io.Serializable;

public class OutParam
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int type;
    private Object initial_value;

    public OutParam(int n) {
        this.type = n;
    }

    public OutParam(int n, Object object) {
        this.type = n;
        this.initial_value = object;
    }

    public boolean has_initial_value() {
        return this.initial_value != null;
    }

    public Object initial_value() {
        return this.initial_value;
    }

    public int get_true_type() {
        return this.type;
    }

    public int get_type() {
        if (this.type == 16) {
            return 4;
        }
        return this.type;
    }

    public String toString() {
        String string = "OutParam(";
        switch (this.type) {
            case 2: {
                string = string + "NUMERIC";
                break;
            }
            case 16: {
                string = string + "BOOLEAN";
                break;
            }
            case -6: {
                string = string + "TINYINT";
                break;
            }
            case 12: {
                string = string + "VARCHAR";
                break;
            }
            case 93: {
                string = string + "TIMESTAMP";
                break;
            }
            case -7: {
                string = string + "BIT";
                break;
            }
            case -10: {
                string = string + "CURSOR";
                break;
            }
            default: {
                return string + "?";
            }
        }
        if (this.has_initial_value()) {
            string = string + ", " + this.initial_value;
        }
        return string + ")";
    }
}

