/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.middleware;

import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import stanford.netdb.exceptions.Exception_Formatter;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.middleware.DB_SS;
import stanford.netdb.middleware.Datastore;
import stanford.netdb.middleware.MCP_i;
import stanford.netdb.middleware.NetDB_Connection;
import stanford.netdb.middleware.NetDB_Record;
import stanford.netdb.middleware.Result_Hash;
import stanford.netdb.middleware.SS_i;

public class NetDB_SS
extends NetDB_Record
implements SS_i {
    private static final long serialVersionUID = 1L;
    private SS_i remote_object = null;
    private NetDB_Connection connection = null;

    public NetDB_SS(Datastore datastore) {
        super(datastore, new DB_SS());
    }

    protected SS_i open_remote_connection(String string) throws Exception, NotBoundException, MalformedURLException, RemoteException {
        MCP_i mCP_i = null;
        try {
            mCP_i = (MCP_i)this.datastore.open_remote_connection();
            return mCP_i.simple_search();
        }
        catch (Exception exception) {
            this.datastore.terminate_remote_connection(string);
            mCP_i = (MCP_i)this.datastore.open_remote_connection();
            return mCP_i.simple_search();
        }
    }

    @Override
    public Hashtable get_ateams(String string, String string2) throws Exception, No_Datastore_Defined {
        Hashtable hashtable = null;
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string, true);
            result_Hash = this.connection.execute(this.logger(), ((DB_SS)this.db_command).get_ateams(string2));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                hashtable = this.remote_object.get_ateams(string, string2);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
        if (result_Hash != null && result_Hash.get_hash("return_value") != null) {
            hashtable = result_Hash.get_hash("return_value");
        }
        return hashtable;
    }

    @Override
    public Hashtable get_ateams(String string) throws Exception, No_Datastore_Defined {
        Hashtable hashtable = null;
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string, true);
            result_Hash = this.connection.execute(this.logger(), ((DB_SS)this.db_command).get_ateams());
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                hashtable = this.remote_object.get_ateams(string);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
        if (result_Hash != null && result_Hash.get_hash("return_value") != null) {
            hashtable = result_Hash.get_hash("return_value");
        }
        return hashtable;
    }

    @Override
    public Hashtable get_domains(String string, String string2) throws Exception, No_Datastore_Defined {
        Hashtable hashtable = null;
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string, true);
            result_Hash = this.connection.execute(this.logger(), ((DB_SS)this.db_command).get_domains(string2));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                hashtable = this.remote_object.get_domains(string, string2);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
        if (result_Hash != null && result_Hash.get_hash("return_value") != null) {
            hashtable = result_Hash.get_hash("return_value");
        }
        return hashtable;
    }

    @Override
    public Hashtable get_groups(String string, String string2) throws Exception, No_Datastore_Defined {
        Hashtable hashtable = null;
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string, true);
            result_Hash = this.connection.execute(this.logger(), ((DB_SS)this.db_command).get_groups(string2));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                hashtable = this.remote_object.get_groups(string, string2);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
        if (result_Hash != null && result_Hash.get_hash("return_value") != null) {
            hashtable = result_Hash.get_hash("return_value");
        }
        return hashtable;
    }

    @Override
    public Hashtable get_groups(String string) throws Exception, No_Datastore_Defined {
        Hashtable hashtable = null;
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string, true);
            result_Hash = this.connection.execute(this.logger(), ((DB_SS)this.db_command).get_groups());
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                hashtable = this.remote_object.get_groups(string);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
        if (result_Hash != null && result_Hash.get_hash("return_value") != null) {
            hashtable = result_Hash.get_hash("return_value");
        }
        return hashtable;
    }

    @Override
    public Hashtable get_networks(String string, String string2, String string3, String string4) throws Exception, No_Datastore_Defined {
        Hashtable hashtable = null;
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string, true);
            result_Hash = this.connection.execute(this.logger(), ((DB_SS)this.db_command).get_networks(string2, string3, string4, this.datastore.operating_user_id()));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                hashtable = this.remote_object.get_networks(string, string2, string3, string4);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
        if (result_Hash != null && result_Hash.get_hash("return_value") != null) {
            hashtable = result_Hash.get_hash("return_value");
        }
        return hashtable;
    }

    @Override
    public Hashtable get_nodes(String string, String string2, String string3, String string4) throws Exception, No_Datastore_Defined {
        Hashtable hashtable = null;
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string, true);
            result_Hash = this.connection.execute(this.logger(), ((DB_SS)this.db_command).get_nodes(string2, string3, string4, this.datastore.operating_user_id()));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                hashtable = this.remote_object.get_nodes(string, string2, string3, string4);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
        if (result_Hash != null && result_Hash.get_hash("return_value") != null) {
            hashtable = result_Hash.get_hash("return_value");
        }
        return hashtable;
    }

    @Override
    public Hashtable get_users(String string, String string2) throws Exception, No_Datastore_Defined {
        Hashtable hashtable = null;
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string, true);
            result_Hash = this.connection.execute(this.logger(), ((DB_SS)this.db_command).get_users(string2));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                hashtable = this.remote_object.get_users(string, string2);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
        if (result_Hash != null && result_Hash.get_hash("return_value") != null) {
            hashtable = result_Hash.get_hash("return_value");
        }
        return hashtable;
    }

    @Override
    public Hashtable get_users(String string) throws Exception, No_Datastore_Defined {
        Hashtable hashtable = null;
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string, true);
            result_Hash = this.connection.execute(this.logger(), ((DB_SS)this.db_command).get_users());
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                hashtable = this.remote_object.get_users(string);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
        if (result_Hash != null && result_Hash.get_hash("return_value") != null) {
            hashtable = result_Hash.get_hash("return_value");
        }
        return hashtable;
    }
}

