/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.middleware;

import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import stanford.netdb.exceptions.Exception_Formatter;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.middleware.DB_ModelType;
import stanford.netdb.middleware.Datastore;
import stanford.netdb.middleware.MCP_i;
import stanford.netdb.middleware.ModelType_i;
import stanford.netdb.middleware.NetDB_Connection;
import stanford.netdb.middleware.NetDB_Record;
import stanford.netdb.middleware.Result_Hash;

public class NetDB_ModelType
extends NetDB_Record
implements ModelType_i {
    private static final long serialVersionUID = 1L;
    private ModelType_i remote_object = null;
    private NetDB_Connection connection = null;

    public NetDB_ModelType(Datastore datastore) {
        super(datastore, new DB_ModelType());
    }

    protected ModelType_i open_remote_connection(String string) throws Exception, NotBoundException, MalformedURLException, RemoteException {
        MCP_i mCP_i = null;
        try {
            mCP_i = (MCP_i)this.datastore.open_remote_connection();
            return mCP_i.model_type();
        }
        catch (Exception exception) {
            this.datastore.terminate_remote_connection(string);
            mCP_i = (MCP_i)this.datastore.open_remote_connection();
            return mCP_i.model_type();
        }
    }

    @Override
    public Hashtable list(String string) throws Exception, No_Datastore_Defined {
        Hashtable hashtable = null;
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_ModelType)this.db_command).list());
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                hashtable = this.remote_object.list(string);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
        if (result_Hash != null && result_Hash.get_hash("return_value") != null) {
            hashtable = result_Hash.get_hash("return_value");
        }
        return hashtable;
    }

    @Override
    public String verify_or_die(String string, String string2) throws Exception, No_Datastore_Defined {
        String string3 = null;
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_ModelType)this.db_command).verify_or_die(string2));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                string3 = this.remote_object.verify_or_die(string, string2);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
        if (result_Hash != null) {
            string3 = this.extract_string_return(result_Hash);
        }
        return string3;
    }
}

