/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.middleware;

import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import stanford.netdb.exceptions.Exception_Formatter;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.middleware.DB_Log;
import stanford.netdb.middleware.Datastore;
import stanford.netdb.middleware.Log_i;
import stanford.netdb.middleware.MCP_i;
import stanford.netdb.middleware.NetDB_Connection;
import stanford.netdb.middleware.NetDB_Record;
import stanford.netdb.middleware.Result_Hash;

public class NetDB_Log
extends NetDB_Record
implements Log_i {
    private static final long serialVersionUID = 1L;
    private Log_i remote_object = null;
    private NetDB_Connection connection = null;

    public NetDB_Log(Datastore datastore) {
        super(datastore, new DB_Log());
    }

    protected Log_i open_remote_connection(String string) throws Exception, NotBoundException, MalformedURLException, RemoteException {
        MCP_i mCP_i = null;
        try {
            mCP_i = (MCP_i)this.datastore.open_remote_connection();
            return mCP_i.log();
        }
        catch (Exception exception) {
            this.datastore.terminate_remote_connection(string);
            mCP_i = (MCP_i)this.datastore.open_remote_connection();
            return mCP_i.log();
        }
    }

    @Override
    public String get_action(String string) throws Exception, No_Datastore_Defined {
        String string2 = null;
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_Log)this.db_command).get_action());
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                string2 = this.remote_object.get_action(string);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
        if (result_Hash != null) {
            string2 = this.extract_string_return(result_Hash);
        }
        return string2;
    }

    @Override
    public void insert(String string, Integer n, String string2, Integer n2, String string3) throws Exception, No_Datastore_Defined {
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_Log)this.db_command).insert(n, string2, n2, string3));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                this.remote_object.insert(string, n, string2, n2, string3);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
    }

    @Override
    public void set_action(String string, String string2) throws Exception, No_Datastore_Defined {
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_Log)this.db_command).set_action(string2));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                this.remote_object.set_action(string, string2);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
    }
}

