/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.middleware;

import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.util.Hashtable;
import stanford.netdb.exceptions.Exception_Formatter;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.middleware.DB_Interface;
import stanford.netdb.middleware.Datastore;
import stanford.netdb.middleware.Interface_i;
import stanford.netdb.middleware.MCP_i;
import stanford.netdb.middleware.NetDB_Connection;
import stanford.netdb.middleware.NetDB_Record;
import stanford.netdb.middleware.Result_Hash;

public class NetDB_Interface
extends NetDB_Record
implements Interface_i {
    private static final long serialVersionUID = 1L;
    private Interface_i remote_object = null;
    private NetDB_Connection connection = null;

    public NetDB_Interface(Datastore datastore) {
        super(datastore, new DB_Interface());
    }

    protected Interface_i open_remote_connection(String string) throws Exception, NotBoundException, MalformedURLException, RemoteException {
        MCP_i mCP_i = null;
        try {
            mCP_i = (MCP_i)this.datastore.open_remote_connection();
            return mCP_i.iface();
        }
        catch (Exception exception) {
            this.datastore.terminate_remote_connection(string);
            mCP_i = (MCP_i)this.datastore.open_remote_connection();
            return mCP_i.iface();
        }
    }

    @Override
    public void delete(String string, Timestamp timestamp, Integer n) throws Exception, No_Datastore_Defined {
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_Interface)this.db_command).delete(this.datastore.operating_user_id(), timestamp, n));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                this.remote_object.delete(string, timestamp, n);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
    }

    @Override
    public Integer get_parent_id(String string, Integer n) throws Exception, No_Datastore_Defined {
        Integer n2 = null;
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_Interface)this.db_command).get_parent_id(n));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                n2 = this.remote_object.get_parent_id(string, n);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
        if (result_Hash != null) {
            n2 = this.extract_integer_return(result_Hash);
        }
        return n2;
    }

    @Override
    public String handle(String string, Integer n) throws Exception, No_Datastore_Defined {
        String string2 = null;
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_Interface)this.db_command).handle(n));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                string2 = this.remote_object.handle(string, n);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
        if (result_Hash != null) {
            string2 = this.extract_string_return(result_Hash);
        }
        return string2;
    }

    @Override
    public Hashtable info(String string, Integer n) throws Exception, No_Datastore_Defined {
        Hashtable hashtable = null;
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_Interface)this.db_command).info(n));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                hashtable = this.remote_object.info(string, n);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
        if (result_Hash != null && result_Hash.get_hash("return_value") != null) {
            hashtable = result_Hash.get_hash("return_value");
        }
        return hashtable;
    }

    @Override
    public Hashtable insert(String string, Timestamp timestamp, String string2, Integer n, Integer n2, Integer n3, String string3, String string4) throws Exception, No_Datastore_Defined {
        Hashtable hashtable = null;
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_Interface)this.db_command).insert(this.datastore.operating_user_id(), timestamp, string2, n, n2, n3, string3, string4));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                hashtable = this.remote_object.insert(string, timestamp, string2, n, n2, n3, string3, string4);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
        if (result_Hash != null && result_Hash.get_hash("return_value") != null) {
            hashtable = result_Hash.get_hash("return_value");
        }
        return hashtable;
    }

    @Override
    public Hashtable insert(String string, Timestamp timestamp, String string2, Integer n, Integer n2, String string3, String string4) throws Exception, No_Datastore_Defined {
        Hashtable hashtable = null;
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_Interface)this.db_command).insert(this.datastore.operating_user_id(), timestamp, string2, n, n2, string3, string4));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                hashtable = this.remote_object.insert(string, timestamp, string2, n, n2, string3, string4);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
        if (result_Hash != null && result_Hash.get_hash("return_value") != null) {
            hashtable = result_Hash.get_hash("return_value");
        }
        return hashtable;
    }

    @Override
    public Hashtable insert(String string, Timestamp timestamp, String string2, Integer n, String string3, String string4) throws Exception, No_Datastore_Defined {
        Hashtable hashtable = null;
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_Interface)this.db_command).insert(this.datastore.operating_user_id(), timestamp, string2, n, string3, string4));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                hashtable = this.remote_object.insert(string, timestamp, string2, n, string3, string4);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
        if (result_Hash != null && result_Hash.get_hash("return_value") != null) {
            hashtable = result_Hash.get_hash("return_value");
        }
        return hashtable;
    }

    @Override
    public Hashtable insert(String string, Timestamp timestamp, String string2, Integer n, String string3) throws Exception, No_Datastore_Defined {
        Hashtable hashtable = null;
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_Interface)this.db_command).insert(this.datastore.operating_user_id(), timestamp, string2, n, string3));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                hashtable = this.remote_object.insert(string, timestamp, string2, n, string3);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
        if (result_Hash != null && result_Hash.get_hash("return_value") != null) {
            hashtable = result_Hash.get_hash("return_value");
        }
        return hashtable;
    }

    @Override
    public Hashtable insert(String string, Timestamp timestamp, String string2, Integer n) throws Exception, No_Datastore_Defined {
        Hashtable hashtable = null;
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_Interface)this.db_command).insert(this.datastore.operating_user_id(), timestamp, string2, n));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                hashtable = this.remote_object.insert(string, timestamp, string2, n);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
        if (result_Hash != null && result_Hash.get_hash("return_value") != null) {
            hashtable = result_Hash.get_hash("return_value");
        }
        return hashtable;
    }

    @Override
    public Hashtable insert(String string, Timestamp timestamp, String string2, Integer n, Integer n2, String string3) throws Exception, No_Datastore_Defined {
        Hashtable hashtable = null;
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_Interface)this.db_command).insert(this.datastore.operating_user_id(), timestamp, string2, n, n2, string3));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                hashtable = this.remote_object.insert(string, timestamp, string2, n, n2, string3);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
        if (result_Hash != null && result_Hash.get_hash("return_value") != null) {
            hashtable = result_Hash.get_hash("return_value");
        }
        return hashtable;
    }

    @Override
    public Hashtable insert(String string, Timestamp timestamp, String string2, Integer n, Integer n2) throws Exception, No_Datastore_Defined {
        Hashtable hashtable = null;
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_Interface)this.db_command).insert(this.datastore.operating_user_id(), timestamp, string2, n, n2));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                hashtable = this.remote_object.insert(string, timestamp, string2, n, n2);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
        if (result_Hash != null && result_Hash.get_hash("return_value") != null) {
            hashtable = result_Hash.get_hash("return_value");
        }
        return hashtable;
    }

    @Override
    public Hashtable insert(String string, Timestamp timestamp, String string2, Integer n, Integer n2, Integer n3, String string3) throws Exception, No_Datastore_Defined {
        Hashtable hashtable = null;
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_Interface)this.db_command).insert(this.datastore.operating_user_id(), timestamp, string2, n, n2, n3, string3));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                hashtable = this.remote_object.insert(string, timestamp, string2, n, n2, n3, string3);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
        if (result_Hash != null && result_Hash.get_hash("return_value") != null) {
            hashtable = result_Hash.get_hash("return_value");
        }
        return hashtable;
    }

    @Override
    public Hashtable insert(String string, Timestamp timestamp, String string2, Integer n, Integer n2, Integer n3) throws Exception, No_Datastore_Defined {
        Hashtable hashtable = null;
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_Interface)this.db_command).insert(this.datastore.operating_user_id(), timestamp, string2, n, n2, n3));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                hashtable = this.remote_object.insert(string, timestamp, string2, n, n2, n3);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
        if (result_Hash != null && result_Hash.get_hash("return_value") != null) {
            hashtable = result_Hash.get_hash("return_value");
        }
        return hashtable;
    }

    @Override
    public void locked_or_die(String string, Timestamp timestamp, Integer n) throws Exception, No_Datastore_Defined {
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_Interface)this.db_command).locked_or_die(this.datastore.operating_user_id(), timestamp, n));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                this.remote_object.locked_or_die(string, timestamp, n);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
    }

    @Override
    public String pretty_handle(String string, String string2) throws Exception, No_Datastore_Defined {
        String string3 = null;
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_Interface)this.db_command).pretty_handle(string2));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                string3 = this.remote_object.pretty_handle(string, string2);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
        if (result_Hash != null) {
            string3 = this.extract_string_return(result_Hash);
        }
        return string3;
    }

    @Override
    public void update(String string, Timestamp timestamp, Integer n, String string2, Integer n2, Integer n3, String string3, String string4) throws Exception, No_Datastore_Defined {
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_Interface)this.db_command).update(this.datastore.operating_user_id(), timestamp, n, string2, n2, n3, string3, string4));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                this.remote_object.update(string, timestamp, n, string2, n2, n3, string3, string4);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
    }

    @Override
    public void update(String string, Timestamp timestamp, Integer n, String string2, Integer n2, String string3, String string4) throws Exception, No_Datastore_Defined {
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_Interface)this.db_command).update(this.datastore.operating_user_id(), timestamp, n, string2, n2, string3, string4));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                this.remote_object.update(string, timestamp, n, string2, n2, string3, string4);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
    }

    @Override
    public void update(String string, Timestamp timestamp, Integer n, String string2, String string3, String string4) throws Exception, No_Datastore_Defined {
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_Interface)this.db_command).update(this.datastore.operating_user_id(), timestamp, n, string2, string3, string4));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                this.remote_object.update(string, timestamp, n, string2, string3, string4);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
    }

    @Override
    public void update(String string, Timestamp timestamp, Integer n, String string2, String string3) throws Exception, No_Datastore_Defined {
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_Interface)this.db_command).update(this.datastore.operating_user_id(), timestamp, n, string2, string3));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                this.remote_object.update(string, timestamp, n, string2, string3);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
    }

    @Override
    public void update(String string, Timestamp timestamp, Integer n, String string2) throws Exception, No_Datastore_Defined {
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_Interface)this.db_command).update(this.datastore.operating_user_id(), timestamp, n, string2));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                this.remote_object.update(string, timestamp, n, string2);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
    }

    @Override
    public void update(String string, Timestamp timestamp, Integer n, String string2, Integer n2, String string3) throws Exception, No_Datastore_Defined {
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_Interface)this.db_command).update(this.datastore.operating_user_id(), timestamp, n, string2, n2, string3));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                this.remote_object.update(string, timestamp, n, string2, n2, string3);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
    }

    @Override
    public void update(String string, Timestamp timestamp, Integer n, String string2, Integer n2) throws Exception, No_Datastore_Defined {
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_Interface)this.db_command).update(this.datastore.operating_user_id(), timestamp, n, string2, n2));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                this.remote_object.update(string, timestamp, n, string2, n2);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
    }

    @Override
    public void update(String string, Timestamp timestamp, Integer n, String string2, Integer n2, Integer n3, String string3) throws Exception, No_Datastore_Defined {
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_Interface)this.db_command).update(this.datastore.operating_user_id(), timestamp, n, string2, n2, n3, string3));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                this.remote_object.update(string, timestamp, n, string2, n2, n3, string3);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
    }

    @Override
    public void update(String string, Timestamp timestamp, Integer n, String string2, Integer n2, Integer n3) throws Exception, No_Datastore_Defined {
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_Interface)this.db_command).update(this.datastore.operating_user_id(), timestamp, n, string2, n2, n3));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                this.remote_object.update(string, timestamp, n, string2, n2, n3);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
    }

    @Override
    public Integer verify_or_die(String string, Integer n, String string2) throws Exception, No_Datastore_Defined {
        Integer n2 = null;
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_Interface)this.db_command).verify_or_die(n, string2));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                n2 = this.remote_object.verify_or_die(string, n, string2);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
        if (result_Hash != null) {
            n2 = this.extract_integer_return(result_Hash);
        }
        return n2;
    }

    @Override
    public Integer verify_or_die(String string, String string2) throws Exception, No_Datastore_Defined {
        Integer n = null;
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_Interface)this.db_command).verify_or_die(string2));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                n = this.remote_object.verify_or_die(string, string2);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
        if (result_Hash != null) {
            n = this.extract_integer_return(result_Hash);
        }
        return n;
    }

    @Override
    public Integer verify_or_die(String string, Integer n) throws Exception, No_Datastore_Defined {
        Integer n2 = null;
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_Interface)this.db_command).verify_or_die(n));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                n2 = this.remote_object.verify_or_die(string, n);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
        if (result_Hash != null) {
            n2 = this.extract_integer_return(result_Hash);
        }
        return n2;
    }
}

