/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.middleware;

import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import stanford.netdb.exceptions.Exception_Formatter;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.middleware.DB_Default;
import stanford.netdb.middleware.Datastore;
import stanford.netdb.middleware.Default_i;
import stanford.netdb.middleware.MCP_i;
import stanford.netdb.middleware.NetDB_Connection;
import stanford.netdb.middleware.NetDB_Record;
import stanford.netdb.middleware.Result_Hash;

public class NetDB_Default
extends NetDB_Record
implements Default_i {
    private static final long serialVersionUID = 1L;
    private Default_i remote_object = null;
    private NetDB_Connection connection = null;

    public NetDB_Default(Datastore datastore) {
        super(datastore, new DB_Default());
    }

    protected Default_i open_remote_connection(String string) throws Exception, NotBoundException, MalformedURLException, RemoteException {
        MCP_i mCP_i = null;
        try {
            mCP_i = (MCP_i)this.datastore.open_remote_connection();
            return mCP_i.global_default();
        }
        catch (Exception exception) {
            this.datastore.terminate_remote_connection(string);
            mCP_i = (MCP_i)this.datastore.open_remote_connection();
            return mCP_i.global_default();
        }
    }

    @Override
    public Integer get_id(String string, String string2) throws Exception, No_Datastore_Defined {
        Integer n = null;
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_Default)this.db_command).get_id(string2));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                n = this.remote_object.get_id(string, string2);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
        if (result_Hash != null) {
            n = this.extract_integer_return(result_Hash);
        }
        return n;
    }

    @Override
    public Integer get_int(String string, String string2) throws Exception, No_Datastore_Defined {
        Integer n = null;
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_Default)this.db_command).get_int(string2));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                n = this.remote_object.get_int(string, string2);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
        if (result_Hash != null) {
            n = this.extract_integer_return(result_Hash);
        }
        return n;
    }

    @Override
    public String get_str(String string, String string2) throws Exception, No_Datastore_Defined {
        String string3 = null;
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_Default)this.db_command).get_str(string2));
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                string3 = this.remote_object.get_str(string, string2);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
        if (result_Hash != null) {
            string3 = this.extract_string_return(result_Hash);
        }
        return string3;
    }

    @Override
    public Hashtable list(String string) throws Exception, No_Datastore_Defined {
        Hashtable hashtable = null;
        Result_Hash result_Hash = null;
        if (this.datastore == null) {
            throw new No_Datastore_Defined("No datastore has been defined.");
        }
        if (this.datastore.connection_type() == Datastore.TYPE.DATABASE) {
            this.connection = this.datastore.open_direct_connection(string);
            result_Hash = this.connection.execute(this.logger(), ((DB_Default)this.db_command).list());
        } else {
            this.remote_object = this.open_remote_connection(string);
            try {
                hashtable = this.remote_object.list(string);
            }
            catch (Exception exception) {
                throw new Exception(Exception_Formatter.clean_remote_exception(exception, this.logger(), "database"), exception);
            }
            finally {
                this.datastore.close_remote_connection(string);
            }
        }
        if (result_Hash != null && result_Hash.get_hash("return_value") != null) {
            hashtable = result_Hash.get_hash("return_value");
        }
        return hashtable;
    }
}

