/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.middleware;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.logging.Logger;
import stanford.netdb.Group;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.User;
import stanford.netdb.directory.Directory;
import stanford.netdb.logging.NetDB_Logger;
import stanford.netdb.middleware.Access_i;
import stanford.netdb.middleware.AdminTeam_i;
import stanford.netdb.middleware.DHCPoption_i;
import stanford.netdb.middleware.DHCPservice_i;
import stanford.netdb.middleware.Datastore;
import stanford.netdb.middleware.Default_i;
import stanford.netdb.middleware.Directory_i;
import stanford.netdb.middleware.Domain_i;
import stanford.netdb.middleware.Full_Search_i;
import stanford.netdb.middleware.Handshake;
import stanford.netdb.middleware.IPaddressSpace_i;
import stanford.netdb.middleware.IPaddress_i;
import stanford.netdb.middleware.InterfaceType_i;
import stanford.netdb.middleware.Interface_i;
import stanford.netdb.middleware.Location_i;
import stanford.netdb.middleware.Log_i;
import stanford.netdb.middleware.MCP_i;
import stanford.netdb.middleware.MXrecord_i;
import stanford.netdb.middleware.Make_i;
import stanford.netdb.middleware.ModelType_i;
import stanford.netdb.middleware.Model_i;
import stanford.netdb.middleware.Name_i;
import stanford.netdb.middleware.Network_i;
import stanford.netdb.middleware.NodeType_i;
import stanford.netdb.middleware.Node_i;
import stanford.netdb.middleware.OS_i;
import stanford.netdb.middleware.Organization_i;
import stanford.netdb.middleware.Owner_i;
import stanford.netdb.middleware.Person_i;
import stanford.netdb.middleware.Queued_Access;
import stanford.netdb.middleware.Queued_AdminTeam;
import stanford.netdb.middleware.Queued_DHCPoption;
import stanford.netdb.middleware.Queued_DHCPservice;
import stanford.netdb.middleware.Queued_Default;
import stanford.netdb.middleware.Queued_Directory;
import stanford.netdb.middleware.Queued_Domain;
import stanford.netdb.middleware.Queued_Full_Search;
import stanford.netdb.middleware.Queued_IPaddress;
import stanford.netdb.middleware.Queued_IPaddressSpace;
import stanford.netdb.middleware.Queued_Interface;
import stanford.netdb.middleware.Queued_InterfaceType;
import stanford.netdb.middleware.Queued_Location;
import stanford.netdb.middleware.Queued_Log;
import stanford.netdb.middleware.Queued_MXrecord;
import stanford.netdb.middleware.Queued_Make;
import stanford.netdb.middleware.Queued_Model;
import stanford.netdb.middleware.Queued_ModelType;
import stanford.netdb.middleware.Queued_Name;
import stanford.netdb.middleware.Queued_Network;
import stanford.netdb.middleware.Queued_Node;
import stanford.netdb.middleware.Queued_NodeType;
import stanford.netdb.middleware.Queued_OS;
import stanford.netdb.middleware.Queued_Organization;
import stanford.netdb.middleware.Queued_Owner;
import stanford.netdb.middleware.Queued_Person;
import stanford.netdb.middleware.Queued_SS;
import stanford.netdb.middleware.Queued_State;
import stanford.netdb.middleware.Queued_User;
import stanford.netdb.middleware.SS_i;
import stanford.netdb.middleware.Session_ID;
import stanford.netdb.middleware.State_i;
import stanford.netdb.middleware.User_i;
import stanford.netdb.util.ACL;
import stanford.netdb.util.ClientSocketFactory;
import stanford.netdb.util.Kerberos;
import stanford.netdb.util.Property;
import stanford.netdb.util.Resource_Reader;
import stanford.netdb.util.ServerSocketFactory;

public class MCP
extends UnicastRemoteObject
implements MCP_i {
    public static final long serialVersionUID = 1L;
    private static String compatible_versions = "";
    private boolean handshake_completed = false;
    private boolean authenticated = false;
    private String authenticated_principal = "";
    private String client_address = null;
    private ACL acl = null;
    private Datastore datastore = null;
    private Directory dir = null;
    private int port = 0;
    private Access_i access = null;
    private AdminTeam_i admin_team = null;
    private Default_i global_default = null;
    private DHCPoption_i dhcp_option = null;
    private DHCPservice_i dhcp_service = null;
    private Domain_i domain = null;
    private IPaddress_i ip_address = null;
    private IPaddressSpace_i ip_address_space = null;
    private Interface_i iface = null;
    private InterfaceType_i interface_type = null;
    private Location_i location = null;
    private Log_i log = null;
    private MXrecord_i mx_record = null;
    private Make_i make = null;
    private Model_i model = null;
    private ModelType_i model_type = null;
    private Name_i name = null;
    private Network_i network = null;
    private Node_i node = null;
    private NodeType_i node_type = null;
    private OS_i os = null;
    private Organization_i organization = null;
    private Owner_i owner = null;
    private Person_i person = null;
    private State_i state = null;
    private User_i user = null;
    private Directory_i directory = null;
    private SS_i simple_search = null;
    private Full_Search_i full_search = null;
    private static Kerberos keytab = null;

    private MCP(int n, Datastore datastore, Directory directory) throws RemoteException {
        super(n, new ClientSocketFactory(), new ServerSocketFactory());
        try {
            this.client_address = this.getClientHost();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.port = n;
        this.datastore = datastore;
        this.dir = directory;
    }

    public MCP(int n, Datastore datastore, Directory directory, ACL aCL) throws RemoteException {
        super(n, new ClientSocketFactory(), new ServerSocketFactory());
        try {
            this.client_address = this.getClientHost();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.port = n;
        this.datastore = datastore;
        this.dir = directory;
        this.acl = aCL;
    }

    public static Kerberos get_keytab() throws Exception {
        return MCP.get_keytab(null);
    }

    public static Kerberos get_keytab(Logger logger) throws Exception {
        String string = System.getProperty("rmi.kerberos.keytab");
        String string2 = System.getProperty("rmi.kerberos.principal");
        if (!(keytab != null && keytab.principal().equals(string2) && keytab.keytab().equals(string) && keytab.still_valid().booleanValue())) {
            keytab = new Kerberos(string, string2);
            if (logger != null) {
                keytab.logger(logger);
            }
            keytab.certify();
        }
        return keytab;
    }

    @Override
    public byte[] handshake(byte[] byArray) throws Exception, RemoteException {
        Handshake handshake = new Handshake();
        byte[] byArray2 = handshake.accept(MCP.get_keytab(), byArray);
        this.handshake_completed = handshake.completed();
        if (handshake.accepted_principal != null && !handshake.accepted_principal.equals("")) {
            this.authenticated_principal = handshake.accepted_principal;
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check_client_version(String string) throws Exception, RemoteException {
        String string2 = compatible_versions;
        synchronized (string2) {
            if (compatible_versions == null || compatible_versions.equals("")) {
                String string3 = System.getProperty("resource.server_versions", "compatible_versions");
                compatible_versions = Resource_Reader.string_data(string3).toLowerCase();
                compatible_versions = "^(" + compatible_versions.replaceAll("\n", "|") + ")$";
                compatible_versions = compatible_versions.replaceAll("(\\|\\s+|\\s+\\|)", "|");
                compatible_versions = compatible_versions.replaceAll("\\|{2,}", "|");
                compatible_versions = compatible_versions.replaceAll("\\|\\)", "\\)").replaceAll("\\(\\|", "\\(");
            }
        }
        if (!string.toLowerCase().matches(compatible_versions)) {
            string2 = compatible_versions.replaceAll("[$^]", "");
            throw new Exception("Your client (" + string + ") is not compatible with the RMI server.  Compatible versions: " + string2);
        }
    }

    @Override
    public MCP_i authenticate() throws Exception, RemoteException {
        Serializable serializable;
        Object object;
        Session_ID session_ID = Session_ID.next();
        this.datastore.session_id(session_ID);
        if (!this.handshake_completed) {
            throw new Exception("The client and server have not completed the handshake process.");
        }
        String string = Kerberos.clean_principal(this.authenticated_principal, "/root", null);
        if (!this.acl.has_access(string).booleanValue()) {
            throw new Exception("'" + string + "' is not permitted access to the RMI server.");
        }
        if (Property.fetch_as_Boolean("rmi.kerberos.require_root", "false").booleanValue()) {
            object = System.getProperty("rmi.kerberos.require_root.group_name", "");
            serializable = false;
            if (object != null && !((String)object).equals("")) {
                User user = User.load(new NetDB_Datastore(this.datastore), string);
                for (Group group : user.owners()) {
                    if (!group.name().equals(object)) continue;
                    serializable = true;
                    break;
                }
            }
            if (serializable.booleanValue() && (this.authenticated_principal == null || !this.authenticated_principal.contains("/root"))) {
                throw new Exception("'" + string + "' is required to use root instances for authentication.");
            }
        }
        object = new Datastore(this.datastore.host(), this.datastore.port(), this.datastore.user_name(), this.datastore.user_password(), this.datastore.search_user_name(), this.datastore.search_user_password());
        ((Datastore)object).session_id(session_ID);
        ((NetDB_Logger)object).logger(this.datastore.logger());
        ((Datastore)object).operating_user(null, string);
        serializable = new MCP(this.port, (Datastore)object, this.dir);
        ((MCP)serializable).authenticated = true;
        this.datastore.logger().info(session_ID.toString() + " " + ((MCP)serializable).client_address + " authenticated as " + this.authenticated_principal);
        return serializable;
    }

    @Override
    public String start_transaction(String string) throws Exception {
        this.check_authentication();
        return this.datastore.start_transaction(string);
    }

    @Override
    public void end_transaction(String string) throws Exception {
        this.check_authentication();
        this.datastore.end_transaction(string);
    }

    @Override
    public void rollback_transaction(String string) throws Exception {
        this.check_authentication();
        this.datastore.rollback_transaction(string);
    }

    private void check_authentication() throws Exception {
        if (!this.authenticated) {
            throw new Exception("You must authenticate before you can interact with the database.");
        }
    }

    @Override
    public Access_i access() throws Exception {
        this.check_authentication();
        if (this.access == null) {
            this.access = new Queued_Access(this.datastore);
        }
        return this.access;
    }

    @Override
    public AdminTeam_i admin_team() throws Exception {
        this.check_authentication();
        if (this.admin_team == null) {
            this.admin_team = new Queued_AdminTeam(this.datastore);
        }
        return this.admin_team;
    }

    @Override
    public Default_i global_default() throws Exception, RemoteException {
        this.check_authentication();
        if (this.global_default == null) {
            this.global_default = new Queued_Default(this.datastore);
        }
        return this.global_default;
    }

    @Override
    public DHCPoption_i dhcp_option() throws Exception {
        this.check_authentication();
        if (this.dhcp_option == null) {
            this.dhcp_option = new Queued_DHCPoption(this.datastore);
        }
        return this.dhcp_option;
    }

    @Override
    public DHCPservice_i dhcp_service() throws Exception {
        this.check_authentication();
        if (this.dhcp_service == null) {
            this.dhcp_service = new Queued_DHCPservice(this.datastore);
        }
        return this.dhcp_service;
    }

    @Override
    public Domain_i domain() throws Exception {
        this.check_authentication();
        if (this.domain == null) {
            this.domain = new Queued_Domain(this.datastore);
        }
        return this.domain;
    }

    @Override
    public IPaddress_i ip_address() throws Exception {
        this.check_authentication();
        if (this.ip_address == null) {
            this.ip_address = new Queued_IPaddress(this.datastore);
        }
        return this.ip_address;
    }

    @Override
    public IPaddressSpace_i ip_address_space() throws Exception {
        this.check_authentication();
        if (this.ip_address_space == null) {
            this.ip_address_space = new Queued_IPaddressSpace(this.datastore);
        }
        return this.ip_address_space;
    }

    @Override
    public Interface_i iface() throws Exception {
        this.check_authentication();
        if (this.iface == null) {
            this.iface = new Queued_Interface(this.datastore);
        }
        return this.iface;
    }

    @Override
    public InterfaceType_i interface_type() throws Exception {
        this.check_authentication();
        if (this.interface_type == null) {
            this.interface_type = new Queued_InterfaceType(this.datastore);
        }
        return this.interface_type;
    }

    @Override
    public Location_i location() throws Exception {
        this.check_authentication();
        if (this.location == null) {
            this.location = new Queued_Location(this.datastore);
        }
        return this.location;
    }

    @Override
    public Log_i log() throws Exception {
        this.check_authentication();
        if (this.log == null) {
            this.log = new Queued_Log(this.datastore);
        }
        return this.log;
    }

    @Override
    public MXrecord_i mx_record() throws Exception {
        this.check_authentication();
        if (this.mx_record == null) {
            this.mx_record = new Queued_MXrecord(this.datastore);
        }
        return this.mx_record;
    }

    @Override
    public Make_i make() throws Exception {
        this.check_authentication();
        if (this.make == null) {
            this.make = new Queued_Make(this.datastore);
        }
        return this.make;
    }

    @Override
    public Model_i model() throws Exception {
        this.check_authentication();
        if (this.model == null) {
            this.model = new Queued_Model(this.datastore);
        }
        return this.model;
    }

    @Override
    public ModelType_i model_type() throws Exception {
        this.check_authentication();
        if (this.model_type == null) {
            this.model_type = new Queued_ModelType(this.datastore);
        }
        return this.model_type;
    }

    @Override
    public Name_i name() throws Exception {
        this.check_authentication();
        if (this.name == null) {
            this.name = new Queued_Name(this.datastore);
        }
        return this.name;
    }

    @Override
    public Network_i network() throws Exception {
        this.check_authentication();
        if (this.network == null) {
            this.network = new Queued_Network(this.datastore);
        }
        return this.network;
    }

    @Override
    public Node_i node() throws Exception {
        this.check_authentication();
        if (this.node == null) {
            this.node = new Queued_Node(this.datastore);
        }
        return this.node;
    }

    @Override
    public NodeType_i node_type() throws Exception {
        this.check_authentication();
        if (this.node_type == null) {
            this.node_type = new Queued_NodeType(this.datastore);
        }
        return this.node_type;
    }

    @Override
    public OS_i os() throws Exception {
        this.check_authentication();
        if (this.os == null) {
            this.os = new Queued_OS(this.datastore);
        }
        return this.os;
    }

    @Override
    public Organization_i organization() throws Exception {
        this.check_authentication();
        if (this.organization == null) {
            this.organization = new Queued_Organization(this.datastore);
        }
        return this.organization;
    }

    @Override
    public Owner_i owner() throws Exception {
        this.check_authentication();
        if (this.owner == null) {
            this.owner = new Queued_Owner(this.datastore);
        }
        return this.owner;
    }

    @Override
    public Person_i person() throws Exception {
        this.check_authentication();
        if (this.person == null) {
            this.person = new Queued_Person(this.datastore);
        }
        return this.person;
    }

    @Override
    public State_i state() throws Exception {
        this.check_authentication();
        if (this.state == null) {
            this.state = new Queued_State(this.datastore);
        }
        return this.state;
    }

    @Override
    public User_i user() throws Exception {
        this.check_authentication();
        if (this.user == null) {
            this.user = new Queued_User(this.datastore);
        }
        return this.user;
    }

    @Override
    public Directory_i directory() throws Exception {
        this.check_authentication();
        if (this.directory == null) {
            this.directory = new Queued_Directory(this.datastore, this.dir);
        }
        return this.directory;
    }

    @Override
    public SS_i simple_search() throws Exception {
        this.check_authentication();
        if (this.simple_search == null) {
            this.simple_search = new Queued_SS(this.datastore);
        }
        return this.simple_search;
    }

    @Override
    public Full_Search_i full_search() throws Exception, RemoteException {
        this.check_authentication();
        if (this.full_search == null) {
            this.full_search = new Queued_Full_Search(this.datastore);
        }
        return this.full_search;
    }
}

