/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.middleware;

import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import stanford.netdb.exceptions.Action_Not_Permitted;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.logging.NetDB_Logger;
import stanford.netdb.middleware.Handshake;
import stanford.netdb.middleware.MCP_i;
import stanford.netdb.middleware.NetDB_Connection;
import stanford.netdb.middleware.NetDB_User;
import stanford.netdb.middleware.Session_ID;
import stanford.netdb.util.Kerberos;
import stanford.netdb.util.SRV_Record;

public class Datastore<T extends Datastore>
extends NetDB_Logger {
    private static final long serialVersionUID = 1L;
    private long srv_age = 162000L;
    private Timestamp srv_lookup = null;
    private String srv_record = null;
    private SRV_Record used_srv = null;
    private Vector<SRV_Record> srv_hosts = new Vector();
    private String host = null;
    private int port = 0;
    private String user_name = null;
    private String user_password = null;
    private String search_user_name = null;
    private String search_user_password = null;
    private String keytab = null;
    private String principal = null;
    private String krb5_conf = null;
    private String directory_connection = null;
    private Session_ID session_id = null;
    private Kerberos kerberos = null;
    private String operating_user_netid = null;
    private Integer operating_user_id = null;
    private MCP_i mcp = null;
    private Hashtable<String, NetDB_Connection> active_transactions = new Hashtable();
    protected Boolean search_connection = false;
    private static Integer transaction_counter = 0;
    protected Integer transaction_id = 0;

    public Datastore(String string) {
        this.srv_record(string);
    }

    public Datastore(String string, String string2) {
        this.srv_record(string);
        Kerberos.krb5_conf(string2);
    }

    public Datastore(String string, String string2, String string3) {
        this.srv_record(string);
        this.keytab(string2);
        this.principal(string3);
    }

    public Datastore(String string, String string2, String string3, String string4) {
        this.srv_record(string);
        this.keytab(string2);
        this.principal(string3);
        Kerberos.krb5_conf(string4);
    }

    public Datastore(String string, int n, String string2, String string3, String string4, String string5) {
        this.host(string, n);
        this.user(string2, string3);
        this.search_user(string4, string5);
    }

    public Datastore(String string, int n) {
        this(string, n, "", "", "");
    }

    public Datastore(String string, int n, String string2) {
        this(string, n, "", "", string2);
    }

    public Datastore(String string, int n, String string2, String string3) {
        this(string, n, string2, string3, "");
    }

    public Datastore(String string, int n, String string2, String string3, String string4) {
        this.host(string, n);
        this.keytab(string2);
        this.principal(string3);
        Kerberos.krb5_conf(string4);
    }

    public Datastore(Datastore datastore) {
        this.logger(datastore.logger);
        this.srv_record = datastore.srv_record;
        this.host = datastore.host;
        this.port = datastore.port;
        this.user_name = datastore.user_name;
        this.user_password = datastore.user_password;
        this.search_user_name = datastore.search_user_name;
        this.search_user_password = datastore.search_user_password;
        this.keytab = datastore.keytab;
        this.principal = datastore.principal;
        this.krb5_conf = datastore.krb5_conf;
        this.directory_connection = datastore.directory_connection;
        this.kerberos = datastore.kerberos;
        this.operating_user_netid = datastore.operating_user_netid;
        this.operating_user_id = datastore.operating_user_id;
        this.session_id = datastore.session_id;
    }

    public String srv_record() {
        return this.srv_record;
    }

    public Vector<SRV_Record> srv_hosts() {
        return (Vector)this.srv_hosts.clone();
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public String user_name() {
        return this.user_name;
    }

    public String user_password() {
        return this.user_password;
    }

    public String search_user_name() {
        return this.search_user_name;
    }

    public String search_user_password() {
        return this.search_user_password;
    }

    public String keytab() {
        return this.keytab;
    }

    public String principal() {
        return this.principal;
    }

    public String directory_connection() {
        return this.directory_connection;
    }

    protected Integer operating_user_id() {
        return this.operating_user_id;
    }

    public String operating_user_netid() throws Exception {
        if (this.operating_user_netid == null) {
            this.operating_user_netid = this.read_user_netid();
        }
        return this.operating_user_netid;
    }

    public Session_ID session_id() {
        return this.session_id;
    }

    public TYPE connection_type() {
        if (!(this.user_name == null || this.user_name.equals("") || this.user_password == null || this.user_password.equals("") || this.search_user_name == null || this.search_user_name.equals("") || this.search_user_password == null || this.search_user_password.equals(""))) {
            return TYPE.DATABASE;
        }
        return TYPE.RMI;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(Boolean bl) {
        String string = "";
        string = this.srv_record != null && !this.srv_record.equals("") ? this.srv_record : this.host + ":" + this.port;
        if (bl.booleanValue()) {
            if (this.srv_record != null && !this.srv_record.equals("")) {
                string = "    " + this.host + ":" + this.port;
            }
            string = string + "    instance: " + System.getProperty("database.instance") + "    schema: " + System.getProperty("database.schema") + "    user: " + this.user_name();
        }
        return string;
    }

    protected T srv_record(String string) {
        if (string != null) {
            this.srv_record = string.trim();
        }
        return (T)this;
    }

    protected T host(String string) {
        if (string != null) {
            this.host = string.trim();
        }
        return (T)this;
    }

    protected T port(int n) {
        this.port = n;
        return (T)this;
    }

    protected T user_name(String string) {
        this.user_name = string;
        return (T)this;
    }

    protected T user_password(String string) {
        this.user_password = string;
        return (T)this;
    }

    protected T search_user_name(String string) {
        this.search_user_name = string;
        return (T)this;
    }

    protected T search_user_password(String string) {
        this.search_user_password = string;
        return (T)this;
    }

    protected T host(String string, int n) {
        this.host(string);
        this.port(n);
        return (T)this;
    }

    protected T user(String string, String string2) {
        this.user_name(string);
        this.user_password(string2);
        if (this.connection_type() == TYPE.RMI) {
            this.operating_user_id = null;
            this.operating_user_netid = null;
            this.mcp = null;
        }
        return (T)this;
    }

    protected T search_user(String string, String string2) {
        this.search_user_name(string);
        this.search_user_password(string2);
        if (this.connection_type() == TYPE.RMI) {
            this.operating_user_id = null;
            this.operating_user_netid = null;
            this.mcp = null;
        }
        return (T)this;
    }

    protected T directory_connection(String string) throws Exception, No_Datastore_Defined, Action_Not_Permitted {
        if (this.connection_type() == TYPE.RMI) {
            throw new Action_Not_Permitted("The directory cannot be set when using an RMI connection.");
        }
        this.directory_connection = string;
        return (T)this;
    }

    protected T operating_user(Integer n, String string) throws Exception, No_Datastore_Defined, Action_Not_Permitted {
        return this.operating_user(n, string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T operating_user(Integer n, String string, Boolean bl) throws Exception, No_Datastore_Defined, Action_Not_Permitted {
        String string2 = "";
        try {
            string2 = this.start_transaction("operating_user");
            if (this.connection_type() == TYPE.RMI) {
                throw new Action_Not_Permitted("The operating user cannot be set when using an RMI connection.");
            }
            if (n == null && string != null) {
                n = new NetDB_User(this).verify_or_die(string2, string);
            } else if (n != null && (string == null || string.equals(""))) {
                string = new NetDB_User(this).handle(string2, new Integer(n));
            } else if (bl.booleanValue()) {
                new NetDB_User(this).verify_or_die(string2, n, string);
            }
            this.mcp = null;
            this.operating_user_id = n;
            this.operating_user_netid = string;
            Datastore datastore = this;
            return (T)datastore;
        }
        finally {
            this.rollback_transaction(string2);
        }
    }

    public T keytab(String string) {
        this.keytab = string.trim();
        return (T)this;
    }

    public T principal(String string) {
        this.principal = string.trim();
        return (T)this;
    }

    public Boolean equals(Datastore datastore) {
        String string = "";
        String string2 = "";
        if (this.srv_record != null && !this.srv_record.equals("")) {
            string = this.srv_record;
        } else if (this.host != null) {
            string = this.host.toLowerCase() + ":" + this.port;
        }
        if (datastore != null) {
            if (datastore.srv_record != null && !datastore.srv_record.equals("")) {
                string2 = datastore.srv_record;
            } else if (datastore.host != null) {
                string2 = datastore.host.toLowerCase() + ":" + datastore.port;
            }
        }
        return string.equals(string2);
    }

    protected void session_id(Session_ID session_ID) {
        this.session_id = session_ID;
    }

    private synchronized Integer next_transaction_id() {
        if (transaction_counter < 0) {
            transaction_counter = 0;
        }
        Integer n = transaction_counter;
        Integer n2 = transaction_counter = Integer.valueOf(transaction_counter + 1);
        return n;
    }

    private String logged_session_id(NetDB_Connection netDB_Connection) {
        return netDB_Connection.logged_session_id();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String start_transaction(String string) throws Exception {
        String string2 = "";
        if (this.connection_type() == TYPE.RMI) {
            this.open_remote_connection();
            string2 = this.mcp.start_transaction(string);
        } else {
            this.transaction_id = this.next_transaction_id();
            string2 = string + "-" + this.transaction_id;
            NetDB_Connection netDB_Connection = null;
            Hashtable<String, NetDB_Connection> hashtable = this.active_transactions;
            synchronized (hashtable) {
                netDB_Connection = this.active_transactions.get(string2);
            }
            if (netDB_Connection == null) {
                netDB_Connection = this.open_direct_connection(string2);
                hashtable = this.active_transactions;
                synchronized (hashtable) {
                    this.active_transactions.put(string2, netDB_Connection);
                }
            }
            if (netDB_Connection.transaction_id() == null) {
                netDB_Connection.transaction_id(this.transaction_id);
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void end_transaction(String string) throws Exception, SQLException {
        if (this.connection_type() == TYPE.RMI) {
            if (this.mcp != null) {
                this.mcp.end_transaction(string);
                this.close_remote_connection(string);
            }
        } else {
            NetDB_Connection netDB_Connection = null;
            Hashtable<String, NetDB_Connection> hashtable = this.active_transactions;
            synchronized (hashtable) {
                netDB_Connection = this.active_transactions.get(string);
            }
            if (netDB_Connection != null) {
                netDB_Connection.commit(this.logger());
                netDB_Connection.transaction_id(null);
            }
            this.close_direct_connection(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollback_transaction(String string) throws Exception, SQLException {
        if (this.connection_type() == TYPE.RMI) {
            if (this.mcp != null) {
                this.mcp.rollback_transaction(string);
                this.close_remote_connection(string);
            }
        } else {
            NetDB_Connection netDB_Connection = null;
            Hashtable<String, NetDB_Connection> hashtable = this.active_transactions;
            synchronized (hashtable) {
                netDB_Connection = this.active_transactions.get(string);
            }
            if (netDB_Connection != null) {
                netDB_Connection.rollback(this.logger());
                netDB_Connection.transaction_id(null);
            }
            this.close_direct_connection(string);
        }
    }

    protected NetDB_Connection open_direct_connection(String string) throws Exception, ClassNotFoundException, InstantiationException, IllegalAccessException {
        return this.open_direct_connection(string, false);
    }

    protected NetDB_Connection open_direct_connection(String string, Boolean bl) throws Exception, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String string2 = System.getProperty("database.type", "oracle");
        if ("oracle".equals(string2)) {
            return this.open_direct_oracle_connection(string, bl);
        }
        throw new Exception("Unknown database type '" + string2 + "'.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetDB_Connection open_direct_oracle_connection(String string, Boolean bl) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        NetDB_Connection netDB_Connection = null;
        Object object = this.active_transactions;
        synchronized (object) {
            netDB_Connection = this.active_transactions.get(string);
        }
        if (netDB_Connection != null && this.search_connection == bl) {
            return netDB_Connection;
        }
        this.search_connection = bl;
        Class.forName("oracle.jdbc.driver.OracleDriver").newInstance();
        object = this.user_name();
        String string2 = this.user_password();
        if (bl.booleanValue()) {
            object = this.search_user_name();
            string2 = this.search_user_password();
        }
        Properties properties = new Properties();
        properties.put("user", object);
        properties.put("password", string2);
        String string3 = String.format("jdbc:oracle:thin:@%s:%s:%s", this.host(), this.port(), System.getProperty("database.instance"));
        netDB_Connection = new NetDB_Connection(string3, properties);
        NetDB_Connection.db_schema(System.getProperty("database.schema", "netdb"));
        netDB_Connection.session_id(this.session_id);
        return netDB_Connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close_direct_connection(String string) throws SQLException {
        NetDB_Connection netDB_Connection = null;
        Hashtable<String, NetDB_Connection> hashtable = this.active_transactions;
        synchronized (hashtable) {
            netDB_Connection = this.active_transactions.get(string);
        }
        if (netDB_Connection != null) {
            netDB_Connection.release();
            hashtable = this.active_transactions;
            synchronized (hashtable) {
                this.active_transactions.remove(string);
            }
        }
    }

    private Kerberos kerberos(String string, String string2) throws Exception {
        if (this.kerberos == null) {
            this.kerberos = new Kerberos();
            if (string != null && string2 != null) {
                this.kerberos.keytab(string).principal(string2);
            }
        }
        return this.kerberos;
    }

    protected String read_user_netid() throws Exception {
        Kerberos kerberos = this.kerberos(this.keytab, this.principal);
        kerberos.certify();
        return Kerberos.clean_principal(kerberos.certified_principal(), "/root", null);
    }

    protected MCP_i remote_authenticate(MCP_i mCP_i) throws Exception {
        MCP_i mCP_i2 = Handshake.initiate(this.kerberos(this.keytab, this.principal), mCP_i);
        return mCP_i2;
    }

    protected void srv_resolve() throws Exception {
        if (this.srv_record == null || this.srv_record.equals("")) {
            return;
        }
        long l = new Date().getTime();
        if (this.srv_lookup == null || l - this.srv_lookup.getTime() > this.srv_age) {
            this.srv_hosts = new Vector();
            InitialDirContext initialDirContext = new InitialDirContext();
            Attributes attributes = initialDirContext.getAttributes("dns:/" + this.srv_record, new String[]{"SRV"});
            Attribute attribute = attributes.get("SRV");
            for (int i = 0; i < attribute.size(); ++i) {
                this.srv_hosts.add(new SRV_Record((String)attribute.get(i)));
            }
            Collections.sort(this.srv_hosts, new SRV_Record());
            this.srv_lookup = new Timestamp(l);
        }
    }

    protected void srv_select() throws Exception {
        String string = "";
        if (this.used_srv != null) {
            string = this.used_srv.toString();
        }
        String string2 = "";
        for (SRV_Record sRV_Record : this.srv_hosts) {
            if (sRV_Record.toString().equals(string)) continue;
            try {
                MCP_i mCP_i = this.naming_lookup(sRV_Record.host(), sRV_Record.port());
                if (mCP_i == null) continue;
                mCP_i.check_client_version(Handshake.client_version());
                this.host(sRV_Record.host());
                this.port(sRV_Record.port());
                this.used_srv = sRV_Record;
                break;
            }
            catch (Exception exception) {
                String string3 = sRV_Record.host();
                if (string3.endsWith(".")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                String string4 = "  " + string3 + ":" + sRV_Record.port() + " reported error:\n    " + exception.getMessage() + "\n";
                string2 = string2 + string4;
                this.logger.warning(string4);
            }
        }
        if (this.host == null && this.port == 0) {
            throw new Exception("Could not connect to NetDB service " + this.srv_record + ".\n  " + string2.trim());
        }
    }

    private MCP_i naming_lookup() throws NotBoundException, MalformedURLException, RemoteException {
        return this.naming_lookup(this.host(), this.port());
    }

    private MCP_i naming_lookup(String string, Integer n) throws NotBoundException, MalformedURLException, RemoteException {
        if (string == null) {
            string = "";
        }
        return (MCP_i)Naming.lookup("//" + string + ":" + n + "/MCP");
    }

    protected Remote open_remote_connection() throws Exception, NotBoundException, MalformedURLException, RemoteException {
        if (this.mcp == null) {
            this.srv_resolve();
            this.srv_select();
            this.mcp = this.naming_lookup();
            this.mcp = this.remote_authenticate(this.mcp);
        } else {
            try {
                this.naming_lookup();
            }
            catch (Exception exception) {
                this.mcp = null;
                this.open_remote_connection();
            }
        }
        return this.mcp;
    }

    protected void close_remote_connection(String string) {
    }

    protected void terminate_remote_connection(String string) {
        try {
            this.rollback_transaction(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mcp = null;
    }

    public static enum TYPE {
        DATABASE,
        RMI;

    }
}

