/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.logging;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import stanford.netdb.util.Property;

public class Syslog_Handler
extends Handler {
    public static final long serialVersionUID = 1L;
    private static Calendar calendar = null;
    private static final long connection_age = Property.fetch_as_long("logging.syslog.connection_age", "30000");
    private String id_string = System.getProperty("logging.syslog.ID_string", "netdb");
    private String host = System.getProperty("logging.syslog.host", "localhost");
    private InetAddress host_address = null;
    private int port = Property.fetch_as_int("logging.syslog.port", "514");
    private int local_port = Property.fetch_as_int("logging.syslog.local_port", "0");
    private FACILITY facility = Syslog_Handler.fetch_facility_property("logging.syslog.facility", FACILITY.LOCAL3);
    private PRIORITY priority = Syslog_Handler.fetch_priority_property("logging.syslog.priority", PRIORITY.INFO);
    private DatagramSocket socket = null;
    private long last_call = 0L;

    @Override
    public void flush() {
    }

    private void open() throws Exception {
        if (Syslog_Handler.now() - this.last_call > connection_age) {
            this.close();
        }
        if (this.socket != null && this.socket.isConnected()) {
            return;
        }
        if (this.host_address == null) {
            this.resolve_hostname();
        }
        this.socket = new DatagramSocket(this.local_port);
        this.socket.connect(this.host_address, this.port);
    }

    @Override
    public void close() {
        if (this.socket != null) {
            this.socket.disconnect();
            this.socket = null;
        }
    }

    @Override
    public void publish(LogRecord logRecord) {
        try {
            this.open();
            Integer n = this.facility.value() << 3 | this.priority.value();
            String string = "<" + n.toString() + ">" + this.id_string + ": " + logRecord.getMessage();
            byte[] byArray = string.getBytes();
            this.socket.send(new DatagramPacket(byArray, byArray.length, this.host_address, this.port));
            this.last_call = Syslog_Handler.now();
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    public FACILITY facility() {
        return this.facility;
    }

    public PRIORITY priority() {
        return this.priority;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public String ID_string() {
        return this.id_string;
    }

    public Syslog_Handler facility(FACILITY fACILITY) {
        this.facility = fACILITY;
        return this;
    }

    public Syslog_Handler priority(PRIORITY pRIORITY) {
        this.priority = pRIORITY;
        return this;
    }

    public Syslog_Handler port(int n) {
        this.port = n;
        return this;
    }

    public Syslog_Handler ID_string(String string) {
        this.id_string = string;
        return this;
    }

    public Syslog_Handler host(String string) throws UnknownHostException {
        this.host = string;
        this.resolve_hostname();
        return this;
    }

    private void resolve_hostname() throws UnknownHostException {
        this.host_address = InetAddress.getByName(this.host);
    }

    private static long now() {
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        return calendar.getTime().getTime();
    }

    private static FACILITY fetch_facility_property(String string, FACILITY fACILITY) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            return FACILITY.valueOf(string2.toUpperCase());
        }
        return fACILITY;
    }

    private static PRIORITY fetch_priority_property(String string, PRIORITY pRIORITY) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            return PRIORITY.valueOf(string2.toUpperCase());
        }
        return pRIORITY;
    }

    public static enum PRIORITY {
        EMERG(0),
        ALERT(1),
        CRIT(2),
        ERR(3),
        WARNING(4),
        NOTICE(5),
        INFO(6),
        DEBUG(7);

        private Integer value = null;

        private PRIORITY(int n2) {
            this.value = new Integer(n2);
        }

        public Integer value() {
            return this.value;
        }
    }

    public static enum FACILITY {
        KERN(0),
        USER(1),
        MAIL(2),
        DAEMON(3),
        AUTH(4),
        LPR(6),
        NEWS(7),
        UUCP(8),
        CRON(9),
        LOCAL0(16),
        LOCAL1(17),
        LOCAL2(18),
        LOCAL3(19),
        LOCAL4(20),
        LOCAL5(21),
        LOCAL6(22),
        LOCAL7(23);

        private Integer value = null;

        private FACILITY(int n2) {
            this.value = new Integer(n2);
        }

        public Integer value() {
            return this.value;
        }
    }
}

