/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.logging;

import java.util.Hashtable;
import java.util.logging.Level;
import org.eclipse.jetty.util.log.Logger;
import stanford.netdb.logging.Silent_Logger;

public class Jetty_Logger
implements Logger {
    private String name = "unnamed logger";
    private boolean debug = false;
    private java.util.logging.Logger logger = new Silent_Logger();
    private static Hashtable<String, Jetty_Logger> named_loggers = new Hashtable();

    public Jetty_Logger(String string) {
        this.name = string;
        named_loggers.put(string, this);
    }

    public Logger getLogger(String string, java.util.logging.Logger logger) {
        Jetty_Logger jetty_Logger;
        if (logger == null) {
            logger = new Silent_Logger();
        }
        if ((jetty_Logger = named_loggers.get(string)) == null) {
            jetty_Logger = new Jetty_Logger(string);
        }
        jetty_Logger.logger(logger);
        return jetty_Logger;
    }

    public Logger getLogger(String string) {
        java.util.logging.Logger logger = null;
        try {
            logger = (java.util.logging.Logger)Class.forName(System.getProperty("logging.class", "stanford.netdb.logging.Silent_Logger")).newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getLogger(string, logger);
    }

    public String getName() {
        return this.name;
    }

    public java.util.logging.Logger logger() {
        return this.logger;
    }

    public void logger(java.util.logging.Logger logger) {
        if (logger == null) {
            logger = new Silent_Logger();
        }
        this.logger = logger;
    }

    protected void log(Level level, String string) {
        this.logger.log(level, "Jetty_Logger: " + string);
    }

    public void warn(String string, Object ... objectArray) {
        this.log(Level.WARNING, String.format(string, objectArray));
    }

    public void warn(String string, Throwable throwable) {
        this.log(Level.WARNING, string + " " + throwable.getMessage());
    }

    public void warn(Throwable throwable) {
        this.log(Level.WARNING, throwable.getMessage());
    }

    public void info(String string, Object ... objectArray) {
        this.log(Level.INFO, String.format(string, objectArray));
    }

    public void info(String string, Throwable throwable) {
        this.log(Level.INFO, string + " " + throwable.getMessage());
    }

    public void info(Throwable throwable) {
        this.log(Level.INFO, throwable.getMessage());
    }

    public void debug(String string, Object ... objectArray) {
        if (this.debug) {
            this.log(Level.FINE, String.format(string, objectArray));
        }
    }

    public void debug(String string, Throwable throwable) {
        if (this.debug) {
            this.log(Level.FINE, string + " " + throwable.getMessage());
        }
    }

    public void debug(Throwable throwable) {
        if (this.debug) {
            this.log(Level.FINE, throwable.getMessage());
        }
    }

    public void ignore(Throwable throwable) {
        this.log(Level.FINER, throwable.getMessage());
    }

    public boolean isDebugEnabled() {
        return this.debug;
    }

    public void setDebugEnabled(boolean bl) {
        this.debug = bl;
    }
}

