/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.field2sql;

import antlr.NoViableAltException;
import antlr.RecognitionException;
import antlr.TreeParser;
import antlr.collections.AST;
import stanford.netdb.field2sql.Field2SQL;
import stanford.netdb.field2sql.FieldPostFilter;
import stanford.netdb.field2sql.PostFilter;
import stanford.netdb.field2sql.StringsParserTokenTypes;

public class FieldTreeParser
extends TreeParser
implements StringsParserTokenTypes {
    public String table = "Record";
    public String column = "name";
    public boolean match_numbers = false;
    public boolean domain_name = false;
    public boolean log_name = false;
    public Object post_filter = null;
    public FieldPostFilter expression_builder = null;
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "AND", "OR", "END", "NOT", "STRING", "REGEX", "LPAREN", "RPAREN", "ESC", "RESC", "CCSET", "WS"};

    String buildRegexCondition(String string) throws RecognitionException, Exception {
        string = Field2SQL.unescape(string);
        string = string.replaceAll("'", "''");
        int n = string.length();
        int n2 = 1;
        String string2 = "";
        if (string.matches("^.*\\/i")) {
            n2 = 2;
            string2 = "i";
        }
        String string3 = this.column;
        String string4 = string.substring(1, string.length() - n2);
        if (this.post_filter instanceof PostFilter) {
            string3 = ((PostFilter)this.post_filter).column_filter("REGEXP_LIKE", this.table, this.column, string4);
            string4 = ((PostFilter)this.post_filter).field_filter("REGEXP_LIKE", this.table, this.column, string4);
        }
        return "REGEXP_LIKE(" + string3 + ", '" + string4 + "', '" + string2 + "')";
    }

    String buildStringCondition(String string) throws RecognitionException, Exception {
        String string2;
        int n;
        string = Field2SQL.unescape(string);
        String string3 = "";
        String string4 = "";
        int n2 = string.length();
        boolean bl = false;
        boolean bl2 = false;
        for (n = 0; n < n2; ++n) {
            String string5;
            string2 = string.substring(n, n + 1);
            boolean bl3 = n == n2 - 1;
            String string6 = string5 = bl3 ? "" : string.substring(n + 1, n + 2);
            if (string2.equals("\\")) {
                bl = !bl;
                string3 = string3 + string2;
                continue;
            }
            if (string2.equals("*") && !bl) {
                string3 = string3 + "%";
                bl2 = true;
                continue;
            }
            if (string2.equals("?") && !bl) {
                string3 = string3 + "_";
                bl2 = true;
                continue;
            }
            if ((string2.equals("%") || string2.equals("_")) && !bl) {
                bl2 = true;
            }
            string3 = string3 + string2;
            bl = false;
        }
        if (bl) {
            throw new RecognitionException("Illegal use of escape character.");
        }
        if (string3.startsWith("\"") && string3.endsWith("\"")) {
            string3 = string3.substring(1, string3.length() - 1);
        }
        if ((this.domain_name || this.column.matches("^.*fullname.*$")) && string3.indexOf(".") < 0) {
            string3 = string3 + ".%";
            bl2 = true;
        }
        if (this.domain_name && !this.log_name && !string3.endsWith(".") && !string3.endsWith("%")) {
            string3 = string3 + ".";
        }
        n2 = string3.length();
        if (!bl2) {
            bl = false;
            for (n = 0; n < n2; ++n) {
                string2 = string3.substring(n, n + 1);
                if (bl) {
                    string4 = string4 + (string2.equals("'") ? "''" : string2);
                    bl = false;
                    continue;
                }
                if (string2.equals("\\")) {
                    bl = true;
                    continue;
                }
                string4 = string4 + (string2.equals("'") ? "''" : string2);
            }
            if (this.expression_builder != null) {
                string4 = this.expression_builder.filter(this.table, this.column, string4);
            } else if (this.post_filter instanceof PostFilter) {
                String string7 = ((PostFilter)this.post_filter).field_filter("=", this.table, this.column, string4);
                string4 = ((PostFilter)this.post_filter).column_filter("=", this.table, this.column, string4) + " = " + (this.match_numbers ? string7 : "'" + string7 + "'");
            } else if (this.post_filter instanceof FieldPostFilter) {
                String string8 = ((FieldPostFilter)this.post_filter).filter(this.table, this.column, string4);
                string4 = this.column + " = " + (this.match_numbers ? string8 : "'" + string8 + "'");
            }
        } else {
            bl = false;
            for (n = 0; n < n2; ++n) {
                string2 = string3.substring(n, n + 1);
                if (bl) {
                    string4 = string2.equals("'") ? string4 + "''" : (string2.equals("\\") || string2.equals("_") || string2.equals("%") ? string4 + "\\" + string2 : string4 + string2);
                    bl = false;
                    continue;
                }
                if (string2.equals("\\")) {
                    bl = true;
                    continue;
                }
                string4 = string4 + (string2.equals("'") ? "''" : string2);
            }
            if (this.expression_builder != null) {
                string4 = this.expression_builder.filter(this.table, this.column, string4);
            } else if (this.post_filter instanceof PostFilter) {
                string4 = ((PostFilter)this.post_filter).column_filter("LIKE", this.table, this.column, string4) + " LIKE '" + ((PostFilter)this.post_filter).field_filter("LIKE", this.table, this.column, string4) + "' ESCAPE '\\'";
            } else if (this.post_filter instanceof FieldPostFilter) {
                string4 = this.column + " LIKE '" + ((FieldPostFilter)this.post_filter).filter(this.table, this.column, string4) + "' ESCAPE '\\'";
            }
        }
        return string4;
    }

    String value(String string) {
        if (string.startsWith("'") && string.endsWith("'")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public FieldTreeParser() {
        this.tokenNames = _tokenNames;
    }

    public final String expr(AST aST) throws RecognitionException {
        AST aST2 = aST == ASTNULL ? null : aST;
        AST aST3 = null;
        AST aST4 = null;
        String string = null;
        String string2 = null;
        String string3 = "";
        if (aST == null) {
            aST = ASTNULL;
        }
        switch (aST.getType()) {
            case 4: {
                AST aST5 = aST;
                AST aST6 = aST;
                this.match(aST, 4);
                aST = aST.getFirstChild();
                string = this.expr(aST);
                aST = this._retTree;
                string2 = this.expr(aST);
                aST = this._retTree;
                aST = aST5;
                aST = aST.getNextSibling();
                string3 = " ( " + string + " INTERSECT " + string2 + " ) ";
                break;
            }
            case 5: {
                AST aST7 = aST;
                AST aST8 = aST;
                this.match(aST, 5);
                aST = aST.getFirstChild();
                string = this.expr(aST);
                aST = this._retTree;
                string2 = this.expr(aST);
                aST = this._retTree;
                aST = aST7;
                aST = aST.getNextSibling();
                string3 = " ( " + string + " UNION " + string2 + " ) ";
                break;
            }
            case 7: {
                AST aST9 = aST;
                AST aST10 = aST;
                this.match(aST, 7);
                aST = aST.getFirstChild();
                string2 = this.expr(aST);
                aST = this._retTree;
                aST = aST9;
                aST = aST.getNextSibling();
                string3 = " ( select id from " + this.table + " MINUS " + string2 + " ) ";
                break;
            }
            case 8: {
                aST3 = aST;
                this.match(aST, 8);
                aST = aST.getNextSibling();
                if (this.match_numbers) {
                    string3 = " ( select id from " + this.table + " where " + this.column + " = " + Integer.parseInt(aST3.toString()) + " ) ";
                    break;
                }
                try {
                    string3 = " ( select id from " + this.table + " where " + this.buildStringCondition(aST3.toString()) + " ) ";
                    break;
                }
                catch (Exception exception) {
                    throw new RecognitionException(exception.getMessage());
                }
            }
            case 9: {
                aST4 = aST;
                this.match(aST, 9);
                aST = aST.getNextSibling();
                try {
                    string3 = " ( select id from " + this.table + " where " + this.buildRegexCondition(aST4.toString()) + " ) ";
                    break;
                }
                catch (Exception exception) {
                    throw new RecognitionException(exception.getMessage());
                }
            }
            default: {
                throw new NoViableAltException(aST);
            }
        }
        this._retTree = aST;
        return string3;
    }
}

