/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import stanford.netdb.Consultant;
import stanford.netdb.Department;
import stanford.netdb.Domain;
import stanford.netdb.Domain_Name;
import stanford.netdb.FS_Boolean;
import stanford.netdb.Field;
import stanford.netdb.Full_Search_Parameters;
import stanford.netdb.Group;
import stanford.netdb.IP.IPaddress;
import stanford.netdb.IP.Prefix;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Person;
import stanford.netdb.Privilege;
import stanford.netdb.User;
import stanford.netdb.middleware.Result_Hash;
import stanford.netdb.util.TZ_Timestamp;

public class User_FS_Parameters
extends Full_Search_Parameters<User_FS_Parameters, User> {
    private static final long serialVersionUID = 1L;
    private static final String INCLUDE_NAME = "displayOrder.txt.1.User Name";
    private static final String INCLUDE_ACTIVE_STATE = "displayOrder.b.2.Active";
    private static final String INCLUDE_LAST_LOGIN = "displayOrder.tst.3.Last Login";
    private static final String INCLUDE_DEPARTMENT = "displayOrder.ns.4.LNA Department";
    private static final String INCLUDE_CONSULTANT = "displayOrder.ns.5.Network Consultant";
    private static final String INCLUDE_RECORD_ACCESS = "displayOrder.txt.7.Record Type";
    private static final String INCLUDE_PHONE = "displayOrder.txt.9.Phone";
    private static final String INCLUDE_EMAIL = "displayOrder.txt.10.Email";
    private static final String INCLUDE_DEFAULT_DOMAIN = "displayOrder.txt.11.Default Domain";
    private static final String INCLUDE_STARTING_ADDRESS = "displayOrder.ip.12.Starting Address";
    private static final String INCLUDE_DEFAULT_GROUP = "displayOrder.txt.13.Default Group";
    private static final String ID_COLUMN = "ID";
    private static final String HANDLE_COLUMN = "handle";
    private static final String NAME_COLUMN = "User Name";
    private static final String ACTIVE_COLUMN = "Active";
    private static final String LAST_LOGIN_COLUMN = "Last Login";
    private static final String DEPARTMENT_COLUMN = "Department";
    private static final String CONSULTANT_COLUMN = "Network Consultant";
    private static final String GROUP_COLUMN = "Group";
    private static final String ALL_GROUPS_COLUMN = "All Groups";
    private static final String RECORD_TYPE_COLUMN = "Record Type";
    private static final String RECORD_DISPLAY_COLUMN = "Record Type Display";
    private static final String ALL_RECORDS_COLUMN = "All Types";
    private static final String COMMENT_COLUMN = "Comment";
    private static final String PHONE_COLUMN = "Phone";
    private static final String EMAIL_COLUMN = "Email";
    private static final String DEFAULT_DOMAIN_COLUMN = "Default Domain";
    private static final String STARTING_ADDRESS_COLUMN = "Starting Address";
    private static final String DEFAULT_GROUP_COLUMN = "Default Group";
    private String netid = "";
    private String name = "";
    private FS_Boolean active = FS_Boolean.EITHER;
    private String last_logged_in_after = "";
    private String last_logged_in_before = "";
    private String department = "";
    private String consultant_name = "";
    private FS_Boolean all_groups = FS_Boolean.EITHER;
    private Boolean search_by_privileges = false;
    private FS_Boolean all_records = FS_Boolean.EITHER;
    private String phone = "";
    private String email = "";
    private String default_domain = "";
    private String starting_address = "";
    private String default_group = "";
    private Hashtable<String, Privilege> privileges = new Hashtable();

    public User_FS_Parameters() {
        this.INCLUDE_MODIFIED_BY = "displayOrder.txt.14.Modified By";
        this.INCLUDE_MODIFIED = "displayOrder.tst.15.Date Modified";
        this.INCLUDE_CREATED_BY = "displayOrder.txt.16.Created By";
        this.INCLUDE_CREATED = "displayOrder.tst.17.Date Created";
        this.INCLUDE_OWNER = "displayOrder.txt.6.Group";
        this.INCLUDE_COMMENT = "displayOrder.txt.8.Comment";
        this.include_fields.put(INCLUDE_NAME, Boolean.FALSE);
        this.include_fields.put(INCLUDE_ACTIVE_STATE, Boolean.FALSE);
        this.include_fields.put(INCLUDE_LAST_LOGIN, Boolean.FALSE);
        this.include_fields.put(INCLUDE_DEPARTMENT, Boolean.FALSE);
        this.include_fields.put(INCLUDE_CONSULTANT, Boolean.FALSE);
        this.include_fields.put(INCLUDE_RECORD_ACCESS, Boolean.FALSE);
        this.include_fields.put(INCLUDE_PHONE, Boolean.FALSE);
        this.include_fields.put(INCLUDE_EMAIL, Boolean.FALSE);
        this.include_fields.put(INCLUDE_DEFAULT_DOMAIN, Boolean.FALSE);
        this.include_fields.put(INCLUDE_STARTING_ADDRESS, Boolean.FALSE);
        this.include_fields.put(INCLUDE_DEFAULT_GROUP, Boolean.FALSE);
        this.include_fields.put(this.INCLUDE_MODIFIED_BY, Boolean.FALSE);
        this.include_fields.put(this.INCLUDE_MODIFIED, Boolean.FALSE);
        this.include_fields.put(this.INCLUDE_CREATED_BY, Boolean.FALSE);
        this.include_fields.put(this.INCLUDE_CREATED, Boolean.FALSE);
        this.include_fields.put(this.INCLUDE_OWNER, Boolean.FALSE);
        this.include_fields.put(this.INCLUDE_COMMENT, Boolean.FALSE);
    }

    public String netID() {
        return this.netid();
    }

    public String netid() {
        return this.netid;
    }

    public String name() {
        return this.name;
    }

    private Boolean include_name() {
        return (Boolean)this.include_fields.get(INCLUDE_NAME);
    }

    public Boolean active() {
        return this.active.value();
    }

    public Boolean include_active() {
        return (Boolean)this.include_fields.get(INCLUDE_ACTIVE_STATE);
    }

    public String last_logged_in_after() {
        return this.last_logged_in_after;
    }

    public String last_logged_in_before() {
        return this.last_logged_in_before;
    }

    public Boolean include_last_login() {
        return (Boolean)this.include_fields.get(INCLUDE_LAST_LOGIN);
    }

    public String department() {
        return this.department;
    }

    public Boolean include_department() {
        return (Boolean)this.include_fields.get(INCLUDE_DEPARTMENT);
    }

    public String consultant_name() {
        return this.consultant_name;
    }

    public Boolean include_consultant_name() {
        return (Boolean)this.include_fields.get(INCLUDE_CONSULTANT);
    }

    public Boolean all_groups() {
        return this.all_groups.value();
    }

    public Boolean all_records() {
        return this.all_records.value();
    }

    public String phone() {
        return this.phone;
    }

    public Boolean include_phone() {
        return (Boolean)this.include_fields.get(INCLUDE_PHONE);
    }

    public String email() {
        return this.email;
    }

    public Boolean include_email() {
        return (Boolean)this.include_fields.get(INCLUDE_EMAIL);
    }

    public String default_domain() {
        return this.default_domain;
    }

    public Boolean include_default_domain() {
        return (Boolean)this.include_fields.get(INCLUDE_DEFAULT_DOMAIN);
    }

    public String starting_address() {
        return this.starting_address;
    }

    public Boolean include_starting_address() {
        return (Boolean)this.include_fields.get(INCLUDE_STARTING_ADDRESS);
    }

    public String default_group() {
        return this.default_group;
    }

    public Boolean include_default_group() {
        return (Boolean)this.include_fields.get(INCLUDE_DEFAULT_GROUP);
    }

    public Boolean include_privileges() {
        return (Boolean)this.include_fields.get(INCLUDE_RECORD_ACCESS);
    }

    public Collection<Privilege> privileges() throws Exception {
        return this.privileges.values();
    }

    public User_FS_Parameters netID(String string) {
        return this.netid(string);
    }

    public User_FS_Parameters netid(String string) {
        if (string == null) {
            string = "";
        }
        this.netid = string;
        return this;
    }

    public User_FS_Parameters netID(String string, Boolean bl) {
        return this.netid(string, bl);
    }

    private User_FS_Parameters netid(String string, Boolean bl) {
        this.netid(string);
        this.include_name(bl);
        return this;
    }

    public User_FS_Parameters name(String string) {
        if (string == null) {
            string = "";
        }
        this.name = string;
        return this;
    }

    private User_FS_Parameters name(String string, Boolean bl) {
        this.name(string);
        this.include_name(bl);
        return this;
    }

    private User_FS_Parameters include_name(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_NAME, bl);
        return this;
    }

    public User_FS_Parameters active(Boolean bl) {
        this.active = new FS_Boolean(bl);
        return this;
    }

    public User_FS_Parameters active(Boolean bl, Boolean bl2) {
        this.active(bl);
        this.include_active(bl2);
        return this;
    }

    public User_FS_Parameters include_active(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_ACTIVE_STATE, bl);
        return this;
    }

    public User_FS_Parameters last_logged_in_after(String string) {
        if (string == null) {
            string = "";
        }
        this.last_logged_in_after = string;
        return this;
    }

    public User_FS_Parameters last_logged_in_after(String string, Boolean bl) {
        this.last_logged_in_after(string);
        this.include_last_login(bl);
        return this;
    }

    public User_FS_Parameters last_logged_in_before(String string) {
        if (string == null) {
            string = "";
        }
        this.last_logged_in_before = string;
        return this;
    }

    public User_FS_Parameters last_logged_in_before(String string, Boolean bl) {
        this.last_logged_in_before(string);
        this.include_last_login(bl);
        return this;
    }

    public User_FS_Parameters include_last_login(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_LAST_LOGIN, bl);
        return this;
    }

    public User_FS_Parameters department(String string) {
        if (string == null) {
            string = "";
        }
        this.department = string;
        return this;
    }

    public User_FS_Parameters department(String string, Boolean bl) {
        this.department(string);
        this.include_department(bl);
        return this;
    }

    public User_FS_Parameters include_department(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_DEPARTMENT, bl);
        return this;
    }

    public User_FS_Parameters consultant_name(String string) {
        if (string == null) {
            string = "";
        }
        this.consultant_name = string;
        return this;
    }

    public User_FS_Parameters consultant_name(String string, Boolean bl) {
        this.consultant_name(string);
        this.include_consultant_name(bl);
        return this;
    }

    public User_FS_Parameters include_consultant_name(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_CONSULTANT, bl);
        return this;
    }

    public User_FS_Parameters all_groups(Boolean bl) {
        this.all_groups = new FS_Boolean(bl);
        return this;
    }

    public User_FS_Parameters all_records(Boolean bl) {
        this.all_records = new FS_Boolean(bl);
        return this;
    }

    public User_FS_Parameters phone(String string) {
        if (string == null) {
            string = "";
        }
        this.phone = string;
        return this;
    }

    public User_FS_Parameters phone(String string, Boolean bl) {
        this.phone(string);
        this.include_phone(bl);
        return this;
    }

    public User_FS_Parameters include_phone(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_PHONE, bl);
        return this;
    }

    public User_FS_Parameters email(String string) {
        if (string == null) {
            string = "";
        }
        this.email = string;
        return this;
    }

    public User_FS_Parameters email(String string, Boolean bl) {
        this.email(string);
        this.include_email(bl);
        return this;
    }

    public User_FS_Parameters include_email(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_EMAIL, bl);
        return this;
    }

    public User_FS_Parameters default_domain(String string) {
        if (string == null) {
            string = "";
        }
        this.default_domain = string;
        return this;
    }

    public User_FS_Parameters default_domain(String string, Boolean bl) {
        this.default_domain(string);
        this.include_default_domain(bl);
        return this;
    }

    public User_FS_Parameters include_default_domain(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_DEFAULT_DOMAIN, bl);
        return this;
    }

    public User_FS_Parameters starting_address(String string) {
        if (string == null) {
            string = "";
        }
        this.starting_address = string;
        return this;
    }

    public User_FS_Parameters starting_address(String string, Boolean bl) {
        this.starting_address(string);
        this.include_starting_address(bl);
        return this;
    }

    public User_FS_Parameters include_starting_address(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_STARTING_ADDRESS, bl);
        return this;
    }

    public User_FS_Parameters default_group(String string) {
        if (string == null) {
            string = "";
        }
        this.default_group = string;
        return this;
    }

    public User_FS_Parameters default_group(String string, Boolean bl) {
        this.default_group(string);
        this.include_default_group(bl);
        return this;
    }

    public User_FS_Parameters include_default_group(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_DEFAULT_GROUP, bl);
        return this;
    }

    public User_FS_Parameters privileges(Collection<Privilege> collection) throws Exception {
        this.privileges = new Hashtable();
        if (collection != null) {
            for (Privilege privilege : collection) {
                this.privileges.put(privilege.name(), privilege);
            }
        }
        return this;
    }

    public User_FS_Parameters privileges(Collection<Privilege> collection, Boolean bl) throws Exception {
        this.privileges(collection);
        this.include_privileges(bl);
        return this;
    }

    public User_FS_Parameters include_privileges(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_RECORD_ACCESS, bl);
        return this;
    }

    @Override
    protected String get_SQL(String string) throws Exception {
        Hashtable<String, String> hashtable = this.legacy_search_params();
        String string2 = "";
        if (!hashtable.get(INCLUDE_RECORD_ACCESS).equals("-1")) {
            string2 = string2 + ", nvl(access_group, ' ') \"Record Type\", nvl(access_dsp, ' ') \"Record Type Display\", decode(all_records, 1, 'Yes', 'No') \"All Types\"";
        }
        String string3 = "SELECT DISTINCT id \"ID\", netid \"handle\", name || '(' || netid || ')' \"User Name\"" + (hashtable.get(INCLUDE_ACTIVE_STATE).equals("-1") ? "" : ", decode(active, 1, 'Yes', 'No') \"Active\"") + (hashtable.get(INCLUDE_LAST_LOGIN).equals("-1") ? "" : ", last_login \"Last Login\"") + ", organization \"" + DEPARTMENT_COLUMN + "\", nvl(cons_name, ' ') \"" + CONSULTANT_COLUMN + "\"" + (hashtable.get(this.INCLUDE_OWNER).equals("-1") ? "" : ", owner \"Group\", decode(all_groups, 1, 'Yes', 'No') \"All Groups\"") + string2 + (hashtable.get(this.INCLUDE_COMMENT).equals("-1") ? "" : ", nvl(comments, ' ') \"Comment\"") + (hashtable.get(INCLUDE_PHONE).equals("-1") ? "" : ", nvl(phone, ' ') \"Phone\"") + (hashtable.get(INCLUDE_EMAIL).equals("-1") ? "" : ", nvl(email, ' ') \"Email\"") + (hashtable.get(INCLUDE_DEFAULT_DOMAIN).equals("-1") ? "" : ", nvl(def_domain, ' ') \"Default Domain\"") + (hashtable.get(INCLUDE_STARTING_ADDRESS).equals("-1") ? "" : ", decode(starting_address, null, ' ', IP.host(starting_address)) \"Starting Address\"") + (hashtable.get(INCLUDE_DEFAULT_GROUP).equals("-1") ? "" : ", nvl(def_group, ' ') \"Default Group\"") + this.modBlock(hashtable) + " FROM " + hashtable.get("fs.table") + " WHERE ID IN ( SELECT unique(id) FROM ";
        hashtable.put("displayOrder.txt.6.All Groups", hashtable.get(this.INCLUDE_OWNER));
        hashtable.put("displayOrder.txt.7.All Types", hashtable.get(INCLUDE_RECORD_ACCESS));
        Vector vector = new Vector();
        this.assmDisplayOrder(vector, hashtable);
        if (User_FS_Parameters.n2s(hashtable.get("rb.b.records")).equals("-1")) {
            hashtable.remove("cb.i.Node");
            hashtable.remove("cb.i.Network");
            hashtable.remove("cb.i.Domain");
            hashtable.remove("cb.i.User");
            hashtable.remove("cb.i.Group");
            hashtable.remove("cb.i.AdminTeam");
            hashtable.remove("cb.i.IPC");
            hashtable.remove("cb.i.AdvancedNode");
            hashtable.remove("cb.i.Router");
            hashtable.remove("cb.i.SystemManagement");
        } else if (User_FS_Parameters.n2s(hashtable.get("rb.b.records")).equals("1")) {
            hashtable.remove("rb.b.records");
        }
        Vector<Exception> vector2 = new Vector<Exception>();
        string3 = string3 + this.assmCommonSQL(hashtable, vector2) + " ) ";
        return string3;
    }

    @Override
    protected Vector<User> process_results(NetDB_Datastore netDB_Datastore, Result_Hash result_Hash) throws Exception {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = -1;
        int n12 = -1;
        int n13 = -1;
        int n14 = -1;
        int n15 = -1;
        int n16 = -1;
        int n17 = -1;
        int n18 = -1;
        int n19 = -1;
        int n20 = -1;
        int n21 = -1;
        int n22 = -1;
        int n23 = 0;
        for (String object2 : result_Hash.get_vector("column_names")) {
            if (object2.equals(ID_COLUMN)) {
                n = n23;
            } else if (object2.equals(HANDLE_COLUMN)) {
                n2 = n23;
            } else if (object2.equals(NAME_COLUMN)) {
                n3 = n23;
            } else if (object2.equals(ACTIVE_COLUMN)) {
                n4 = n23;
            } else if (object2.equals(LAST_LOGIN_COLUMN)) {
                n5 = n23;
            } else if (object2.equals(DEPARTMENT_COLUMN)) {
                n6 = n23;
            } else if (object2.equals(CONSULTANT_COLUMN)) {
                n7 = n23;
            } else if (object2.equals(GROUP_COLUMN)) {
                n8 = n23;
            } else if (object2.equals(ALL_GROUPS_COLUMN)) {
                n9 = n23;
            } else if (object2.equals(RECORD_TYPE_COLUMN)) {
                n10 = n23;
            } else if (object2.equals(RECORD_DISPLAY_COLUMN)) {
                n11 = n23;
            } else if (object2.equals(ALL_RECORDS_COLUMN)) {
                n12 = n23;
            } else if (object2.equals(COMMENT_COLUMN)) {
                n13 = n23;
            } else if (object2.equals(PHONE_COLUMN)) {
                n14 = n23;
            } else if (object2.equals(EMAIL_COLUMN)) {
                n15 = n23;
            } else if (object2.equals(DEFAULT_DOMAIN_COLUMN)) {
                n16 = n23;
            } else if (object2.equals(STARTING_ADDRESS_COLUMN)) {
                n17 = n23;
            } else if (object2.equals(DEFAULT_GROUP_COLUMN)) {
                n18 = n23;
            } else if (object2.equals("Modified By")) {
                n19 = n23;
            } else if (object2.equals("Date Modified")) {
                n20 = n23;
            } else if (object2.equals("Created By")) {
                n21 = n23;
            } else if (object2.equals("Date Created")) {
                n22 = n23;
            } else {
                netDB_Datastore.logger().severe("'" + object2 + "' was encountered and not expected.  The data will not be processed.  The '" + this.getClass().getName() + "' class will need to be updated before it will be processed.");
            }
            ++n23;
        }
        Hashtable hashtable = new Hashtable();
        Hashtable<Object, Department> hashtable2 = new Hashtable<Object, Department>();
        Vector<User> vector = new Vector<User>();
        for (Vector vector2 : (Vector)result_Hash.get("resultSet")) {
            Object object;
            Serializable serializable;
            Object object2;
            Object object3;
            User user = null;
            String string = (String)vector2.get(n2);
            user = (User)hashtable.get(string);
            if (user == null) {
                object3 = (BigDecimal)vector2.get(n);
                user = object3 != null ? new User(netDB_Datastore, ((BigDecimal)object3).intValue(), string) : new User(netDB_Datastore, -1, string);
                user.flag_as_system_created();
                vector.add(user);
                hashtable.put(string, user);
            }
            if (n3 != -1) {
                object3 = new Person(netDB_Datastore, (String)vector2.get(n3));
                object2 = user.id();
                if (object2 != null) {
                    ((Person)object3).id((Integer)object2);
                }
                user.identity((Person)object3);
            }
            if (n4 != -1) {
                object3 = (String)vector2.get(n4);
                object2 = false;
                if (((String)object3).equals("Yes")) {
                    object2 = true;
                }
                user.active((Boolean)object2);
            }
            if (n5 != -1) {
                object3 = (TZ_Timestamp)vector2.get(n5);
                if (object3 != null) {
                    user.last_login((Timestamp)object3);
                }
                user.flag_field_as_defined(Field.LAST_LOGIN);
            }
            if (n6 != -1) {
                object3 = (String)vector2.get(n6);
                object2 = string + " " + (String)object3;
                serializable = (Department)hashtable2.get(object2);
                if (serializable == null && object3 != null && ((String)object3).trim().length() > 0) {
                    serializable = new Department(netDB_Datastore, (String)object3);
                    ((NetDB)serializable).flag_as_system_created();
                    user.add_department((Department)serializable);
                    hashtable2.put(object2, (Department)serializable);
                }
                user.flag_field_as_defined(Field.DEPARTMENT);
                if (serializable != null && n7 != -1) {
                    object = (String)vector2.get(n7);
                    if (object != null && ((String)(object = ((String)object).trim())).length() > 0) {
                        Person person = new Person(netDB_Datastore, (String)object);
                        Consultant consultant = new Consultant(person, false);
                        person.flag_as_system_created();
                        consultant.flag_as_system_created();
                        ((Department)serializable).add_consultant(consultant);
                    }
                    ((Department)serializable).flag_field_as_defined(Field.CONSULTANT);
                }
            }
            if (n8 != -1) {
                object3 = (String)vector2.get(n8);
                if (object3 != null && ((String)(object3 = ((String)object3).trim())).length() > 0) {
                    object2 = new Group(netDB_Datastore, (String)object3);
                    ((NetDB)object2).flag_as_system_created();
                    user.add_owner((Group)object2);
                }
                user.flag_field_as_defined(Field.OWNER);
            }
            if (n9 != -1) {
                object3 = (String)vector2.get(n9);
                object2 = false;
                if (((String)object3).equals("Yes")) {
                    object2 = true;
                }
                user.all_groups((Boolean)object2);
            }
            if (n10 != -1 && n11 != -1) {
                object3 = ((String)vector2.get(n10)).trim();
                object2 = ((String)vector2.get(n11)).trim();
                if (((String)object3).length() > 0 && ((String)object2).length() > 0) {
                    serializable = new Privilege(netDB_Datastore, (String)object3, (String)object2);
                    ((NetDB)serializable).flag_as_system_created();
                    user.grant_privilege((Privilege)serializable);
                }
                user.flag_field_as_defined(Field.PRIVILEGE);
            }
            if (n12 != -1) {
                object3 = (String)vector2.get(n12);
                object2 = false;
                if (((String)object3).equals("Yes")) {
                    object2 = true;
                }
                user.all_records((Boolean)object2);
            }
            if (n13 != -1) {
                object3 = (String)vector2.get(n13);
                if (object3 != null && ((String)(object3 = ((String)object3).trim())).length() > 0) {
                    user.comment((String)object3);
                }
                user.flag_field_as_defined(Field.COMMENT);
            }
            if ((object3 = user.identity()) != null) {
                if (n14 != -1) {
                    object2 = (String)vector2.get(n14);
                    if (object2 != null && ((String)(object2 = ((String)object2).trim())).length() > 0) {
                        ((Person)object3).phone((String)object2);
                    }
                    ((Person)object3).flag_field_as_defined(Field.PHONE);
                }
                if (n15 != -1) {
                    object2 = (String)vector2.get(n15);
                    if (object2 != null && ((String)(object2 = ((String)object2).trim())).length() > 0) {
                        ((Person)object3).email((String)object2);
                    }
                    ((Person)object3).flag_field_as_defined(Field.EMAIL);
                }
            }
            if (n16 != -1) {
                object2 = (String)vector2.get(n16);
                if (object2 != null && ((String)object2).trim().length() > 0) {
                    serializable = new Domain_Name(netDB_Datastore, (String)object2);
                    object = new Domain(netDB_Datastore, (Domain_Name)serializable);
                    ((NetDB)serializable).flag_as_system_created();
                    ((NetDB)object).flag_as_system_created();
                    user.default_domain((Domain)object);
                }
                user.flag_field_as_defined(Field.DEFAULT_DOMAIN);
            }
            if (n17 != -1) {
                object2 = (String)vector2.get(n17);
                if (object2 != null && ((String)object2).trim().length() > 0) {
                    if (((String)object2).indexOf("/") > 0) {
                        serializable = new Prefix((String)object2);
                        user.starting_address(((Prefix)serializable).address());
                    } else {
                        user.starting_address(new IPaddress((String)object2));
                    }
                }
                user.flag_field_as_defined(Field.STARTING_ADDRESS);
            }
            if (n18 != -1) {
                object2 = (String)vector2.get(n18);
                if (object2 != null && ((String)object2).trim().length() > 0) {
                    serializable = new Group(netDB_Datastore, (String)object2);
                    ((NetDB)serializable).flag_as_system_created();
                    user.default_group((Group)serializable);
                }
                user.flag_field_as_defined(Field.DEFAULT_GROUP);
            }
            super.process_common_results(user, vector2, n20, n19, n22, n21);
        }
        Collections.sort(vector);
        return vector;
    }

    @Override
    protected String child_params() {
        String string = "";
        return string;
    }

    public Hashtable<String, String> legacy_search_params() {
        String string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("fs.table", "FS_User");
        for (String string2 : this.include_fields.keySet()) {
            string = "-1";
            if (((Boolean)this.include_fields.get(string2)).booleanValue()) {
                string = "1";
            }
            hashtable.put(string2, string);
        }
        Object object = this.privileges.keySet().iterator();
        while (object.hasNext()) {
            String string2;
            string = string2 = (String)object.next();
            if (string2.equals("IPCProvider")) {
                string = "IPC";
            }
            hashtable.put("cb.i." + string, "access_group = '" + string2 + "'");
        }
        hashtable.put("txt.lower(netid)", this.netid.toLowerCase());
        hashtable.put("txt.lower(name)", this.name.toLowerCase());
        hashtable.put("tst.last_login >= ", this.last_logged_in_after);
        hashtable.put("tst.last_login <= ", this.last_logged_in_before);
        hashtable.put("txt.lower(organization)", this.department.toLowerCase());
        hashtable.put("txt.cons_name", this.consultant_name);
        hashtable.put("txt.lower(phone)", this.phone.toLowerCase());
        hashtable.put("txt.lower(email)", this.email.toLowerCase());
        hashtable.put("txt.lower(def_domain)", this.default_domain.toLowerCase());
        hashtable.put("txt.NetDB.IP.host(starting_address)", this.starting_address);
        hashtable.put("txt.lower(def_group)", this.default_group.toLowerCase());
        hashtable.put("rb.b.active", this.active.sql_string());
        hashtable.put("rb.b.all_groups", this.all_groups.sql_string());
        hashtable.put("rb.b.all_records", this.all_records.sql_string());
        object = "-1";
        if (this.privileges.size() > 0) {
            object = "1";
        }
        hashtable.put("rb.b.records", (String)object);
        super.legacy_search_params(hashtable);
        hashtable.put("txt.lower(owner)", this.owner.toLowerCase());
        hashtable.put("txt.lower(comments)", this.comment.toLowerCase());
        return hashtable;
    }
}

