/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import stanford.netdb.Field;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Privilege;
import stanford.netdb.Record;
import stanford.netdb.Record_Type;
import stanford.netdb.User;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.exceptions.Record_Not_Found;

public class State
extends Record<State> {
    public static String template_name = "templates/toString/state.tmpl";
    private static final long serialVersionUID = 1L;
    private String id = null;
    private String name = null;
    private Integer rank = null;
    private String comment = null;
    private Boolean deny_dhcp = null;
    private Boolean deny_dns = null;
    private Privilege access_group = null;

    public State() {
        this.init();
    }

    public State(String string, Integer n, Boolean bl, Boolean bl2) {
        this.init(string, n, bl, bl2);
    }

    public State(String string, Integer n, String string2, Boolean bl, Boolean bl2, Privilege privilege) {
        this.init(string, n, string2, bl, bl2, privilege);
    }

    public State(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
        this.init();
    }

    public State(NetDB_Datastore netDB_Datastore, String string, Integer n, Boolean bl, Boolean bl2) {
        super(netDB_Datastore);
        this.init(string, n, bl, bl2);
    }

    public State(NetDB_Datastore netDB_Datastore, String string, Integer n, String string2, Boolean bl, Boolean bl2, Privilege privilege) {
        super(netDB_Datastore);
        this.init(string, n, string2, bl, bl2, privilege);
    }

    private void init() {
        this.init(null, null, null, null, null, null);
    }

    private void init(String string, Integer n, Boolean bl, Boolean bl2) {
        this.init(string, n, null, bl, bl2, null);
    }

    private void init(String string, Integer n, String string2, Boolean bl, Boolean bl2, Privilege privilege) {
        if (string != null) {
            this.name(string);
        }
        if (n != null) {
            this.rank(n);
        }
        if (string2 != null) {
            this.comment(string2);
        }
        if (bl != null) {
            this.deny_dhcp(bl);
        }
        if (bl2 != null) {
            this.deny_dns(bl2);
        }
        if (privilege != null) {
            this.privilege(privilege);
        }
    }

    public String name() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.name, NetDB.unset_string, "name");
        return this.name;
    }

    public Integer rank() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.rank, NetDB.unset_integer, "rank");
        return this.rank;
    }

    public String comment() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.comment, NetDB.unset_string, "comment");
        return this.comment;
    }

    public Boolean denyDHCP() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this.deny_dhcp();
    }

    public Boolean deny_dhcp() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.deny_dhcp, NetDB.unset_boolean, "deny_dhcp");
        return this.deny_dhcp;
    }

    public Boolean denyDNS() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this.deny_dns();
    }

    public Boolean deny_dns() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.deny_dns, NetDB.unset_boolean, "deny_dns");
        return this.deny_dns;
    }

    public Privilege privilege() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.access_group, NetDB.unset_privilege, "access_group");
        return this.access_group;
    }

    @Override
    public String handle() {
        return this.name;
    }

    public State name(String string) {
        this.name = string;
        return this;
    }

    public State rank(Integer n) {
        this.rank = n;
        return this;
    }

    public State comment(String string) {
        this.comment = string;
        return this;
    }

    public State denyDHCP(Boolean bl) {
        return this.deny_dhcp(bl);
    }

    public State deny_dhcp(Boolean bl) {
        this.deny_dhcp = bl;
        return this;
    }

    public State denyDNS(Boolean bl) {
        return this.deny_dns(bl);
    }

    public State deny_dns(Boolean bl) {
        this.deny_dns = bl;
        return this;
    }

    public State privilege(Privilege privilege) {
        this.access_group = privilege;
        return this;
    }

    @Override
    public State unlink() {
        super.unlink();
        this.id = null;
        return this;
    }

    @Override
    public String single_value_attributes() {
        String string = "";
        if (this.access_group != null) {
            string = this.access_group.single_value_attributes();
        }
        return this.name + " " + this.rank + " " + this.comment + " " + this.deny_dhcp + " " + this.deny_dns + " " + string;
    }

    @Override
    protected void initialize_member_data() {
        super.initialize_member_data();
        if (this.name == null) {
            this.name = NetDB.unset_string;
        }
        if (this.rank == null) {
            this.rank = NetDB.unset_integer;
        }
        if (this.comment == null) {
            this.comment = NetDB.unset_string;
        }
        if (this.deny_dhcp == null) {
            this.deny_dhcp = NetDB.unset_boolean;
        }
        if (this.deny_dns == null) {
            this.deny_dns = NetDB.unset_boolean;
        }
        if (this.access_group == null) {
            this.access_group = NetDB.unset_privilege;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        super.flag_field_as_defined(field);
        if (field == Field.NAME) {
            if (NetDB.unset_string.equals(this.name)) {
                this.name = null;
            }
        } else if (field == Field.RANK) {
            if (this.rank == NetDB.unset_integer) {
                this.rank = null;
            }
        } else if (field == Field.COMMENT) {
            if (NetDB.unset_string.equals(this.comment)) {
                this.comment = null;
            }
        } else if (field == Field.DENY_DHCP) {
            if (this.deny_dhcp == NetDB.unset_boolean) {
                this.deny_dhcp = null;
            }
        } else if (field == Field.DENY_DNS) {
            if (this.deny_dns == NetDB.unset_boolean) {
                this.deny_dns = null;
            }
        } else if (field == Field.ACCESS_GROUP && this.access_group == NetDB.unset_privilege) {
            this.access_group = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        super.clear_default_member_data();
        if (NetDB.unset_string.equals(this.name)) {
            this.name = null;
        }
        if (this.rank == NetDB.unset_integer) {
            this.rank = null;
        }
        if (NetDB.unset_string.equals(this.comment)) {
            this.comment = null;
        }
        if (this.deny_dhcp == NetDB.unset_boolean) {
            this.deny_dhcp = null;
        }
        if (this.deny_dns == NetDB.unset_boolean) {
            this.deny_dns = null;
        }
        if (this.access_group == NetDB.unset_privilege) {
            this.access_group = null;
        }
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return Record.toString(fORMAT, template_name, "state", this, bl);
    }

    protected static State extract(NetDB_Datastore netDB_Datastore, Hashtable hashtable) {
        State state = new State(netDB_Datastore);
        state.flag_as_system_created();
        state.extract(hashtable);
        return state;
    }

    protected State extract(Hashtable hashtable) {
        if (hashtable == null) {
            return this;
        }
        String string = (String)hashtable.get("object");
        if ("node".equals(string)) {
            this.name((String)hashtable.get("state"));
            hashtable.remove("state");
        } else {
            this.name((String)hashtable.get("name"));
            hashtable.remove("name");
            this.rank((Integer)hashtable.get("rank"));
            hashtable.remove("rank");
            this.comment((String)hashtable.get("description"));
            hashtable.remove("description");
            this.deny_dhcp((Boolean)hashtable.get("denyDHCP"));
            hashtable.remove("denyDHCP");
            this.deny_dns((Boolean)hashtable.get("denyDNS"));
            hashtable.remove("denyDNS");
            String string2 = (String)hashtable.get("access");
            hashtable.remove("access");
            if (string2 != null) {
                this.privilege(new Privilege(this.datastore, string2));
            }
        }
        return this;
    }

    @Override
    public int compareTo(State state) {
        String string = this.rank + "_" + this.name;
        String string2 = state.rank + "_" + state.name;
        return string.compareTo(string2);
    }

    public static Boolean has_access() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(Record_Type.STATE);
    }

    public static Boolean has_access(User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(user, Record_Type.STATE);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, Record_Type.STATE);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, user, Record_Type.STATE);
    }

    public static State load(String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return State.load(NetDB.default_datastore(), string);
    }

    public static State load(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        State state = new State(netDB_Datastore);
        state.load_object(string);
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void load_object(String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        if (string == null || string.trim().equals("")) {
            throw Insufficient_Information.missing_handle();
        }
        String string2 = "";
        try {
            string2 = this.datastore.start_transaction(NetDB.current_method_name());
            if (this.name == null) {
                this.name = this.datastore.state().verify_or_die(string2, string);
                if (this.name == null) {
                    throw new Record_Not_Found("'" + string + "' was not found in the database.");
                }
            }
        }
        finally {
            this.datastore.rollback_transaction(string2);
        }
        Collection<State> collection = State.list(this.datastore, string, true);
        Iterator<State> iterator = collection.iterator();
        State state = iterator.next();
        this.id = state.name();
        this.name(state.name());
        this.rank(state.rank());
        this.comment(state.comment());
        this.deny_dhcp(state.deny_dhcp());
        this.deny_dns(state.deny_dns());
        this.privilege(state.privilege());
        this.flag_as_system_created().flag_as_loaded();
    }

    public static Collection<State> list() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return State.list(NetDB.default_datastore());
    }

    public static Collection<State> list(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return State.list(NetDB.default_datastore(), string);
    }

    public static Collection<State> list(Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return State.list(NetDB.default_datastore(), bl);
    }

    public static Collection<State> list(String string, Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return State.list(NetDB.default_datastore(), string, bl);
    }

    public static Collection<State> list(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return State.list(netDB_Datastore, null, false);
    }

    public static Collection<State> list(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return State.list(netDB_Datastore, string, false);
    }

    public static Collection<State> list(NetDB_Datastore netDB_Datastore, Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return State.list(netDB_Datastore, null, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<State> list(NetDB_Datastore netDB_Datastore, String string, Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Integer n = null;
        if (!bl.booleanValue() && netDB_Datastore.operating_user() != null) {
            n = netDB_Datastore.operating_user().id();
        }
        Vector<State> vector = new Vector<State>();
        Hashtable hashtable = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            hashtable = string != null && n != null ? netDB_Datastore.state().list(string2, string, n) : (string == null && n != null ? netDB_Datastore.state().list(string2, n) : (string != null && n == null ? netDB_Datastore.state().list(string2, string) : netDB_Datastore.state().list(string2)));
        }
        finally {
            netDB_Datastore.rollback_transaction(string2);
        }
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                State state = State.extract(netDB_Datastore, (Hashtable)hashtable.get(string3));
                state.flag_as_system_created().flag_as_loaded();
                vector.add(state);
            }
        }
        Collections.sort(vector);
        return vector;
    }

    @Override
    public void delete() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.delete(this.get_datastore());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Boolean bl = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            netDB_Datastore.state().delete(string, this.name);
            this.flag_as_modified().flag_as_user_created();
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
    }

    public static void delete(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        State.delete(NetDB.default_datastore(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Boolean bl = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            netDB_Datastore.state().delete(string2, string);
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string2);
                } else {
                    netDB_Datastore.end_transaction(string2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public State commit(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.bind(netDB_Datastore);
        Insufficient_Information.defined_or_die(this.rank, "rank");
        Insufficient_Information.defined_or_die(this.name, "name");
        Boolean bl = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            String string2 = "";
            if (this.access_group != null) {
                string2 = this.access_group.handle();
            }
            if (this.created_by_user().booleanValue()) {
                netDB_Datastore.state().insert(string, this.name, this.rank, NetDB.boolean_to_integer(this.deny_dhcp), NetDB.boolean_to_integer(this.deny_dns), this.comment, string2);
            } else {
                netDB_Datastore.state().update(string, this.id, this.name, this.rank, NetDB.boolean_to_integer(this.deny_dhcp), NetDB.boolean_to_integer(this.deny_dns), this.comment, string2);
            }
            this.id = this.name;
            this.flag_as_system_created().flag_as_loaded();
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
        return this;
    }
}

