/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import stanford.netdb.Field;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Record;
import stanford.netdb.Record_Type;
import stanford.netdb.User;
import stanford.netdb.exceptions.Exception_Formatter;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.exceptions.Not_Implemented;
import stanford.netdb.exceptions.Record_Not_Found;
import stanford.netdb.util.Cache;

public class Privilege
extends Record<Privilege> {
    public static String template_name = "templates/toString/privilege.tmpl";
    private static final long serialVersionUID = 1L;
    private static String CACHE_NAME = "Privilege";
    private Integer id = null;
    private String name = null;
    private String display_name = null;
    private String comment = "";
    private Boolean default_access = false;

    public Privilege() {
        this.init();
    }

    public Privilege(String string) {
        this.init(string);
    }

    public Privilege(String string, String string2) {
        this.init(string, string2);
    }

    public Privilege(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
        this.init();
    }

    public Privilege(NetDB_Datastore netDB_Datastore, String string) {
        super(netDB_Datastore);
        this.init(string);
    }

    public Privilege(NetDB_Datastore netDB_Datastore, String string, String string2) {
        super(netDB_Datastore);
        this.init(string, string2);
    }

    protected Privilege(NetDB_Datastore netDB_Datastore, Integer n) {
        super(netDB_Datastore);
        this.id = n;
    }

    private void init() {
        this.init(null, null, null, null);
    }

    private void init(String string) {
        this.init(string, null, null, null);
    }

    private void init(String string, String string2) {
        this.init(string, string2, null, null);
    }

    private void init(String string, String string2, String string3, Boolean bl) {
        if (string != null) {
            this.name(string);
        }
        if (string2 != null) {
            this.display_name(string2);
        }
        if (string3 != null) {
            this.comment(string3);
        }
        if (bl != null) {
            this.default_access(bl);
        }
    }

    public Integer id() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.id, NetDB.unset_integer, "id");
        return this.id;
    }

    public String name() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.name, NetDB.unset_string, "name");
        return this.name;
    }

    public String display_name() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.display_name, NetDB.unset_string, "display_name");
        return this.display_name;
    }

    private String comment() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.name, NetDB.unset_string, "comment");
        return this.comment;
    }

    private Boolean default_access() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.name, NetDB.unset_string, "default_access");
        return this.default_access;
    }

    @Override
    public String handle() {
        return this.name;
    }

    private Privilege name(String string) {
        this.name = string;
        return this;
    }

    private Privilege display_name(String string) {
        this.display_name = string;
        return this;
    }

    private Privilege comment(String string) {
        this.comment = string;
        return this;
    }

    private Privilege default_access(Boolean bl) {
        this.default_access = bl;
        return this;
    }

    @Override
    public Privilege unlink() {
        super.unlink();
        this.id = null;
        return this;
    }

    @Override
    public String single_value_attributes() {
        return this.name + " " + this.display_name;
    }

    @Override
    protected void initialize_member_data() {
        super.initialize_member_data();
        if (this.name == null) {
            this.name = NetDB.unset_string;
        }
        if (this.display_name == null) {
            this.display_name = NetDB.unset_string;
        }
        if (this.comment == null) {
            this.comment = NetDB.unset_string;
        }
        if (this.default_access == null) {
            this.default_access = NetDB.unset_boolean;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        super.flag_field_as_defined(field);
        if (field == Field.NAME) {
            if (NetDB.unset_string.equals(this.name)) {
                this.name = null;
            }
        } else if (field == Field.DISPLAY_NAME) {
            if (NetDB.unset_string.equals(this.display_name)) {
                this.display_name = null;
            }
        } else if (field == Field.COMMENT) {
            if (NetDB.unset_string.equals(this.comment)) {
                this.comment = null;
            }
        } else if (field == Field.DEFAULT_ACCESS && this.default_access == NetDB.unset_boolean) {
            this.default_access = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        super.clear_default_member_data();
        if (NetDB.unset_string.equals(this.name)) {
            this.name = null;
        }
        if (NetDB.unset_string.equals(this.display_name)) {
            this.display_name = null;
        }
        if (NetDB.unset_string.equals(this.comment)) {
            this.comment = null;
        }
        if (this.default_access == NetDB.unset_boolean) {
            this.default_access = null;
        }
    }

    @Override
    public String toString() {
        String string = "";
        try {
            string = this.toString(NetDB.FORMAT.FULL, true);
        }
        catch (Exception exception) {
            this.logger().severe("An exception was encountered while attempting to convert a Privilege into a string:\n" + Exception_Formatter.stack_trace(exception));
        }
        return string;
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT) throws Exception {
        return this.toString(fORMAT, false);
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return NetDB.toString(fORMAT, template_name, "privilege", this, bl);
    }

    protected static Boolean has_access(Record_Type record_Type) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access((NetDB_Datastore)null, record_Type);
    }

    protected static Boolean has_access(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access((NetDB_Datastore)null, string);
    }

    protected static Boolean has_access(User user, Record_Type record_Type) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access((NetDB_Datastore)null, user, record_Type);
    }

    protected static Boolean has_access(User user, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access((NetDB_Datastore)null, user, string);
    }

    protected static Boolean has_access(Record_Type record_Type, Integer n) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access((NetDB_Datastore)null, record_Type, n);
    }

    protected static Boolean has_access(NetDB_Datastore netDB_Datastore, Record_Type record_Type) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, null, record_Type.toString(), null);
    }

    protected static Boolean has_access(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, null, string, null);
    }

    protected static Boolean has_access(NetDB_Datastore netDB_Datastore, User user, Record_Type record_Type) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Integer n = null;
        if (user != null) {
            n = user.id();
        }
        return Privilege.has_access(netDB_Datastore, n, record_Type.toString(), null);
    }

    protected static Boolean has_access(NetDB_Datastore netDB_Datastore, User user, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Integer n = null;
        if (user != null) {
            n = user.id();
        }
        return Privilege.has_access(netDB_Datastore, n, string, null);
    }

    protected static Boolean has_access(NetDB_Datastore netDB_Datastore, Record_Type record_Type, Integer n) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, null, record_Type.toString(), n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Boolean has_access(NetDB_Datastore netDB_Datastore, Integer n, String string, Integer n2) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Comparable<User> comparable;
        if (netDB_Datastore == null) {
            netDB_Datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        if (n == null) {
            comparable = netDB_Datastore.operating_user();
            if (comparable == null) {
                throw new Insufficient_Information("A user must be specified, or an operating user must be set.");
            }
            n = ((User)comparable).id();
        }
        comparable = false;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            comparable = n2 != null ? netDB_Datastore.access().check_access(string2, n, string) : netDB_Datastore.access().check_access(string2, n, string, n2);
        }
        finally {
            netDB_Datastore.rollback_transaction(string2);
        }
        return comparable;
    }

    public static Privilege load(String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return Privilege.load(NetDB.default_datastore(), string);
    }

    public static Privilege load(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        Privilege privilege = new Privilege(netDB_Datastore);
        privilege.load_object(string);
        return privilege;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void load_object(String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        if (string == null || string.trim().equals("") || NetDB.unset_string.equals(string) && this.id == null) {
            throw Insufficient_Information.missing_handle();
        }
        String string2 = "";
        try {
            string2 = this.datastore.start_transaction(NetDB.current_method_name());
            if (NetDB.unset_string.equals(string) && this.id != null) {
                string = this.datastore.access().handle(string2, this.id);
            }
        }
        finally {
            this.datastore.rollback_transaction(string2);
        }
        try {
            string2 = this.datastore.start_transaction(NetDB.current_method_name());
            if (this.id == null) {
                this.id = this.datastore.access().verify_or_die(string2, string);
            }
        }
        finally {
            this.datastore.rollback_transaction(string2);
        }
        Cache<Hashtable<String, String>> cache = Cache.fetch_hashtable_cache(this.datastore.cache_name(CACHE_NAME));
        try {
            string2 = this.datastore.start_transaction(NetDB.current_method_name());
            if (cache.is_old().booleanValue()) {
                cache.data(this.datastore.access().list(string2));
            }
        }
        finally {
            this.datastore.rollback_transaction(string2);
        }
        this.name = string;
        this.display_name = cache.data().get(string);
        this.flag_as_system_created().flag_as_loaded();
    }

    public static Collection<Privilege> list() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.list(NetDB.default_datastore());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Collection<Privilege> list(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Vector<Privilege> vector = new Vector<Privilege>();
        Hashtable hashtable = null;
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            hashtable = netDB_Datastore.access().list(string);
        }
        finally {
            netDB_Datastore.rollback_transaction(string);
        }
        if (hashtable != null) {
            Cache.fetch_hashtable_cache(netDB_Datastore.cache_name(CACHE_NAME)).data(hashtable);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                Privilege privilege = new Privilege(netDB_Datastore, string2, (String)hashtable.get(string2));
                privilege.flag_as_system_created();
                vector.add(privilege);
            }
        }
        Collections.sort(vector);
        return vector;
    }

    @Override
    public void delete(NetDB_Datastore netDB_Datastore) throws Not_Implemented {
        throw new Not_Implemented("This class cannot currently be deleted.");
    }

    public static void delete(String string) throws Not_Implemented {
        Privilege.delete(NetDB.default_datastore(), string);
    }

    public static void delete(NetDB_Datastore netDB_Datastore, String string) throws Not_Implemented {
        throw new Not_Implemented("This class cannot currently be deleted.");
    }

    @Override
    public Privilege commit(NetDB_Datastore netDB_Datastore) throws Not_Implemented {
        throw new Not_Implemented("This class cannot currently be committed.");
    }
}

