/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Vector;
import stanford.netdb.A_Name;
import stanford.netdb.Admin_Team;
import stanford.netdb.Domain;
import stanford.netdb.Field;
import stanford.netdb.Group;
import stanford.netdb.IP_Address;
import stanford.netdb.Interface;
import stanford.netdb.Interface_IP_Address;
import stanford.netdb.Log_Entry;
import stanford.netdb.NetDB;
import stanford.netdb.Network;
import stanford.netdb.Node;
import stanford.netdb.User;
import stanford.netdb.util.Date_Formatter;

public class Object_Comparator
implements Comparator<NetDB> {
    private Hashtable<Integer, Field> order = new Hashtable();
    public static String date_format = "yyyy-MM-dd HH:mm:ss";

    public Object_Comparator put(Integer n, String string) {
        if (string == null) {
            return null;
        }
        return this.put(n, Field.find(string));
    }

    public Object_Comparator put(Integer n, Field field) {
        if (n != null && field != null) {
            this.order.put(n, field);
        }
        return this;
    }

    public Field get(Integer n) {
        return this.order.get(n);
    }

    public Integer get(Field field) {
        Vector<Integer> vector = new Vector<Integer>(this.order.keySet());
        Collections.sort(vector);
        for (Integer n : vector) {
            if (this.order.get(n) != field) continue;
            return n;
        }
        return null;
    }

    public Integer get(String string) {
        Vector<Integer> vector = new Vector<Integer>(this.order.keySet());
        Collections.sort(vector);
        for (Integer n : vector) {
            if (this.order.get(n) != Field.valueOf(string)) continue;
            return n;
        }
        return null;
    }

    public Object_Comparator remove(Integer n) {
        this.order.remove(n);
        return this;
    }

    public Vector<Integer> ordered_column_keys() {
        Vector<Integer> vector = new Vector<Integer>(this.order.keySet());
        Collections.sort(vector);
        return vector;
    }

    public Vector<Field> ordered_columns() {
        Vector<Field> vector = new Vector<Field>();
        for (Integer n : this.ordered_column_keys()) {
            vector.add(this.order.get(n));
        }
        return vector;
    }

    public Object_Comparator clean_up() {
        Vector<Integer> vector = new Vector<Integer>(this.order.keySet());
        for (Integer n : vector) {
            if (n != -1 && (n != 0 || this.order.get(n) != Field.ACTION)) continue;
            this.order.remove(n);
        }
        return this;
    }

    @Override
    public int compare(NetDB netDB, NetDB netDB2) {
        String string = "";
        if (netDB instanceof Admin_Team) {
            string = this.admin_team_sort_string((Admin_Team)netDB);
        } else if (netDB instanceof Domain) {
            string = this.domain_sort_string((Domain)netDB);
        } else if (netDB instanceof Group) {
            string = this.group_sort_string((Group)netDB);
        } else if (netDB instanceof Network) {
            string = this.network_sort_string((Network)netDB);
        } else if (netDB instanceof Node) {
            string = this.node_team_sort_string((Node)netDB);
        } else if (netDB instanceof User) {
            string = this.user_sort_string((User)netDB);
        } else if (netDB instanceof Log_Entry) {
            string = this.log_entry_sort_string((Log_Entry)netDB);
        }
        String string2 = "";
        if (netDB2 instanceof Admin_Team) {
            string2 = this.admin_team_sort_string((Admin_Team)netDB2);
        } else if (netDB2 instanceof Domain) {
            string2 = this.domain_sort_string((Domain)netDB2);
        } else if (netDB2 instanceof Group) {
            string2 = this.group_sort_string((Group)netDB2);
        } else if (netDB2 instanceof Network) {
            string2 = this.network_sort_string((Network)netDB2);
        } else if (netDB2 instanceof Node) {
            string2 = this.node_team_sort_string((Node)netDB2);
        } else if (netDB2 instanceof User) {
            string2 = this.user_sort_string((User)netDB2);
        } else if (netDB2 instanceof Log_Entry) {
            string2 = this.log_entry_sort_string((Log_Entry)netDB2);
        }
        return string.toLowerCase().compareTo(string2.toLowerCase());
    }

    public String admin_team_sort_string(Admin_Team admin_Team) {
        if (admin_Team == null) {
            return "";
        }
        Vector<Integer> vector = new Vector<Integer>(this.order.keySet());
        Collections.sort(vector);
        String string = "";
        for (Integer n : vector) {
            Field field = this.order.get(n);
            if (field == Field.COMMENT) {
                try {
                    string = string + admin_Team.comment();
                }
                catch (Exception exception) {}
            } else if (field == Field.CREATED_BY) {
                try {
                    string = string + admin_Team.created_by();
                }
                catch (Exception exception) {}
            } else if (field == Field.DEPARTMENT) {
                try {
                    string = string + this.first_handle(admin_Team.departments());
                }
                catch (Exception exception) {}
            } else if (field == Field.EMAIL) {
                try {
                    string = string + admin_Team.email();
                }
                catch (Exception exception) {}
            } else if (field == Field.MEMBER) {
                try {
                    string = string + this.first_handle(admin_Team.members());
                }
                catch (Exception exception) {}
            } else if (field == Field.MODIFIED_BY) {
                try {
                    string = string + admin_Team.modified_by();
                }
                catch (Exception exception) {}
            } else if (field == Field.NAME) {
                try {
                    string = string + admin_Team.name();
                }
                catch (Exception exception) {}
            } else if (field == Field.OWNER) {
                try {
                    string = string + this.first_handle(admin_Team.owners());
                }
                catch (Exception exception) {}
            } else if (field == Field.PHONE) {
                try {
                    string = string + admin_Team.phone();
                }
                catch (Exception exception) {}
            } else if (field == Field.CREATED_AT) {
                try {
                    string = string + Date_Formatter.format(date_format, admin_Team.created_at());
                }
                catch (Exception exception) {}
            } else if (field == Field.MODIFIED_AT) {
                try {
                    string = string + Date_Formatter.format(date_format, admin_Team.modified_at());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            string = string + " zzzzz ";
        }
        return string;
    }

    public String domain_sort_string(Domain domain) {
        if (domain == null) {
            return "";
        }
        Vector<Integer> vector = new Vector<Integer>(this.order.keySet());
        Collections.sort(vector);
        String string = "";
        for (Integer n : vector) {
            Field field = this.order.get(n);
            if (field == Field.COMMENT) {
                try {
                    string = string + domain.comment();
                }
                catch (Exception exception) {}
            } else if (field == Field.CREATED_BY) {
                try {
                    string = string + domain.created_by();
                }
                catch (Exception exception) {}
            } else if (field == Field.CREATE_NAMES) {
                try {
                    string = string + this.first_handle(domain.get_acl(Domain.ACCESS_TYPE.CREATE_NAMES_IN_DOMAIN));
                }
                catch (Exception exception) {}
            } else if (field == Field.DELEGATED) {
                try {
                    string = string + domain.delegated();
                }
                catch (Exception exception) {}
            } else if (field == Field.LIMITED) {
                try {
                    string = string + domain.limited();
                }
                catch (Exception exception) {}
            } else if (field == Field.MODIFIED_BY) {
                try {
                    string = string + domain.modified_by();
                }
                catch (Exception exception) {}
            } else if (field == Field.NAME) {
                try {
                    string = string + domain.name();
                }
                catch (Exception exception) {}
            } else if (field == Field.OWNER) {
                try {
                    string = string + this.first_handle(domain.owners());
                }
                catch (Exception exception) {}
            } else if (field == Field.USE_AS_NAME) {
                try {
                    string = string + this.first_handle(domain.get_acl(Domain.ACCESS_TYPE.USE_DOMAIN_AS_NAME));
                }
                catch (Exception exception) {}
            } else if (field == Field.CREATED_AT) {
                try {
                    string = string + Date_Formatter.format(date_format, domain.created_at());
                }
                catch (Exception exception) {}
            } else if (field == Field.MODIFIED_AT) {
                try {
                    string = string + Date_Formatter.format(date_format, domain.modified_at());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            string = string + " zzzzz ";
        }
        return string;
    }

    public String group_sort_string(Group group) {
        if (group == null) {
            return "";
        }
        Vector<Integer> vector = new Vector<Integer>(this.order.keySet());
        Collections.sort(vector);
        String string = "";
        for (Integer n : vector) {
            Field field = this.order.get(n);
            if (field == Field.COMMENT) {
                try {
                    string = string + group.comment();
                }
                catch (Exception exception) {}
            } else if (field == Field.CREATED_BY) {
                try {
                    string = string + group.created_by();
                }
                catch (Exception exception) {}
            } else if (field == Field.MODIFIED_BY) {
                try {
                    string = string + group.modified_by();
                }
                catch (Exception exception) {}
            } else if (field == Field.NAME) {
                try {
                    string = string + group.name();
                }
                catch (Exception exception) {}
            } else if (field == Field.CREATED_AT) {
                try {
                    string = string + Date_Formatter.format(date_format, group.created_at());
                }
                catch (Exception exception) {}
            } else if (field == Field.MODIFIED_AT) {
                try {
                    string = string + Date_Formatter.format(date_format, group.modified_at());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            string = string + " zzzzz ";
        }
        return string;
    }

    public String network_sort_string(Network network) {
        if (network == null) {
            return "";
        }
        Vector<Integer> vector = new Vector<Integer>(this.order.keySet());
        Collections.sort(vector);
        String string = "";
        for (Integer n : vector) {
            Field field = this.order.get(n);
            string = string + " zzzzz ";
        }
        return string;
    }

    public String node_team_sort_string(Node node) {
        if (node == null) {
            return "";
        }
        Interface interface_ = null;
        Interface_IP_Address interface_IP_Address = null;
        A_Name a_Name = null;
        IP_Address iP_Address = null;
        try {
            a_Name = (A_Name)node.names().toArray()[0];
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            interface_ = (Interface)node.interfaces().toArray()[0];
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            interface_IP_Address = (Interface_IP_Address)interface_.addresses().toArray()[0];
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            iP_Address = (IP_Address)node.addresses().toArray()[0];
        }
        catch (Exception exception) {
            // empty catch block
        }
        Vector<Integer> vector = new Vector<Integer>(this.order.keySet());
        Collections.sort(vector);
        String string = "";
        for (Integer n : vector) {
            Field field = this.order.get(n);
            if (field == Field.ACTIVE) {
                try {
                    string = string + interface_IP_Address.active();
                }
                catch (Exception exception) {}
            } else if (field == Field.ADDRESS) {
                try {
                    string = string + interface_IP_Address.handle();
                }
                catch (Exception exception) {}
            } else if (field == Field.ADDRESS_NAME) {
                try {
                    string = string + this.first_handle(interface_IP_Address.names());
                }
                catch (Exception exception) {}
            } else if (field == Field.ADMIN) {
                try {
                    string = string + this.first_handle(node.admins());
                }
                catch (Exception exception) {}
            } else if (field == Field.ALIAS) {
                try {
                    string = string + this.first_handle(a_Name.aliases());
                }
                catch (Exception exception) {}
            } else if (field == Field.CODE) {
                try {
                    string = string + node.location().code();
                }
                catch (Exception exception) {}
            } else if (field == Field.COMMENT) {
                try {
                    string = string + node.comment();
                }
                catch (Exception exception) {}
            } else if (field == Field.CREATED_BY) {
                try {
                    string = string + node.created_by();
                }
                catch (Exception exception) {}
            } else if (field == Field.CUSTOM_TAG) {
                try {
                    string = string + this.first_handle(node.custom_fields());
                }
                catch (Exception exception) {}
            } else if (field == Field.DEPARTMENT) {
                try {
                    string = string + node.department().name();
                }
                catch (Exception exception) {}
            } else if (field == Field.DHCP) {
                try {
                    string = string + interface_.dhcp();
                }
                catch (Exception exception) {}
            } else if (field == Field.DHCP_SETTING) {
                try {
                    string = string + this.first_handle(interface_.dhcp_settings());
                }
                catch (Exception exception) {}
            } else if (field == Field.HW_ADDRESS) {
                try {
                    string = string + interface_.hardware_address();
                }
                catch (Exception exception) {}
            } else if (field == Field.INTERFACE_NAME) {
                try {
                    string = string + this.first_handle(interface_.names());
                }
                catch (Exception exception) {}
            } else if (field == Field.IPC_NAME) {
                try {
                    string = string + this.first_handle(iP_Address.names());
                }
                catch (Exception exception) {}
            } else if (field == Field.LOCATION) {
                try {
                    string = string + node.location().name();
                }
                catch (Exception exception) {}
            } else if (field == Field.MAKE) {
                try {
                    string = string + node.model().handle();
                }
                catch (Exception exception) {}
            } else if (field == Field.MODIFIED_BY) {
                try {
                    string = string + node.modified_by();
                }
                catch (Exception exception) {}
            } else if (field == Field.MX) {
                try {
                    string = string + this.first_handle(a_Name.mxes());
                }
                catch (Exception exception) {}
            } else if (field == Field.NAME) {
                try {
                    string = string + this.first_handle(node.names());
                }
                catch (Exception exception) {}
            } else if (field == Field.OS) {
                try {
                    string = string + this.first_handle(node.oses());
                }
                catch (Exception exception) {}
            } else if (field == Field.OWNER) {
                try {
                    string = string + this.first_handle(node.owners());
                }
                catch (Exception exception) {}
            } else if (field == Field.PREF) {
                try {
                    string = string + (Object)((Object)interface_IP_Address.ptr_pref());
                }
                catch (Exception exception) {}
            } else if (field == Field.ROAM) {
                try {
                    string = string + interface_.roam();
                }
                catch (Exception exception) {}
            } else if (field == Field.ROOM) {
                try {
                    string = string + node.room();
                }
                catch (Exception exception) {}
            } else if (field == Field.SITE) {
                try {
                    string = string + node.location().site();
                }
                catch (Exception exception) {}
            } else if (field == Field.STATE) {
                try {
                    string = string + node.state().name();
                }
                catch (Exception exception) {}
            } else if (field == Field.TYPE) {
                try {
                    string = string + this.first_handle(node.types());
                }
                catch (Exception exception) {}
            } else if (field == Field.USER) {
                try {
                    string = string + this.first_handle(node.users());
                }
                catch (Exception exception) {}
            } else if (field == Field.EXPIRATION) {
                try {
                    string = string + Date_Formatter.format(date_format, node.expiration_date());
                }
                catch (Exception exception) {}
            } else if (field == Field.CREATED_AT) {
                try {
                    string = string + Date_Formatter.format(date_format, node.created_at());
                }
                catch (Exception exception) {}
            } else if (field == Field.MODIFIED_AT) {
                try {
                    string = string + Date_Formatter.format(date_format, node.modified_at());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            string = string + " zzzzz ";
        }
        return string;
    }

    public String user_sort_string(User user) {
        if (user == null) {
            return "";
        }
        Vector<Integer> vector = new Vector<Integer>(this.order.keySet());
        Collections.sort(vector);
        String string = "";
        for (Integer n : vector) {
            Field field = this.order.get(n);
            if (field == Field.ACTIVE) {
                try {
                    string = string + user.active();
                }
                catch (Exception exception) {}
            } else if (field == Field.ALL_GROUPS) {
                try {
                    string = string + user.all_groups();
                }
                catch (Exception exception) {}
            } else if (field == Field.ALL_RECORDS) {
                try {
                    string = string + user.all_records();
                }
                catch (Exception exception) {}
            } else if (field == Field.COMMENT) {
                try {
                    string = string + user.comment();
                }
                catch (Exception exception) {}
            } else if (field == Field.CREATED_BY) {
                try {
                    string = string + user.created_by();
                }
                catch (Exception exception) {}
            } else if (field == Field.DEFAULT_DOMAIN) {
                try {
                    string = string + user.default_domain().name();
                }
                catch (Exception exception) {}
            } else if (field == Field.DEFAULT_GROUP) {
                try {
                    string = string + user.default_group().name();
                }
                catch (Exception exception) {}
            } else if (field == Field.DEPARTMENT) {
                try {
                    string = string + this.first_handle(user.departments());
                }
                catch (Exception exception) {}
            } else if (field == Field.IDENTITY) {
                try {
                    string = string + user.identity();
                }
                catch (Exception exception) {}
            } else if (field == Field.MODIFIED_BY) {
                try {
                    string = string + user.modified_by();
                }
                catch (Exception exception) {}
            } else if (field == Field.NAME) {
                try {
                    string = string + user.name();
                }
                catch (Exception exception) {}
            } else if (field == Field.NETID) {
                try {
                    string = string + user.netid();
                }
                catch (Exception exception) {}
            } else if (field == Field.PRIVILEGE) {
                try {
                    string = string + this.first_handle(user.privileges());
                }
                catch (Exception exception) {}
            } else if (field == Field.STARTING_ADDRESS) {
                try {
                    string = string + user.starting_address();
                }
                catch (Exception exception) {}
            } else if (field == Field.CREATED_AT) {
                try {
                    string = string + Date_Formatter.format(date_format, user.created_at());
                }
                catch (Exception exception) {}
            } else if (field == Field.LAST_LOGIN) {
                try {
                    string = string + Date_Formatter.format(date_format, user.last_login());
                }
                catch (Exception exception) {}
            } else if (field == Field.MODIFIED_AT) {
                try {
                    string = string + Date_Formatter.format(date_format, user.modified_at());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            string = string + " zzzzz ";
        }
        return string;
    }

    public String log_entry_sort_string(Log_Entry log_Entry) {
        if (log_Entry == null) {
            return "";
        }
        Vector<Integer> vector = new Vector<Integer>(this.order.keySet());
        Collections.sort(vector);
        String string = "";
        for (Integer n : vector) {
            Field field = this.order.get(n);
            string = string + " zzzzz ";
        }
        return string;
    }

    private String first_handle(Collection collection) throws Exception {
        Object object;
        if (collection != null && (object = collection.toArray()[0]) instanceof NetDB) {
            return ((NetDB)object).handle();
        }
        return "";
    }
}

