/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import stanford.netdb.Field;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Person;
import stanford.netdb.Privilege;
import stanford.netdb.Record;
import stanford.netdb.Record_Type;
import stanford.netdb.User;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.exceptions.Record_Not_Found;

public class OS
extends Record<OS> {
    public static String template_name = "templates/toString/os.tmpl";
    private static final long serialVersionUID = 1L;
    private String id = null;
    private String name = null;
    private String comment = null;
    private Person modified_by = null;
    private Timestamp modified = null;

    public OS() {
        this.init();
    }

    public OS(String string) {
        this.init(string);
    }

    public OS(String string, String string2) {
        this.init(string, string2);
    }

    public OS(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
        this.init();
    }

    public OS(NetDB_Datastore netDB_Datastore, String string) {
        super(netDB_Datastore);
        this.init(string);
    }

    public OS(NetDB_Datastore netDB_Datastore, String string, String string2) {
        super(netDB_Datastore);
        this.init(string, string2);
    }

    private void init() {
        this.init(null, null, null, null);
    }

    private void init(String string) {
        this.init(string, null, null, null);
    }

    private void init(String string, String string2) {
        this.init(string, string2, null, null);
    }

    private void init(String string, String string2, Person person, Timestamp timestamp) {
        if (string != null) {
            this.name(string);
        }
        if (string2 != null) {
            this.comment(string2);
        }
        if (person != null) {
            this.modified_by(person);
        }
        if (timestamp != null) {
            this.modified(timestamp);
        }
    }

    public String name() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.name, NetDB.unset_string, "name");
        return this.name;
    }

    public String comment() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.comment, NetDB.unset_string, "comment");
        return this.comment;
    }

    private Person modified_by() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.modified_by, NetDB.unset_person, "modified_by");
        return this.modified_by;
    }

    private Timestamp modified() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.modified, NetDB.unset_timestamp, "modified");
        return this.modified;
    }

    @Override
    public String handle() throws Insufficient_Information {
        if (this.name == null) {
            this.name = this.id;
        }
        if (this.name == null) {
            throw new Insufficient_Information("The OS does not have a handle or an ID defined.");
        }
        return this.name;
    }

    public OS name(String string) {
        this.name = string;
        return this;
    }

    public OS comment(String string) {
        this.comment = string;
        return this;
    }

    private OS modified_by(Person person) {
        this.modified_by = person;
        return this;
    }

    private OS modified(Timestamp timestamp) {
        this.modified = timestamp;
        return this;
    }

    @Override
    public OS unlink() {
        super.unlink();
        this.id = null;
        return this;
    }

    @Override
    public String single_value_attributes() {
        return this.name;
    }

    @Override
    protected void initialize_member_data() {
        super.initialize_member_data();
        if (this.name == null) {
            this.name = NetDB.unset_string;
        }
        if (this.comment == null) {
            this.comment = NetDB.unset_string;
        }
        if (this.modified_by == null) {
            this.modified_by = NetDB.unset_person;
        }
        if (this.modified == null) {
            this.modified = NetDB.unset_timestamp;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        super.flag_field_as_defined(field);
        if (field == Field.NAME) {
            if (NetDB.unset_string.equals(this.name)) {
                this.name = null;
            }
        } else if (field == Field.COMMENT) {
            if (NetDB.unset_string.equals(this.comment)) {
                this.comment = null;
            }
        } else if (field == Field.MODIFIED_BY) {
            if (this.modified_by == NetDB.unset_person) {
                this.modified_by = null;
            }
        } else if (field == Field.MODIFIED_AT && this.modified == NetDB.unset_timestamp) {
            this.modified = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        super.clear_default_member_data();
        if (NetDB.unset_string.equals(this.name)) {
            this.name = null;
        }
        if (NetDB.unset_string.equals(this.comment)) {
            this.comment = null;
        }
        if (this.modified_by == NetDB.unset_person) {
            this.modified_by = null;
        }
        if (this.modified == NetDB.unset_timestamp) {
            this.modified = null;
        }
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return Record.toString(fORMAT, template_name, "os", this, bl);
    }

    public static Boolean has_access() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(Record_Type.OS);
    }

    public static Boolean has_access(User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(user, Record_Type.OS);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, Record_Type.OS);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, user, Record_Type.OS);
    }

    public static OS load(String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return OS.load(NetDB.default_datastore(), string);
    }

    public static OS load(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        OS oS = new OS(netDB_Datastore);
        oS.load_object(string);
        return oS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void load_object(String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        if (string == null || string.trim().equals("")) {
            throw Insufficient_Information.missing_handle();
        }
        String string2 = "";
        try {
            string2 = this.datastore.start_transaction(NetDB.current_method_name());
            this.id = this.datastore.os().verify_or_die(string2, string);
        }
        finally {
            this.datastore.rollback_transaction(string2);
        }
        Hashtable hashtable = this.datastore.os().list(this.id);
        this.name(this.id);
        this.comment((String)hashtable.get(this.id));
        this.flag_as_system_created().flag_as_loaded();
    }

    public static Collection<OS> list() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return OS.list(NetDB.default_datastore());
    }

    public static Collection<OS> list(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return OS.list(NetDB.default_datastore(), string);
    }

    public static Collection<OS> list(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return OS.list(netDB_Datastore, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<OS> list(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Vector<OS> vector = new Vector<OS>();
        Hashtable hashtable = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            hashtable = string != null ? netDB_Datastore.os().list(string2, string) : netDB_Datastore.os().list(string2);
        }
        finally {
            netDB_Datastore.rollback_transaction(string2);
        }
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                OS oS = new OS(netDB_Datastore, string3, (String)hashtable.get(string3));
                oS.flag_as_system_created().flag_as_loaded();
                vector.add(oS);
            }
        }
        Collections.sort(vector);
        return vector;
    }

    @Override
    public void delete() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.delete(this.get_datastore());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Boolean bl = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            netDB_Datastore.os().delete(string, this.name);
            this.flag_as_modified().flag_as_user_created();
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
    }

    public static void delete(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        OS.delete(NetDB.default_datastore(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Boolean bl = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            netDB_Datastore.os().delete(string2, string);
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string2);
                } else {
                    netDB_Datastore.end_transaction(string2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OS commit(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.bind(netDB_Datastore);
        Boolean bl = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            Insufficient_Information.defined_or_die(this.name, "name");
            if (this.created_by_user().booleanValue()) {
                netDB_Datastore.os().insert(string, this.name, this.comment);
            } else {
                netDB_Datastore.os().update(string, this.id, this.name, this.comment);
            }
            this.id = this.name;
            this.flag_as_system_created().flag_as_loaded();
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OS supplant(OS oS) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB_Datastore netDB_Datastore = this.get_datastore();
        Boolean bl = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            if (this.created_by_user().booleanValue()) {
                throw new Exception("You must load the record that is being supplanted.");
            }
            netDB_Datastore.os().supplant(string, this.name, oS.name);
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
        return oS;
    }
}

