/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import stanford.netdb.A_Name;
import stanford.netdb.Admin_Team;
import stanford.netdb.Alias;
import stanford.netdb.Attribute;
import stanford.netdb.Custom_Field;
import stanford.netdb.DHCP_Option;
import stanford.netdb.DHCP_Setting;
import stanford.netdb.Department;
import stanford.netdb.FS_Boolean;
import stanford.netdb.FS_Hashtable;
import stanford.netdb.Field;
import stanford.netdb.Full_Search_Parameters;
import stanford.netdb.Group;
import stanford.netdb.IP_Address;
import stanford.netdb.Interface;
import stanford.netdb.Interface_IP_Address;
import stanford.netdb.Location;
import stanford.netdb.MX;
import stanford.netdb.Make;
import stanford.netdb.Model;
import stanford.netdb.Name;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Node;
import stanford.netdb.Node_Type;
import stanford.netdb.OS;
import stanford.netdb.Person;
import stanford.netdb.State;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.middleware.Result_Hash;
import stanford.netdb.util.TZ_Timestamp;

public class Node_FS_Parameters
extends Full_Search_Parameters<Node_FS_Parameters, Node> {
    private static final long serialVersionUID = 1L;
    private static final String INCLUDE_NAME = "displayOrder.ns.2.Name:Node";
    private static final String INCLUDE_ALIAS = "displayOrder.ns.3.Name:Alias";
    private static final String INCLUDE_INTERFACE_NAME = "displayOrder.ns.4.Name:Interface";
    private static final String INCLUDE_IP_NAME = "displayOrder.ns.5.Name:IP";
    private static final String INCLUDE_IPC_NAME = "displayOrder.ns.6.Name:IPC";
    private static final String INCLUDE_RECEIVES_MAIL_FOR = "displayOrder.ns.7.Receives Mail For";
    private static final String INCLUDE_NODE_TYPE = "displayOrder.txt.8.Node Type";
    private static final String INCLUDE_STATE = "displayOrder.txt.9.State";
    private static final String INCLUDE_ADDRESS = "displayOrder.ni.10.Address";
    private static final String INCLUDE_PTR_PREF = "displayOrder.ns.11.PTR Pref";
    private static final String INCLUDE_ACTIVE_ADDRESS = "displayOrder.ns.12.Active Address";
    private static final String INCLUDE_HW_ADDRESS = "displayOrder.ns.13.Hardware Address";
    private static final String INCLUDE_DHCP_STATE = "displayOrder.ns.14.DHCP";
    private static final String INCLUDE_DHCP_OPTION = "displayOrder.ns.15.DHCP Option";
    private static final String INCLUDE_ROAMING_STATE = "displayOrder.ns.16.Roaming";
    private static final String INCLUDE_DEPARTMENT = "displayOrder.txt.18.Department";
    private static final String INCLUDE_LOCATION = "displayOrder.txt.19.Location";
    private static final String INCLUDE_SITE = "displayOrder.txt.20.Site";
    private static final String INCLUDE_CODE = "displayOrder.txt.21.Code";
    private static final String INCLUDE_ROOM = "displayOrder.txt.22.Room";
    private static final String INCLUDE_EXPIRATION_DATE = "displayOrder.tst.23.Expires On";
    private static final String INCLUDE_MAKE_MODEL = "displayOrder.txt.24.Make/Model";
    private static final String INCLUDE_OS = "displayOrder.txt.25.Operating System";
    private static final String INCLUDE_ADMINISTRATORS = "displayOrder.txt.26.Node Administrator";
    private static final String INCLUDE_USERS = "displayOrder.txt.27.Node User";
    private static final String INCLUDE_CUSTOM_FIELDS = "displayOrder.txt.28.Node Tag";
    private static final String ID_COLUMN = "ID";
    private static final String HANDLE_COLUMN = "handle";
    private static final String NAME_ID_COLUMN = "NAME_ID";
    private static final String NAME_COLUMN = "NAME";
    private static final String DOMAIN_COLUMN = "DOMAIN";
    private static final String ALIASEE_COLUMN = "ALIASEE";
    private static final String INTERFACE_COLUMN = "INTERFACE";
    private static final String NODE_COLUMN = "NODE";
    private static final String IP_ADDRESS_COLUMN = "IPADDRESS";
    private static final String IP_NAME_INTERFACE_COLUMN = "IP_NAME_INTERFACE";
    private static final String IPC_ADDRESS_TXT_COLUMN = "IPC_ADDRESS_TXT";
    private static final String IPC_ACTIVE_COLUMN = "IPC_ACTIVE";
    private static final String IP_INTERFACE_COLUMN = "IP_INTERFACE";
    private static final String IP_ADDRESS_TXT_COLUMN = "IP_ADDRESS_TXT";
    private static final String IP_ACTIVE_COLUMN = "IP_ACTIVE";
    private static final String PTR_PREF_COLUMN = "PTRPREF";
    private static final String INTERFACE_ID_COLUMN = "INTERFACE_ID";
    private static final String INTERFACE_HW_COLUMN = "INTERFACE_HW";
    private static final String INTERFACE_ROAM_COLUMN = "INTERFACE_ROAM";
    private static final String INTERFACE_DHCP_COLUMN = "INTERFACE_DHCP";
    private static final String DHCP_OPTIONS_COLUMN = "DHCP_OPTIONS";
    private static final String MX_NAME_COLUMN = "MX_NAME";
    private static final String MX_DOMAIN_COLUMN = "MX_DOMAIN";
    private static final String MX_RECEIVED_BY_COLUMN = "MX_RECEIVED_BY";
    private static final String MX_PREF_COLUMN = "MX_PREF";
    private static final String NODE_TYPE_COLUMN = "Node Type";
    private static final String STATE_COLUMN = "State";
    private static final String GROUP_COLUMN = "Group";
    private static final String DEPARTMENT_COLUMN = "Department";
    private static final String LOCATION_COLUMN = "Location";
    private static final String SITE_COLUMN = "Site";
    private static final String CODE_COLUMN = "Code";
    private static final String ROOM_COLUMN = "Room";
    private static final String EXPIRATION_COLUMN = "Expires On";
    private static final String MAKE_AND_MODEL_COLUMN = "Make/Model";
    private static final String OS_COLUMN = "Operating System";
    private static final String NODE_ADMIN_COLUMN = "Node Administrator";
    private static final String NODE_USER_COLUMN = "Node User";
    private static final String NODE_TAG_COLUMN = "Node Tag";
    private static final String COMMENT_COLUMN = "Comment";
    private String name = "";
    private String receives_mail_for = "";
    private String state = "";
    private String ip_address = "";
    private FS_Boolean ptr_pref = FS_Boolean.EITHER;
    private FS_Boolean ip_active = FS_Boolean.EITHER;
    private String hardware_address = "";
    private FS_Boolean dhcp = FS_Boolean.EITHER;
    private String dhcp_setting = "";
    private FS_Boolean roaming = FS_Boolean.EITHER;
    private Boolean records_in_my_groups = false;
    private String department = "";
    private String location = "";
    private String site = "";
    private String code = "";
    private String room = "";
    private String expires_after_date = "";
    private String expires_before_date = "";
    private String make = "";
    private String model = "";
    private String os = "";
    private String admin_netid = "";
    private String admin_name = "";
    private String admin_team = "";
    private String user_netid = "";
    private String user_name = "";
    private String custom_field = "";
    private Hashtable<NAME_TYPES, Boolean> name_types = new Hashtable();
    private Hashtable<String, Node_Type> include_node_types = new Hashtable();
    private Hashtable<String, Node_Type> exclude_node_types = new Hashtable();
    private Boolean mx_include_name = false;
    private Integer op_uid = null;
    private String OP_UID = "OP_UID";

    public Node_FS_Parameters() {
        this.INCLUDE_MODIFIED_BY = "displayOrder.txt.30.Modified By";
        this.INCLUDE_MODIFIED = "displayOrder.tst.31.Date Modified";
        this.INCLUDE_CREATED_BY = "displayOrder.txt.32.Created By";
        this.INCLUDE_CREATED = "displayOrder.tst.33.Date Created";
        this.INCLUDE_OWNER = "displayOrder.txt.17.Group";
        this.INCLUDE_COMMENT = "displayOrder.txt.29.Comment";
        this.include_fields.put(INCLUDE_NAME, Boolean.FALSE);
        this.include_fields.put(INCLUDE_ALIAS, Boolean.FALSE);
        this.include_fields.put(INCLUDE_INTERFACE_NAME, Boolean.FALSE);
        this.include_fields.put(INCLUDE_IP_NAME, Boolean.FALSE);
        this.include_fields.put(INCLUDE_IPC_NAME, Boolean.FALSE);
        this.include_fields.put(INCLUDE_RECEIVES_MAIL_FOR, Boolean.FALSE);
        this.include_fields.put(INCLUDE_NODE_TYPE, Boolean.FALSE);
        this.include_fields.put(INCLUDE_STATE, Boolean.FALSE);
        this.include_fields.put(INCLUDE_ADDRESS, Boolean.FALSE);
        this.include_fields.put(INCLUDE_PTR_PREF, Boolean.FALSE);
        this.include_fields.put(INCLUDE_ACTIVE_ADDRESS, Boolean.FALSE);
        this.include_fields.put(INCLUDE_HW_ADDRESS, Boolean.FALSE);
        this.include_fields.put(INCLUDE_DHCP_STATE, Boolean.FALSE);
        this.include_fields.put(INCLUDE_DHCP_OPTION, Boolean.FALSE);
        this.include_fields.put(INCLUDE_ROAMING_STATE, Boolean.FALSE);
        this.include_fields.put(INCLUDE_DEPARTMENT, Boolean.FALSE);
        this.include_fields.put(INCLUDE_LOCATION, Boolean.FALSE);
        this.include_fields.put(INCLUDE_SITE, Boolean.FALSE);
        this.include_fields.put(INCLUDE_CODE, Boolean.FALSE);
        this.include_fields.put(INCLUDE_ROOM, Boolean.FALSE);
        this.include_fields.put(INCLUDE_EXPIRATION_DATE, Boolean.FALSE);
        this.include_fields.put(INCLUDE_MAKE_MODEL, Boolean.FALSE);
        this.include_fields.put(INCLUDE_OS, Boolean.FALSE);
        this.include_fields.put(INCLUDE_ADMINISTRATORS, Boolean.FALSE);
        this.include_fields.put(INCLUDE_USERS, Boolean.FALSE);
        this.include_fields.put(INCLUDE_CUSTOM_FIELDS, Boolean.FALSE);
        this.include_fields.put(this.INCLUDE_MODIFIED_BY, Boolean.FALSE);
        this.include_fields.put(this.INCLUDE_MODIFIED, Boolean.FALSE);
        this.include_fields.put(this.INCLUDE_CREATED_BY, Boolean.FALSE);
        this.include_fields.put(this.INCLUDE_CREATED, Boolean.FALSE);
        this.include_fields.put(this.INCLUDE_OWNER, Boolean.FALSE);
        this.include_fields.put(this.INCLUDE_COMMENT, Boolean.FALSE);
        this.name_types.put(NAME_TYPES.ALIAS, Boolean.FALSE);
        this.name_types.put(NAME_TYPES.INTERFACE, Boolean.FALSE);
        this.name_types.put(NAME_TYPES.IPC, Boolean.FALSE);
        this.name_types.put(NAME_TYPES.IP_ADDRESS, Boolean.FALSE);
        this.name_types.put(NAME_TYPES.NODE, Boolean.FALSE);
    }

    public String name() {
        return this.name;
    }

    public Boolean search_node_names() {
        return this.name_types.get((Object)NAME_TYPES.NODE);
    }

    public Boolean include_node_name() {
        return (Boolean)this.include_fields.get(INCLUDE_NAME);
    }

    public Boolean search_aliases() {
        return this.name_types.get((Object)NAME_TYPES.ALIAS);
    }

    public Boolean include_alias() {
        return (Boolean)this.include_fields.get(INCLUDE_ALIAS);
    }

    public Boolean search_interface_names() {
        return this.name_types.get((Object)NAME_TYPES.INTERFACE);
    }

    public Boolean include_interface_name() {
        return (Boolean)this.include_fields.get(INCLUDE_INTERFACE_NAME);
    }

    public Boolean search_IP_names() {
        return this.search_ip_names();
    }

    public Boolean search_ip_names() {
        return this.name_types.get((Object)NAME_TYPES.IP_ADDRESS);
    }

    public Boolean include_IP_name() {
        return this.include_ip_name();
    }

    public Boolean include_ip_name() {
        return (Boolean)this.include_fields.get(INCLUDE_IP_NAME);
    }

    public Boolean search_IPC_names() {
        return this.search_ipc_names();
    }

    public Boolean search_ipc_names() {
        return this.name_types.get((Object)NAME_TYPES.IPC);
    }

    public Boolean include_IPC_name() {
        return this.include_ipc_name();
    }

    public Boolean include_ipc_name() {
        return (Boolean)this.include_fields.get(INCLUDE_IPC_NAME);
    }

    public String receives_mail_for() {
        return this.receives_mail_for;
    }

    public Boolean include_receives_mail_for() {
        return (Boolean)this.include_fields.get(INCLUDE_RECEIVES_MAIL_FOR);
    }

    public Collection<Node_Type> types() throws Exception {
        return this.include_node_types.values();
    }

    public Collection<Node_Type> not_types() throws Exception {
        return this.exclude_node_types.values();
    }

    public Boolean include_types() throws Exception {
        return (Boolean)this.include_fields.get(INCLUDE_NODE_TYPE);
    }

    public String state() {
        return this.state;
    }

    public Boolean include_active() {
        return (Boolean)this.include_fields.get(INCLUDE_STATE);
    }

    public String IP_address() {
        return this.ip_address();
    }

    public String ip_address() {
        return this.ip_address;
    }

    public Boolean include_IP_address() {
        return this.include_ip_address();
    }

    public Boolean include_ip_address() {
        return (Boolean)this.include_fields.get(INCLUDE_ADDRESS);
    }

    public Boolean PTRpref() {
        return this.ptr_pref();
    }

    public Boolean ptr_pref() {
        return this.ptr_pref.value();
    }

    public Boolean include_PTRpref() {
        return this.include_ptr_pref();
    }

    public Boolean include_ptr_pref() {
        return (Boolean)this.include_fields.get(INCLUDE_PTR_PREF);
    }

    public Boolean IP_active() {
        return this.ip_active();
    }

    public Boolean ip_active() {
        return this.ip_active.value();
    }

    public Boolean include_IP_active() {
        return this.include_ip_active();
    }

    public Boolean include_ip_active() {
        return (Boolean)this.include_fields.get(INCLUDE_ACTIVE_ADDRESS);
    }

    public String hardware_address() {
        return this.hardware_address;
    }

    public Boolean include_hardware_address() {
        return (Boolean)this.include_fields.get(INCLUDE_HW_ADDRESS);
    }

    public Boolean DHCP() {
        return this.dhcp();
    }

    public Boolean dhcp() {
        return this.dhcp.value();
    }

    public Boolean include_DHCP() {
        return this.include_dhcp();
    }

    public Boolean include_dhcp() {
        return (Boolean)this.include_fields.get(INCLUDE_DHCP_STATE);
    }

    public String DHCP_setting() {
        return this.dhcp_setting();
    }

    public String dhcp_setting() {
        return this.dhcp_setting;
    }

    public Boolean include_DHCP_setting() {
        return this.include_dhcp_setting();
    }

    public Boolean include_dhcp_setting() {
        return (Boolean)this.include_fields.get(INCLUDE_DHCP_OPTION);
    }

    public Boolean roaming() {
        return this.roaming.value();
    }

    public Boolean include_roaming() {
        return (Boolean)this.include_fields.get(INCLUDE_ROAMING_STATE);
    }

    public Boolean records_in_my_groups() {
        return this.records_in_my_groups;
    }

    public String department() {
        return this.department;
    }

    public Boolean include_department() {
        return (Boolean)this.include_fields.get(INCLUDE_DEPARTMENT);
    }

    public String location() {
        return this.location;
    }

    public Boolean include_location() {
        return (Boolean)this.include_fields.get(INCLUDE_LOCATION);
    }

    public String site() {
        return this.site;
    }

    public Boolean include_site() {
        return (Boolean)this.include_fields.get(INCLUDE_SITE);
    }

    public String code() {
        return this.code;
    }

    public Boolean include_code() {
        return (Boolean)this.include_fields.get(INCLUDE_CODE);
    }

    public String room() {
        return this.room;
    }

    public Boolean include_room() {
        return (Boolean)this.include_fields.get(INCLUDE_ROOM);
    }

    public String expires_after_date() {
        return this.expires_after_date;
    }

    public String expires_before_date() {
        return this.expires_before_date;
    }

    public Boolean include_expiration_date() {
        return (Boolean)this.include_fields.get(INCLUDE_EXPIRATION_DATE);
    }

    public String model() {
        return this.model;
    }

    public String make() {
        return this.make;
    }

    public Boolean include_make_and_model() {
        return (Boolean)this.include_fields.get(INCLUDE_MAKE_MODEL);
    }

    public String OS() {
        return this.os();
    }

    public String os() {
        return this.os;
    }

    public Boolean include_OS() {
        return this.include_os();
    }

    public Boolean include_os() {
        return (Boolean)this.include_fields.get(INCLUDE_OS);
    }

    public String admin_netID() {
        return this.admin_netid();
    }

    public String admin_netid() {
        return this.admin_netid;
    }

    public String admin_name() {
        return this.admin_name;
    }

    public String admin_team() {
        return this.admin_team;
    }

    public Boolean include_administrators() {
        return (Boolean)this.include_fields.get(INCLUDE_ADMINISTRATORS);
    }

    public String user_netID() {
        return this.user_netid();
    }

    public String user_netid() {
        return this.user_netid;
    }

    public String user_name() {
        return this.user_name;
    }

    public Boolean include_user() {
        return (Boolean)this.include_fields.get(INCLUDE_USERS);
    }

    public String custom_field() {
        return this.custom_field;
    }

    public Boolean include_custom_field() {
        return (Boolean)this.include_fields.get(INCLUDE_CUSTOM_FIELDS);
    }

    public Node_FS_Parameters name(String string) {
        if (string == null) {
            string = "";
        }
        this.name = string;
        return this;
    }

    public Node_FS_Parameters search_node_names(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.name_types.put(NAME_TYPES.NODE, bl);
        return this;
    }

    public Node_FS_Parameters include_node_name(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_NAME, bl);
        return this;
    }

    public Node_FS_Parameters search_aliases(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.name_types.put(NAME_TYPES.ALIAS, bl);
        return this;
    }

    public Node_FS_Parameters include_alias(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_ALIAS, bl);
        return this;
    }

    public Node_FS_Parameters search_interface_names(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.name_types.put(NAME_TYPES.INTERFACE, bl);
        return this;
    }

    public Node_FS_Parameters include_interface_name(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_INTERFACE_NAME, bl);
        return this;
    }

    public Node_FS_Parameters search_IP_names(Boolean bl) {
        return this.search_ip_names(bl);
    }

    public Node_FS_Parameters search_ip_names(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.name_types.put(NAME_TYPES.IP_ADDRESS, bl);
        return this;
    }

    public Node_FS_Parameters include_IP_name(Boolean bl) {
        return this.include_ip_name(bl);
    }

    public Node_FS_Parameters include_ip_name(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_IP_NAME, bl);
        return this;
    }

    public Node_FS_Parameters search_IPC_names(Boolean bl) {
        return this.search_ipc_names(bl);
    }

    public Node_FS_Parameters search_ipc_names(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.name_types.put(NAME_TYPES.IPC, bl);
        return this;
    }

    public Node_FS_Parameters include_IPC_name(Boolean bl) {
        return this.include_ipc_name(bl);
    }

    public Node_FS_Parameters include_ipc_name(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_IPC_NAME, bl);
        return this;
    }

    public Node_FS_Parameters receives_mail_for(String string) {
        if (string == null) {
            string = "";
        }
        this.receives_mail_for = string;
        return this;
    }

    public Node_FS_Parameters receives_mail_for(String string, Boolean bl) {
        this.receives_mail_for(string);
        this.include_receives_mail_for(bl);
        return this;
    }

    public Node_FS_Parameters include_receives_mail_for(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.mx_include_name = bl;
        this.include_fields.put(INCLUDE_RECEIVES_MAIL_FOR, bl);
        return this;
    }

    public Node_FS_Parameters types(Collection<Node_Type> collection) throws Exception {
        this.include_node_types = new Hashtable();
        if (collection != null) {
            for (Node_Type node_Type : collection) {
                this.include_node_types.put(node_Type.name(), node_Type);
            }
        }
        return this;
    }

    public Node_FS_Parameters types(Collection<Node_Type> collection, Boolean bl) throws Exception {
        this.types(collection);
        this.include_types(bl);
        return this;
    }

    public Node_FS_Parameters not_types(Collection<Node_Type> collection) throws Exception {
        this.exclude_node_types = new Hashtable();
        if (collection != null) {
            for (Node_Type node_Type : collection) {
                this.exclude_node_types.put(node_Type.name(), node_Type);
            }
        }
        return this;
    }

    public Node_FS_Parameters not_types(Collection<Node_Type> collection, Boolean bl) throws Exception {
        this.not_types(collection);
        this.include_types(bl);
        return this;
    }

    public Node_FS_Parameters include_types(Boolean bl) throws Exception {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_NODE_TYPE, bl);
        return this;
    }

    public Node_FS_Parameters state(String string) {
        if (string == null) {
            string = "";
        }
        this.state = string;
        return this;
    }

    public Node_FS_Parameters state(String string, Boolean bl) {
        this.state(string);
        this.include_state(bl);
        return this;
    }

    public Node_FS_Parameters include_state(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_STATE, bl);
        return this;
    }

    public Node_FS_Parameters IP_address(String string) {
        return this.ip_address(string);
    }

    public Node_FS_Parameters ip_address(String string) {
        if (string == null) {
            string = "";
        }
        this.ip_address = string;
        return this;
    }

    public Node_FS_Parameters IP_address(String string, Boolean bl) {
        return this.ip_address(string, bl);
    }

    public Node_FS_Parameters ip_address(String string, Boolean bl) {
        this.ip_address(string);
        this.include_ip_address(bl);
        return this;
    }

    public Node_FS_Parameters include_IP_address(Boolean bl) {
        return this.include_ip_address(bl);
    }

    public Node_FS_Parameters include_ip_address(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_ADDRESS, bl);
        return this;
    }

    public Node_FS_Parameters PTRpref(Boolean bl) {
        return this.ptr_pref(bl);
    }

    public Node_FS_Parameters ptr_pref(Boolean bl) {
        this.ptr_pref = new FS_Boolean(bl);
        return this;
    }

    public Node_FS_Parameters PTRpref(Boolean bl, Boolean bl2) {
        return this.ptr_pref(bl, bl2);
    }

    public Node_FS_Parameters ptr_pref(Boolean bl, Boolean bl2) {
        this.ptr_pref(bl);
        this.include_ptr_pref(bl2);
        return this;
    }

    public Node_FS_Parameters include_PTRpref(Boolean bl) {
        return this.include_ptr_pref(bl);
    }

    public Node_FS_Parameters include_ptr_pref(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_PTR_PREF, bl);
        return this;
    }

    public Node_FS_Parameters IP_active(Boolean bl) {
        return this.ip_active(bl);
    }

    public Node_FS_Parameters ip_active(Boolean bl) {
        this.ip_active = new FS_Boolean(bl);
        return this;
    }

    public Node_FS_Parameters IP_active(Boolean bl, Boolean bl2) {
        return this.ip_active(bl, bl2);
    }

    public Node_FS_Parameters ip_active(Boolean bl, Boolean bl2) {
        this.ip_active(bl);
        this.include_ip_active(bl2);
        return this;
    }

    public Node_FS_Parameters include_IP_active(Boolean bl) {
        return this.include_ip_active(bl);
    }

    public Node_FS_Parameters include_ip_active(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_ACTIVE_ADDRESS, bl);
        return this;
    }

    public Node_FS_Parameters hardware_address(String string) {
        if (string == null) {
            string = "";
        }
        this.hardware_address = string;
        return this;
    }

    public Node_FS_Parameters hardware_address(String string, Boolean bl) {
        this.hardware_address(string);
        this.include_hardware_address(bl);
        return this;
    }

    public Node_FS_Parameters include_hardware_address(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_HW_ADDRESS, bl);
        return this;
    }

    public Node_FS_Parameters DHCP(Boolean bl) {
        return this.dhcp(bl);
    }

    public Node_FS_Parameters dhcp(Boolean bl) {
        this.dhcp = new FS_Boolean(bl);
        return this;
    }

    public Node_FS_Parameters DHCP(Boolean bl, Boolean bl2) {
        return this.dhcp(bl, bl2);
    }

    public Node_FS_Parameters dhcp(Boolean bl, Boolean bl2) {
        this.dhcp(bl);
        this.include_dhcp(bl2);
        return this;
    }

    public Node_FS_Parameters include_DHCP(Boolean bl) {
        return this.include_dhcp(bl);
    }

    public Node_FS_Parameters include_dhcp(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_DHCP_STATE, bl);
        return this;
    }

    public Node_FS_Parameters DHCP_setting(String string) {
        return this.dhcp_setting(string);
    }

    public Node_FS_Parameters dhcp_setting(String string) {
        if (string == null) {
            string = "";
        }
        this.dhcp_setting = string;
        return this;
    }

    public Node_FS_Parameters DHCP_setting(String string, Boolean bl) {
        return this.dhcp_setting(string, bl);
    }

    public Node_FS_Parameters dhcp_setting(String string, Boolean bl) {
        this.dhcp_setting(string);
        this.include_dhcp_setting(bl);
        return this;
    }

    public Node_FS_Parameters include_DHCP_setting(Boolean bl) {
        return this.include_dhcp_setting(bl);
    }

    public Node_FS_Parameters include_dhcp_setting(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_DHCP_OPTION, bl);
        return this;
    }

    public Node_FS_Parameters roaming(Boolean bl) {
        this.roaming = new FS_Boolean(bl);
        return this;
    }

    public Node_FS_Parameters roaming(Boolean bl, Boolean bl2) {
        this.roaming(bl);
        this.include_roaming(bl2);
        return this;
    }

    public Node_FS_Parameters include_roaming(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_ROAMING_STATE, bl);
        return this;
    }

    public Node_FS_Parameters records_in_my_groups(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.records_in_my_groups = bl;
        return this;
    }

    public Node_FS_Parameters department(String string) {
        if (string == null) {
            string = "";
        }
        this.department = string;
        return this;
    }

    public Node_FS_Parameters department(String string, Boolean bl) {
        this.department(string);
        this.include_department(bl);
        return this;
    }

    public Node_FS_Parameters include_department(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_DEPARTMENT, bl);
        return this;
    }

    public Node_FS_Parameters location(String string) {
        if (string == null) {
            string = "";
        }
        this.location = string;
        return this;
    }

    public Node_FS_Parameters location(String string, Boolean bl) {
        this.location(string);
        this.include_location(bl);
        return this;
    }

    public Node_FS_Parameters include_location(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_LOCATION, bl);
        return this;
    }

    public Node_FS_Parameters site(String string) {
        if (string == null) {
            string = "";
        }
        this.site = string;
        return this;
    }

    public Node_FS_Parameters site(String string, Boolean bl) {
        this.site(string);
        this.include_site(bl);
        return this;
    }

    public Node_FS_Parameters include_site(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_SITE, bl);
        return this;
    }

    public Node_FS_Parameters code(String string) {
        if (string == null) {
            string = "";
        }
        this.code = string;
        return this;
    }

    public Node_FS_Parameters code(String string, Boolean bl) {
        this.code(string);
        this.include_code(bl);
        return this;
    }

    public Node_FS_Parameters include_code(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_CODE, bl);
        return this;
    }

    public Node_FS_Parameters room(String string) {
        if (string == null) {
            string = "";
        }
        this.room = string;
        return this;
    }

    public Node_FS_Parameters room(String string, Boolean bl) {
        this.room(string);
        this.include_room(bl);
        return this;
    }

    public Node_FS_Parameters include_room(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_ROOM, bl);
        return this;
    }

    public Node_FS_Parameters expires_after_date(String string) {
        if (string == null) {
            string = "";
        }
        this.expires_after_date = string;
        return this;
    }

    public Node_FS_Parameters expires_after_date(String string, Boolean bl) {
        this.expires_after_date(string);
        this.include_expiration_date(bl);
        return this;
    }

    public Node_FS_Parameters expires_before_date(String string) {
        if (string == null) {
            string = "";
        }
        this.expires_before_date = string;
        return this;
    }

    public Node_FS_Parameters expires_before_date(String string, Boolean bl) {
        this.expires_before_date(string);
        this.include_expiration_date(bl);
        return this;
    }

    public Node_FS_Parameters include_expiration_date(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_EXPIRATION_DATE, bl);
        return this;
    }

    public Node_FS_Parameters make(String string) {
        if (string == null) {
            string = "";
        }
        this.make = string;
        return this;
    }

    public Node_FS_Parameters make(String string, Boolean bl) {
        this.make(string);
        this.include_make_and_model(bl);
        return this;
    }

    public Node_FS_Parameters model(String string) {
        if (string == null) {
            string = "";
        }
        this.model = string;
        return this;
    }

    public Node_FS_Parameters model(String string, Boolean bl) {
        this.model(string);
        this.include_make_and_model(bl);
        return this;
    }

    public Node_FS_Parameters include_make_and_model(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_MAKE_MODEL, bl);
        return this;
    }

    public Node_FS_Parameters OS(String string) {
        return this.os(string);
    }

    public Node_FS_Parameters os(String string) {
        if (string == null) {
            string = "";
        }
        this.os = string;
        return this;
    }

    public Node_FS_Parameters OS(String string, Boolean bl) {
        return this.os(string, bl);
    }

    public Node_FS_Parameters os(String string, Boolean bl) {
        this.os(string);
        this.include_os(bl);
        return this;
    }

    public Node_FS_Parameters include_OS(Boolean bl) {
        return this.include_os(bl);
    }

    public Node_FS_Parameters include_os(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_OS, bl);
        return this;
    }

    public Node_FS_Parameters admin_netID(String string) {
        return this.admin_netid(string);
    }

    public Node_FS_Parameters admin_netid(String string) {
        if (string == null) {
            string = "";
        }
        this.admin_netid = string;
        return this;
    }

    public Node_FS_Parameters admin_netID(String string, Boolean bl) {
        return this.admin_netid(string, bl);
    }

    public Node_FS_Parameters admin_netid(String string, Boolean bl) {
        this.admin_netid(string);
        this.include_administrators(bl);
        return this;
    }

    public Node_FS_Parameters admin_name(String string) {
        if (string == null) {
            string = "";
        }
        this.admin_name = string;
        return this;
    }

    public Node_FS_Parameters admin_name(String string, Boolean bl) {
        this.admin_name(string);
        this.include_administrators(bl);
        return this;
    }

    public Node_FS_Parameters admin_team(String string) {
        if (string == null) {
            string = "";
        }
        this.admin_team = string;
        return this;
    }

    public Node_FS_Parameters admin_team(String string, Boolean bl) {
        this.admin_team(string);
        this.include_administrators(bl);
        return this;
    }

    public Node_FS_Parameters include_administrators(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_ADMINISTRATORS, bl);
        return this;
    }

    public Node_FS_Parameters user_netID(String string) {
        return this.user_netid(string);
    }

    public Node_FS_Parameters user_netid(String string) {
        if (string == null) {
            string = "";
        }
        this.user_netid = string;
        return this;
    }

    public Node_FS_Parameters user_netID(String string, Boolean bl) {
        return this.user_netid(string, bl);
    }

    public Node_FS_Parameters user_netid(String string, Boolean bl) {
        this.user_netid(string);
        this.include_user(bl);
        return this;
    }

    public Node_FS_Parameters user_name(String string) {
        if (string == null) {
            string = "";
        }
        this.user_name = string;
        return this;
    }

    public Node_FS_Parameters user_name(String string, Boolean bl) {
        this.user_name(string);
        this.include_user(bl);
        return this;
    }

    public Node_FS_Parameters include_user(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_USERS, bl);
        return this;
    }

    public Node_FS_Parameters custom_field(String string) {
        if (string == null) {
            string = "";
        }
        this.custom_field = string;
        return this;
    }

    public Node_FS_Parameters custom_field(String string, Boolean bl) {
        this.custom_field(string);
        this.include_custom_field(bl);
        return this;
    }

    public Node_FS_Parameters include_custom_field(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_CUSTOM_FIELDS, bl);
        return this;
    }

    @Override
    public Vector<Node> search(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        if (netDB_Datastore != null && netDB_Datastore.operating_user() != null) {
            this.op_uid = netDB_Datastore.operating_user().id();
        }
        return super.search(netDB_Datastore);
    }

    @Override
    protected String get_SQL(String string) throws Exception {
        String string2;
        String string3;
        Hashtable<String, String> hashtable = this.legacy_search_params();
        String string4 = "WITH Records AS ( SELECT unique(id) record_id FROM ";
        Vector vector = new Vector();
        this.assmDisplayOrder(vector, hashtable);
        if (hashtable.get("cb.i.Name:Node") == null && hashtable.get("cb.i.Name:Alias") == null && hashtable.get("cb.i.Name:Interface") == null && hashtable.get("cb.i.Name:IP") == null && hashtable.get("cb.i.Name:IPC") == null) {
            hashtable.remove("fs.FS_NameNode.txt.fullname_lc");
        }
        if ((string3 = hashtable.get("txt.customFields")) != null && string3.trim().length() > 0) {
            hashtable.put("fs.FS_Node.txt.lower(custom_field)", string3.replaceAll("#", "#hsh").replaceAll("\\\\\\\\", "&bsl;").replaceAll("\\\\=", "#eql").replaceAll("&bsl;", "\\\\\\\\"));
        }
        if ((string2 = hashtable.get("txt.DHCPoptions")) != null && string2.trim().length() > 0) {
            hashtable.put("fs.FS_NodeIPaddress.txt.lower(dhcp_option)", string2.replaceAll("#", "#hsh").replaceAll("\\\\\\\\", "&bsl;").replaceAll("\\\\=", "#eql").replaceAll("&bsl;", "\\\\\\\\"));
        }
        if (hashtable.get("cb.i.f.InMyGroups").length() > 0) {
            hashtable.put("cb.i.f.InMyGroups", hashtable.get("cb.i.f.InMyGroups").replace(this.OP_UID, this.op_uid.toString()));
            if (hashtable.get("fs.FS_NameNode.txt.fullname_lc") == null || hashtable.get("fs.FS_NameNode.txt.fullname_lc").trim().equals("")) {
                hashtable.put("fs.FS_NameNode.txt.fullname_lc", "*");
                hashtable.put("cb.i.Name:Node", "node is not null");
            }
        }
        Vector<Exception> vector2 = new Vector<Exception>();
        string4 = string4 + this.assmCommonSQL(hashtable, vector2) + " ) ";
        Vector<String> vector3 = new Vector<String>();
        boolean bl = false;
        String string5 = "\nSELECT DISTINCT id \"ID\", to_char(id) \"handle\"";
        if (!(hashtable.get(INCLUDE_NAME).equals("-1") && hashtable.get(INCLUDE_ALIAS).equals("-1") && hashtable.get(INCLUDE_INTERFACE_NAME).equals("-1") && hashtable.get(INCLUDE_IP_NAME).equals("-1") && hashtable.get(INCLUDE_IPC_NAME).equals("-1"))) {
            string5 = string5 + ", NAME_ID, NAME, DOMAIN, ALIASEE, INTERFACE, NODE, IPADDRESS, IP_NAME_INTERFACE";
            bl = true;
            vector3.addElement("FS_NodeInfoNames");
        }
        if (!(hashtable.get(INCLUDE_ADDRESS).equals("-1") && hashtable.get(INCLUDE_ACTIVE_ADDRESS).equals("-1") && hashtable.get(INCLUDE_PTR_PREF).equals("-1"))) {
            string5 = string5 + ", IPC_ADDRESS_TXT, IPC_ACTIVE, IP_INTERFACE, IP_ADDRESS_TXT, IP_ACTIVE, PTRPREF";
            vector3.addElement("FS_NodeInfoIPaddresses");
            vector3.addElement("FS_NodeInfoIPC");
        }
        if (!(hashtable.get(INCLUDE_HW_ADDRESS).equals("-1") && hashtable.get(INCLUDE_DHCP_STATE).equals("-1") && hashtable.get(INCLUDE_DHCP_OPTION).equals("-1") && hashtable.get(INCLUDE_ROAMING_STATE).equals("-1"))) {
            string5 = string5 + ", INTERFACE_ID, INTERFACE_HW, INTERFACE_ROAM, INTERFACE_DHCP, DHCP_OPTIONS";
            vector3.addElement("FS_NodeInfoInterfaces");
        }
        if (!hashtable.get(INCLUDE_RECEIVES_MAIL_FOR).equals("-1")) {
            string5 = string5 + ", MX_NAME, MX_DOMAIN, MX_RECEIVED_BY, MX_PREF";
            if (!bl) {
                vector3.addElement("FS_NodeInfoNames");
            }
        }
        string5 = string5 + (hashtable.get(INCLUDE_NODE_TYPE).equals("-1") ? "" : ", type \"Node Type\"") + (hashtable.get(INCLUDE_STATE).equals("-1") ? "" : ", state \"State\"") + (hashtable.get(this.INCLUDE_OWNER).equals("-1") ? "" : ", owner \"Group\"") + (hashtable.get(INCLUDE_DEPARTMENT).equals("-1") ? "" : ", organization \"Department\"") + (hashtable.get(INCLUDE_LOCATION).equals("-1") ? "" : ", location \"Location\"") + (hashtable.get(INCLUDE_SITE).equals("-1") ? "" : ", site \"Site\"") + (hashtable.get(INCLUDE_CODE).equals("-1") ? "" : ", code \"Code\"") + (hashtable.get(INCLUDE_ROOM).equals("-1") ? "" : ", room \"Room\"") + (hashtable.get(INCLUDE_EXPIRATION_DATE).equals("-1") ? "" : ", expiration \"Expires On\"") + (hashtable.get(INCLUDE_MAKE_MODEL).equals("-1") ? "" : ", make_and_model \"Make/Model\"") + (hashtable.get(INCLUDE_OS).equals("-1") ? "" : ", os \"Operating System\"") + (hashtable.get(INCLUDE_ADMINISTRATORS).equals("-1") ? "" : ", node_admin \"Node Administrator\"") + (hashtable.get(INCLUDE_USERS).equals("-1") ? "" : ", node_user \"Node User\"") + (hashtable.get(INCLUDE_CUSTOM_FIELDS).equals("-1") ? "" : ", tag \"Node Tag\"") + (hashtable.get(this.INCLUDE_COMMENT).equals("-1") ? "" : ", comments \"Comment\"") + this.modBlock(hashtable);
        vector3.addElement("FS_NodeInfo");
        for (int i = 0; i < vector3.size(); ++i) {
            string4 = string4 + string5 + " FROM " + vector3.elementAt(i) + " JOIN Records on ID = Records.record_id";
            if (i + 1 >= vector3.size()) continue;
            string4 = string4 + "\nUNION";
        }
        return string4;
    }

    @Override
    protected Vector<Node> process_results(NetDB_Datastore netDB_Datastore, Result_Hash result_Hash) throws Exception {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = -1;
        int n12 = -1;
        int n13 = -1;
        int n14 = -1;
        int n15 = -1;
        int n16 = -1;
        int n17 = -1;
        int n18 = -1;
        int n19 = -1;
        int n20 = -1;
        int n21 = -1;
        int n22 = -1;
        int n23 = -1;
        int n24 = -1;
        int n25 = -1;
        int n26 = -1;
        int n27 = -1;
        int n28 = -1;
        int n29 = -1;
        int n30 = -1;
        int n31 = -1;
        int n32 = -1;
        int n33 = -1;
        int n34 = -1;
        int n35 = -1;
        int n36 = -1;
        int n37 = -1;
        int n38 = -1;
        int n39 = -1;
        int n40 = -1;
        int n41 = -1;
        int n42 = -1;
        int n43 = -1;
        int n44 = -1;
        int n45 = 0;
        for (String object2 : result_Hash.get_vector("column_names")) {
            if (object2.equals(ID_COLUMN)) {
                n = n45;
            } else if (object2.equals(HANDLE_COLUMN)) {
                n2 = n45;
            } else if (object2.equals(NAME_ID_COLUMN)) {
                n3 = n45;
            } else if (object2.equals(NAME_COLUMN)) {
                n4 = n45;
            } else if (object2.equals(DOMAIN_COLUMN)) {
                n5 = n45;
            } else if (object2.equals(ALIASEE_COLUMN)) {
                n6 = n45;
            } else if (object2.equals(INTERFACE_COLUMN)) {
                n7 = n45;
            } else if (object2.equals(NODE_COLUMN)) {
                n8 = n45;
            } else if (object2.equals(IP_ADDRESS_COLUMN)) {
                n9 = n45;
            } else if (object2.equals(IP_NAME_INTERFACE_COLUMN)) {
                n10 = n45;
            } else if (object2.equals(IPC_ADDRESS_TXT_COLUMN)) {
                n11 = n45;
            } else if (object2.equals(IPC_ACTIVE_COLUMN)) {
                n12 = n45;
            } else if (object2.equals(IP_INTERFACE_COLUMN)) {
                n13 = n45;
            } else if (object2.equals(IP_ADDRESS_TXT_COLUMN)) {
                n14 = n45;
            } else if (object2.equals(IP_ACTIVE_COLUMN)) {
                n15 = n45;
            } else if (object2.equals(PTR_PREF_COLUMN)) {
                n16 = n45;
            } else if (object2.equals(INTERFACE_ID_COLUMN)) {
                n17 = n45;
            } else if (object2.equals(INTERFACE_HW_COLUMN)) {
                n18 = n45;
            } else if (object2.equals(INTERFACE_ROAM_COLUMN)) {
                n19 = n45;
            } else if (object2.equals(INTERFACE_DHCP_COLUMN)) {
                n20 = n45;
            } else if (object2.equals(DHCP_OPTIONS_COLUMN)) {
                n21 = n45;
            } else if (object2.equals(MX_NAME_COLUMN)) {
                n22 = n45;
            } else if (object2.equals(MX_DOMAIN_COLUMN)) {
                n23 = n45;
            } else if (object2.equals(MX_RECEIVED_BY_COLUMN)) {
                n24 = n45;
            } else if (object2.equals(MX_PREF_COLUMN)) {
                n25 = n45;
            } else if (object2.equals(NODE_TYPE_COLUMN)) {
                n26 = n45;
            } else if (object2.equals(STATE_COLUMN)) {
                n27 = n45;
            } else if (object2.equals(GROUP_COLUMN)) {
                n28 = n45;
            } else if (object2.equals(DEPARTMENT_COLUMN)) {
                n29 = n45;
            } else if (object2.equals(LOCATION_COLUMN)) {
                n30 = n45;
            } else if (object2.equals(SITE_COLUMN)) {
                n31 = n45;
            } else if (object2.equals(CODE_COLUMN)) {
                n32 = n45;
            } else if (object2.equals(ROOM_COLUMN)) {
                n33 = n45;
            } else if (object2.equals(EXPIRATION_COLUMN)) {
                n34 = n45;
            } else if (object2.equals(MAKE_AND_MODEL_COLUMN)) {
                n35 = n45;
            } else if (object2.equals(OS_COLUMN)) {
                n36 = n45;
            } else if (object2.equals(NODE_ADMIN_COLUMN)) {
                n37 = n45;
            } else if (object2.equals(NODE_USER_COLUMN)) {
                n38 = n45;
            } else if (object2.equals(NODE_TAG_COLUMN)) {
                n39 = n45;
            } else if (object2.equals(COMMENT_COLUMN)) {
                n40 = n45;
            } else if (object2.equals("Modified By")) {
                n41 = n45;
            } else if (object2.equals("Date Modified")) {
                n42 = n45;
            } else if (object2.equals("Created By")) {
                n43 = n45;
            } else if (object2.equals("Date Created")) {
                n44 = n45;
            } else {
                netDB_Datastore.logger().severe("'" + object2 + "' was encountered and not expected.  The data will not be processed.  The '" + this.getClass().getName() + "' class will need to be updated before it will be processed.");
            }
            ++n45;
        }
        Node node = new Node();
        A_Name a_Name = new A_Name();
        Alias alias = new Alias();
        MX mX = new MX();
        IP_Address iP_Address = new IP_Address();
        Interface_IP_Address interface_IP_Address = new Interface_IP_Address();
        Interface interface_ = new Interface();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        FS_Hashtable fS_Hashtable = new FS_Hashtable("id");
        FS_Hashtable fS_Hashtable2 = new FS_Hashtable("id");
        FS_Hashtable fS_Hashtable3 = new FS_Hashtable("full_name");
        FS_Hashtable fS_Hashtable4 = new FS_Hashtable("address");
        FS_Hashtable fS_Hashtable5 = new FS_Hashtable("id");
        long l = 0L;
        long l2 = ((Vector)result_Hash.get("resultSet")).size();
        for (Serializable serializable : (Vector)result_Hash.get("resultSet")) {
            Attribute attribute;
            Comparable<Integer> comparable;
            Object object;
            Object object2;
            Object object3;
            Comparable<BigDecimal> n50;
            Object n49;
            Object object4;
            Object object5;
            Object n55;
            Object n54;
            Node node2 = null;
            BigDecimal bigDecimal = (BigDecimal)((Vector)serializable).get(n);
            int n46 = -1;
            if (bigDecimal != null) {
                n46 = bigDecimal.intValue();
            }
            node2 = (Node)fS_Hashtable.get(n46, node, netDB_Datastore);
            if (n3 != -1 && n4 != -1 && n5 != -1 && n6 != -1 && n7 != -1 && n8 != -1 && n9 != -1 && n10 != -1) {
                n54 = (BigDecimal)((Vector)serializable).get(n3);
                n55 = (String)((Vector)serializable).get(n4);
                object5 = (String)((Vector)serializable).get(n5);
                object4 = (BigDecimal)((Vector)serializable).get(n6);
                n49 = (BigDecimal)((Vector)serializable).get(n7);
                n50 = (BigDecimal)((Vector)serializable).get(n8);
                object3 = (String)((Vector)serializable).get(n9);
                object2 = (String)((Vector)serializable).get(n10);
                int interface_2 = -1;
                if (n54 != null) {
                    interface_2 = ((BigDecimal)n54).intValue();
                }
                Name n51 = null;
                if (object4 != null) {
                    n51 = (Name)fS_Hashtable2.get(interface_2, alias, netDB_Datastore);
                } else if (n49 != null || n50 != null || object3 != null) {
                    n51 = (Name)fS_Hashtable2.get(interface_2, a_Name, netDB_Datastore);
                }
                if (n51 != null && (n51.name == null || n51.name.equals(NetDB.unset_string))) {
                    n51.name((String)n55);
                    n51.domain((String)object5);
                }
                int string = -1;
                if (object4 != null) {
                    string = ((BigDecimal)object4).intValue();
                    object = (A_Name)fS_Hashtable2.get(string, a_Name, netDB_Datastore);
                    ((A_Name)object).add_alias((Alias)n51);
                    ((A_Name)object).flag_field_as_defined(Field.ALIAS);
                } else if (n49 != null) {
                    string = ((BigDecimal)n49).intValue();
                    object = (Interface)fS_Hashtable5.get(string, interface_, netDB_Datastore);
                    ((Interface)object).add_name((A_Name)n51);
                    node2.add_interface((Interface)object);
                    ((Interface)object).flag_field_as_defined(Field.NAME);
                    node2.flag_field_as_defined(Field.INTERFACE);
                } else if (n50 != null) {
                    string = ((BigDecimal)n50).intValue();
                    object = (Node)fS_Hashtable.get(string, node, netDB_Datastore);
                    ((Node)object).add_name((A_Name)n51);
                    ((Node)object).flag_field_as_defined(Field.NAME);
                } else if (object3 != null) {
                    object = null;
                    if ("ipc".equals(object2)) {
                        object = (IP_Address)fS_Hashtable4.get(object3, iP_Address, netDB_Datastore);
                        node2.add_address((IP_Address)object);
                        node2.flag_field_as_defined(Field.ADDRESS);
                    } else {
                        object = (IP_Address)fS_Hashtable4.get(object3, interface_IP_Address, netDB_Datastore);
                        comparable = new Integer((String)object2);
                        attribute = (Interface)fS_Hashtable5.get((Integer)comparable, interface_, netDB_Datastore);
                        ((Interface)attribute).add_address((Interface_IP_Address)object);
                        ((Interface)attribute).flag_field_as_defined(Field.ADDRESS);
                    }
                    ((IP_Address)object).add_name((A_Name)n51);
                    ((IP_Address)object).flag_field_as_defined(Field.NAME);
                }
            }
            if (n11 != -1 && n12 != -1) {
                n54 = (String)((Vector)serializable).get(n11);
                n55 = (String)((Vector)serializable).get(n12);
                if (n54 != null && n55 != null) {
                    object5 = (IP_Address)fS_Hashtable4.get(n54, iP_Address, netDB_Datastore);
                    object4 = true;
                    if (!((String)n55).toLowerCase().equals("yes")) {
                        object4 = false;
                    }
                    ((IP_Address)object5).active((Boolean)object4);
                    node2.add_address((IP_Address)object5);
                }
                node2.flag_field_as_defined(Field.ADDRESS);
            }
            if (n13 != -1 && n14 != -1 && n15 != -1 && n16 != -1) {
                n54 = (BigDecimal)((Vector)serializable).get(n13);
                n55 = (String)((Vector)serializable).get(n14);
                object5 = (String)((Vector)serializable).get(n15);
                object4 = (String)((Vector)serializable).get(n16);
                if (n54 != null && n55 != null && object5 != null && object4 != null) {
                    int n52 = ((BigDecimal)n54).intValue();
                    n50 = (Interface_IP_Address)fS_Hashtable4.get(n55, interface_IP_Address, netDB_Datastore);
                    object3 = (Interface)fS_Hashtable5.get(n52, interface_, netDB_Datastore);
                    object2 = true;
                    if (!((String)object5).toLowerCase().equals("yes")) {
                        object2 = false;
                    }
                    ((IP_Address)n50).active((Boolean)object2);
                    ((Interface_IP_Address)n50).ptr_pref(Interface_IP_Address.PTR_PREF.fetch((String)object4));
                    ((Interface)object3).add_address((Interface_IP_Address)n50);
                    node2.add_interface((Interface)object3);
                }
                node2.flag_field_as_defined(Field.INTERFACE);
            }
            if (n17 != -1 && n18 != -1 && n19 != -1 && n20 != -1 && n21 != -1) {
                n54 = (BigDecimal)((Vector)serializable).get(n17);
                n55 = (String)((Vector)serializable).get(n18);
                object5 = (String)((Vector)serializable).get(n19);
                object4 = (String)((Vector)serializable).get(n20);
                n49 = (String)((Vector)serializable).get(n21);
                if (n54 != null) {
                    int n53 = ((BigDecimal)n54).intValue();
                    object3 = true;
                    if (object5 != null && !((String)object5).toLowerCase().equals("yes")) {
                        object3 = false;
                    }
                    object2 = true;
                    if (object4 != null && !((String)object4).toLowerCase().equals("yes")) {
                        object2 = false;
                    }
                    Interface a_Name2 = (Interface)fS_Hashtable5.get(n53, interface_, netDB_Datastore);
                    a_Name2.hardware_address((String)n55);
                    a_Name2.roaming((Boolean)object3);
                    a_Name2.dhcp((Boolean)object2);
                    if (n49 != null && !((String)n49).trim().equals("")) {
                        int n47 = ((String)n49).indexOf("=");
                        String string = ((String)n49).substring(0, n47);
                        object = null;
                        if (n47 >= 0) {
                            object = ((String)n49).substring(n47 + 1);
                        }
                        comparable = new DHCP_Option(netDB_Datastore, string);
                        attribute = new DHCP_Setting((DHCP_Option)comparable, (String)object);
                        ((NetDB)comparable).flag_as_system_created();
                        a_Name2.add_dhcp_setting((DHCP_Setting)attribute);
                    }
                    node2.add_interface(a_Name2);
                    a_Name2.flag_field_as_defined(Field.HW_ADDRESS);
                    a_Name2.flag_field_as_defined(Field.DHCP_SETTING);
                }
                node2.flag_field_as_defined(Field.INTERFACE);
            }
            if (n22 != -1 && n23 != -1 && n24 != -1 && n25 != -1) {
                n54 = (String)((Vector)serializable).get(n22);
                n55 = (String)((Vector)serializable).get(n23);
                object5 = (BigDecimal)((Vector)serializable).get(n24);
                object4 = (BigDecimal)((Vector)serializable).get(n25);
                if (n54 != null && n55 != null && object5 != null && object4 != null) {
                    int custom_Field = ((BigDecimal)object5).intValue();
                    int n48 = ((BigDecimal)object4).intValue();
                    object3 = Name.generate_full_name((String)n54, (String)n55);
                    object2 = (MX)fS_Hashtable3.get(object3, mX, netDB_Datastore);
                    A_Name a_Name3 = (A_Name)fS_Hashtable2.get(custom_Field, a_Name, netDB_Datastore);
                    ((MX)object2).pref(n48);
                    a_Name3.add_mx((MX)object2);
                    node2.add_name(a_Name3);
                    ((MX)object2).flag_field_as_defined(Field.PREF);
                }
                node2.flag_field_as_defined(Field.NAME);
            }
            if (n26 != -1) {
                n54 = (String)((Vector)serializable).get(n26);
                if (n54 != null && ((String)(n54 = ((String)n54).trim())).length() > 0) {
                    n55 = new Node_Type(netDB_Datastore);
                    ((NetDB)n55).flag_as_system_created();
                    ((Node_Type)n55).name((String)n54);
                    node2.add_type((Node_Type)n55);
                }
                node2.flag_field_as_defined(Field.NODE_TYPE);
            }
            if (n27 != -1) {
                n54 = (String)((Vector)serializable).get(n27);
                if (n54 != null && ((String)(n54 = ((String)n54).trim())).length() > 0) {
                    n55 = new State(netDB_Datastore);
                    ((NetDB)n55).flag_as_system_created();
                    ((State)n55).name((String)n54);
                    node2.state((State)n55);
                }
                node2.flag_field_as_defined(Field.STATE);
            }
            if (n28 != -1) {
                n54 = (String)((Vector)serializable).get(n28);
                if (n54 != null && ((String)(n54 = ((String)n54).trim())).length() > 0) {
                    n55 = new Group(netDB_Datastore);
                    ((NetDB)n55).flag_as_system_created();
                    ((Group)n55).name((String)n54);
                    node2.add_owner((Group)n55);
                }
                node2.flag_field_as_defined(Field.OWNER);
            }
            if (n29 != -1) {
                n54 = (String)((Vector)serializable).get(n29);
                if (n54 != null && ((String)(n54 = ((String)n54).trim())).length() > 0) {
                    n55 = new Department(netDB_Datastore);
                    ((NetDB)n55).flag_as_system_created();
                    ((Department)n55).name((String)n54);
                    node2.department((Department)n55);
                }
                node2.flag_field_as_defined(Field.DEPARTMENT);
            }
            if (n30 != -1 || n31 != -1 || n32 != -1) {
                int string = 0;
                n55 = new Location(netDB_Datastore);
                ((NetDB)n55).flag_as_system_created();
                if (n30 != -1) {
                    object5 = (String)((Vector)serializable).get(n30);
                    if (object5 != null && ((String)(object5 = ((String)object5).trim())).length() > 0) {
                        ++string;
                        ((Location)n55).name((String)object5);
                    }
                    ((Location)n55).flag_field_as_defined(Field.NAME);
                }
                if (n31 != -1) {
                    object5 = (String)((Vector)serializable).get(n31);
                    if (object5 != null && ((String)(object5 = ((String)object5).trim())).length() > 0) {
                        ++string;
                        ((Location)n55).site((String)object5);
                    }
                    ((Location)n55).flag_field_as_defined(Field.SITE);
                }
                if (n32 != -1) {
                    object5 = (String)((Vector)serializable).get(n32);
                    if (object5 != null && ((String)(object5 = ((String)object5).trim())).length() > 0) {
                        ++string;
                        ((Location)n55).code((String)object5);
                    }
                    ((Location)n55).flag_field_as_defined(Field.CODE);
                }
                if (string > 0) {
                    node2.location((Location)n55);
                }
                node2.flag_field_as_defined(Field.LOCATION);
            }
            if (n33 != -1) {
                String tZ_Timestamp = (String)((Vector)serializable).get(n33);
                if (tZ_Timestamp != null && (tZ_Timestamp = tZ_Timestamp.trim()).length() > 0) {
                    node2.room(tZ_Timestamp);
                }
                node2.flag_field_as_defined(Field.ROOM);
            }
            if (n34 != -1) {
                TZ_Timestamp string = (TZ_Timestamp)((Vector)serializable).get(n34);
                if (string != null) {
                    node2.expiration_date(string);
                }
                node2.flag_field_as_defined(Field.EXPIRATION);
            }
            if (n35 != -1) {
                String string = (String)((Vector)serializable).get(n35);
                if (string != null) {
                    n55 = (Model)hashtable.get(string);
                    if (n55 == null) {
                        n55 = new Model(netDB_Datastore);
                        ((NetDB)n55).flag_as_system_created();
                        object5 = ((Model)n55).extract_make_and_model(string);
                        if (((Boolean)object5).booleanValue()) {
                            hashtable.put(string, n55);
                        } else {
                            n55 = null;
                        }
                    }
                    if (n55 != null) {
                        object5 = new Model(netDB_Datastore);
                        ((NetDB)object5).flag_as_system_created();
                        ((Model)object5).name(((Model)n55).name());
                        object4 = new Make(netDB_Datastore);
                        ((NetDB)object4).flag_as_system_created();
                        ((Make)object4).name(((Model)n55).make().name());
                        ((Model)object5).make((Make)object4);
                        node2.model((Model)object5);
                    }
                }
                node2.flag_field_as_defined(Field.MODEL);
            }
            if (n36 != -1) {
                String string = (String)((Vector)serializable).get(n36);
                if (string != null && (string = string.trim()).length() > 0) {
                    n55 = new OS(netDB_Datastore);
                    ((NetDB)n55).flag_as_system_created();
                    ((OS)n55).name(string);
                    node2.add_os((OS)n55);
                }
                node2.flag_field_as_defined(Field.OS);
            }
            if (n37 != -1) {
                String string = (String)((Vector)serializable).get(n37);
                if (string != null) {
                    if (string.endsWith(";")) {
                        n55 = new Admin_Team(netDB_Datastore);
                        ((NetDB)n55).flag_as_system_created();
                        ((Admin_Team)n55).name(string.substring(0, string.length() - 1));
                        node2.add_admin((Admin_Team)n55);
                    } else {
                        n55 = new Person(netDB_Datastore, string);
                        node2.add_admin((Person)n55);
                    }
                }
                node2.flag_field_as_defined(Field.ADMIN);
            }
            if (n38 != -1) {
                String string = (String)((Vector)serializable).get(n38);
                if (string != null && string.trim().length() > 0) {
                    n55 = new Person(netDB_Datastore, string);
                    node2.add_user((Person)n55);
                }
                node2.flag_field_as_defined(Field.USER);
            }
            if (n39 != -1) {
                String string = (String)((Vector)serializable).get(n39);
                if (string != null && string.trim().length() > 0) {
                    int n51 = string.indexOf("=");
                    object5 = string.substring(0, n51);
                    object4 = null;
                    if (n51 >= 0) {
                        object4 = string.substring(n51 + 1);
                    }
                    Custom_Field custom_Field = new Custom_Field((String)object5, (String)object4);
                    node2.add_custom_field(custom_Field);
                }
                node2.flag_field_as_defined(Field.CUSTOM_TAG);
            }
            if (n40 != -1) {
                String string = (String)((Vector)serializable).get(n40);
                if (string != null && (string = string.trim()).length() > 0) {
                    node2.comment(string);
                }
                node2.flag_field_as_defined(Field.COMMENT);
            }
            super.process_common_results(node2, (Vector)serializable, n42, n41, n44, n43);
        }
        if (n22 != -1 && n23 != -1 && n24 != -1 && n25 != -1) {
            for (Serializable serializable : fS_Hashtable2.values()) {
                if (!(serializable instanceof A_Name)) continue;
                ((Name)serializable).flag_field_as_defined(Field.MX);
            }
        }
        if (n13 != -1 && n14 != -1 && n15 != -1 && n16 != -1) {
            for (Serializable serializable : fS_Hashtable5.values()) {
                ((Interface)serializable).flag_field_as_defined(Field.ADDRESS);
            }
        }
        return new Vector<Node>(fS_Hashtable.values());
    }

    @Override
    protected String child_params() {
        String string = "";
        return string;
    }

    public Hashtable<String, String> legacy_search_params() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("fs.table", "FS_NodeInfo");
        for (String object : this.include_fields.keySet()) {
            String string = "-1";
            if (((Boolean)this.include_fields.get(object)).booleanValue()) {
                string = "1";
            }
            hashtable.put(object, string);
        }
        for (NAME_TYPES nAME_TYPES : this.name_types.keySet()) {
            if (!this.name_types.get((Object)nAME_TYPES).booleanValue()) continue;
            hashtable.put(nAME_TYPES.fs_field(), nAME_TYPES.sql_condition());
        }
        for (String string : this.include_node_types.keySet()) {
            hashtable.put("fs.FS_NodeType.cb.i.only_" + string, "lower(type) = '" + string.toLowerCase() + "'");
        }
        for (String string : this.exclude_node_types.keySet()) {
            hashtable.put("fs.FS_NodeType.cb.i.not_" + string, "lower(type) != '" + string.toLowerCase() + "'");
        }
        hashtable.put("fs.FS_NameNode.txt.fullname_lc", this.name);
        hashtable.put("fs.FS_NodeMX.txt.fullname_lc", this.receives_mail_for);
        hashtable.put("fs.FS_Node.txt.lower(state)", this.state.toLowerCase());
        hashtable.put("fs.FS_NodeIPaddress.ip.IPaddress", this.ip_address);
        hashtable.put("fs.FS_NodeIPaddress.hw.lower(HW_address)", this.hardware_address.toLowerCase());
        hashtable.put("txt.DHCPoptions", this.dhcp_setting);
        hashtable.put("fs.FS_Node.txt.lower(department)", this.department.toLowerCase());
        hashtable.put("fs.FS_Node.txt.lower(location)", this.location.toLowerCase());
        hashtable.put("fs.FS_Node.txt.lower(site)", this.site.toLowerCase());
        hashtable.put("fs.FS_Node.txt.lower(code)", this.code.toLowerCase());
        hashtable.put("fs.FS_Node.txt.lower(room)", this.room.toLowerCase());
        hashtable.put("fs.FS_Node.tst.expiration >= ", this.expires_after_date);
        hashtable.put("fs.FS_Node.tst.expiration <= ", this.expires_before_date);
        hashtable.put("fs.FS_Node.txt.lower(make)", this.make.toLowerCase());
        hashtable.put("fs.FS_Node.txt.lower(model)", this.model.toLowerCase());
        hashtable.put("fs.FS_Node.txt.lower(os)", this.os.toLowerCase());
        hashtable.put("fs.FS_Node_Admin.txt.groupA.lower(admin_netid)", this.admin_netid.toLowerCase());
        hashtable.put("fs.FS_Node_Admin.txt.groupA.lower(admin_name)", this.admin_name.toLowerCase());
        hashtable.put("fs.FS_Node_Admin.txt.groupA.lower(ateam)", this.admin_team.toLowerCase());
        hashtable.put("fs.FS_Node_User.txt.groupU.lower(user_netid)", this.user_netid.toLowerCase());
        hashtable.put("fs.FS_Node_User.txt.groupU.lower(user_name)", this.user_name.toLowerCase());
        hashtable.put("txt.customFields", this.custom_field);
        hashtable.put("fs.FS_NodeIPaddress.rb.b.PTRpref", this.ptr_pref.sql_string());
        hashtable.put("fs.FS_NodeIPaddress.rb.b.active", this.ip_active.sql_string());
        hashtable.put("fs.FS_NodeIPaddress.rb.b.dhcp", this.dhcp.sql_string());
        hashtable.put("fs.FS_NodeIPaddress.rb.b.roam", this.roaming.sql_string());
        super.legacy_search_params(hashtable);
        hashtable.put("fs.FS_Node.txt.groupZ.lower(owner)", this.owner.toLowerCase());
        hashtable.put("fs.FS_Node.txt.lower(comments)", this.comment.toLowerCase());
        if (this.mx_include_name.booleanValue()) {
            hashtable.put(INCLUDE_NAME, "1");
        }
        if (this.records_in_my_groups.booleanValue()) {
            hashtable.put("cb.i.f.InMyGroups", "groupZ.( select FS_Node_Owner.node id from FS_Users_Owner join FS_Node_Owner on FS_Node_Owner.owner = FS_Users_Owner.owner where FS_Users_Owner.userid = " + this.OP_UID + " )");
        } else {
            hashtable.put("cb.i.f.InMyGroups", "");
        }
        return hashtable;
    }

    public static enum NAME_TYPES {
        NODE("cb.i.Name:Node", "node is not null"),
        ALIAS("cb.i.Name:Alias", "aliasee is not null"),
        INTERFACE("cb.i.Name:Interface", "interface is not null"),
        IP_ADDRESS("cb.i.Name:IP", "iptype = 'ip'"),
        IPC("cb.i.Name:IPC", "iptype = 'ipc'");

        String fs_field = "";
        String sql_condition = "";

        private NAME_TYPES(String string2, String string3) {
            this.fs_field = string2;
            this.sql_condition = string3;
        }

        protected String fs_field() {
            return this.fs_field;
        }

        protected String sql_condition() {
            return this.sql_condition;
        }
    }
}

