/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.io.Serializable;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import stanford.netdb.A_Name;
import stanford.netdb.Address_Space;
import stanford.netdb.Admin_Team;
import stanford.netdb.Attribute;
import stanford.netdb.Comparison_Result;
import stanford.netdb.Custom_Field;
import stanford.netdb.DHCP_Service;
import stanford.netdb.Defaults;
import stanford.netdb.Department;
import stanford.netdb.Field;
import stanford.netdb.Group;
import stanford.netdb.IP.Prefix;
import stanford.netdb.IP_Address;
import stanford.netdb.Interface;
import stanford.netdb.Interface_IP_Address;
import stanford.netdb.Location;
import stanford.netdb.Lockable;
import stanford.netdb.MX;
import stanford.netdb.Model;
import stanford.netdb.Multi_Value_Attribute;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Node_FS_Parameters;
import stanford.netdb.Node_SS_Result;
import stanford.netdb.Node_Type;
import stanford.netdb.OS;
import stanford.netdb.Person;
import stanford.netdb.Privilege;
import stanford.netdb.Record;
import stanford.netdb.Record_Type;
import stanford.netdb.Simple_Search_Result;
import stanford.netdb.State;
import stanford.netdb.User;
import stanford.netdb.exceptions.Exception_Formatter;
import stanford.netdb.exceptions.Idiot_Programmer;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.exceptions.Record_Not_Found;
import stanford.netdb.ssparser.SSparser;
import stanford.netdb.util.Date_Formatter;
import stanford.netdb.util.Property;

public class Node
extends Lockable<Node> {
    public static String template_name = "templates/toString/node.tmpl";
    private static final long serialVersionUID = 1L;
    private Integer id = null;
    private Department department = null;
    private Location location = null;
    private String room = null;
    private State state = null;
    private Model model = null;
    private String comment = null;
    private Timestamp expiration = null;
    private DHCP_Service dhcp_service = null;
    private Address_Space address_space = null;
    private Multi_Value_Attribute<A_Name> names = null;
    private Multi_Value_Attribute<Interface> interfaces = null;
    private Multi_Value_Attribute<IP_Address> ipc_addresses = null;
    private Multi_Value_Attribute<Node_Type> node_types = null;
    private Multi_Value_Attribute<Record> admins = null;
    private Multi_Value_Attribute<OS> oses = null;
    private Multi_Value_Attribute<DHCP_Service> services = null;
    private Multi_Value_Attribute<Person> users = null;
    private Multi_Value_Attribute<Custom_Field> custom_tags = null;
    private Boolean can_modify = null;
    private Vector<Node> mail_exchangers = null;

    public Node() {
        this.init();
    }

    public Node(Department department, Location location, String string, State state, Model model) {
        this.init(department, location, string, state, model);
    }

    public Node(Department department, Location location, String string, State state, Model model, String string2, Timestamp timestamp) {
        this.init(department, location, string, state, model, string2, timestamp);
    }

    public Node(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
        this.init();
    }

    public Node(NetDB_Datastore netDB_Datastore, Department department, Location location, String string, State state, Model model) {
        super(netDB_Datastore);
        this.init(department, location, string, state, model);
    }

    public Node(NetDB_Datastore netDB_Datastore, Department department, Location location, String string, State state, Model model, String string2, Timestamp timestamp) {
        super(netDB_Datastore);
        this.init(department, location, string, state, model, string2, timestamp);
    }

    private void init() {
        this.init(null, null, null, null, null, null, null);
    }

    private void init(Department department, Location location, String string, State state, Model model) {
        this.init(department, location, string, state, model, null, null);
    }

    private void init(Department department, Location location, String string, State state, Model model, String string2, Timestamp timestamp) {
        if (department != null) {
            this.department(department);
        }
        if (location != null) {
            this.location(location);
        }
        if (string != null) {
            this.room(string);
        }
        if (state != null) {
            this.state(state);
        }
        if (model != null) {
            this.model(model);
        }
        if (string2 != null) {
            this.comment(string2);
        }
        if (timestamp != null) {
            this.expiration_date(timestamp);
        }
    }

    public Integer id() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.verify_or_die();
        return this.id;
    }

    public Department department() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.department, NetDB.unset_department, "department");
        return this.department;
    }

    public Location location() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.location, NetDB.unset_location, "location");
        return this.location;
    }

    public String room() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.room, NetDB.unset_string, "room");
        return this.room;
    }

    public State state() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.state, NetDB.unset_state, "state");
        return this.state;
    }

    public Model model() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.model, NetDB.unset_model, "model");
        return this.model;
    }

    public String comment() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.comment, NetDB.unset_string, "comment");
        return this.comment;
    }

    public Timestamp expiration_date() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.expiration, NetDB.unset_timestamp, "expiration");
        return this.expiration;
    }

    public Address_Space address_space() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.address_space, NetDB.unset_address_space, "address_space");
        return this.address_space;
    }

    public Collection<A_Name> names() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.names, NetDB.unset_mva_a_name, "names");
        if (this.names == null || this.names == NetDB.unset_mva_a_name) {
            return new Multi_Value_Attribute().all_values();
        }
        return this.names.all_values();
    }

    public Collection<Interface> interfaces() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.interfaces, NetDB.unset_mva_interface, "interfaces");
        if (this.interfaces == null || this.interfaces == NetDB.unset_mva_interface) {
            return new Multi_Value_Attribute().all_values();
        }
        return this.interfaces.all_values();
    }

    public Collection<IP_Address> addresses() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.ipc_addresses, NetDB.unset_mva_ip, "ipc_addresses");
        if (this.ipc_addresses == null || this.ipc_addresses == NetDB.unset_mva_ip) {
            return new Multi_Value_Attribute().all_values();
        }
        return this.ipc_addresses.all_values();
    }

    public Collection<Node_Type> types() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.node_types, NetDB.unset_mva_node_type, "node_types");
        if (this.node_types == null || this.node_types == NetDB.unset_mva_node_type) {
            return new Multi_Value_Attribute().all_values();
        }
        return this.node_types.all_values();
    }

    public Collection<Record> admins() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.admins, NetDB.unset_mva_record, "admins");
        if (this.admins == null || this.admins == NetDB.unset_mva_record) {
            return new Multi_Value_Attribute().all_values();
        }
        return this.admins.all_values();
    }

    public Collection<OS> OSes() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this.oses();
    }

    public Collection<OS> oses() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.oses, NetDB.unset_mva_os, "oses");
        if (this.oses == null || this.oses == NetDB.unset_mva_os) {
            return new Multi_Value_Attribute().all_values();
        }
        return this.oses.all_values();
    }

    private Collection<DHCP_Service> services() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.services, NetDB.unset_mva_dhcp_service, "services");
        if (this.services == null || this.services == NetDB.unset_mva_dhcp_service) {
            return new Multi_Value_Attribute().all_values();
        }
        return this.services.all_values();
    }

    public Collection<Person> users() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.users, NetDB.unset_mva_person, "users");
        if (this.users == null || this.users == NetDB.unset_mva_person) {
            return new Multi_Value_Attribute().all_values();
        }
        return this.users.all_values();
    }

    public Collection<Custom_Field> custom_fields() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.custom_tags, NetDB.unset_mva_custom_field, "custom_tags");
        if (this.custom_tags == null || this.custom_tags == NetDB.unset_mva_custom_field) {
            return new Multi_Value_Attribute().all_values();
        }
        return this.custom_tags.all_values();
    }

    public Boolean can_modify() {
        return this.can_modify;
    }

    @Override
    public String handle() {
        if (this.names == null) {
            return null;
        }
        Collection<A_Name> collection = this.names.all_values();
        Iterator<A_Name> iterator = collection.iterator();
        try {
            return iterator.next().handle();
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public Collection<Node> mail_exchangers() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.mail_exchangers, NetDB.unset_node_vector, "mail_exchangers");
        return this.mail_exchangers;
    }

    @Override
    protected Node id(Integer n) {
        this.id = n;
        return this;
    }

    public Node department(Department department) {
        this.department = department;
        return this;
    }

    public Node location(Location location) {
        this.location = location;
        return this;
    }

    public Node room(String string) {
        this.room = string;
        return this;
    }

    public Node state(State state) {
        this.state = state;
        return this;
    }

    public Node model(Model model) {
        this.model = model;
        return this;
    }

    public Node comment(String string) {
        this.comment = string;
        return this;
    }

    public Node expiration_date(String string) throws ParseException {
        Timestamp timestamp = null;
        if (string != null && !string.equals("")) {
            timestamp = Date_Formatter.to_timestamp(string);
        }
        return this.expiration_date(timestamp);
    }

    public Node expiration_date(Timestamp timestamp) {
        this.expiration = timestamp;
        return this;
    }

    public Node address_space(Address_Space address_Space) {
        this.address_space = address_Space;
        return this;
    }

    public Node add_name(A_Name a_Name) {
        if (this.names == null || this.names == NetDB.unset_mva_a_name) {
            this.names = new Multi_Value_Attribute();
        }
        a_Name.flag_as_user_created();
        this.names.add(a_Name);
        return this;
    }

    public Node add_names(Collection<A_Name> collection) {
        Iterator<A_Name> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add_name(iterator.next());
        }
        return this;
    }

    public Node remove_name(A_Name a_Name) {
        if (this.names != null) {
            this.names.remove(a_Name, (Boolean)true);
        }
        return this;
    }

    public Node remove_names(Collection<A_Name> collection) {
        Iterator<A_Name> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.remove_name(iterator.next());
        }
        return this;
    }

    public Node add_interface(Interface interface_) {
        if (this.interfaces == null || this.interfaces == NetDB.unset_mva_interface) {
            this.interfaces = new Multi_Value_Attribute();
        }
        this.interfaces.add(interface_);
        return this;
    }

    public Node add_interfaces(Collection<Interface> collection) {
        Iterator<Interface> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add_interface(iterator.next());
        }
        return this;
    }

    public Node remove_interface(String string) throws Exception {
        block5: {
            Hashtable<String, String> hashtable;
            block4: {
                if (this.interfaces == null) {
                    return this;
                }
                hashtable = SSparser.parse(string);
                if (hashtable.get("hw") == null) break block4;
                for (Interface interface_ : this.interfaces.all_values()) {
                    if (!hashtable.get("hw").equals(interface_.hardware_address())) continue;
                    this.remove_interface(interface_);
                }
                break block5;
            }
            if (hashtable.get("ip_low") == null) break block5;
            for (Interface interface_ : this.interfaces.all_values()) {
                for (Interface_IP_Address interface_IP_Address : interface_.addresses()) {
                    if (!hashtable.get("ip_low").equals(interface_IP_Address.address().toString())) continue;
                    this.remove_interface(interface_);
                }
            }
        }
        return this;
    }

    public Node remove_interface(Interface interface_) {
        if (this.interfaces != null) {
            this.interfaces.remove(interface_);
        }
        return this;
    }

    public Node remove_interfaces(Collection<Interface> collection) {
        Iterator<Interface> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.remove_interface(iterator.next());
        }
        return this;
    }

    public Node add_address(IP_Address iP_Address) {
        if (this.ipc_addresses == null || this.ipc_addresses == NetDB.unset_mva_ip) {
            this.ipc_addresses = new Multi_Value_Attribute();
        }
        this.ipc_addresses.add(iP_Address);
        return this;
    }

    public Node add_addresses(Collection<IP_Address> collection) {
        Iterator<IP_Address> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add_address(iterator.next());
        }
        return this;
    }

    public Node remove_address(IP_Address iP_Address) {
        if (this.ipc_addresses != null) {
            this.ipc_addresses.remove(iP_Address, (Boolean)true);
        }
        return this;
    }

    public Node remove_addresses(Collection<IP_Address> collection) {
        Iterator<IP_Address> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.remove_address(iterator.next());
        }
        return this;
    }

    public Node add_type(Node_Type node_Type) throws Exception {
        if (this.node_types == null || this.node_types == NetDB.unset_mva_node_type) {
            this.node_types = new Multi_Value_Attribute();
        }
        this.node_types.add(node_Type);
        return this;
    }

    public Node add_types(Collection<Node_Type> collection) throws Exception {
        Iterator<Node_Type> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add_type(iterator.next());
        }
        return this;
    }

    public Node remove_type(Node_Type node_Type) {
        if (this.node_types != null) {
            this.node_types.remove(node_Type, (Boolean)true);
        }
        return this;
    }

    public Node remove_types(Collection<Node_Type> collection) {
        Iterator<Node_Type> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.remove_type(iterator.next());
        }
        return this;
    }

    public Node add_admin(Person person) {
        return this.add_admin_record(person);
    }

    public Node add_admin(Admin_Team admin_Team) {
        return this.add_admin_record(admin_Team);
    }

    private Node add_admin_record(Record record) {
        if (this.admins == null || this.admins == NetDB.unset_mva_record) {
            this.admins = new Multi_Value_Attribute();
        }
        this.admins.add(record);
        return this;
    }

    public Node add_admins(Collection<Record> collection) {
        for (Record record : collection) {
            if (record instanceof Person) {
                this.add_admin((Person)record);
                continue;
            }
            if (!(record instanceof Admin_Team)) continue;
            this.add_admin((Admin_Team)record);
        }
        return this;
    }

    public Node remove_admin(Person person) {
        return this.remove_admin_record(person, false);
    }

    public Node remove_admin(Admin_Team admin_Team) {
        return this.remove_admin_record(admin_Team, true);
    }

    private Node remove_admin_record(Record record, Boolean bl) {
        if (this.admins != null) {
            this.admins.remove(record, bl);
        }
        return this;
    }

    public Node remove_admins(Collection<Record> collection) {
        for (Record record : collection) {
            if (record instanceof Person) {
                this.remove_admin((Person)record);
                continue;
            }
            if (!(record instanceof Admin_Team)) continue;
            this.remove_admin((Admin_Team)record);
        }
        return this;
    }

    public Node add_OS(OS oS) {
        return this.add_os(oS);
    }

    public Node add_os(OS oS) {
        if (this.oses == null || this.oses == NetDB.unset_mva_os) {
            this.oses = new Multi_Value_Attribute();
        }
        this.oses.add(oS);
        return this;
    }

    public Node add_OSes(Collection<OS> collection) {
        return this.add_oses(collection);
    }

    public Node add_oses(Collection<OS> collection) {
        Iterator<OS> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add_os(iterator.next());
        }
        return this;
    }

    public Node remove_OS(OS oS) {
        return this.remove_os(oS);
    }

    public Node remove_os(OS oS) {
        if (this.oses != null) {
            this.oses.remove(oS, (Boolean)true);
        }
        return this;
    }

    public Node remove_OSes(Collection<OS> collection) {
        return this.remove_oses(collection);
    }

    public Node remove_oses(Collection<OS> collection) {
        Iterator<OS> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.remove_os(iterator.next());
        }
        return this;
    }

    private Node add_service(DHCP_Service dHCP_Service) {
        if (this.services == null || this.services == NetDB.unset_mva_dhcp_service) {
            this.services = new Multi_Value_Attribute();
        }
        this.services.add(dHCP_Service);
        return this;
    }

    private Node add_services(Collection<DHCP_Service> collection) {
        Iterator<DHCP_Service> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add_service(iterator.next());
        }
        return this;
    }

    private Node remove_service(DHCP_Service dHCP_Service) {
        if (this.services != null) {
            this.services.remove(dHCP_Service, (Boolean)true);
        }
        return this;
    }

    private Node remove_services(Collection<DHCP_Service> collection) {
        Iterator<DHCP_Service> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.remove_service(iterator.next());
        }
        return this;
    }

    public Node add_user(Person person) {
        if (this.users == null || this.users == NetDB.unset_mva_person) {
            this.users = new Multi_Value_Attribute();
        }
        this.users.add(person);
        return this;
    }

    public Node add_users(Collection<Person> collection) {
        Iterator<Person> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add_user(iterator.next());
        }
        return this;
    }

    public Node remove_user(Person person) {
        if (this.users != null) {
            this.users.remove(person);
        }
        return this;
    }

    public Node remove_users(Collection<Person> collection) {
        Iterator<Person> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.remove_user(iterator.next());
        }
        return this;
    }

    public Node add_custom_field(Custom_Field custom_Field) {
        if (this.custom_tags == null || this.custom_tags == NetDB.unset_mva_custom_field) {
            this.custom_tags = new Multi_Value_Attribute();
        }
        this.custom_tags.add(custom_Field);
        return this;
    }

    public Node add_custom_fields(Collection<Custom_Field> collection) {
        Iterator<Custom_Field> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add_custom_field(iterator.next());
        }
        return this;
    }

    public Node remove_custom_field(Custom_Field custom_Field) {
        if (this.custom_tags != null) {
            this.custom_tags.remove(custom_Field);
        }
        return this;
    }

    public Node remove_custom_fields(Collection<Custom_Field> collection) {
        Iterator<Custom_Field> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.remove_custom_field(iterator.next());
        }
        return this;
    }

    @Override
    public Node bind(NetDB_Datastore netDB_Datastore) throws No_Datastore_Defined {
        super.bind(netDB_Datastore);
        this.bind_children(this.names, netDB_Datastore);
        this.bind_children(this.interfaces, netDB_Datastore);
        this.bind_children(this.ipc_addresses, netDB_Datastore);
        this.bind_children(this.node_types, netDB_Datastore);
        this.bind_children(this.admins, netDB_Datastore);
        this.bind_children(this.oses, netDB_Datastore);
        this.bind_children(this.users, netDB_Datastore);
        this.bind_children(this.custom_tags, netDB_Datastore);
        return this;
    }

    @Override
    public Node unbind() {
        super.unbind();
        this.unbind_children(this.names);
        this.unbind_children(this.interfaces);
        this.unbind_children(this.ipc_addresses);
        this.unbind_children(this.node_types);
        this.unbind_children(this.admins);
        this.unbind_children(this.oses);
        this.unbind_children(this.users);
        this.unbind_children(this.custom_tags);
        return this;
    }

    @Override
    public Node unlink() {
        super.unlink();
        this.unlink_children(this.names);
        this.unlink_children(this.interfaces);
        this.unlink_children(this.ipc_addresses);
        this.unlink_children(this.node_types);
        this.unlink_children(this.admins);
        this.unlink_children(this.oses);
        this.unlink_children(this.users);
        this.unlink_children(this.custom_tags);
        this.id = null;
        return this;
    }

    @Override
    public String single_value_attributes() {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (this.department != null) {
            string = this.department.single_value_attributes();
        }
        if (this.location != null) {
            string2 = this.location.single_value_attributes();
        }
        if (this.state != null) {
            string3 = this.state.single_value_attributes();
        }
        if (this.model != null) {
            string4 = this.model.single_value_attributes();
        }
        if (this.address_space != null) {
            string5 = this.address_space.single_value_attributes();
        }
        return string + " " + string2 + " " + this.room + " " + string3 + " " + string4 + " " + this.comment + " " + this.expiration + " " + string5;
    }

    @Override
    protected void initialize_member_data() {
        super.initialize_member_data();
        if (this.department == null) {
            this.department = NetDB.unset_department;
        }
        if (this.location == null) {
            this.location = NetDB.unset_location;
        }
        if (this.room == null) {
            this.room = NetDB.unset_string;
        }
        if (this.state == null) {
            this.state = NetDB.unset_state;
        }
        if (this.model == null) {
            this.model = NetDB.unset_model;
        }
        if (this.comment == null) {
            this.comment = NetDB.unset_string;
        }
        if (this.expiration == null) {
            this.expiration = NetDB.unset_timestamp;
        }
        if (this.address_space == null) {
            this.address_space = NetDB.unset_address_space;
        }
        if (this.names == null) {
            this.names = NetDB.unset_mva_a_name;
        }
        if (this.interfaces == null) {
            this.interfaces = NetDB.unset_mva_interface;
        }
        if (this.ipc_addresses == null) {
            this.ipc_addresses = NetDB.unset_mva_ip;
        }
        if (this.node_types == null) {
            this.node_types = NetDB.unset_mva_node_type;
        }
        if (this.admins == null) {
            this.admins = NetDB.unset_mva_record;
        }
        if (this.oses == null) {
            this.oses = NetDB.unset_mva_os;
        }
        if (this.users == null) {
            this.users = NetDB.unset_mva_person;
        }
        if (this.custom_tags == null) {
            this.custom_tags = NetDB.unset_mva_custom_field;
        }
        if (this.mail_exchangers == null) {
            this.mail_exchangers = NetDB.unset_node_vector;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        super.flag_field_as_defined(field);
        if (field == Field.DEPARTMENT) {
            if (this.department == NetDB.unset_department) {
                this.department = null;
            }
        } else if (field == Field.LOCATION) {
            if (this.location == NetDB.unset_location) {
                this.location = null;
            }
        } else if (field == Field.ROOM) {
            if (NetDB.unset_string.equals(this.room)) {
                this.room = null;
            }
        } else if (field == Field.STATE) {
            if (this.state == NetDB.unset_state) {
                this.state = null;
            }
        } else if (field == Field.MODEL) {
            if (this.model == NetDB.unset_model) {
                this.model = null;
            }
        } else if (field == Field.COMMENT) {
            if (NetDB.unset_string.equals(this.comment)) {
                this.comment = null;
            }
        } else if (field == Field.EXPIRATION) {
            if (this.expiration == NetDB.unset_timestamp) {
                this.expiration = null;
            }
        } else if (field == Field.DHCP_SERVICE) {
            if (this.dhcp_service == NetDB.unset_dhcp_service) {
                this.dhcp_service = null;
            }
        } else if (field == Field.ADDRESS_SPACE) {
            if (this.address_space == NetDB.unset_address_space) {
                this.address_space = null;
            }
        } else if (field == Field.NAME) {
            if (this.names == NetDB.unset_mva_a_name) {
                this.names = null;
            }
        } else if (field == Field.INTERFACE) {
            if (this.interfaces == NetDB.unset_mva_interface) {
                this.interfaces = null;
            }
        } else if (field == Field.IPC_ADDRESS) {
            if (this.ipc_addresses == NetDB.unset_mva_ip) {
                this.ipc_addresses = null;
            }
        } else if (field == Field.NODE_TYPE) {
            if (this.node_types == NetDB.unset_mva_node_type) {
                this.node_types = null;
            }
        } else if (field == Field.ADMIN) {
            if (this.admins == NetDB.unset_mva_record) {
                this.admins = null;
            }
        } else if (field == Field.OS) {
            if (this.oses == NetDB.unset_mva_os) {
                this.oses = null;
            }
        } else if (field == Field.SERVICE) {
            if (this.services == NetDB.unset_mva_dhcp_service) {
                this.services = null;
            }
        } else if (field == Field.USER) {
            if (this.users == NetDB.unset_mva_person) {
                this.users = null;
            }
        } else if (field == Field.CUSTOM_TAG) {
            if (this.custom_tags == NetDB.unset_mva_custom_field) {
                this.custom_tags = null;
            }
        } else if (field == Field.MX && this.mail_exchangers == NetDB.unset_node_vector) {
            this.mail_exchangers = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        super.clear_default_member_data();
        if (this.department == NetDB.unset_department) {
            this.department = null;
        }
        if (this.location == NetDB.unset_location) {
            this.location = null;
        }
        if (NetDB.unset_string.equals(this.room)) {
            this.room = null;
        }
        if (this.state == NetDB.unset_state) {
            this.state = null;
        }
        if (this.model == NetDB.unset_model) {
            this.model = null;
        }
        if (NetDB.unset_string.equals(this.comment)) {
            this.comment = null;
        }
        if (this.expiration == NetDB.unset_timestamp) {
            this.expiration = null;
        }
        if (this.address_space == NetDB.unset_address_space) {
            this.address_space = null;
        }
        if (this.names == NetDB.unset_mva_a_name) {
            this.names = null;
        }
        if (this.interfaces == NetDB.unset_mva_interface) {
            this.interfaces = null;
        }
        if (this.ipc_addresses == NetDB.unset_mva_ip) {
            this.ipc_addresses = null;
        }
        if (this.node_types == NetDB.unset_mva_node_type) {
            this.node_types = null;
        }
        if (this.admins == NetDB.unset_mva_record) {
            this.admins = null;
        }
        if (this.oses == NetDB.unset_mva_os) {
            this.oses = null;
        }
        if (this.users == NetDB.unset_mva_person) {
            this.users = null;
        }
        if (this.custom_tags == NetDB.unset_mva_custom_field) {
            this.custom_tags = null;
        }
        if (this.mail_exchangers == NetDB.unset_node_vector) {
            this.mail_exchangers = null;
        }
    }

    @Override
    protected NetDB flag_as_user_created() {
        super.flag_as_user_created();
        if (this.names != null) {
            for (A_Name netDB : this.names.all_values(true)) {
                netDB.flag_as_user_created();
            }
        }
        if (this.interfaces != null) {
            for (Interface interface_ : this.interfaces.all_values(true)) {
                interface_.flag_as_user_created();
            }
        }
        if (this.ipc_addresses != null) {
            for (IP_Address iP_Address : this.ipc_addresses.all_values(true)) {
                iP_Address.flag_as_user_created();
            }
        }
        return this;
    }

    @Override
    protected NetDB flag_as_modified() {
        super.flag_as_modified();
        if (this.names != null) {
            for (A_Name netDB : this.names.all_values(true)) {
                netDB.flag_as_modified();
            }
        }
        if (this.interfaces != null) {
            for (Interface interface_ : this.interfaces.all_values(true)) {
                interface_.flag_as_modified();
            }
        }
        if (this.ipc_addresses != null) {
            for (IP_Address iP_Address : this.ipc_addresses.all_values(true)) {
                iP_Address.flag_as_modified();
            }
        }
        return this;
    }

    @Override
    protected Node flag_as_system_created() {
        super.flag_as_system_created();
        if (this.names != null) {
            for (A_Name netDB : this.names.all_values(true)) {
                netDB.flag_as_system_created();
            }
        }
        if (this.interfaces != null) {
            for (Interface interface_ : this.interfaces.all_values(true)) {
                interface_.flag_as_system_created();
            }
        }
        if (this.ipc_addresses != null) {
            for (IP_Address iP_Address : this.ipc_addresses.all_values(true)) {
                iP_Address.flag_as_system_created();
            }
        }
        return this;
    }

    @Override
    protected Node flag_as_loaded() {
        super.flag_as_loaded();
        if (this.names != null) {
            for (A_Name netDB : this.names.all_values(true)) {
                netDB.flag_as_loaded();
            }
        }
        if (this.interfaces != null) {
            for (Interface interface_ : this.interfaces.all_values(true)) {
                interface_.flag_as_loaded();
            }
        }
        if (this.ipc_addresses != null) {
            for (IP_Address iP_Address : this.ipc_addresses.all_values(true)) {
                iP_Address.flag_as_loaded();
            }
        }
        return this;
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (fORMAT == NetDB.FORMAT.WHOIS || fORMAT == NetDB.FORMAT.WHOIS_HTML) {
            Boolean bl2 = Property.fetch_as_Boolean("display.node.state", "true");
            Boolean bl3 = Property.fetch_as_Boolean("display.node.room", "false");
            Boolean bl4 = Property.fetch_as_Boolean("display.node.users", "false");
            Boolean bl5 = Property.fetch_as_Boolean("display.node.custom_fields", "false");
            hashtable.put("display_custom_fields", bl5);
            hashtable.put("display_room", bl3);
            hashtable.put("display_state", bl2);
            hashtable.put("display_users", bl4);
        }
        return Lockable.toString(fORMAT, template_name, "node", this, hashtable, bl);
    }

    protected static Node extract(NetDB_Datastore netDB_Datastore, Hashtable hashtable) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Node node = new Node(netDB_Datastore);
        node.flag_as_system_created();
        node.extract(hashtable);
        return node;
    }

    @Override
    protected Node extract(Hashtable hashtable) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Object object;
        Enumeration enumeration;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        Serializable serializable;
        if (hashtable == null) {
            return this;
        }
        this.names = new Multi_Value_Attribute();
        this.interfaces = new Multi_Value_Attribute();
        this.ipc_addresses = new Multi_Value_Attribute();
        this.node_types = new Multi_Value_Attribute();
        this.admins = new Multi_Value_Attribute();
        this.oses = new Multi_Value_Attribute();
        this.groups = new Multi_Value_Attribute();
        this.services = new Multi_Value_Attribute();
        this.users = new Multi_Value_Attribute();
        this.custom_tags = new Multi_Value_Attribute();
        super.extract(hashtable);
        this.department(Department.extract(this.datastore, hashtable));
        this.location(Location.extract(this.datastore, hashtable));
        this.state(State.extract(this.datastore, hashtable));
        this.model(Model.extract(this.datastore, hashtable));
        this.room((String)hashtable.get("room"));
        hashtable.remove("room");
        this.comment((String)hashtable.get("comment"));
        hashtable.remove("comment");
        this.expiration_date((Timestamp)hashtable.get("exp.date"));
        hashtable.remove("exp.date");
        this.can_modify = (Boolean)hashtable.get("can_modify?");
        hashtable.remove("can_modify?");
        String string = (String)hashtable.get("addr_space");
        if (string != null) {
            try {
                serializable = new Prefix(string);
                this.address_space = new Address_Space(this.datastore, (Prefix)serializable);
                this.address_space.flag_as_system_created();
            }
            catch (Exception exception) {
                this.logger().fine(Exception_Formatter.stack_trace(exception));
            }
        }
        hashtable.remove("addr_space");
        serializable = (Hashtable)hashtable.get("names");
        if (serializable != null) {
            object10 = ((Hashtable)serializable).keys();
            while (object10.hasMoreElements()) {
                object9 = (String)object10.nextElement();
                object8 = A_Name.extract(this.datastore, (Hashtable)((Hashtable)serializable).get(object9));
                ((A_Name)object8).flag_as_loaded();
                this.add_name((A_Name)object8);
            }
        }
        hashtable.remove("names");
        object10 = (Hashtable)hashtable.get("types");
        if (object10 != null) {
            object9 = ((Hashtable)object10).keys();
            while (object9.hasMoreElements()) {
                object8 = (String)object9.nextElement();
                this.add_type(Node_Type.extract(this.datastore, (Hashtable)((Hashtable)object10).get(object8)));
            }
        }
        hashtable.remove("types");
        object9 = (Hashtable)hashtable.get("oses");
        if (object9 != null) {
            object8 = ((Hashtable)object9).keys();
            while (object8.hasMoreElements()) {
                object7 = (String)object8.nextElement();
                object6 = new OS(this.datastore, (String)object7);
                ((NetDB)object6).flag_as_system_created();
                this.add_os((OS)object6);
            }
        }
        hashtable.remove("oses");
        object8 = (Hashtable)hashtable.get("tags");
        if (object8 != null) {
            object7 = ((Hashtable)object8).keys();
            while (object7.hasMoreElements()) {
                object6 = (String)object7.nextElement();
                object5 = new Custom_Field((String)object6, (String)((Hashtable)object8).get(object6));
                this.add_custom_field((Custom_Field)object5);
            }
        }
        hashtable.remove("tags");
        object7 = (Hashtable)hashtable.get("groups");
        if (object7 != null) {
            object6 = ((Hashtable)object7).keys();
            while (object6.hasMoreElements()) {
                object5 = (String)object6.nextElement();
                object4 = new Group(this.datastore, (String)object5);
                ((NetDB)object4).flag_as_system_created();
                this.add_owner((Group)object4);
            }
        }
        hashtable.remove("groups");
        object6 = (Hashtable)hashtable.get("users");
        if (object6 != null) {
            object5 = ((Hashtable)object6).keys();
            while (object5.hasMoreElements()) {
                object4 = (String)object5.nextElement();
                this.add_user(Person.extract(this.datastore, (Hashtable)((Hashtable)object6).get(object4)));
            }
        }
        hashtable.remove("users");
        object5 = (Hashtable)hashtable.get("admins");
        if (object5 != null) {
            object4 = (Hashtable)((Hashtable)object5).get("admins");
            object3 = (Hashtable)((Hashtable)object5).get("ateams");
            if (object4 != null) {
                object2 = ((Hashtable)object4).keys();
                while (object2.hasMoreElements()) {
                    enumeration = (String)object2.nextElement();
                    this.add_admin(Person.extract(this.datastore, (Hashtable)((Hashtable)object4).get(enumeration)));
                }
            }
            if (object3 != null) {
                object2 = ((Hashtable)object3).keys();
                while (object2.hasMoreElements()) {
                    enumeration = (String)object2.nextElement();
                    object = Admin_Team.extract(this.datastore, (Hashtable)((Hashtable)object3).get(enumeration));
                    ((Admin_Team)object).name((String)((Object)enumeration));
                    this.add_admin((Admin_Team)object);
                }
            }
        }
        hashtable.remove("admins");
        object4 = (Hashtable)hashtable.get("interfaces");
        if (object4 != null) {
            object3 = ((Hashtable)object4).keys();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                enumeration = Interface.extract(this.datastore, (Hashtable)((Hashtable)object4).get(object2));
                ((Interface)((Object)enumeration)).id(Integer.parseInt(object2));
                this.add_interface((Interface)((Object)enumeration));
            }
        }
        hashtable.remove("interfaces");
        object3 = (Hashtable)hashtable.get("ipc_addresses");
        if (object3 != null) {
            object2 = ((Hashtable)object3).keys();
            while (object2.hasMoreElements()) {
                enumeration = (String)object2.nextElement();
                this.add_address(IP_Address.extract(this.datastore, (Hashtable)((Hashtable)object3).get(enumeration)));
            }
        }
        hashtable.remove("ipc_addresses");
        object2 = (Hashtable)hashtable.get("mxSlaves");
        if (object2 != null) {
            this.mail_exchangers = new Vector();
            enumeration = ((Hashtable)object2).keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                Node node = new Node();
                node.id = new Integer((String)object);
                this.mail_exchangers.add(node);
                Enumeration enumeration2 = ((Hashtable)((Hashtable)object2).get(object)).keys();
                while (enumeration2.hasMoreElements()) {
                    String string2 = (String)enumeration2.nextElement();
                    A_Name a_Name = new A_Name(string2);
                    node.add_name(a_Name);
                    Enumeration enumeration3 = ((Hashtable)((Hashtable)((Hashtable)object2).get(object)).get(string2)).keys();
                    while (enumeration3.hasMoreElements()) {
                        a_Name.add_mx(new MX((String)enumeration3.nextElement()));
                    }
                }
            }
        }
        hashtable.remove("mxSlaves");
        hashtable.remove("id");
        NetDB.unhandled_keys(hashtable, "Node.extract");
        return this;
    }

    public Collection<A_Name> all_names() throws Exception {
        return this.all_names(A_Name.ALLOW.ALL);
    }

    public Collection<A_Name> all_names(A_Name.ALLOW aLLOW) throws Exception {
        Vector<A_Name> vector = new Vector<A_Name>();
        if (this.names != null) {
            for (A_Name netDB : this.names.all_values()) {
                vector.add(netDB);
            }
        }
        if (this.interfaces != null) {
            for (Interface interface_ : this.interfaces.all_values()) {
                if (aLLOW == A_Name.ALLOW.ALL || aLLOW == A_Name.ALLOW.ALIAS && Defaults.interface_allow_aliases().booleanValue() || aLLOW == A_Name.ALLOW.MX && Defaults.interface_allow_mxes().booleanValue()) {
                    for (A_Name a_Name : interface_.names()) {
                        vector.add(a_Name);
                    }
                }
                if (aLLOW != A_Name.ALLOW.ALL && (aLLOW != A_Name.ALLOW.ALIAS || !Defaults.interface_ip_allow_aliases().booleanValue()) && (aLLOW != A_Name.ALLOW.MX || !Defaults.interface_ip_allow_mxes().booleanValue())) continue;
                for (Interface_IP_Address interface_IP_Address : interface_.addresses()) {
                    for (A_Name a_Name : interface_IP_Address.names()) {
                        vector.add(a_Name);
                    }
                }
            }
        }
        if (this.ipc_addresses != null && (aLLOW == A_Name.ALLOW.ALL || aLLOW == A_Name.ALLOW.ALIAS && Defaults.node_ip_allow_aliases().booleanValue() || aLLOW == A_Name.ALLOW.MX && Defaults.node_ip_allow_mxes().booleanValue())) {
            for (IP_Address iP_Address : this.ipc_addresses.all_values()) {
                for (A_Name a_Name : iP_Address.names()) {
                    vector.add(a_Name);
                }
            }
        }
        return vector;
    }

    private void verify_or_die() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.id = this.verify_or_die(this.handle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer verify_or_die(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.datastore == null) {
            this.datastore = this.get_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        if (this.id != null && this.id != NetDB.unset_integer) {
            return this.id;
        }
        String string2 = "";
        try {
            string2 = this.datastore.start_transaction(NetDB.current_method_name());
            Integer n = this.datastore.node().verify_or_die(string2, string);
            return n;
        }
        finally {
            this.datastore.rollback_transaction(string2);
        }
    }

    public static Boolean has_access() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(Record_Type.NODE);
    }

    public static Boolean has_access(User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(user, Record_Type.NODE);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, Record_Type.NODE);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, user, Record_Type.NODE);
    }

    public static Boolean has_access(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Node.has_access(null, null, string);
    }

    public static Boolean has_access(User user, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Node.has_access(null, user, string);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Node.has_access(netDB_Datastore, null, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean has_access(NetDB_Datastore netDB_Datastore, User user, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (netDB_Datastore == null) {
            netDB_Datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        if (user == null && (user = netDB_Datastore.operating_user()) == null) {
            throw new Insufficient_Information("A user must be specified, or an operating user must be set.");
        }
        Integer n = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            n = netDB_Datastore.node().verify_or_die(string2, string);
        }
        catch (Exception exception) {
            Boolean bl = false;
            return bl;
        }
        finally {
            netDB_Datastore.rollback_transaction(string2);
        }
        if (Node.has_access(netDB_Datastore, user).booleanValue() && Group.has_access(netDB_Datastore, user.id(), Record_Type.NODE.toString(), n).booleanValue()) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Timestamp lock_record() throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        this.verify_or_die();
        Boolean bl = null;
        String string = "";
        try {
            string = this.datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            Hashtable hashtable = this.datastore.node().lock_record(string, this.id);
            this.lock((Timestamp)hashtable.get("locked"));
            this.locked_by(this.datastore.operating_user().id());
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    this.datastore.rollback_transaction(string);
                } else {
                    this.datastore.end_transaction(string);
                }
            }
        }
        return this.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node unlock() throws Exception, No_Datastore_Defined {
        NetDB_Datastore.defined_or_die(this.datastore);
        Boolean bl = null;
        String string = "";
        try {
            string = this.datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            this.datastore.node().unlock_record(string, this.lock(), this.id);
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    this.datastore.rollback_transaction(string);
                } else {
                    this.datastore.end_transaction(string);
                }
            }
        }
        this.lock(null);
        this.locked_by(null);
        return this;
    }

    public static Node load(Boolean bl, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return Node.load(NetDB.default_datastore(), bl, string);
    }

    public static Node load(NetDB_Datastore netDB_Datastore, Boolean bl, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        Node node = new Node(netDB_Datastore);
        A_Name a_Name = new A_Name(netDB_Datastore, string);
        a_Name.flag_as_system_created();
        node.add_name(a_Name);
        if (bl.booleanValue()) {
            node.lock_record();
        }
        node.load_object(string);
        return node;
    }

    public static Node load(String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return Node.load(NetDB.default_datastore(), string);
    }

    public static Node load(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        Node node = new Node(netDB_Datastore);
        node.load_object(string);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void load_object(String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        if ((string == null || string.trim().equals("")) && this.id == null) {
            throw Insufficient_Information.missing_handle();
        }
        this.id = this.verify_or_die(string);
        String string2 = "";
        try {
            string2 = this.datastore.start_transaction(NetDB.current_method_name());
            Hashtable hashtable = this.datastore.node().info(string2, this.id, this.datastore.operating_user().id());
            this.extract(hashtable);
            this.flag_as_system_created().flag_as_loaded();
        }
        finally {
            this.datastore.rollback_transaction(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Boolean bl = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            this.verify_or_die();
            netDB_Datastore.node().delete(string, this.lock(), this.id);
            this.id = null;
            this.flag_as_modified().flag_as_user_created();
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
    }

    public static void delete(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Node.delete(NetDB.default_datastore(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Boolean bl = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            Node node = new Node(netDB_Datastore);
            node.add_name(new A_Name(netDB_Datastore, string));
            node.lock_record();
            node.delete();
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string2);
                } else {
                    netDB_Datastore.end_transaction(string2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node commit(NetDB_Datastore netDB_Datastore, Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        this.bind(netDB_Datastore);
        Node node = null;
        Boolean bl2 = null;
        String string = "";
        Insufficient_Information.defined_or_die(this.department, "department");
        Insufficient_Information.defined_or_die(this.location, "location");
        Insufficient_Information.defined_or_die(this.state, "state");
        Insufficient_Information.defined_or_die(this.model, "model");
        Insufficient_Information.defined_or_die(this.model.make(), "make");
        try {
            String string2;
            String string3;
            int n;
            Record record2;
            Object object;
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl2 = false;
            if (this.created_by_user().booleanValue()) {
                node = new Node();
                object = null;
                object = this.address_space != null ? netDB_Datastore.node().insert(string, this.department.handle(), this.location.handle(), this.room, this.state.handle(), this.model.make().handle(), this.model.name(), this.comment, this.expiration, this.address_space.handle()) : netDB_Datastore.node().insert(string, this.department.handle(), this.location.handle(), this.room, this.state.handle(), this.model.make().handle(), this.model.name(), this.comment, this.expiration);
                this.id = new Integer((String)((Hashtable)object).get("id"));
                super.lock((Timestamp)((Hashtable)object).get("locked"));
                super.locked_by(netDB_Datastore.operating_user());
            } else {
                node = Node.load(netDB_Datastore, netDB_Datastore.node().handle(string, this.id));
                if (this.address_space != null) {
                    netDB_Datastore.node().update(string, this.lock(), this.id, this.department.handle(), this.location.handle(), this.room, this.state.handle(), this.model.make().handle(), this.model.name(), this.comment, this.expiration, this.address_space.handle());
                } else {
                    netDB_Datastore.node().update(string, this.lock(), this.id, this.department.handle(), this.location.handle(), this.room, this.state.handle(), this.model.make().handle(), this.model.name(), this.comment, this.expiration);
                }
            }
            object = this.handle();
            Timestamp timestamp = this.lock();
            Comparison_Result comparison_Result = Multi_Value_Attribute.compare_for_commit(this.names, node.names);
            Comparison_Result comparison_Result2 = Multi_Value_Attribute.compare_for_commit(this.custom_tags, node.custom_tags);
            Comparison_Result comparison_Result3 = Multi_Value_Attribute.compare_for_commit(this.groups, node.groups, Attribute.COMPARISON_TYPE.UNIQUE_IDENTIFER);
            Comparison_Result comparison_Result4 = Multi_Value_Attribute.compare_for_commit(this.interfaces, node.interfaces);
            Comparison_Result comparison_Result5 = Multi_Value_Attribute.compare_for_commit(this.ipc_addresses, node.ipc_addresses);
            Comparison_Result comparison_Result6 = Multi_Value_Attribute.compare_for_commit(this.node_types, node.node_types, Attribute.COMPARISON_TYPE.UNIQUE_IDENTIFER);
            Comparison_Result comparison_Result7 = Multi_Value_Attribute.compare_for_commit(this.oses, node.oses, Attribute.COMPARISON_TYPE.UNIQUE_IDENTIFER);
            Comparison_Result comparison_Result8 = Multi_Value_Attribute.compare_for_commit(this.admins, node.admins, Attribute.COMPARISON_TYPE.UNIQUE_IDENTIFER);
            Comparison_Result comparison_Result9 = Multi_Value_Attribute.compare_for_commit(this.users, node.users, Attribute.COMPARISON_TYPE.UNIQUE_IDENTIFER);
            Vector vector = comparison_Result.only_in_set1();
            Vector vector2 = comparison_Result.only_in_set2();
            Vector vector3 = comparison_Result.both_sets();
            Vector vector4 = comparison_Result2.only_in_set1();
            Vector vector5 = comparison_Result2.only_in_set2();
            Vector vector6 = comparison_Result3.only_in_set1();
            Vector vector7 = comparison_Result3.only_in_set2();
            Vector vector8 = comparison_Result4.only_in_set1();
            Vector vector9 = comparison_Result4.only_in_set2();
            Vector vector10 = comparison_Result4.both_sets();
            Vector vector11 = comparison_Result5.only_in_set1();
            Vector vector12 = comparison_Result5.only_in_set2();
            Vector vector13 = comparison_Result5.both_sets();
            Vector vector14 = comparison_Result6.only_in_set1();
            Vector vector15 = comparison_Result6.only_in_set2();
            Vector vector16 = comparison_Result7.only_in_set1();
            Vector vector17 = comparison_Result7.only_in_set2();
            Vector vector18 = comparison_Result8.only_in_set1();
            Vector vector19 = comparison_Result8.only_in_set2();
            Vector vector20 = comparison_Result9.only_in_set1();
            Vector vector21 = comparison_Result9.only_in_set2();
            Hashtable<String, Person> hashtable = new Hashtable<String, Person>();
            for (Record record2 : vector20) {
                hashtable.put(((Person)record2).handle(), (Person)record2);
            }
            for (Record record2 : vector18) {
                if (!(record2 instanceof Person)) continue;
                hashtable.put(record2.handle(), (Person)record2);
            }
            for (Record record2 : hashtable.values()) {
                ((Person)record2).insert_or_update();
            }
            for (n = 0; n < vector2.size(); ++n) {
                ((A_Name)vector2.get(n)).delete(string, timestamp);
            }
            for (n = 0; n < vector3.size(); ++n) {
                ((A_Name)vector3.get(n)).delete_children(string, (A_Name)comparison_Result.both_sets_alternate(n), timestamp);
            }
            for (n = 0; n < vector10.size(); ++n) {
                ((Interface)vector10.get(n)).delete_children(string, (Interface)comparison_Result4.both_sets_alternate(n), timestamp);
            }
            for (n = 0; n < vector13.size(); ++n) {
                ((IP_Address)vector13.get(n)).delete_children(string, (IP_Address)comparison_Result5.both_sets_alternate(n), timestamp);
            }
            for (n = 0; n < vector12.size(); ++n) {
                ((IP_Address)vector12.get(n)).delete(string, timestamp);
            }
            for (n = 0; n < vector9.size(); ++n) {
                ((Interface)vector9.get(n)).delete(string, timestamp);
            }
            for (n = 0; n < vector8.size(); ++n) {
                ((Interface)vector8.get(n)).commit(string, netDB_Datastore, Interface.EMPTY, this.id, timestamp);
            }
            for (n = 0; n < vector10.size(); ++n) {
                ((Interface)vector10.get(n)).commit_children(string, netDB_Datastore, (Interface)comparison_Result4.both_sets_alternate(n), this.id, timestamp);
            }
            for (n = 0; n < vector11.size(); ++n) {
                ((IP_Address)vector11.get(n)).commit(string, netDB_Datastore, IP_Address.EMPTY, this.id, timestamp, Record_Type.NODE);
            }
            for (n = 0; n < vector13.size(); ++n) {
                ((IP_Address)vector13.get(n)).commit(string, netDB_Datastore, (IP_Address)comparison_Result5.both_sets_alternate(n), this.id, timestamp, Record_Type.NODE);
            }
            for (n = 0; n < vector.size(); ++n) {
                ((A_Name)vector.get(n)).commit(string, netDB_Datastore, A_Name.EMPTY, this.id, timestamp, Record_Type.NODE);
            }
            for (n = 0; n < vector3.size(); ++n) {
                ((A_Name)vector3.get(n)).commit_children(string, netDB_Datastore, (A_Name)comparison_Result.both_sets_alternate(n), this.id, timestamp, Record_Type.NODE);
            }
            for (n = 0; n < vector15.size(); ++n) {
                netDB_Datastore.node().type(string, "remove", timestamp, (String)object, ((Node_Type)vector15.get(n)).handle());
            }
            for (n = 0; n < vector14.size(); ++n) {
                netDB_Datastore.node().type(string, "add", timestamp, (String)object, ((Node_Type)vector14.get(n)).handle());
            }
            for (n = 0; n < vector18.size(); ++n) {
                record2 = (Record)vector18.get(n);
                string3 = null;
                string2 = null;
                if (record2 instanceof Person) {
                    string3 = record2.handle();
                } else if (record2 instanceof Admin_Team) {
                    string2 = record2.handle();
                } else if (record2 != null) {
                    throw new Idiot_Programmer("Admins cannot be the class '" + record2.getClass().getName() + "'.");
                }
                netDB_Datastore.node().admin(string, "add", timestamp, (String)object, "", string2, (Integer)null, string3);
            }
            for (n = 0; n < vector19.size(); ++n) {
                record2 = (Record)vector19.get(n);
                string3 = null;
                string2 = null;
                if (record2 instanceof Person) {
                    string3 = record2.handle();
                } else if (record2 instanceof Admin_Team) {
                    string2 = record2.handle();
                } else if (record2 != null) {
                    throw new Idiot_Programmer("Admins cannot be the class '" + record2.getClass().getName() + "'.");
                }
                netDB_Datastore.node().admin(string, "remove", timestamp, (String)object, "", string2, (Integer)null, string3);
            }
            for (n = 0; n < vector16.size(); ++n) {
                netDB_Datastore.node().OS(string, "add", timestamp, (String)object, ((OS)vector16.get(n)).handle(), " ");
            }
            for (n = 0; n < vector17.size(); ++n) {
                netDB_Datastore.node().OS(string, "remove", timestamp, (String)object, ((OS)vector17.get(n)).handle(), " ");
            }
            for (n = 0; n < vector6.size(); ++n) {
                netDB_Datastore.owner().add(string, timestamp, ((Group)vector6.get(n)).handle(), this.id, Record_Type.NODE.toString());
            }
            for (n = 0; n < vector7.size(); ++n) {
                netDB_Datastore.owner().remove(string, timestamp, ((Group)vector7.get(n)).handle(), this.id, Record_Type.NODE.toString());
            }
            for (n = 0; n < vector21.size(); ++n) {
                netDB_Datastore.node().user(string, "remove", timestamp, (String)object, ((Person)vector21.get(n)).handle());
            }
            for (n = 0; n < vector20.size(); ++n) {
                netDB_Datastore.node().user(string, "add", timestamp, (String)object, ((Person)vector20.get(n)).handle());
            }
            for (n = 0; n < vector5.size(); ++n) {
                netDB_Datastore.node().tag(string, "remove", timestamp, (String)object, ((Custom_Field)vector5.get(n)).name(), ((Custom_Field)vector5.get(n)).value());
            }
            for (n = 0; n < vector4.size(); ++n) {
                netDB_Datastore.node().tag(string, "add", timestamp, (String)object, ((Custom_Field)vector4.get(n)).name(), ((Custom_Field)vector4.get(n)).value());
            }
            netDB_Datastore.node().verify_and_log(string, this.id);
            this.flag_as_system_created().flag_as_loaded();
            bl2 = true;
        }
        finally {
            if (bl2 != null) {
                if (!bl2.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
        if (bl.booleanValue()) {
            try {
                this.unlock();
            }
            catch (Exception exception) {
                this.logger.warning("Unlock exception: " + Exception_Formatter.stack_trace(exception));
            }
        }
        return this;
    }

    public static Collection<Node_SS_Result> search(String string) throws Exception, No_Datastore_Defined {
        return Node.search(NetDB.default_datastore(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Node_SS_Result> search(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined {
        if (netDB_Datastore == null) {
            netDB_Datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Hashtable<String, String> hashtable = SSparser.parse(string);
        String string2 = hashtable.get("ip_low");
        String string3 = hashtable.get("ip_high");
        String string4 = hashtable.get("original_name");
        String string5 = hashtable.get("hw");
        String string6 = string4;
        Simple_Search_Result.SEARCH_TYPE sEARCH_TYPE = Simple_Search_Result.SEARCH_TYPE.NAME;
        if (string2 != null) {
            string6 = string2;
            sEARCH_TYPE = Simple_Search_Result.SEARCH_TYPE.IP;
        } else if (string5 != null) {
            string6 = string5;
            sEARCH_TYPE = Simple_Search_Result.SEARCH_TYPE.HARDWARE_ADDRESS;
        }
        Hashtable hashtable2 = null;
        String string7 = "";
        try {
            string7 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            hashtable2 = netDB_Datastore.simple_search().get_nodes(string7, string6, string3, sEARCH_TYPE.toString());
        }
        finally {
            netDB_Datastore.rollback_transaction(string7);
        }
        Vector<Node_SS_Result> vector = new Vector<Node_SS_Result>();
        for (String string8 : hashtable2.keySet()) {
            Hashtable hashtable3 = (Hashtable)hashtable2.get(string8);
            Node_SS_Result node_SS_Result = new Node_SS_Result(netDB_Datastore, (String)hashtable3.get("handle"));
            node_SS_Result.search_type(sEARCH_TYPE);
            node_SS_Result.node_id((String)hashtable3.get("NodeID"));
            node_SS_Result.name((String)hashtable3.get("name"));
            node_SS_Result.name_type((String)hashtable3.get("name_type"), (String)hashtable3.get("alias_of"));
            node_SS_Result.display_name((String)hashtable3.get("node_name"));
            node_SS_Result.ip_type((String)hashtable3.get("ip_type"));
            node_SS_Result.department((String)hashtable3.get("department"));
            node_SS_Result.ip((String)hashtable3.get("ip"));
            node_SS_Result.make_and_model((String)hashtable3.get("make_and_model"));
            node_SS_Result.os((String)hashtable3.get("os"));
            node_SS_Result.received_by((String)hashtable3.get("received_by"));
            node_SS_Result.received_by_fullname((String)hashtable3.get("received_by_fullname"));
            node_SS_Result.preference((String)hashtable3.get("preference"));
            Hashtable hashtable4 = (Hashtable)hashtable3.get("node_type");
            if (hashtable4 != null) {
                for (String string9 : hashtable4.keySet()) {
                    node_SS_Result.add_type(string9);
                }
            }
            vector.add(node_SS_Result);
        }
        Collections.sort(vector, new Node_SS_Result(null, ""));
        return vector;
    }

    public static Collection<Node> full_search(Node_FS_Parameters node_FS_Parameters) throws Exception {
        return Node.full_search(NetDB.default_datastore(), node_FS_Parameters);
    }

    public static Collection<Node> full_search(NetDB_Datastore netDB_Datastore, Node_FS_Parameters node_FS_Parameters) throws Exception {
        return node_FS_Parameters.search(netDB_Datastore);
    }
}

