/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import stanford.netdb.A_Name;
import stanford.netdb.Address_Space;
import stanford.netdb.Attribute;
import stanford.netdb.Comparison_Result;
import stanford.netdb.DHCP_Service;
import stanford.netdb.DHCP_Setting;
import stanford.netdb.Field;
import stanford.netdb.Group;
import stanford.netdb.Location;
import stanford.netdb.Lockable;
import stanford.netdb.Multi_Value_Attribute;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Network_FS_Parameters;
import stanford.netdb.Network_SS_Result;
import stanford.netdb.Privilege;
import stanford.netdb.Record_Type;
import stanford.netdb.Simple_Search_Result;
import stanford.netdb.User;
import stanford.netdb.exceptions.Exception_Formatter;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.exceptions.Record_Not_Found;
import stanford.netdb.ssparser.SSparser;

public class Network
extends Lockable<Network> {
    public static String template_name = "templates/toString/network.tmpl";
    private static final long serialVersionUID = 1L;
    private Integer id = null;
    private DHCP_Service dhcp_service = null;
    private Integer vlan = null;
    private String comment = null;
    private Multi_Value_Attribute<A_Name> names = null;
    private Multi_Value_Attribute<Address_Space> address_spaces = null;
    private Multi_Value_Attribute<DHCP_Setting> dhcp_settings = null;
    private Multi_Value_Attribute<Location> locations = null;

    public Network() {
        this.init();
    }

    public Network(DHCP_Service dHCP_Service, String string) {
        this.init(dHCP_Service, string);
    }

    public Network(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
        this.init();
    }

    public Network(NetDB_Datastore netDB_Datastore, DHCP_Service dHCP_Service, String string) {
        super(netDB_Datastore);
        this.init(dHCP_Service, string);
    }

    private void init() {
        this.init(null, null);
    }

    private void init(DHCP_Service dHCP_Service, String string) {
        if (dHCP_Service != null) {
            this.dhcp_service(dHCP_Service);
        }
        if (string != null) {
            this.comment(string);
        }
    }

    public Integer id() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.verify_or_die();
        return this.id;
    }

    public DHCP_Service DHCP_service() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this.dhcp_service();
    }

    public DHCP_Service dhcp_service() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.dhcp_service, NetDB.unset_dhcp_service, "dhcp_service");
        return this.dhcp_service;
    }

    public int VLAN() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this.vlan();
    }

    public Integer vlan() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.vlan, NetDB.unset_integer, "VLAN");
        return this.vlan;
    }

    public String comment() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.comment, NetDB.unset_string, "comment");
        return this.comment;
    }

    public Collection<A_Name> names() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.names, NetDB.unset_mva_a_name, "names");
        if (this.names == null || this.names == NetDB.unset_mva_a_name) {
            return new Multi_Value_Attribute().all_values();
        }
        return this.names.all_values();
    }

    public Collection<Address_Space> address_spaces() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.address_spaces, NetDB.unset_mva_address_space, "address_spaces");
        if (this.address_spaces == null || this.address_spaces == NetDB.unset_mva_address_space) {
            return new Multi_Value_Attribute().all_values();
        }
        return this.address_spaces.all_values();
    }

    public Collection<DHCP_Setting> DHCP_settings() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this.dhcp_settings();
    }

    public Collection<DHCP_Setting> dhcp_settings() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.dhcp_settings, NetDB.unset_mva_dhcp_setting, "dhcp_settings");
        if (this.dhcp_settings == null || this.dhcp_settings == NetDB.unset_mva_dhcp_setting) {
            return new Multi_Value_Attribute().all_values();
        }
        return this.dhcp_settings.all_values();
    }

    public Collection<Location> locations() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.locations, NetDB.unset_mva_location, "locations");
        if (this.locations == null || this.locations == NetDB.unset_mva_location) {
            return new Multi_Value_Attribute().all_values();
        }
        return this.locations.all_values();
    }

    @Override
    public String handle() {
        if (this.names == null) {
            return null;
        }
        Collection<A_Name> collection = this.names.all_values();
        if (collection.size() <= 0) {
            return null;
        }
        try {
            return collection.iterator().next().full_name();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    protected Network id(Integer n) {
        this.id = n;
        return this;
    }

    public Network DHCP_service(DHCP_Service dHCP_Service) {
        return this.dhcp_service(dHCP_Service);
    }

    public Network dhcp_service(DHCP_Service dHCP_Service) {
        this.dhcp_service = dHCP_Service;
        return this;
    }

    public Network VLAN(Integer n) {
        return this.vlan(n);
    }

    public Network vlan(Integer n) {
        this.vlan = n;
        return this;
    }

    public Network comment(String string) {
        this.comment = string;
        return this;
    }

    public Network add_name(A_Name a_Name) {
        if (this.names == null || this.names == NetDB.unset_mva_a_name) {
            this.names = new Multi_Value_Attribute();
        }
        a_Name.flag_as_user_created();
        this.names.add(a_Name);
        return this;
    }

    public Network add_names(Collection<A_Name> collection) {
        Iterator<A_Name> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add_name(iterator.next());
        }
        return this;
    }

    public Network remove_name(A_Name a_Name) {
        if (this.names != null) {
            this.names.remove(a_Name, (Boolean)true);
        }
        return this;
    }

    public Network remove_names(Collection<A_Name> collection) {
        Iterator<A_Name> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.remove_name(iterator.next());
        }
        return this;
    }

    public Network add_address_space(Address_Space address_Space) {
        if (this.address_spaces == null || this.address_spaces == NetDB.unset_mva_address_space) {
            this.address_spaces = new Multi_Value_Attribute();
        }
        this.address_spaces.add(address_Space);
        address_Space.parent(this);
        return this;
    }

    public Network add_address_spaces(Collection<Address_Space> collection) {
        Iterator<Address_Space> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add_address_space(iterator.next());
        }
        return this;
    }

    public Network remove_address_space(Address_Space address_Space) {
        if (this.address_spaces != null) {
            this.address_spaces.remove(address_Space, (Boolean)true);
            address_Space.parent(null);
        }
        return this;
    }

    public Network remove_address_spaces(Collection<Address_Space> collection) {
        Iterator<Address_Space> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.remove_address_space(iterator.next());
        }
        return this;
    }

    public Network add_DHCP_setting(DHCP_Setting dHCP_Setting) {
        return this.add_dhcp_setting(dHCP_Setting);
    }

    public Network add_dhcp_setting(DHCP_Setting dHCP_Setting) {
        if (this.dhcp_settings == null || this.dhcp_settings == NetDB.unset_mva_dhcp_setting) {
            this.dhcp_settings = new Multi_Value_Attribute();
        }
        this.dhcp_settings.add(dHCP_Setting);
        return this;
    }

    public Network add_DHCP_settings(Collection<DHCP_Setting> collection) {
        return this.add_dhcp_settings(collection);
    }

    public Network add_dhcp_settings(Collection<DHCP_Setting> collection) {
        Iterator<DHCP_Setting> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add_dhcp_setting(iterator.next());
        }
        return this;
    }

    public Network remove_DHCP_setting(DHCP_Setting dHCP_Setting) {
        return this.remove_dhcp_setting(dHCP_Setting);
    }

    public Network remove_dhcp_setting(DHCP_Setting dHCP_Setting) {
        if (this.dhcp_settings != null) {
            this.dhcp_settings.remove(dHCP_Setting, (Boolean)true);
        }
        return this;
    }

    public Network remove_DHCP_settings(Collection<DHCP_Setting> collection) {
        return this.remove_dhcp_settings(collection);
    }

    public Network remove_dhcp_settings(Collection<DHCP_Setting> collection) {
        Iterator<DHCP_Setting> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.remove_dhcp_setting(iterator.next());
        }
        return this;
    }

    public Network add_location(Location location) {
        if (this.locations == null || this.locations == NetDB.unset_mva_location) {
            this.locations = new Multi_Value_Attribute();
        }
        this.locations.add(location);
        return this;
    }

    public Network add_locations(Collection<Location> collection) {
        Iterator<Location> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add_location(iterator.next());
        }
        return this;
    }

    public Network remove_location(Location location) {
        if (this.locations != null) {
            this.locations.remove(location, (Boolean)true);
        }
        return this;
    }

    public Network remove_locations(Collection<Location> collection) {
        Iterator<Location> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.remove_location(iterator.next());
        }
        return this;
    }

    @Override
    public Network bind(NetDB_Datastore netDB_Datastore) throws No_Datastore_Defined {
        super.bind(netDB_Datastore);
        this.bind_children(this.names, netDB_Datastore);
        this.bind_children(this.address_spaces, netDB_Datastore);
        this.bind_children(this.dhcp_settings, netDB_Datastore);
        this.bind_children(this.locations, netDB_Datastore);
        return this;
    }

    @Override
    public Network unbind() {
        super.unbind();
        this.unbind_children(this.names);
        this.unbind_children(this.address_spaces);
        this.unbind_children(this.dhcp_settings);
        this.unbind_children(this.locations);
        return this;
    }

    @Override
    public Network unlink() {
        super.unlink();
        this.unlink_children(this.names);
        this.unlink_children(this.address_spaces);
        this.unlink_children(this.dhcp_settings);
        this.unlink_children(this.locations);
        this.id = null;
        return this;
    }

    @Override
    public String single_value_attributes() {
        String string = "";
        if (this.dhcp_service != null) {
            string = this.dhcp_service.single_value_attributes();
        }
        return string + " " + this.vlan + " " + this.comment;
    }

    @Override
    protected void initialize_member_data() {
        super.initialize_member_data();
        if (this.dhcp_service == null) {
            this.dhcp_service = NetDB.unset_dhcp_service;
        }
        if (this.vlan == null) {
            this.vlan = NetDB.unset_integer;
        }
        if (this.comment == null) {
            this.comment = NetDB.unset_string;
        }
        if (this.names == null) {
            this.names = NetDB.unset_mva_a_name;
        }
        if (this.address_spaces == null) {
            this.address_spaces = NetDB.unset_mva_address_space;
        }
        if (this.dhcp_settings == null) {
            this.dhcp_settings = NetDB.unset_mva_dhcp_setting;
        }
        if (this.locations == null) {
            this.locations = NetDB.unset_mva_location;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        super.flag_field_as_defined(field);
        if (field == Field.DHCP_SERVICE) {
            if (this.dhcp_service == NetDB.unset_dhcp_service) {
                this.dhcp_service = null;
            }
        } else if (field == Field.VLAN) {
            if (this.vlan == NetDB.unset_integer) {
                this.vlan = null;
            }
        } else if (field == Field.COMMENT) {
            if (NetDB.unset_string.equals(this.comment)) {
                this.comment = null;
            }
        } else if (field == Field.NAME) {
            if (this.names == NetDB.unset_mva_a_name) {
                this.names = null;
            }
        } else if (field == Field.ADDRESS_SPACE) {
            if (this.address_spaces == NetDB.unset_mva_address_space) {
                this.address_spaces = null;
            }
        } else if (field == Field.DHCP_SETTING) {
            if (this.dhcp_settings == NetDB.unset_mva_dhcp_setting) {
                this.dhcp_settings = null;
            }
        } else if (field == Field.LOCATION && this.locations == NetDB.unset_mva_location) {
            this.locations = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        super.clear_default_member_data();
        if (this.dhcp_service == NetDB.unset_dhcp_service) {
            this.dhcp_service = null;
        }
        if (this.vlan == NetDB.unset_integer) {
            this.vlan = null;
        }
        if (NetDB.unset_string.equals(this.comment)) {
            this.comment = null;
        }
        if (this.names == NetDB.unset_mva_a_name) {
            this.names = null;
        }
        if (this.address_spaces == NetDB.unset_mva_address_space) {
            this.address_spaces = null;
        }
        if (this.dhcp_settings == NetDB.unset_mva_dhcp_setting) {
            this.dhcp_settings = null;
        }
        if (this.locations == NetDB.unset_mva_location) {
            this.locations = null;
        }
    }

    @Override
    protected NetDB flag_as_system_created() {
        super.flag_as_system_created();
        if (this.names != null) {
            for (A_Name netDB : this.names.all_values(true)) {
                netDB.flag_as_system_created();
            }
        }
        if (this.address_spaces != null) {
            for (Address_Space address_Space : this.address_spaces.all_values(true)) {
                address_Space.flag_as_system_created();
            }
        }
        if (this.locations != null) {
            for (Location location : this.locations.all_values(true)) {
                location.flag_as_system_created();
            }
        }
        return this;
    }

    @Override
    protected NetDB flag_as_user_created() {
        super.flag_as_user_created();
        if (this.names != null) {
            for (A_Name netDB : this.names.all_values(true)) {
                netDB.flag_as_user_created();
            }
        }
        if (this.address_spaces != null) {
            for (Address_Space address_Space : this.address_spaces.all_values(true)) {
                address_Space.flag_as_user_created();
            }
        }
        if (this.locations != null) {
            for (Location location : this.locations.all_values(true)) {
                location.flag_as_user_created();
            }
        }
        return this;
    }

    @Override
    protected NetDB flag_as_modified() {
        super.flag_as_modified();
        if (this.names != null) {
            for (A_Name netDB : this.names.all_values(true)) {
                netDB.flag_as_modified();
            }
        }
        if (this.address_spaces != null) {
            for (Address_Space address_Space : this.address_spaces.all_values(true)) {
                address_Space.flag_as_modified();
            }
        }
        if (this.locations != null) {
            for (Location location : this.locations.all_values(true)) {
                location.flag_as_modified();
            }
        }
        return this;
    }

    @Override
    protected Network flag_as_loaded() {
        super.flag_as_loaded();
        if (this.names != null) {
            for (A_Name netDB : this.names.all_values(true)) {
                netDB.flag_as_loaded();
            }
        }
        if (this.address_spaces != null) {
            for (Address_Space address_Space : this.address_spaces.all_values(true)) {
                address_Space.flag_as_loaded();
            }
        }
        if (this.locations != null) {
            for (Location location : this.locations.all_values(true)) {
                location.flag_as_loaded();
            }
        }
        return this;
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return Lockable.toString(fORMAT, template_name, "network", this, bl);
    }

    protected static Network extract(NetDB_Datastore netDB_Datastore, Hashtable hashtable) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Network network = new Network(netDB_Datastore);
        network.flag_as_system_created();
        network.extract(hashtable);
        return network;
    }

    @Override
    protected Network extract(Hashtable hashtable) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (hashtable == null) {
            return this;
        }
        this.names = new Multi_Value_Attribute();
        this.groups = new Multi_Value_Attribute();
        this.address_spaces = new Multi_Value_Attribute();
        this.dhcp_settings = new Multi_Value_Attribute();
        this.locations = new Multi_Value_Attribute();
        super.extract(hashtable);
        String string = (String)hashtable.get("vlan");
        hashtable.remove("vlan");
        if (string != null) {
            this.vlan = new Integer(string);
        }
        this.comment = (String)hashtable.get("comment");
        hashtable.remove("comment");
        Hashtable hashtable2 = (Hashtable)hashtable.get("names");
        if (hashtable2 != null) {
            object5 = hashtable2.keys();
            while (object5.hasMoreElements()) {
                object4 = (String)object5.nextElement();
                this.add_name(A_Name.extract(this.datastore, (Hashtable)hashtable2.get(object4)));
            }
        }
        hashtable.remove("names");
        object5 = (Hashtable)hashtable.get("groups");
        if (object5 != null) {
            object4 = ((Hashtable)object5).keys();
            while (object4.hasMoreElements()) {
                object3 = (String)object4.nextElement();
                object2 = new Group(this.datastore, (String)object3);
                ((NetDB)object2).flag_as_system_created();
                this.add_owner((Group)object2);
            }
        }
        hashtable.remove("groups");
        object4 = (Hashtable)hashtable.get("locations");
        if (object4 != null) {
            object3 = ((Hashtable)object4).keys();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                this.add_location(Location.extract(this.datastore, (Hashtable)((Hashtable)object4).get(object2)));
            }
        }
        hashtable.remove("locations");
        object3 = (Hashtable)hashtable.get("dhcp_options");
        if (object3 != null) {
            object2 = ((Hashtable)object3).keys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                this.add_dhcp_setting(DHCP_Setting.extract(this.datastore, (Hashtable)((Hashtable)object3).get(object)));
            }
        }
        hashtable.remove("dhcp_options");
        object2 = (Hashtable)hashtable.get("address_spaces");
        if (object2 != null) {
            object = ((Hashtable)object2).keys();
            while (object.hasMoreElements()) {
                String string2 = (String)object.nextElement();
                Address_Space address_Space = Address_Space.extract(this.datastore, (Hashtable)((Hashtable)object2).get(string2));
                this.add_address_space(address_Space);
            }
        }
        hashtable.remove("address_spaces");
        this.dhcp_service = new DHCP_Service((String)hashtable.get("dhcp_service"));
        hashtable.remove("dhcp_service");
        hashtable.remove("id");
        NetDB.unhandled_keys(hashtable, "Network.extract");
        return this;
    }

    private void verify_or_die() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.id = this.verify_or_die(this.handle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer verify_or_die(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.datastore == null) {
            this.datastore = this.get_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        if (this.id != null && this.id != NetDB.unset_integer) {
            return this.id;
        }
        String string2 = "";
        try {
            string2 = this.datastore.start_transaction(NetDB.current_method_name());
            Integer n = this.datastore.network().verify_or_die(string2, string);
            return n;
        }
        finally {
            this.datastore.rollback_transaction(string2);
        }
    }

    public static Boolean has_access() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(Record_Type.NETWORK);
    }

    public static Boolean has_access(User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(user, Record_Type.NETWORK);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, Record_Type.NETWORK);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, user, Record_Type.NETWORK);
    }

    public static Boolean has_access(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Network.has_access(null, null, string);
    }

    public static Boolean has_access(User user, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Network.has_access(null, user, string);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Network.has_access(netDB_Datastore, null, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean has_access(NetDB_Datastore netDB_Datastore, User user, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (netDB_Datastore == null) {
            netDB_Datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        if (user == null && (user = netDB_Datastore.operating_user()) == null) {
            throw new Insufficient_Information("A user must be specified, or an operating user must be set.");
        }
        Integer n = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            n = netDB_Datastore.network().verify_or_die(string2, string);
        }
        catch (Exception exception) {
            Boolean bl = false;
            return bl;
        }
        finally {
            netDB_Datastore.rollback_transaction(string2);
        }
        if (Network.has_access(netDB_Datastore, user).booleanValue() && Group.has_access(netDB_Datastore, user.id(), Record_Type.NETWORK.toString(), n).booleanValue()) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Timestamp lock_record() throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        this.verify_or_die();
        Boolean bl = null;
        String string = "";
        try {
            string = this.datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            Hashtable hashtable = this.datastore.network().lock_record(string, this.id);
            this.lock((Timestamp)hashtable.get("locked"));
            this.locked_by(this.datastore.operating_user().id());
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    this.datastore.rollback_transaction(string);
                } else {
                    this.datastore.end_transaction(string);
                }
            }
        }
        return this.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Network unlock() throws Exception, No_Datastore_Defined {
        NetDB_Datastore.defined_or_die(this.datastore);
        Boolean bl = null;
        String string = "";
        try {
            string = this.datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            this.datastore.network().unlock_record(string, this.lock(), this.id);
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    this.datastore.rollback_transaction(string);
                } else {
                    this.datastore.end_transaction(string);
                }
            }
        }
        this.lock(null);
        this.locked_by(null);
        return this;
    }

    public static Network load(Boolean bl, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return Network.load(NetDB.default_datastore(), bl, string);
    }

    public static Network load(NetDB_Datastore netDB_Datastore, Boolean bl, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        Network network = new Network(netDB_Datastore);
        A_Name a_Name = new A_Name(netDB_Datastore, string);
        a_Name.flag_as_system_created();
        network.add_name(a_Name);
        if (bl.booleanValue()) {
            network.lock_record();
        }
        network.remove_name(a_Name);
        network.load_object(string);
        return network;
    }

    public static Network load(String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return Network.load(NetDB.default_datastore(), string);
    }

    public static Network load(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        Network network = new Network(netDB_Datastore);
        network.load_object(string);
        return network;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void load_object(String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        if ((string == null || string.trim().equals("")) && this.id == null) {
            throw Insufficient_Information.missing_handle();
        }
        this.id = this.verify_or_die(string);
        String string2 = "";
        try {
            string2 = this.datastore.start_transaction(NetDB.current_method_name());
            Hashtable hashtable = this.datastore.network().info(string2, this.id);
            this.extract(hashtable);
            this.flag_as_system_created().flag_as_loaded();
        }
        finally {
            this.datastore.rollback_transaction(string2);
        }
    }

    public static Collection<Network> list() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Network.list(NetDB.default_datastore());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Network> list(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Integer n = netDB_Datastore.operating_user().id();
        Vector<Network> vector = new Vector<Network>();
        Hashtable hashtable = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            hashtable = netDB_Datastore.network().list(string, n);
        }
        finally {
            netDB_Datastore.rollback_transaction(string);
        }
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                Network network = new Network(netDB_Datastore);
                A_Name a_Name = new A_Name(netDB_Datastore, string2);
                network.add_name(a_Name);
                a_Name.flag_as_system_created();
                network.flag_as_system_created();
                vector.add(network);
            }
        }
        Collections.sort(vector);
        return vector;
    }

    public static void move_address_space(String string, String string2, String string3) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        Network.move_address_space(NetDB.default_datastore(), string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void move_address_space(NetDB_Datastore netDB_Datastore, String string, String string2, String string3) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Boolean bl = null;
        String string4 = "";
        try {
            string4 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            Network network = Network.load(netDB_Datastore, true, string2);
            Network network2 = Network.load(netDB_Datastore, true, string3);
            Vector vector = (Vector)network.address_spaces();
            Address_Space address_Space = null;
            for (int i = 0; i < vector.size(); ++i) {
                if (!((Address_Space)vector.get(i)).prefix().toString().equals(string)) continue;
                address_Space = (Address_Space)vector.get(i);
                break;
            }
            address_Space.move(network2);
            network.unlock();
            network2.unlock();
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string4);
                } else {
                    netDB_Datastore.end_transaction(string4);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Boolean bl = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            this.verify_or_die();
            netDB_Datastore.network().delete(string, this.lock(), this.id);
            this.flag_as_modified().flag_as_user_created();
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
    }

    public static void delete(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Network.delete(NetDB.default_datastore(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Boolean bl = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            Network network = new Network(netDB_Datastore);
            network.add_name(new A_Name(netDB_Datastore, string));
            network.lock_record();
            network.delete();
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string2);
                } else {
                    netDB_Datastore.end_transaction(string2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Network commit(NetDB_Datastore netDB_Datastore, Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        this.bind(netDB_Datastore);
        Network network = null;
        Boolean bl2 = null;
        String string = "";
        try {
            int n;
            Object object;
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl2 = false;
            if (this.created_by_user().booleanValue()) {
                network = new Network();
                object = null;
                object = this.dhcp_service != null ? netDB_Datastore.network().insert(string, this.dhcp_service.id(), this.vlan, this.comment) : netDB_Datastore.network().insert(string, this.vlan, this.comment);
                this.id = new Integer((String)((Hashtable)object).get("id"));
                super.lock((Timestamp)((Hashtable)object).get("locked"));
                super.locked_by(netDB_Datastore.operating_user().id());
            } else {
                network = Network.load(netDB_Datastore, netDB_Datastore.network().handle(string, this.id));
                if (this.dhcp_service != null) {
                    netDB_Datastore.network().update(string, this.lock(), this.id, this.dhcp_service.id(), this.vlan, this.comment);
                } else {
                    netDB_Datastore.network().update(string, this.lock(), this.id, this.vlan, this.comment);
                }
            }
            object = this.handle();
            Timestamp timestamp = this.lock();
            Comparison_Result comparison_Result = Multi_Value_Attribute.compare_for_commit(this.names, network.names);
            Comparison_Result comparison_Result2 = Multi_Value_Attribute.compare_for_commit(this.groups, network.groups, Attribute.COMPARISON_TYPE.UNIQUE_IDENTIFER);
            Comparison_Result comparison_Result3 = Multi_Value_Attribute.compare_for_commit(this.address_spaces, network.address_spaces);
            Comparison_Result comparison_Result4 = Multi_Value_Attribute.compare_for_commit(this.dhcp_settings, network.dhcp_settings);
            Comparison_Result comparison_Result5 = Multi_Value_Attribute.compare_for_commit(this.locations, network.locations);
            Vector vector = comparison_Result.only_in_set1();
            Vector vector2 = comparison_Result.only_in_set2();
            Vector vector3 = comparison_Result.both_sets();
            Vector vector4 = comparison_Result2.only_in_set1();
            Vector vector5 = comparison_Result2.only_in_set2();
            Vector vector6 = comparison_Result3.only_in_set1();
            Vector vector7 = comparison_Result3.only_in_set2();
            Vector vector8 = comparison_Result3.both_sets();
            Vector vector9 = comparison_Result4.only_in_set1();
            Vector vector10 = comparison_Result4.only_in_set2();
            Vector vector11 = comparison_Result4.both_sets();
            Vector vector12 = comparison_Result5.only_in_set1();
            Vector vector13 = comparison_Result5.only_in_set2();
            for (n = 0; n < vector2.size(); ++n) {
                ((A_Name)vector2.get(n)).delete(string, timestamp);
            }
            for (n = 0; n < vector3.size(); ++n) {
                ((A_Name)vector3.get(n)).delete_children(string, (A_Name)comparison_Result.both_sets_alternate(n), timestamp);
            }
            for (n = 0; n < vector8.size(); ++n) {
                ((Address_Space)vector8.get(n)).delete_children(string, (Address_Space)comparison_Result3.both_sets_alternate(n), timestamp);
            }
            for (n = 0; n < vector7.size(); ++n) {
                ((Address_Space)vector7.get(n)).delete(string, timestamp);
            }
            for (n = 0; n < vector6.size(); ++n) {
                ((Address_Space)vector6.get(n)).commit(string, netDB_Datastore, Address_Space.EMPTY, this.id, timestamp);
            }
            for (n = 0; n < vector8.size(); ++n) {
                ((Address_Space)vector8.get(n)).commit_children(string, netDB_Datastore, (Address_Space)comparison_Result3.both_sets_alternate(n), this.id, timestamp);
            }
            for (n = 0; n < vector.size(); ++n) {
                ((A_Name)vector.get(n)).commit(string, netDB_Datastore, A_Name.EMPTY, this.id, timestamp, Record_Type.NETWORK);
            }
            for (n = 0; n < vector3.size(); ++n) {
                ((A_Name)vector3.get(n)).commit_children(string, netDB_Datastore, (A_Name)comparison_Result.both_sets_alternate(n), this.id, timestamp, Record_Type.NETWORK);
            }
            for (n = 0; n < vector4.size(); ++n) {
                netDB_Datastore.owner().add(string, timestamp, ((Group)vector4.get(n)).handle(), this.id, Record_Type.NETWORK.toString());
            }
            for (n = 0; n < vector5.size(); ++n) {
                netDB_Datastore.owner().remove(string, timestamp, ((Group)vector5.get(n)).handle(), this.id, Record_Type.NETWORK.toString());
            }
            for (n = 0; n < vector10.size(); ++n) {
                netDB_Datastore.dhcp_option().remove(string, timestamp, this.id, Record_Type.NETWORK.toString(), ((DHCP_Setting)vector10.get(n)).handle());
            }
            for (n = 0; n < vector9.size(); ++n) {
                netDB_Datastore.dhcp_option().add(string, timestamp, this.id, Record_Type.NETWORK.toString(), ((DHCP_Setting)vector9.get(n)).handle(), ((DHCP_Setting)vector9.get(n)).value());
            }
            for (n = 0; n < vector11.size(); ++n) {
                DHCP_Setting dHCP_Setting = (DHCP_Setting)vector11.get(n);
                DHCP_Setting dHCP_Setting2 = (DHCP_Setting)comparison_Result4.both_sets_alternate(n);
                String string2 = dHCP_Setting.value();
                String string3 = dHCP_Setting2.value();
                if (string2 == null || string3 == null || string2.equals(string3)) continue;
                netDB_Datastore.dhcp_option().remove(string, timestamp, this.id, Record_Type.NETWORK.toString(), dHCP_Setting.handle());
                netDB_Datastore.dhcp_option().add(string, timestamp, this.id, Record_Type.NETWORK.toString(), dHCP_Setting2.handle(), string3);
            }
            for (n = 0; n < vector13.size(); ++n) {
                netDB_Datastore.network().location(string, "remove", timestamp, this.id, ((Location)vector13.get(n)).id());
            }
            for (n = 0; n < vector12.size(); ++n) {
                netDB_Datastore.network().location(string, "add", timestamp, this.id, ((Location)vector12.get(n)).id());
            }
            netDB_Datastore.network().verify_and_log(string, this.id);
            this.flag_as_system_created().flag_as_loaded();
            bl2 = true;
        }
        finally {
            if (bl2 != null) {
                if (!bl2.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
        if (bl.booleanValue()) {
            try {
                this.unlock();
            }
            catch (Exception exception) {
                this.logger.warning("Unlock exception: " + Exception_Formatter.stack_trace(exception));
            }
        }
        return this;
    }

    public static Integer next_available_VLAN(Integer n) throws Exception, No_Datastore_Defined {
        return Network.next_available_vlan(n);
    }

    public static Integer next_available_vlan(Integer n) throws Exception, No_Datastore_Defined {
        return Network.next_available_vlan(null, n);
    }

    public static Integer next_available_VLAN(NetDB_Datastore netDB_Datastore, Integer n) throws Exception, No_Datastore_Defined {
        return Network.next_available_vlan(netDB_Datastore, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer next_available_vlan(NetDB_Datastore netDB_Datastore, Integer n) throws Exception, No_Datastore_Defined {
        if (netDB_Datastore == null) {
            netDB_Datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        if (n == null) {
            n = new Integer(0);
        }
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            Integer n2 = netDB_Datastore.network().next_available_vlan(string, n);
            return n2;
        }
        finally {
            netDB_Datastore.rollback_transaction(string);
        }
    }

    public static Collection<Network_SS_Result> search(String string) throws Exception, No_Datastore_Defined {
        return Network.search(NetDB.default_datastore(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Network_SS_Result> search(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined {
        String string2;
        if (netDB_Datastore == null) {
            netDB_Datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Hashtable<String, String> hashtable = SSparser.parse(string);
        String string3 = hashtable.get("ip_low");
        String string4 = hashtable.get("ip_high");
        String string5 = string2 = hashtable.get("original_name");
        Simple_Search_Result.SEARCH_TYPE sEARCH_TYPE = Simple_Search_Result.SEARCH_TYPE.NAME;
        if (string3 != null) {
            string5 = string3;
            sEARCH_TYPE = Simple_Search_Result.SEARCH_TYPE.IP;
        }
        Hashtable hashtable2 = null;
        String string6 = "";
        try {
            string6 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            hashtable2 = netDB_Datastore.simple_search().get_networks(string6, string5, string4, sEARCH_TYPE.toString());
        }
        finally {
            netDB_Datastore.rollback_transaction(string6);
        }
        Vector<Network_SS_Result> vector = new Vector<Network_SS_Result>();
        for (String string7 : hashtable2.keySet()) {
            Hashtable hashtable3 = (Hashtable)hashtable2.get(string7);
            Network_SS_Result network_SS_Result = new Network_SS_Result((String)hashtable3.get("handle"));
            network_SS_Result.search_type(sEARCH_TYPE);
            network_SS_Result.ip((String)hashtable3.get("ip"));
            network_SS_Result.network_name((String)hashtable3.get("net_name"));
            network_SS_Result.address_name((String)hashtable3.get("dhcp_name"));
            network_SS_Result.comment((String)hashtable3.get("comment"));
            vector.add(network_SS_Result);
        }
        Collections.sort(vector, new Network_SS_Result(""));
        return vector;
    }

    public static Collection<Network> full_search(Network_FS_Parameters network_FS_Parameters) throws Exception {
        return Network.full_search(NetDB.default_datastore(), network_FS_Parameters);
    }

    public static Collection<Network> full_search(NetDB_Datastore netDB_Datastore, Network_FS_Parameters network_FS_Parameters) throws Exception {
        return network_FS_Parameters.search(netDB_Datastore);
    }
}

