/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import stanford.netdb.A_Name;
import stanford.netdb.Address_Space;
import stanford.netdb.Alias;
import stanford.netdb.Attribute;
import stanford.netdb.Consultant;
import stanford.netdb.Custom_Field;
import stanford.netdb.DHCP_Service;
import stanford.netdb.DHCP_Setting;
import stanford.netdb.Department;
import stanford.netdb.Domain;
import stanford.netdb.Domain_Name;
import stanford.netdb.Field;
import stanford.netdb.Group;
import stanford.netdb.IP.IPaddress;
import stanford.netdb.IP.Prefix;
import stanford.netdb.IP_Address;
import stanford.netdb.IP_Pool;
import stanford.netdb.Interface;
import stanford.netdb.Interface_IP_Address;
import stanford.netdb.Interface_Type;
import stanford.netdb.Location;
import stanford.netdb.MX;
import stanford.netdb.Make;
import stanford.netdb.Model;
import stanford.netdb.Model_Type;
import stanford.netdb.Multi_Value_Attribute;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Node;
import stanford.netdb.Node_Type;
import stanford.netdb.OS;
import stanford.netdb.Person;
import stanford.netdb.Privilege;
import stanford.netdb.Record;
import stanford.netdb.State;
import stanford.netdb.User;
import stanford.netdb.Velocity_Parser;
import stanford.netdb.exceptions.Autocomplete_Disabled;
import stanford.netdb.exceptions.Exception_Formatter;
import stanford.netdb.exceptions.Idiot_Programmer;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.util.Resource_Reader;
import stanford.netdb.util.TZ_Timestamp;

public abstract class NetDB<T extends NetDB>
extends Attribute<T> {
    protected static final Boolean unset_boolean = new Boolean("false");
    protected static final String unset_string = new String("UNSET STRING ~(*^-^*)~");
    protected static final BigInteger unset_biginteger = new BigInteger("0");
    protected static final Integer unset_integer = new Integer(0);
    protected static final Timestamp unset_timestamp = new Timestamp(0L);
    protected static final TZ_Timestamp unset_tz_timestamp = new TZ_Timestamp(0L);
    protected static final Hashtable unset_hashtable = new Hashtable();
    protected static final Prefix unset_prefix = NetDB.new_prefix();
    protected static final IPaddress unset_address = NetDB.new_ip_address();
    protected static final Address_Space unset_address_space = new Address_Space();
    protected static final Department unset_department = new Department();
    protected static final DHCP_Service unset_dhcp_service = new DHCP_Service();
    protected static final DHCP_Setting unset_dhcp_setting = new DHCP_Setting();
    protected static final Domain unset_domain = new Domain();
    protected static final Domain_Name unset_domain_name = new Domain_Name();
    protected static final Group unset_group = new Group();
    protected static final Interface_Type unset_interface_type = new Interface_Type();
    protected static final Location unset_location = new Location();
    protected static final Make unset_make = new Make();
    protected static final Model unset_model = new Model();
    protected static final Model_Type unset_model_type = new Model_Type();
    protected static final Person unset_person = new Person();
    protected static final Privilege unset_privilege = new Privilege();
    protected static final State unset_state = new State();
    protected static final User unset_user = new User();
    protected static final Vector<Node> unset_node_vector = new Vector();
    protected static final Vector<String> unset_string_vector = new Vector();
    protected static final Vector<IPaddress> unset_ip_vector = new Vector();
    protected static final Multi_Value_Attribute<Address_Space> unset_mva_address_space = new Multi_Value_Attribute();
    protected static final Multi_Value_Attribute<Alias> unset_mva_alias = new Multi_Value_Attribute();
    protected static final Multi_Value_Attribute<A_Name> unset_mva_a_name = new Multi_Value_Attribute();
    protected static final Multi_Value_Attribute<Consultant> unset_mva_consultant = new Multi_Value_Attribute();
    protected static final Multi_Value_Attribute<Custom_Field> unset_mva_custom_field = new Multi_Value_Attribute();
    protected static final Multi_Value_Attribute<Department> unset_mva_department = new Multi_Value_Attribute();
    protected static final Multi_Value_Attribute<DHCP_Setting> unset_mva_dhcp_setting = new Multi_Value_Attribute();
    protected static final Multi_Value_Attribute<DHCP_Service> unset_mva_dhcp_service = new Multi_Value_Attribute();
    protected static final Multi_Value_Attribute<Group> unset_mva_group = new Multi_Value_Attribute();
    protected static final Multi_Value_Attribute<Interface> unset_mva_interface = new Multi_Value_Attribute();
    protected static final Multi_Value_Attribute<Interface_IP_Address> unset_mva_interface_ip = new Multi_Value_Attribute();
    protected static final Multi_Value_Attribute<IP_Address> unset_mva_ip = new Multi_Value_Attribute();
    protected static final Multi_Value_Attribute<IP_Pool> unset_mva_ip_pool = new Multi_Value_Attribute();
    protected static final Multi_Value_Attribute<Location> unset_mva_location = new Multi_Value_Attribute();
    protected static final Multi_Value_Attribute<MX> unset_mva_mx = new Multi_Value_Attribute();
    protected static final Multi_Value_Attribute<Node_Type> unset_mva_node_type = new Multi_Value_Attribute();
    protected static final Multi_Value_Attribute<OS> unset_mva_os = new Multi_Value_Attribute();
    protected static final Multi_Value_Attribute<Person> unset_mva_person = new Multi_Value_Attribute();
    protected static final Multi_Value_Attribute<Privilege> unset_mva_privilege = new Multi_Value_Attribute();
    protected static final Multi_Value_Attribute<Record> unset_mva_record = new Multi_Value_Attribute();
    protected static final String REMOVE_ACTION = "remove";
    protected static final String ADD_ACTION = "add";
    protected static final String INSERT_ACTION = "insert";
    protected static final String UPDATE_ACTION = "update";
    protected static final String DELETE_ACTION = "delete";
    protected transient NetDB_Datastore datastore = null;
    private static transient NetDB_Datastore default_datastore = null;
    private static Boolean autocomplete = true;
    private Boolean user_created = true;
    private Boolean loaded = false;

    protected NetDB() {
    }

    protected NetDB(NetDB_Datastore netDB_Datastore) {
        try {
            this.bind(netDB_Datastore);
        }
        catch (No_Datastore_Defined no_Datastore_Defined) {
            // empty catch block
        }
    }

    public NetDB_Datastore datastore() {
        return this.datastore;
    }

    public static NetDB_Datastore default_datastore() {
        return default_datastore;
    }

    public static Boolean autocomplete() {
        return autocomplete;
    }

    public Boolean is_bound() {
        if (this.datastore != null || default_datastore != null) {
            return true;
        }
        return false;
    }

    protected NetDB_Datastore get_datastore() throws No_Datastore_Defined {
        NetDB_Datastore netDB_Datastore = this.datastore;
        if (netDB_Datastore == null) {
            if (default_datastore != null) {
                netDB_Datastore = default_datastore;
            } else {
                NetDB_Datastore.defined_or_die(null);
            }
        }
        return netDB_Datastore;
    }

    public Boolean created_by_user() {
        return this.user_created;
    }

    public Boolean is_partial() {
        if (!this.loaded.booleanValue() && !this.user_created.booleanValue()) {
            return true;
        }
        return false;
    }

    public Boolean is_complete() {
        if (this.loaded.booleanValue() && !this.user_created.booleanValue()) {
            return true;
        }
        return false;
    }

    protected Boolean has_been_loaded() {
        return this.loaded;
    }

    public abstract String handle() throws Exception, No_Datastore_Defined, Insufficient_Information;

    @Override
    public String unique_identifier() {
        try {
            return this.handle();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public T bind(NetDB_Datastore netDB_Datastore) throws No_Datastore_Defined {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        if (this.datastore == null || !this.datastore.equals(netDB_Datastore).booleanValue()) {
            if (this.datastore != null) {
                this.unbind();
            }
            this.datastore = netDB_Datastore;
        }
        return (T)this;
    }

    protected void bind_children(Multi_Value_Attribute multi_Value_Attribute, NetDB_Datastore netDB_Datastore) throws No_Datastore_Defined {
        if (multi_Value_Attribute == null) {
            return;
        }
        Vector vector = (Vector)multi_Value_Attribute.all_values();
        if (vector.size() > 0 && vector.get(0) instanceof NetDB) {
            for (int i = 0; i < vector.size(); ++i) {
                ((NetDB)vector.get(i)).bind(netDB_Datastore);
            }
        }
    }

    public static void default_datastore(NetDB_Datastore netDB_Datastore) {
        default_datastore = netDB_Datastore;
    }

    public T unbind() {
        this.datastore = null;
        this.unlink();
        return (T)this;
    }

    protected void unbind_children(Multi_Value_Attribute multi_Value_Attribute) {
        if (multi_Value_Attribute == null) {
            return;
        }
        Vector vector = (Vector)multi_Value_Attribute.all_values();
        if (vector.size() > 0 && vector.get(0) instanceof NetDB) {
            for (int i = 0; i < vector.size(); ++i) {
                ((NetDB)vector.get(i)).unbind();
            }
        }
    }

    public T unlink() {
        this.flag_as_modified().flag_as_user_created();
        return (T)this;
    }

    protected void unlink_children(Multi_Value_Attribute multi_Value_Attribute) {
        if (multi_Value_Attribute == null) {
            return;
        }
        Vector vector = (Vector)multi_Value_Attribute.all_values();
        if (vector.size() > 0 && vector.get(0) instanceof NetDB) {
            for (int i = 0; i < vector.size(); ++i) {
                ((NetDB)vector.get(i)).unlink();
            }
        }
    }

    public static void autocomplete(Boolean bl) {
        autocomplete = bl;
    }

    protected NetDB flag_as_user_created() {
        this.user_created = true;
        this.clear_default_member_data();
        return this;
    }

    protected abstract void initialize_member_data();

    protected abstract void flag_field_as_defined(Field var1);

    protected NetDB flag_as_system_created() {
        if (this.user_created.booleanValue()) {
            this.initialize_member_data();
        }
        this.user_created = false;
        return this;
    }

    protected abstract void clear_default_member_data();

    protected NetDB flag_as_loaded() {
        if (!this.loaded.booleanValue()) {
            this.clear_default_member_data();
        }
        this.loaded = true;
        return this;
    }

    protected NetDB flag_as_modified() {
        this.loaded = false;
        return this;
    }

    public T complete() throws Exception, No_Datastore_Defined, Insufficient_Information {
        T t = this.complete_object();
        this.flag_as_loaded();
        return t;
    }

    protected abstract T complete_object() throws Exception, No_Datastore_Defined, Insufficient_Information;

    protected void internal_complete(Object object, Object object2, String string) throws Exception, No_Datastore_Defined {
        if (object != null && object2 != null && !this.valid_class(object, object2).booleanValue()) {
            throw new Idiot_Programmer(string + ": data class '" + object.getClass().getName() + "' is not the same class as the default_value class '" + object2.getClass().getName() + "'.");
        }
        if (object == object2) {
            if (NetDB.autocomplete().booleanValue()) {
                if (this.is_partial().booleanValue()) {
                    this.complete();
                } else if (object2 != null) {
                    throw new Idiot_Programmer("The data '" + string + "' still has the default_value set, even though the instance is not partial.");
                }
            } else {
                throw new Autocomplete_Disabled("Autocomplete is off, and the requested data (" + string + ") is not present.");
            }
        }
    }

    private Boolean valid_class(Object object, Object object2) {
        Class<?> clazz = object2.getClass();
        Class<?> clazz2 = object.getClass();
        do {
            if (!clazz.equals(clazz2)) continue;
            return true;
        } while ((clazz2 = clazz2.getSuperclass()) != null);
        return false;
    }

    @Override
    public int compare(T t, T t2) {
        if (t == null && t2 == null) {
            return 0;
        }
        if (t == null) {
            return -1;
        }
        if (t2 == null) {
            return 1;
        }
        return ((NetDB)t).compare((Attribute<T>)t2);
    }

    public Boolean equals(T t) {
        if (this.compare((Attribute<T>)t) == 0) {
            return true;
        }
        return false;
    }

    @Override
    public int compare(Attribute<T> attribute) {
        return this.compare(attribute, Attribute.COMPARISON_TYPE.UNIQUE_IDENTIFER);
    }

    @Override
    public int compare(Attribute<T> attribute, Attribute.COMPARISON_TYPE cOMPARISON_TYPE) {
        String string = null;
        String string2 = null;
        if (cOMPARISON_TYPE == Attribute.COMPARISON_TYPE.UNIQUE_IDENTIFER) {
            string = this.unique_identifier().toLowerCase();
            if (attribute != null) {
                string2 = attribute.unique_identifier().toLowerCase();
            }
        } else {
            string = this.single_value_attributes();
            if (attribute != null) {
                string2 = attribute.single_value_attributes();
            }
        }
        if (string != null) {
            return string.compareTo(string2);
        }
        if (string2 != null) {
            return -string2.compareTo(string);
        }
        return 0;
    }

    @Override
    public int compareTo(T t) {
        String string = this.unique_identifier();
        String string2 = null;
        if (t != null) {
            string2 = ((NetDB)t).unique_identifier();
        }
        if (string != null) {
            string = string.toLowerCase();
        }
        if (string2 != null) {
            string2 = string2.toLowerCase();
        }
        if (string == null && string2 == null) {
            return 0;
        }
        if (string == null) {
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        return string.compareTo(string2);
    }

    protected static void unhandled_keys(Hashtable hashtable, String string) {
        NetDB.unhandled_keys(hashtable, string, false);
    }

    protected static void unhandled_keys(Hashtable hashtable, String string, Boolean bl) {
        String string2 = System.getProperty("unhandled_keys");
        if (!(bl.booleanValue() || string2 != null && "true".equals(string2))) {
            return;
        }
        if (hashtable.size() > 0) {
            System.out.println("Remaining keys (" + string + "): " + hashtable);
        }
    }

    protected static final String current_method_name() {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            if (!"current_method_name".equals(stackTraceElementArray[i].getMethodName())) continue;
            return stackTraceElementArray[i + 1].getClassName() + "." + stackTraceElementArray[i + 1].getMethodName();
        }
        return "Method not found...";
    }

    protected static final Integer boolean_to_integer(Boolean bl) {
        if (bl != null && bl.booleanValue()) {
            return new Integer(1);
        }
        return new Integer(0);
    }

    private static final Prefix new_prefix() {
        try {
            return new Prefix("0.0.0.0/32");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    private static final IPaddress new_ip_address() {
        try {
            return new IPaddress("0.0.0.0");
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            System.exit(1);
            return null;
        }
    }

    public String toString() {
        String string = "";
        try {
            string = this.toString(FORMAT.FULL, true);
        }
        catch (Exception exception) {
            this.logger().severe("An exception was encountered while attempting to convert a " + this.getClass().getName() + " into a string:\n" + Exception_Formatter.stack_trace(exception));
        }
        return string;
    }

    public String toString(FORMAT fORMAT) throws Exception {
        return this.toString(fORMAT, false);
    }

    public abstract String toString(FORMAT var1, Boolean var2) throws Exception;

    public static String toString(FORMAT fORMAT, String string, String string2, Object object, Boolean bl) throws Exception {
        return NetDB.toString(fORMAT, string, string2, object, new Hashtable<String, Object>(), bl);
    }

    public static String toString(FORMAT fORMAT, String string, String string2, Object object, Hashtable<String, Object> hashtable, Boolean bl) throws Exception {
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        if (fORMAT == FORMAT.HTML || fORMAT == FORMAT.WHOIS_HTML) {
            Velocity_Parser.html_safe(hashtable);
        }
        if (fORMAT == FORMAT.WHOIS || fORMAT == FORMAT.WHOIS_HTML) {
            hashtable.put("display_created", false);
        }
        hashtable.put(string2, object);
        return Velocity_Parser.parse(string, hashtable, true, bl);
    }

    public static String version() throws Exception {
        return Resource_Reader.string_data(System.getProperty("resource.client_version", "client_version"));
    }

    public static enum FORMAT {
        FULL,
        HTML,
        WHOIS,
        WHOIS_HTML;

    }
}

