/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Pattern;
import stanford.netdb.Attribute;
import stanford.netdb.Comparison_Result;

public class Multi_Value_Attribute<T extends Attribute>
implements Comparator<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Vector<T> values = new Vector();
    private Boolean sorted = false;

    protected void add(Collection<T> collection) {
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add((Attribute)iterator.next());
        }
    }

    public void add(T t) {
        if (t == null) {
            return;
        }
        Boolean bl = false;
        String string = t.getClass().getName();
        for (int i = 0; i < this.values.size(); ++i) {
            String string2 = ((Attribute)this.values.get(i)).getClass().getName();
            if (!string.equals(string2) || t.compareTo(this.values.get(i)) != 0) continue;
            this.values.set(i, t);
            bl = true;
            break;
        }
        if (!bl.booleanValue()) {
            this.values.add(t);
            this.sorted = false;
        }
    }

    public int remove(T t) {
        return this.remove(t, (Boolean)false);
    }

    public int remove(T t, Boolean bl) {
        String string = "";
        try {
            string = ((Attribute)t).unique_identifier();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.remove(string, t, bl);
    }

    public int remove(String string, Boolean bl) {
        return this.remove(string, null, bl);
    }

    public int remove(String string, T t, Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        int n = 0;
        for (int i = 0; i < this.values.size(); ++i) {
            String string2 = ((Attribute)this.values.get(i)).unique_identifier();
            if (string2 == null) {
                string2 = "";
            }
            if (!(bl == false && string2.equals(string) || bl == true && string2.toLowerCase().equals(string.toLowerCase())) && t != this.values.get(i)) continue;
            this.values.remove(i);
            ++n;
        }
        return n;
    }

    public int size() {
        if (this.values == null) {
            return -1;
        }
        return this.values.size();
    }

    public T find(String string) {
        for (int i = 0; i < this.values.size(); ++i) {
            if (!((Attribute)this.values.get(i)).unique_identifier().equals(string)) continue;
            return (T)((Attribute)this.values.get(i));
        }
        return null;
    }

    public Boolean contains_match(String string) {
        Pattern pattern = Pattern.compile(string, 2);
        return this.contains_match(pattern);
    }

    public Boolean contains_match(Pattern pattern) {
        for (int i = 0; i < this.values.size(); ++i) {
            if (!pattern.matcher(((Attribute)this.values.get(i)).unique_identifier()).matches()) continue;
            return true;
        }
        return false;
    }

    public Collection<T> all_values() {
        return this.all_values(false);
    }

    public Collection<T> all_values(Boolean bl) {
        if (!this.sorted.booleanValue()) {
            Comparator comparator = null;
            if (this.values.size() > 0) {
                comparator = ((Attribute)this.values.firstElement()).sort_comparator();
            }
            if (comparator != null) {
                try {
                    Collections.sort(this.values, comparator);
                    this.sorted = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!this.sorted.booleanValue()) {
                Collections.sort(this.values, this);
                this.sorted = true;
            }
        }
        if (!bl.booleanValue()) {
            return (Collection)this.values.clone();
        }
        return this.values;
    }

    public static Comparison_Result compare_for_commit(Multi_Value_Attribute multi_Value_Attribute, Multi_Value_Attribute multi_Value_Attribute2) {
        return Multi_Value_Attribute.compare_for_commit(multi_Value_Attribute, multi_Value_Attribute2, Attribute.COMPARISON_TYPE.SINGLE_VALUES);
    }

    public static Comparison_Result compare_for_commit(Multi_Value_Attribute multi_Value_Attribute, Multi_Value_Attribute multi_Value_Attribute2, Attribute.COMPARISON_TYPE cOMPARISON_TYPE) {
        int n;
        Comparison_Result<Attribute> comparison_Result = new Comparison_Result<Attribute>();
        Vector vector = null;
        Vector vector2 = null;
        vector = multi_Value_Attribute == null ? new Vector() : (Vector)multi_Value_Attribute.values.clone();
        vector2 = multi_Value_Attribute2 == null ? new Vector() : (Vector)multi_Value_Attribute2.values.clone();
        for (n = 0; n < vector.size(); ++n) {
            Attribute attribute = (Attribute)vector.get(n);
            Boolean bl = false;
            for (int i = 0; i < vector2.size(); ++i) {
                if (attribute.compare((Attribute)vector2.get(i), cOMPARISON_TYPE) != 0) continue;
                comparison_Result.in_both(attribute, (Attribute)vector2.get(i));
                vector2.remove(i);
                bl = true;
                break;
            }
            if (bl.booleanValue()) continue;
            comparison_Result.in_set1(attribute);
        }
        for (n = 0; n < vector2.size(); ++n) {
            comparison_Result.in_set2((Attribute)vector2.get(n));
        }
        return comparison_Result;
    }

    @Override
    public int compare(T t, T t2) {
        String string;
        if (t == null && t2 != null) {
            return -1;
        }
        if (t != null && t2 == null) {
            return 1;
        }
        if (t == null && t2 == null) {
            return 0;
        }
        String string2 = t.getClass().getName();
        int n = string2.compareTo(string = t2.getClass().getName());
        if (n != 0) {
            return n;
        }
        return t.compareTo(t2);
    }
}

