/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import stanford.netdb.Field;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Privilege;
import stanford.netdb.Record;
import stanford.netdb.Record_Type;
import stanford.netdb.User;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.exceptions.Not_Implemented;

public class Model_Type
extends Record<Model_Type> {
    public static String template_name = "templates/toString/model_type.tmpl";
    private static final long serialVersionUID = 1L;
    private String name = null;
    private String comment = null;

    public Model_Type() {
        this.init();
    }

    public Model_Type(String string) {
        this.init(string);
    }

    public Model_Type(String string, String string2) {
        this.init(string, string2);
    }

    public Model_Type(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
        this.init();
    }

    public Model_Type(NetDB_Datastore netDB_Datastore, String string) {
        super(netDB_Datastore);
        this.init(string);
    }

    public Model_Type(NetDB_Datastore netDB_Datastore, String string, String string2) {
        super(netDB_Datastore);
        this.init(string, string2);
    }

    private void init() {
        this.init(null, null);
    }

    private void init(String string) {
        this.init(string, null);
    }

    private void init(String string, String string2) {
        if (string != null) {
            this.name(string);
        }
        if (string2 != null) {
            this.comment(string2);
        }
    }

    public String name() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.name, NetDB.unset_string, "name");
        return this.name;
    }

    public String comment() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.comment, NetDB.unset_string, "comment");
        return this.comment;
    }

    @Override
    public String handle() {
        return this.name;
    }

    public Model_Type name(String string) {
        this.name = string;
        return this;
    }

    public Model_Type comment(String string) {
        this.comment = string;
        return this;
    }

    @Override
    public String single_value_attributes() {
        return this.name + " " + this.comment;
    }

    @Override
    protected void initialize_member_data() {
        super.initialize_member_data();
        if (this.comment == null) {
            this.comment = NetDB.unset_string;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        super.flag_field_as_defined(field);
        if (field == Field.COMMENT && NetDB.unset_string.equals(this.comment)) {
            this.comment = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        super.clear_default_member_data();
        if (NetDB.unset_string.equals(this.comment)) {
            this.comment = null;
        }
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return Record.toString(fORMAT, template_name, "model_type", this, bl);
    }

    public static Boolean has_access() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(Record_Type.MODEL_TYPE);
    }

    public static Boolean has_access(User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(user, Record_Type.MODEL_TYPE);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, Record_Type.MODEL_TYPE);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, user, Record_Type.MODEL_TYPE);
    }

    public static Collection<Model_Type> list() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Model_Type.list(NetDB.default_datastore());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Model_Type> list(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Vector<Model_Type> vector = new Vector<Model_Type>();
        Hashtable hashtable = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            hashtable = netDB_Datastore.model_type().list(string);
        }
        finally {
            netDB_Datastore.rollback_transaction(string);
        }
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                Model_Type model_Type = new Model_Type(netDB_Datastore, string2, (String)hashtable.get(string2));
                model_Type.flag_as_system_created().flag_as_loaded();
                vector.add(model_Type);
            }
        }
        Collections.sort(vector);
        return vector;
    }

    @Override
    protected void load_object(String string) throws Not_Implemented {
        throw new Not_Implemented("This class cannot currently be loaded.");
    }

    @Override
    public void delete(NetDB_Datastore netDB_Datastore) throws Not_Implemented {
        throw new Not_Implemented("This class cannot currently be deleted.");
    }

    public static void delete(String string) throws Not_Implemented {
        Model_Type.delete(NetDB.default_datastore(), string);
    }

    public static void delete(NetDB_Datastore netDB_Datastore, String string) throws Not_Implemented {
        throw new Not_Implemented("This class cannot currently be deleted.");
    }

    @Override
    public Model_Type commit(NetDB_Datastore netDB_Datastore) throws Not_Implemented {
        throw new Not_Implemented("This class cannot currently be committed.");
    }
}

