/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import stanford.netdb.Field;
import stanford.netdb.Make;
import stanford.netdb.Model_Type;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Person;
import stanford.netdb.Privilege;
import stanford.netdb.Record;
import stanford.netdb.Record_Type;
import stanford.netdb.User;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.exceptions.Not_Implemented;
import stanford.netdb.exceptions.Record_Not_Found;

public class Model
extends Record<Model> {
    public static String template_name = "templates/toString/model.tmpl";
    private static final long serialVersionUID = 1L;
    private Integer id = null;
    private String name = null;
    private Make make = null;
    private Model_Type model_type = null;
    private Person modified_by = null;
    private Timestamp modified = null;

    public Model() {
        this.init();
    }

    public Model(String string, String string2) {
        this.init(string, string2);
    }

    public Model(String string, String string2, String string3) {
        this.init(string, string2, string3);
    }

    public Model(String string, Make make) {
        this.init(string, make);
    }

    public Model(String string, Make make, Model_Type model_Type) {
        this.init(string, make, model_Type);
    }

    public Model(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
        this.init();
    }

    public Model(NetDB_Datastore netDB_Datastore, String string, String string2) {
        super(netDB_Datastore);
        this.init(string, string2);
    }

    public Model(NetDB_Datastore netDB_Datastore, String string, String string2, String string3) {
        super(netDB_Datastore);
        this.init(string, string2, string3);
    }

    public Model(NetDB_Datastore netDB_Datastore, String string, Make make) {
        super(netDB_Datastore);
        this.init(string, make);
    }

    public Model(NetDB_Datastore netDB_Datastore, String string, Make make, Model_Type model_Type) {
        super(netDB_Datastore);
        this.init(string, make, model_Type);
    }

    private void init() {
        this.init((String)null, (Make)null, (Model_Type)null);
    }

    private void init(String string, String string2) {
        this.init(string, new Make(string2), null);
    }

    private void init(String string, String string2, String string3) {
        this.init(string, new Make(string2), new Model_Type(string3));
    }

    private void init(String string, Make make) {
        this.init(string, make, null);
    }

    private void init(String string, Make make, Model_Type model_Type) {
        this.init(string, make, model_Type, null, null);
    }

    private void init(String string, Make make, Model_Type model_Type, Person person, Timestamp timestamp) {
        if (string != null) {
            this.name(string);
        }
        if (make != null) {
            this.make(make);
        }
        if (model_Type != null) {
            this.model_type(model_Type);
        }
        if (person != null) {
            this.modified_by(person);
        }
        if (timestamp != null) {
            this.modified(timestamp);
        }
    }

    public Integer id() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.verify_or_die();
        return this.id;
    }

    public String name() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.name, NetDB.unset_string, "name");
        return this.name;
    }

    public Make make() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.make, NetDB.unset_make, "make");
        return this.make;
    }

    public Model_Type model_type() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.model_type, NetDB.unset_model_type, "model_type");
        return this.model_type;
    }

    private Person modified_by() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.modified_by, NetDB.unset_person, "modified_by");
        return this.modified_by;
    }

    private Timestamp modified() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.modified, NetDB.unset_timestamp, "modified");
        return this.modified;
    }

    @Override
    public String handle() {
        return this.make.handle() + " " + this.name;
    }

    public Model name(String string) {
        this.name = string;
        return this;
    }

    public Model make(String string) {
        return this.make(new Make(string));
    }

    public Model make(Make make) {
        this.make = make;
        return this;
    }

    public Model model_type(String string) {
        return this.model_type(new Model_Type(string));
    }

    public Model model_type(Model_Type model_Type) {
        this.model_type = model_Type;
        return this;
    }

    private Model modified_by(Person person) {
        this.modified_by = person;
        return this;
    }

    private Model modified(Timestamp timestamp) {
        this.modified = timestamp;
        return this;
    }

    @Override
    public Model unlink() {
        super.unlink();
        this.id = null;
        return this;
    }

    @Override
    public String single_value_attributes() {
        String string = "";
        String string2 = "";
        if (this.make != null) {
            string = this.make.single_value_attributes();
        }
        if (string2 != null) {
            string2 = this.model_type.single_value_attributes();
        }
        return this.name + " " + string + " " + string2;
    }

    @Override
    protected void initialize_member_data() {
        super.initialize_member_data();
        if (this.name == null) {
            this.name = NetDB.unset_string;
        }
        if (this.make == null) {
            this.make = NetDB.unset_make;
        }
        if (this.model_type == null) {
            this.model_type = NetDB.unset_model_type;
        }
        if (this.modified_by == null) {
            this.modified_by = NetDB.unset_person;
        }
        if (this.modified == null) {
            this.modified = NetDB.unset_timestamp;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        super.flag_field_as_defined(field);
        if (field == Field.NAME) {
            if (NetDB.unset_string.equals(this.name)) {
                this.name = null;
            }
        } else if (field == Field.MAKE) {
            if (this.make == NetDB.unset_make) {
                this.make = null;
            }
        } else if (field == Field.MODEL_TYPE) {
            if (this.model_type == NetDB.unset_model_type) {
                this.model_type = null;
            }
        } else if (field == Field.MODIFIED_BY) {
            if (this.modified_by == NetDB.unset_person) {
                this.modified_by = null;
            }
        } else if (field == Field.MODIFIED_AT && this.modified == NetDB.unset_timestamp) {
            this.modified = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        super.clear_default_member_data();
        if (NetDB.unset_string.equals(this.name)) {
            this.name = null;
        }
        if (this.make == NetDB.unset_make) {
            this.make = null;
        }
        if (this.model_type == NetDB.unset_model_type) {
            this.model_type = null;
        }
        if (this.modified_by == NetDB.unset_person) {
            this.modified_by = null;
        }
        if (this.modified == NetDB.unset_timestamp) {
            this.modified = null;
        }
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return Record.toString(fORMAT, template_name, "model", this, bl);
    }

    protected static Model extract(NetDB_Datastore netDB_Datastore, Hashtable hashtable) {
        Model model = new Model(netDB_Datastore);
        model.flag_as_system_created();
        model.extract(hashtable);
        return model;
    }

    protected Model extract(Hashtable hashtable) {
        if (hashtable == null) {
            return this;
        }
        String string = (String)hashtable.get("id");
        if (string != null) {
            this.id = Integer.parseInt(string);
        }
        hashtable.remove("id");
        this.name((String)hashtable.get("model"));
        hashtable.remove("model");
        this.make((String)hashtable.get("make"));
        hashtable.remove("make");
        this.model_type((String)hashtable.get("type"));
        hashtable.remove("type");
        this.make.flag_as_system_created();
        this.model_type.flag_as_system_created();
        NetDB.unhandled_keys(hashtable, "Model.extract");
        return this;
    }

    protected Boolean extract_make_and_model(String string) {
        int n = 0;
        Boolean bl = false;
        while (!bl.booleanValue() && n != -1) {
            n = string.indexOf(" ", n);
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            try {
                this.verify_or_die(string2, string3, false);
                Make make = new Make(this.datastore);
                make.flag_as_system_created();
                make.name(string2);
                this.name(string3);
                this.make(make);
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n <= 0) continue;
            ++n;
        }
        return bl;
    }

    private void verify_or_die() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.id = this.verify_or_die(this.make.handle(), this.name, true);
    }

    private Integer verify_or_die(String string, String string2, Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.datastore == null) {
            this.datastore = this.get_datastore();
        }
        if (this.id != null && this.id != NetDB.unset_integer) {
            return this.id;
        }
        return Model.verify_or_die(this.datastore, string, string2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Integer verify_or_die(NetDB_Datastore netDB_Datastore, String string, String string2, Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        if (bl == null) {
            bl = true;
        }
        Integer n = null;
        String string3 = "";
        try {
            string3 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            n = netDB_Datastore.model().verify_or_die(string3, string, string2);
            if (n == null) {
                throw new Record_Not_Found("'" + string + " " + string2 + "' was not found in the database.");
            }
        }
        catch (Exception exception) {
            if (bl.booleanValue()) {
                throw exception;
            }
        }
        finally {
            netDB_Datastore.rollback_transaction(string3);
        }
        return n;
    }

    public static Boolean has_access() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(Record_Type.MODEL);
    }

    public static Boolean has_access(User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(user, Record_Type.MODEL);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, Record_Type.MODEL);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, user, Record_Type.MODEL);
    }

    public static Model load(String string, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return Model.load(NetDB.default_datastore(), string, string2);
    }

    public static Model load(NetDB_Datastore netDB_Datastore, String string, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        Model model = new Model(netDB_Datastore);
        model.load_object(netDB_Datastore, string, string2);
        return model;
    }

    protected void load_object(NetDB_Datastore netDB_Datastore, String string, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        if (string2 == null || string2.trim().equals("") || string == null || string.trim().equals("")) {
            throw Insufficient_Information.missing_handle();
        }
        this.id = this.verify_or_die(string, string2, true);
        Hashtable hashtable = null;
        Hashtable hashtable2 = netDB_Datastore.model().list(string2);
        if (hashtable2 != null) {
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                Hashtable hashtable3 = (Hashtable)hashtable2.get(string3);
                if (!new Integer((String)hashtable3.get("id")).equals(this.id)) continue;
                hashtable = hashtable3;
                break;
            }
        }
        if (hashtable == null) {
            throw new Record_Not_Found("'" + string + " " + string2 + "' was not found in the database.");
        }
        this.extract(hashtable);
        this.flag_as_system_created().flag_as_loaded();
    }

    @Override
    protected void load_object(String string) throws Not_Implemented {
        throw new Not_Implemented("This class cannot be loaded with this method.");
    }

    public static Collection<Model> list() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Model.list(NetDB.default_datastore());
    }

    public static Collection<Model> list(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Model.list(NetDB.default_datastore(), string);
    }

    public static Collection<Model> list(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Model.list(netDB_Datastore, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Model> list(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Vector<Model> vector = new Vector<Model>();
        Hashtable hashtable = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            hashtable = string != null ? netDB_Datastore.model().list(string2, string) : netDB_Datastore.model().list(string2);
        }
        finally {
            netDB_Datastore.rollback_transaction(string2);
        }
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                Model model = Model.extract(netDB_Datastore, (Hashtable)hashtable.get(string3));
                model.flag_as_loaded();
                vector.add(model);
            }
        }
        Collections.sort(vector);
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Boolean bl = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            this.verify_or_die();
            netDB_Datastore.model().delete(string, this.id);
            this.flag_as_modified().flag_as_user_created();
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
    }

    public static void delete(String string, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Model.delete(NetDB.default_datastore(), string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(NetDB_Datastore netDB_Datastore, String string, String string2) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Boolean bl = null;
        String string3 = "";
        try {
            string3 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            netDB_Datastore.model().delete(string3, Model.verify_or_die(netDB_Datastore, string, string2, true));
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string3);
                } else {
                    netDB_Datastore.end_transaction(string3);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model commit(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        this.bind(netDB_Datastore);
        Boolean bl = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            Insufficient_Information.defined_or_die(this.make, "make");
            if (this.created_by_user().booleanValue()) {
                Hashtable hashtable = null;
                hashtable = this.model_type != null ? netDB_Datastore.model().insert(string, this.make.handle(), this.name, this.model_type.handle()) : netDB_Datastore.model().insert(string, this.make.handle(), this.name);
                this.id = new Integer((String)hashtable.get("id"));
            } else {
                this.verify_or_die();
                if (this.model_type != null) {
                    netDB_Datastore.model().update(string, this.id, this.make.handle(), this.name, this.model_type.handle());
                } else {
                    netDB_Datastore.model().update(string, this.id, this.make.handle(), this.name);
                }
            }
            this.flag_as_system_created().flag_as_loaded();
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model supplant(Model model) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        Boolean bl = null;
        String string = "";
        try {
            string = this.datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            this.verify_or_die();
            if (this.created_by_user().booleanValue()) {
                throw new Exception("You must load the record that is being supplanted.");
            }
            this.datastore.model().supplant(string, this.id, model.make.handle(), model.name());
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    this.datastore.rollback_transaction(string);
                } else {
                    this.datastore.end_transaction(string);
                }
            }
        }
        return model;
    }
}

