/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import stanford.netdb.IP.IPaddress;
import stanford.netdb.Log_Entry;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.State;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.middleware.Full_Search;
import stanford.netdb.middleware.Result_Hash;
import stanford.netdb.util.TZ_Timestamp;

public class Log_Search_Parameters
extends Full_Search<Log_Entry> {
    private static final long serialVersionUID = 1L;
    private static final String INCLUDE_ACTION_DATE = "displayOrder.tst.1.Date of Action";
    private static final String INCLUDE_RECORD_NAME = "displayOrder.txt.2.Record Name";
    private static final String INCLUDE_RECORD_ID = "displayOrder.num.3.Record ID";
    private static final String INCLUDE_RECORD_TYPE = "displayOrder.txt.4.Record Type";
    private static final String INCLUDE_IP_ADDRESS = "displayOrder.ip.5.IP Address";
    private static final String INCLUDE_NODE_STATE = "displayOrder.txt.6.Node State";
    private static final String INCLUDE_USER = "displayOrder.txt.7.User";
    private static final String INCLUDE_ACTION = "displayOrder.txt.8.Action";
    private static final String ID_COLUMN = "ID";
    private static final String HANDLE_COLUMN = "handle";
    private static final String DATE_OF_ACTION_COLUMN = "Date of Action";
    private static final String RECORD_NAME_COLUMN = "Record Name";
    private static final String RECORD_ID_COLUMN = "Record ID";
    private static final String RECORD_TYPE_COLUMN = "Record Type";
    private static final String IP_ADDRESS_COLUMN = "IP Address";
    private static final String NODE_STATE_COLUMN = "Node State";
    private static final String USER_COLUMN = "User";
    private static final String ACTION_COLUMN = "Action";
    private String action_after = "";
    private String action_before = "";
    private String record_name = "";
    private String record_id = "";
    private Log_Entry.RECORD_TYPE record_type = Log_Entry.RECORD_TYPE.NODE;
    private String ip_address = "";
    private String node_state = "";
    private String user_netid = "";
    private String user_name = "";
    private Hashtable<Log_Entry.ACTION, Boolean> actions = new Hashtable();

    public Log_Search_Parameters() {
        this.include_fields.put(INCLUDE_ACTION_DATE, Boolean.FALSE);
        this.include_fields.put(INCLUDE_RECORD_NAME, Boolean.FALSE);
        this.include_fields.put(INCLUDE_RECORD_ID, Boolean.FALSE);
        this.include_fields.put(INCLUDE_RECORD_TYPE, Boolean.FALSE);
        this.include_fields.put(INCLUDE_IP_ADDRESS, Boolean.FALSE);
        this.include_fields.put(INCLUDE_NODE_STATE, Boolean.FALSE);
        this.include_fields.put(INCLUDE_USER, Boolean.FALSE);
        this.include_fields.put(INCLUDE_ACTION, Boolean.FALSE);
    }

    public String after() {
        return this.action_after;
    }

    public String before() {
        return this.action_before;
    }

    public Boolean include_date() {
        return (Boolean)this.include_fields.get(INCLUDE_ACTION_DATE);
    }

    public String record_name() {
        return this.record_name;
    }

    public Boolean include_record_name() {
        return (Boolean)this.include_fields.get(INCLUDE_RECORD_NAME);
    }

    public String recordID() {
        return this.record_id();
    }

    public String record_id() {
        return this.record_id;
    }

    public Boolean include_recordID() {
        return this.include_record_id();
    }

    public Boolean include_record_id() {
        return (Boolean)this.include_fields.get(INCLUDE_RECORD_ID);
    }

    public Log_Entry.RECORD_TYPE record_type() {
        return this.record_type;
    }

    public Boolean include_record_type() {
        return (Boolean)this.include_fields.get(INCLUDE_RECORD_TYPE);
    }

    public String IP_address() {
        return this.ip_address();
    }

    public String ip_address() {
        return this.ip_address;
    }

    public Boolean include_IP_address() {
        return this.include_ip_address();
    }

    public Boolean include_ip_address() {
        return (Boolean)this.include_fields.get(INCLUDE_IP_ADDRESS);
    }

    public String node_state() {
        return this.node_state;
    }

    public Boolean include_node_state() {
        return (Boolean)this.include_fields.get(INCLUDE_NODE_STATE);
    }

    public String user_netID() {
        return this.user_netid();
    }

    public String user_netid() {
        return this.user_netid;
    }

    public String user_name() {
        return this.user_name;
    }

    public Boolean include_user() {
        return (Boolean)this.include_fields.get(INCLUDE_USER);
    }

    public Collection<Log_Entry.ACTION> actions() {
        Vector<Log_Entry.ACTION> vector = new Vector<Log_Entry.ACTION>();
        for (Log_Entry.ACTION aCTION : this.actions.keySet()) {
            if (!this.actions.get((Object)aCTION).booleanValue()) continue;
            vector.add(aCTION);
        }
        return vector;
    }

    public Boolean include_actions() {
        return (Boolean)this.include_fields.get(INCLUDE_ACTION);
    }

    public Log_Search_Parameters after(String string) {
        if (string == null) {
            string = "";
        }
        this.action_after = string;
        return this;
    }

    public Log_Search_Parameters after(String string, Boolean bl) {
        this.after(string);
        this.include_date(bl);
        return this;
    }

    public Log_Search_Parameters before(String string) {
        if (string == null) {
            string = "";
        }
        this.action_before = string;
        return this;
    }

    public Log_Search_Parameters before(String string, Boolean bl) {
        this.before(string);
        this.include_date(bl);
        return this;
    }

    public Log_Search_Parameters include_date(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_ACTION_DATE, bl);
        return this;
    }

    public Log_Search_Parameters record_name(String string) {
        if (string == null) {
            string = "";
        }
        this.record_name = string;
        return this;
    }

    public Log_Search_Parameters record_name(String string, Boolean bl) {
        this.record_name(string);
        this.include_record_name(bl);
        return this;
    }

    public Log_Search_Parameters include_record_name(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_RECORD_NAME, bl);
        return this;
    }

    public Log_Search_Parameters recordID(String string) {
        return this.record_id(string);
    }

    public Log_Search_Parameters record_id(String string) {
        if (string == null) {
            string = "";
        }
        this.record_id = string;
        return this;
    }

    public Log_Search_Parameters recordID(String string, Boolean bl) {
        return this.record_id(string, bl);
    }

    public Log_Search_Parameters record_id(String string, Boolean bl) {
        this.record_id(string);
        this.include_record_id(bl);
        return this;
    }

    public Log_Search_Parameters include_recordID(Boolean bl) {
        return this.include_record_id(bl);
    }

    public Log_Search_Parameters include_record_id(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_RECORD_ID, bl);
        return this;
    }

    public Log_Search_Parameters record_type(Log_Entry.RECORD_TYPE rECORD_TYPE) {
        if (rECORD_TYPE == null) {
            rECORD_TYPE = Log_Entry.RECORD_TYPE.NODE;
        }
        this.record_type = rECORD_TYPE;
        return this;
    }

    public Log_Search_Parameters record_type(Log_Entry.RECORD_TYPE rECORD_TYPE, Boolean bl) {
        this.record_type(rECORD_TYPE);
        this.include_record_type(bl);
        return this;
    }

    public Log_Search_Parameters include_record_type(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_RECORD_TYPE, bl);
        return this;
    }

    public Log_Search_Parameters IP_address(String string) {
        return this.ip_address(string);
    }

    public Log_Search_Parameters ip_address(String string) {
        if (string == null) {
            string = "";
        }
        this.ip_address = string;
        return this;
    }

    public Log_Search_Parameters IP_address(String string, Boolean bl) {
        return this.ip_address(string, bl);
    }

    public Log_Search_Parameters ip_address(String string, Boolean bl) {
        this.ip_address(string);
        this.include_ip_address(bl);
        return this;
    }

    public Log_Search_Parameters include_IP_address(Boolean bl) {
        return this.include_ip_address(bl);
    }

    public Log_Search_Parameters include_ip_address(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_IP_ADDRESS, bl);
        return this;
    }

    public Log_Search_Parameters node_state(String string) {
        if (string == null) {
            string = "";
        }
        this.node_state = string;
        return this;
    }

    public Log_Search_Parameters node_state(String string, Boolean bl) {
        this.node_state(string);
        this.include_node_state(bl);
        return this;
    }

    public Log_Search_Parameters include_node_state(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_NODE_STATE, bl);
        return this;
    }

    public Log_Search_Parameters user_netID(String string) {
        return this.user_netid(string);
    }

    public Log_Search_Parameters user_netid(String string) {
        if (string == null) {
            string = "";
        }
        this.user_netid = string;
        return this;
    }

    public Log_Search_Parameters user_netID(String string, Boolean bl) {
        return this.user_netid(string, bl);
    }

    public Log_Search_Parameters user_netid(String string, Boolean bl) {
        this.user_netid(string);
        this.include_user(bl);
        return this;
    }

    public Log_Search_Parameters user_name(String string) {
        if (string == null) {
            string = "";
        }
        this.user_name = string;
        return this;
    }

    public Log_Search_Parameters user_name(String string, Boolean bl) {
        this.user_name(string);
        this.include_user(bl);
        return this;
    }

    public Log_Search_Parameters include_user(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_USER, bl);
        return this;
    }

    public Log_Search_Parameters actions(Collection<Log_Entry.ACTION> collection) {
        if (collection == null) {
            return this;
        }
        this.actions = new Hashtable();
        for (Log_Entry.ACTION aCTION : collection) {
            this.actions.put(aCTION, true);
        }
        return this;
    }

    public Log_Search_Parameters actions(Collection<Log_Entry.ACTION> collection, Boolean bl) {
        this.actions(collection);
        this.include_actions(bl);
        return this;
    }

    public Log_Search_Parameters include_actions(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_ACTION, bl);
        return this;
    }

    @Override
    protected String get_SQL(String string) throws Exception {
        Hashtable<String, String> hashtable = this.legacy_search_params();
        if (hashtable.get("rb.b.recordtype") == null) {
            throw new Exception("Please select record types to search for.");
        }
        if (hashtable.get("cb.i.Delete") == null && hashtable.get("cb.i.Add") == null && hashtable.get("cb.i.Update") == null) {
            throw new Exception("Please select actions to search for.");
        }
        String string2 = "SELECT DISTINCT id \"ID\", to_char(id) \"handle\"" + (hashtable.get(INCLUDE_ACTION_DATE).equals("-1") ? "" : ", logdate \"Date of Action\"") + (hashtable.get(INCLUDE_RECORD_NAME).equals("-1") ? "" : ", record_name \"Record Name\"") + (hashtable.get(INCLUDE_RECORD_ID).equals("-1") ? "" : ", to_char(record_id) \"Record ID\"") + (hashtable.get(INCLUDE_RECORD_TYPE).equals("-1") ? "" : ", recordtype_display \"Record Type\"") + (hashtable.get(INCLUDE_IP_ADDRESS).equals("-1") ? "" : ", IPaddress_txt \"IP Address\"") + (hashtable.get(INCLUDE_NODE_STATE).equals("-1") ? "" : ", state \"Node State\"") + (hashtable.get(INCLUDE_USER).equals("-1") ? "" : ", name || ' (' || netid || ')' \"User\"") + (hashtable.get(INCLUDE_ACTION).equals("-1") ? "" : ", action \"Action\"") + " FROM " + hashtable.get("fs.table") + " WHERE ID IN ( SELECT unique(id) FROM ";
        Vector vector = new Vector();
        this.assmDisplayOrder(vector, hashtable);
        Vector<Exception> vector2 = new Vector<Exception>();
        string2 = string2 + this.assmCommonSQL(hashtable, vector2) + " ) ";
        return string2;
    }

    protected Vector<Log_Entry> search(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        Vector vector = this.perform_search(netDB_Datastore);
        Vector<Log_Entry> vector2 = new Vector<Log_Entry>();
        if (vector != null && vector.size() > 0 && vector.get(0) instanceof Result_Hash) {
            vector2 = this.process_results(netDB_Datastore, (Result_Hash)vector.get(0));
        }
        return vector2;
    }

    @Override
    protected Vector<Log_Entry> process_results(NetDB_Datastore netDB_Datastore, Result_Hash result_Hash) throws Exception {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = 0;
        for (String object2 : result_Hash.get_vector("column_names")) {
            if (object2.equals(ID_COLUMN)) {
                n = n11;
            } else if (object2.equals(HANDLE_COLUMN)) {
                n2 = n11;
            } else if (object2.equals(DATE_OF_ACTION_COLUMN)) {
                n3 = n11;
            } else if (object2.equals(RECORD_NAME_COLUMN)) {
                n4 = n11;
            } else if (object2.equals(RECORD_ID_COLUMN)) {
                n5 = n11;
            } else if (object2.equals(RECORD_TYPE_COLUMN)) {
                n6 = n11;
            } else if (object2.equals(IP_ADDRESS_COLUMN)) {
                n7 = n11;
            } else if (object2.equals(NODE_STATE_COLUMN)) {
                n8 = n11;
            } else if (object2.equals(USER_COLUMN)) {
                n9 = n11;
            } else if (object2.equals(ACTION_COLUMN)) {
                n10 = n11;
            } else {
                netDB_Datastore.logger().severe("'" + object2 + "' was encountered and not expected.  The data will not be processed.  The '" + this.getClass().getName() + "' class will need to be updated before it will be processed.");
            }
            ++n11;
        }
        Hashtable hashtable = new Hashtable();
        Vector<Log_Entry> vector = new Vector<Log_Entry>();
        for (Vector vector2 : (Vector)result_Hash.get("resultSet")) {
            Object object;
            Log_Entry log_Entry = null;
            BigDecimal bigDecimal = (BigDecimal)vector2.get(n);
            int n12 = -1;
            if (bigDecimal != null) {
                n12 = bigDecimal.intValue();
            }
            if ((log_Entry = (Log_Entry)hashtable.get(n12)) == null) {
                log_Entry = new Log_Entry(netDB_Datastore, n12);
                vector.add(log_Entry);
                hashtable.put(n12, log_Entry);
            }
            if (n3 != -1 && (object = (TZ_Timestamp)vector2.get(n3)) != null) {
                log_Entry.date((Timestamp)object);
            }
            if (n4 != -1) {
                log_Entry.add_record_name((String)vector2.get(n4));
            }
            if (n5 != -1) {
                log_Entry.record_id(new Integer((String)vector2.get(n5)));
            }
            if (n6 != -1) {
                log_Entry.record_type(Log_Entry.RECORD_TYPE.find((String)vector2.get(n6)));
            }
            if (n7 != -1 && (object = new IPaddress((String)vector2.get(n7))) != null) {
                log_Entry.add_ip_address((IPaddress)object);
            }
            if (n8 != -1) {
                object = new State(netDB_Datastore);
                ((State)object).name((String)vector2.get(n8));
                ((NetDB)object).flag_as_system_created();
                if (object != null) {
                    log_Entry.node_state((State)object);
                }
            }
            if (n9 != -1 && (object = (String)vector2.get(n9)) != null && ((String)(object = ((String)object).trim())).length() > 0) {
                log_Entry.user((String)object);
            }
            if (n10 == -1) continue;
            log_Entry.action(Log_Entry.ACTION.find((String)vector2.get(n10)));
        }
        return vector;
    }

    public Hashtable<String, String> legacy_search_params() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("fs.table", "FS_Log");
        for (String object : this.include_fields.keySet()) {
            String string = "-1";
            if (((Boolean)this.include_fields.get(object)).booleanValue()) {
                string = "1";
            }
            hashtable.put(object, string);
        }
        for (Log_Entry.ACTION aCTION : this.actions.keySet()) {
            if (!this.actions.get((Object)aCTION).booleanValue()) continue;
            hashtable.put(aCTION.fs_field(), "groupB.action = '" + aCTION.fs_value() + "'");
        }
        hashtable.put("tst.logdate >=", this.action_after);
        hashtable.put("tst.logdate <=", this.action_before);
        hashtable.put("txt.lower(record_name)", this.record_name.toLowerCase());
        hashtable.put("num.record_id", this.record_id);
        hashtable.put("rb.b.recordtype", "'" + this.record_type.fs_value() + "'");
        hashtable.put("ip.IPaddress", this.ip_address);
        hashtable.put("txt.lower(state)", this.node_state.toLowerCase());
        hashtable.put("txt.lower(netid)", this.user_netid.toLowerCase());
        hashtable.put("txt.lower(name)", this.user_name.toLowerCase());
        return hashtable;
    }
}

