/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import stanford.netdb.Field;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Privilege;
import stanford.netdb.Record;
import stanford.netdb.Record_Type;
import stanford.netdb.User;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.exceptions.Record_Not_Found;

public class Location
extends Record<Location> {
    public static String template_name = "templates/toString/location.tmpl";
    private static final long serialVersionUID = 1L;
    private Integer id = null;
    private String name = null;
    private String site = null;
    private String code = null;

    public Location() {
        this.init();
    }

    public Location(String string, String string2, String string3) {
        this.init(string, string2, string3);
    }

    public Location(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
        this.init();
    }

    public Location(NetDB_Datastore netDB_Datastore, String string, String string2, String string3) {
        super(netDB_Datastore);
        this.init(string, string2, string3);
    }

    private void init() {
        this.init(null, null, null);
    }

    private void init(String string, String string2, String string3) {
        if (string != null) {
            this.name(string);
        }
        if (string2 != null) {
            this.site(string2);
        }
        if (string3 != null) {
            this.code(string3);
        }
    }

    protected Integer id() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.verify_or_die();
        return this.id;
    }

    public String name() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.name, NetDB.unset_string, "name");
        return this.name;
    }

    public String site() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.site, NetDB.unset_string, "site");
        return this.site;
    }

    public String code() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.code, NetDB.unset_string, "code");
        return this.code;
    }

    @Override
    public String handle() {
        return this.name;
    }

    public Location name(String string) {
        this.name = string;
        return this;
    }

    public Location site(String string) {
        this.site = string;
        return this;
    }

    public Location code(String string) {
        this.code = string;
        return this;
    }

    @Override
    public Location unlink() {
        super.unlink();
        this.id = null;
        return this;
    }

    @Override
    public String single_value_attributes() {
        return this.name + " " + this.site + " " + this.code;
    }

    @Override
    protected void initialize_member_data() {
        super.initialize_member_data();
        if (this.name == null) {
            this.name = NetDB.unset_string;
        }
        if (this.site == null) {
            this.site = NetDB.unset_string;
        }
        if (this.code == null) {
            this.code = NetDB.unset_string;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        super.flag_field_as_defined(field);
        if (field == Field.NAME) {
            if (NetDB.unset_string.equals(this.name)) {
                this.name = null;
            }
        } else if (field == Field.SITE) {
            if (NetDB.unset_string.equals(this.site)) {
                this.site = null;
            }
        } else if (field == Field.CODE && NetDB.unset_string.equals(this.code)) {
            this.code = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        super.clear_default_member_data();
        if (NetDB.unset_string.equals(this.name)) {
            this.name = null;
        }
        if (NetDB.unset_string.equals(this.site)) {
            this.site = null;
        }
        if (NetDB.unset_string.equals(this.code)) {
            this.code = null;
        }
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return Record.toString(fORMAT, template_name, "location", this, bl);
    }

    protected static Location extract(NetDB_Datastore netDB_Datastore, Hashtable hashtable) {
        Location location = new Location(netDB_Datastore);
        location.flag_as_system_created();
        location.extract(hashtable);
        return location;
    }

    protected Location extract(Hashtable hashtable) {
        if (hashtable == null) {
            return this;
        }
        this.name((String)hashtable.get("location"));
        hashtable.remove("location");
        this.site((String)hashtable.get("site"));
        hashtable.remove("site");
        this.code((String)hashtable.get("code"));
        hashtable.remove("code");
        if (this.name == null || this.name.trim().equals("")) {
            this.name((String)hashtable.get("name"));
            hashtable.remove("name");
        }
        NetDB.unhandled_keys(hashtable, "Location.extract");
        return this;
    }

    private void verify_or_die() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.id = this.verify_or_die(this.handle());
    }

    private Integer verify_or_die(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.datastore == null) {
            this.datastore = this.get_datastore();
        }
        if (this.id != null && this.id != NetDB.unset_integer) {
            return this.id;
        }
        return Location.verify_or_die(this.datastore, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Integer verify_or_die(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            Integer n = netDB_Datastore.location().verify_or_die(string2, string);
            return n;
        }
        finally {
            netDB_Datastore.rollback_transaction(string2);
        }
    }

    public static Boolean has_access() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(Record_Type.LOCATION);
    }

    public static Boolean has_access(User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(user, Record_Type.LOCATION);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, Record_Type.LOCATION);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, user, Record_Type.LOCATION);
    }

    public static Location load(String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return Location.load(NetDB.default_datastore(), string);
    }

    public static Location load(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        Location location = new Location(netDB_Datastore);
        location.load_object(string);
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void load_object(String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        if (string == null || string.trim().equals("")) {
            throw Insufficient_Information.missing_handle();
        }
        if (this.id == null) {
            this.id = this.verify_or_die(string);
            if (this.id == null) {
                throw new Record_Not_Found("'" + string + "' was not found in the database.");
            }
        }
        String string2 = "";
        Hashtable hashtable = null;
        try {
            string2 = this.datastore.start_transaction(NetDB.current_method_name());
            hashtable = this.datastore.location().list(string2, string);
        }
        finally {
            this.datastore.rollback_transaction(string2);
        }
        Set set = hashtable.keySet();
        if (set.size() > 1) {
            throw new Exception("Expected one result, '" + set.size() + "' found.");
        }
        for (String string3 : set) {
            if (!string3.equalsIgnoreCase(string)) continue;
            this.extract((Hashtable)hashtable.get(string3));
        }
        this.flag_as_system_created().flag_as_loaded();
    }

    public static Collection<Location> list() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Location.list(NetDB.default_datastore());
    }

    public static Collection<Location> list(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Location.list(NetDB.default_datastore(), string);
    }

    public static Collection<Location> list(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Location.list(netDB_Datastore, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Location> list(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Vector<Location> vector = new Vector<Location>();
        Hashtable hashtable = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            hashtable = string != null ? netDB_Datastore.location().list(string2, string) : netDB_Datastore.location().list(string2);
        }
        finally {
            netDB_Datastore.rollback_transaction(string2);
        }
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                Location location = Location.extract(netDB_Datastore, (Hashtable)hashtable.get(string3));
                vector.add(location);
            }
        }
        Collections.sort(vector);
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Boolean bl = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            this.verify_or_die();
            netDB_Datastore.location().delete(string, this.id);
            this.flag_as_modified().flag_as_user_created();
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
    }

    public static void delete(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Location.delete(NetDB.default_datastore(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Boolean bl = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            Location location = new Location(netDB_Datastore);
            location.id = Location.verify_or_die(netDB_Datastore, string);
            location.delete();
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string2);
                } else {
                    netDB_Datastore.end_transaction(string2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Location commit(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        this.bind(netDB_Datastore);
        Location location = null;
        Boolean bl = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            Insufficient_Information.defined_or_die(this.name, "name");
            Insufficient_Information.defined_or_die(this.site, "site");
            Insufficient_Information.defined_or_die(this.code, "code");
            if (this.created_by_user().booleanValue()) {
                location = new Location();
                Hashtable hashtable = netDB_Datastore.location().insert(string, this.name, this.site, this.code);
                this.id = new Integer((String)hashtable.get("id"));
            } else {
                location = Location.load(netDB_Datastore, netDB_Datastore.location().handle(string, this.id));
                if (this.compare(location) != 0) {
                    netDB_Datastore.location().update(string, this.id, this.name, this.site, this.code);
                }
            }
            this.flag_as_system_created().flag_as_loaded();
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
        return this;
    }
}

