/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import stanford.netdb.A_Name;
import stanford.netdb.Attribute;
import stanford.netdb.Comparison_Result;
import stanford.netdb.Field;
import stanford.netdb.Group;
import stanford.netdb.IP.IPaddress;
import stanford.netdb.Interface_IP_Address;
import stanford.netdb.Multi_Value_Attribute;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Network;
import stanford.netdb.Node;
import stanford.netdb.Record_Type;
import stanford.netdb.User;
import stanford.netdb.exceptions.Exception_Formatter;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.util.TZ_Timestamp;

public class IP_Address
extends NetDB<IP_Address> {
    public static String template_name = "templates/toString/ip_address.tmpl";
    private static final long serialVersionUID = 1L;
    protected static final IP_Address EMPTY = new IP_Address();
    private Integer id = null;
    private IPaddress ip = null;
    private Boolean active = null;
    private TZ_Timestamp reserved = null;
    private Integer reserved_by = null;
    private Multi_Value_Attribute<A_Name> names = null;

    protected IP_Address() {
        this.init();
    }

    public IP_Address(String string) throws Exception {
        this(new IPaddress(string));
    }

    public IP_Address(IPaddress iPaddress) {
        this.init(iPaddress);
    }

    public IP_Address(IPaddress iPaddress, Boolean bl) {
        this.init(iPaddress, bl);
    }

    protected IP_Address(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
        this.init();
    }

    public IP_Address(NetDB_Datastore netDB_Datastore, String string) throws Exception {
        this(netDB_Datastore, new IPaddress(string));
    }

    public IP_Address(NetDB_Datastore netDB_Datastore, IPaddress iPaddress) {
        super(netDB_Datastore);
        this.init(iPaddress);
    }

    public IP_Address(NetDB_Datastore netDB_Datastore, IPaddress iPaddress, Boolean bl) {
        super(netDB_Datastore);
        this.init(iPaddress, bl);
    }

    private void init() {
        this.init(null, true);
    }

    private void init(IPaddress iPaddress) {
        this.init(iPaddress, true);
    }

    private void init(IPaddress iPaddress, Boolean bl) {
        if (iPaddress != null) {
            this.address(iPaddress);
        }
        if (bl != null) {
            this.active(bl);
        }
    }

    protected IP_Address new_instance(NetDB_Datastore netDB_Datastore, String string) throws Exception {
        return new IP_Address(netDB_Datastore, string);
    }

    protected Integer id() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.verify_or_die();
        return this.id;
    }

    public IPaddress address() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.ip, NetDB.unset_address, "address");
        return this.ip;
    }

    public Boolean active() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.active, NetDB.unset_boolean, "active");
        return this.active;
    }

    public Boolean is_active() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this.active();
    }

    protected Integer active_int() {
        if (this.active.booleanValue()) {
            return new Integer(1);
        }
        return new Integer(0);
    }

    public Collection<A_Name> names() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.names, NetDB.unset_mva_a_name, "names");
        if (this.names == null || this.names == NetDB.unset_mva_a_name) {
            return new Multi_Value_Attribute().all_values();
        }
        return this.names.all_values();
    }

    public Boolean is_reserved() {
        if (this.reserved != null) {
            return true;
        }
        return false;
    }

    @Override
    public String handle() {
        return this.handle(0);
    }

    public String handle(int n) {
        IPaddress iPaddress = this.ip;
        if (iPaddress != null) {
            return iPaddress.toString(n);
        }
        return null;
    }

    protected IP_Address id(Integer n) {
        this.id = n;
        return this;
    }

    public IP_Address address(String string) throws Exception {
        return this.address(new IPaddress(string));
    }

    public IP_Address address(IPaddress iPaddress) {
        if (this.ip != null && this.ip != NetDB.unset_address && (iPaddress == null || iPaddress != null && iPaddress.compareTo(this.ip) != 0)) {
            this.unbind();
        }
        this.ip = iPaddress;
        return this;
    }

    public IP_Address active(Boolean bl) {
        this.active = bl;
        return this;
    }

    public IP_Address activate() {
        return this.active(true);
    }

    public IP_Address deactivate() {
        return this.active(false);
    }

    public IP_Address add_name(String string) {
        return this.add_name(new A_Name(string));
    }

    public IP_Address add_name(String string, String string2) {
        return this.add_name(new A_Name(string, string2));
    }

    public IP_Address add_name(A_Name a_Name) {
        if (this.names == null || this.names == NetDB.unset_mva_a_name) {
            this.names = new Multi_Value_Attribute();
        }
        a_Name.flag_as_user_created();
        this.names.add(a_Name);
        return this;
    }

    public IP_Address add_names(Collection<A_Name> collection) {
        Iterator<A_Name> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add_name(iterator.next());
        }
        return this;
    }

    public IP_Address remove_name(String string) {
        return this.remove_name(new A_Name(string));
    }

    public IP_Address remove_name(String string, String string2) {
        return this.remove_name(new A_Name(string, string2));
    }

    public IP_Address remove_name(A_Name a_Name) {
        if (this.names != null) {
            this.names.remove(a_Name, (Boolean)true);
        }
        return this;
    }

    public IP_Address remove_names(Collection<A_Name> collection) {
        Iterator<A_Name> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.remove_name(iterator.next());
        }
        return this;
    }

    @Override
    public IP_Address bind(NetDB_Datastore netDB_Datastore) throws No_Datastore_Defined {
        super.bind(netDB_Datastore);
        this.bind_children(this.names, netDB_Datastore);
        return this;
    }

    @Override
    public IP_Address unbind() {
        super.unbind();
        this.unbind_children(this.names);
        return this;
    }

    @Override
    public IP_Address unlink() {
        super.unlink();
        this.unlink_children(this.names);
        this.id = null;
        return this;
    }

    @Override
    public int compareTo(IP_Address iP_Address) {
        IPaddress iPaddress = this.ip;
        IPaddress iPaddress2 = null;
        if (iP_Address != null) {
            iPaddress2 = iP_Address.ip;
        }
        if (iPaddress == null && iPaddress2 == null) {
            return 0;
        }
        if (iPaddress == null) {
            return -1;
        }
        if (iPaddress2 == null) {
            return 1;
        }
        return iPaddress.compareTo(iPaddress2);
    }

    @Override
    public String single_value_attributes() {
        String string = "";
        if (this.ip != null) {
            string = this.ip.toString();
        }
        return string + " " + this.active;
    }

    @Override
    protected void initialize_member_data() {
        if (this.ip == null) {
            this.ip = NetDB.unset_address;
        }
        if (this.active == null) {
            this.active = NetDB.unset_boolean;
        }
        if (this.reserved == null) {
            this.reserved = NetDB.unset_tz_timestamp;
        }
        if (this.reserved_by == null) {
            this.reserved_by = NetDB.unset_integer;
        }
        if (this.names == null) {
            this.names = NetDB.unset_mva_a_name;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        if (field == Field.ADDRESS) {
            if (this.ip == NetDB.unset_address) {
                this.ip = null;
            }
        } else if (field == Field.ACTIVE) {
            if (this.active == NetDB.unset_boolean) {
                this.active = null;
            }
        } else if (field == Field.RESERVED) {
            if (this.reserved == NetDB.unset_tz_timestamp) {
                this.reserved = null;
            }
        } else if (field == Field.RESERVED_BY) {
            if (this.reserved_by == NetDB.unset_integer) {
                this.reserved_by = null;
            }
        } else if (field == Field.NAME && this.names == NetDB.unset_mva_a_name) {
            this.names = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        if (this.ip == NetDB.unset_address) {
            this.ip = null;
        }
        if (this.active == NetDB.unset_boolean) {
            this.active = null;
        }
        if (this.reserved == NetDB.unset_tz_timestamp) {
            this.reserved = null;
        }
        if (this.reserved_by == NetDB.unset_integer) {
            this.reserved_by = null;
        }
        if (this.names == NetDB.unset_mva_a_name) {
            this.names = null;
        }
    }

    @Override
    protected NetDB flag_as_user_created() {
        super.flag_as_user_created();
        if (this.names != null) {
            for (A_Name a_Name : this.names.all_values(true)) {
                a_Name.flag_as_user_created();
            }
        }
        return this;
    }

    @Override
    protected NetDB flag_as_modified() {
        super.flag_as_modified();
        if (this.names != null) {
            for (A_Name a_Name : this.names.all_values(true)) {
                a_Name.flag_as_modified();
            }
        }
        return this;
    }

    @Override
    protected IP_Address flag_as_system_created() {
        super.flag_as_system_created();
        if (this.names != null) {
            for (A_Name a_Name : this.names.all_values(true)) {
                a_Name.flag_as_system_created();
            }
        }
        return this;
    }

    @Override
    protected IP_Address flag_as_loaded() {
        super.flag_as_loaded();
        if (this.names != null) {
            for (A_Name a_Name : this.names.all_values(true)) {
                a_Name.flag_as_loaded();
            }
        }
        return this;
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return NetDB.toString(fORMAT, template_name, "ip_address", this, bl);
    }

    protected static IP_Address extract(NetDB_Datastore netDB_Datastore, Hashtable hashtable) {
        IP_Address iP_Address = new IP_Address(netDB_Datastore);
        iP_Address.flag_as_system_created();
        iP_Address.extract(hashtable);
        return iP_Address;
    }

    protected IP_Address extract(Hashtable hashtable) {
        if (hashtable == null) {
            return this;
        }
        this.names = new Multi_Value_Attribute();
        IPaddress iPaddress = null;
        try {
            iPaddress = new IPaddress((String)hashtable.get("ip_address"));
        }
        catch (Exception exception) {
            this.logger().fine(Exception_Formatter.stack_trace(exception));
        }
        this.address(iPaddress);
        hashtable.remove("ip_address");
        this.active((Boolean)hashtable.get("active?"));
        hashtable.remove("active?");
        Hashtable hashtable2 = (Hashtable)hashtable.get("names");
        if (hashtable2 != null) {
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.add_name(A_Name.extract(this.datastore, (Hashtable)hashtable2.get(string)));
            }
        }
        hashtable.remove("names");
        NetDB.unhandled_keys(hashtable, "IP_Address.extract");
        return this;
    }

    protected void delete_children(String string, IP_Address iP_Address, Timestamp timestamp) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Comparison_Result comparison_Result = Multi_Value_Attribute.compare_for_commit(this.names, iP_Address.names);
        Vector vector = comparison_Result.only_in_set2();
        for (int i = 0; i < vector.size(); ++i) {
            ((A_Name)vector.get(i)).delete(string, timestamp);
        }
    }

    private void verify_or_die() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.id = this.verify_or_die(this.handle(8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer verify_or_die(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.datastore == null) {
            this.datastore = this.get_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        if (this.id != null && this.id != NetDB.unset_integer) {
            return this.id;
        }
        String string2 = "";
        try {
            string2 = this.datastore.start_transaction(NetDB.current_method_name());
            Integer n = this.datastore.ip_address().verify_or_die(string2, string);
            return n;
        }
        finally {
            this.datastore.rollback_transaction(string2);
        }
    }

    public static Boolean has_access(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return IP_Address.has_access(null, null, string);
    }

    public static Boolean has_access(User user, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return IP_Address.has_access(null, user, string);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return IP_Address.has_access(netDB_Datastore, null, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean has_access(NetDB_Datastore netDB_Datastore, User user, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (netDB_Datastore == null) {
            netDB_Datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        if (user == null && (user = netDB_Datastore.operating_user()) == null) {
            throw new Insufficient_Information("A user must be specified, or an operating user must be set.");
        }
        Integer n = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            n = netDB_Datastore.ip_address().verify_or_die(string2, string);
        }
        catch (Exception exception) {
            Boolean bl = false;
            return bl;
        }
        finally {
            netDB_Datastore.rollback_transaction(string2);
        }
        String string3 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            string3 = netDB_Datastore.ip_address().closest_name(string2, string);
        }
        finally {
            netDB_Datastore.rollback_transaction(string2);
        }
        if (string3 == null) {
            return false;
        }
        Integer n2 = null;
        Integer n3 = null;
        Boolean bl = true;
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            n2 = netDB_Datastore.name().verify_or_die(string2, string3, "%");
            n3 = netDB_Datastore.name().related_node(string2, n2);
        }
        finally {
            netDB_Datastore.rollback_transaction(string2);
        }
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            if (n3 == null) {
                bl = false;
                n3 = netDB_Datastore.name().related_network(string2, n2);
            }
        }
        finally {
            netDB_Datastore.rollback_transaction(string2);
        }
        if ((bl.booleanValue() && Node.has_access(netDB_Datastore, user).booleanValue() || !bl.booleanValue() && Network.has_access(netDB_Datastore, user).booleanValue()) && Group.has_access(netDB_Datastore, user.id(), Record_Type.ADDRESS.toString(), n).booleanValue()) {
            return true;
        }
        return false;
    }

    @Override
    protected IP_Address complete_object() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this;
    }

    public static Collection reserve(IPaddress iPaddress) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return IP_Address.reserve(NetDB.default_datastore(), iPaddress.toString(), 1, (Boolean)false, (Boolean)false);
    }

    public static Collection reserve(IPaddress iPaddress, int n) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return IP_Address.reserve(NetDB.default_datastore(), iPaddress.toString(), n, (Boolean)false, (Boolean)false);
    }

    public static Collection reserve(IPaddress iPaddress, Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return IP_Address.reserve(NetDB.default_datastore(), iPaddress.toString(), 1, bl, (Boolean)false);
    }

    public static Collection reserve(IPaddress iPaddress, int n, Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return IP_Address.reserve(NetDB.default_datastore(), iPaddress.toString(), n, bl, (Boolean)false);
    }

    public static Collection reserve(IPaddress iPaddress, int n, Boolean bl, Boolean bl2) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return IP_Address.reserve(NetDB.default_datastore(), iPaddress.toString(), n, bl, bl2);
    }

    public static Collection reserve(NetDB_Datastore netDB_Datastore, IPaddress iPaddress) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return IP_Address.reserve(netDB_Datastore, iPaddress, 1, (Boolean)false, (Boolean)false);
    }

    public static Collection reserve(NetDB_Datastore netDB_Datastore, IPaddress iPaddress, int n) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return IP_Address.reserve(netDB_Datastore, iPaddress, n, (Boolean)false, (Boolean)false);
    }

    public static Collection reserve(NetDB_Datastore netDB_Datastore, IPaddress iPaddress, Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return IP_Address.reserve(netDB_Datastore, iPaddress.toString(), 1, bl, (Boolean)false);
    }

    public static Collection reserve(NetDB_Datastore netDB_Datastore, IPaddress iPaddress, int n, Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return IP_Address.reserve(netDB_Datastore, iPaddress.toString(), n, bl, (Boolean)false);
    }

    public static Collection reserve(NetDB_Datastore netDB_Datastore, IPaddress iPaddress, int n, Boolean bl, Boolean bl2) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return IP_Address.reserve(netDB_Datastore, iPaddress.toString(), n, bl, bl2);
    }

    public static Collection reserve(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return IP_Address.reserve(NetDB.default_datastore(), string, 1, (Boolean)false, (Boolean)false);
    }

    public static Collection reserve(String string, int n) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return IP_Address.reserve(NetDB.default_datastore(), string, n, (Boolean)false, (Boolean)false);
    }

    public static Collection reserve(String string, Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return IP_Address.reserve(NetDB.default_datastore(), string, 1, bl, (Boolean)false);
    }

    public static Collection reserve(String string, int n, Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return IP_Address.reserve(NetDB.default_datastore(), string, n, bl, (Boolean)false);
    }

    public static Collection reserve(String string, int n, Boolean bl, Boolean bl2) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return IP_Address.reserve(NetDB.default_datastore(), string, n, bl, bl2);
    }

    public static Collection reserve(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return IP_Address.reserve(netDB_Datastore, string, 1, (Boolean)false, (Boolean)false);
    }

    public static Collection reserve(NetDB_Datastore netDB_Datastore, String string, int n) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return IP_Address.reserve(netDB_Datastore, string, n, (Boolean)false, (Boolean)false);
    }

    public static Collection reserve(NetDB_Datastore netDB_Datastore, String string, Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return IP_Address.reserve(netDB_Datastore, string, 1, bl, (Boolean)false);
    }

    public static Collection reserve(NetDB_Datastore netDB_Datastore, String string, int n, Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return IP_Address.reserve(netDB_Datastore, string, n, bl, (Boolean)false);
    }

    public static Collection reserve(NetDB_Datastore netDB_Datastore, String string, int n, Boolean bl, Boolean bl2) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return new IP_Address().reserve_addresses(netDB_Datastore, string, n, bl, bl2);
    }

    public IP_Address reserve() throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        return this.reserve(this.datastore);
    }

    public IP_Address reserve(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this.reserve("", netDB_Datastore);
    }

    protected IP_Address reserve(String string, NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.ip == null) {
            throw Insufficient_Information.missing_information("IP");
        }
        Collection collection = this.reserve_addresses(string, netDB_Datastore, this.ip.toString(), 1, true, false);
        Iterator iterator = collection.iterator();
        IP_Address iP_Address = (IP_Address)iterator.next();
        this.reserved = iP_Address.reserved != null ? new TZ_Timestamp(iP_Address.reserved) : null;
        this.reserved_by = iP_Address.reserved_by;
        return this;
    }

    protected Collection reserve_addresses(NetDB_Datastore netDB_Datastore, String string, int n, Boolean bl, Boolean bl2) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this.reserve_addresses("", netDB_Datastore, string, n, bl, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection reserve_addresses(String string, NetDB_Datastore netDB_Datastore, String string2, int n, Boolean bl, Boolean bl2) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        this.bind(netDB_Datastore);
        if (string2 == null) {
            throw Insufficient_Information.missing_information("starting address");
        }
        Integer n2 = 0;
        Integer n3 = 0;
        if (bl.booleanValue()) {
            n2 = 1;
        }
        if (bl2.booleanValue()) {
            n3 = 1;
        }
        Boolean bl3 = false;
        if (string == null || string.equals("")) {
            bl3 = true;
        }
        Hashtable hashtable = null;
        Boolean bl4 = null;
        try {
            if (bl3.booleanValue()) {
                string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            }
            bl4 = false;
            hashtable = netDB_Datastore.ip_address().reserve(string, string2, n, n2, n3);
            bl4 = true;
        }
        finally {
            if (bl4 != null && bl3.booleanValue()) {
                if (!bl4.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
        hashtable = (Hashtable)hashtable.get("ip_addresses");
        int n4 = netDB_Datastore.operating_user().id();
        Vector<IP_Address> vector = new Vector<IP_Address>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            IP_Address iP_Address = this.new_instance(netDB_Datastore, string3);
            Timestamp timestamp = (Timestamp)hashtable.get(string3);
            iP_Address.reserved = timestamp != null ? new TZ_Timestamp(timestamp) : null;
            iP_Address.reserved_by = n4;
            vector.add(iP_Address);
        }
        Collections.sort(vector);
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IP_Address unreserve() throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB_Datastore netDB_Datastore = this.get_datastore();
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Boolean bl = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            netDB_Datastore.ip_address().cancel(string, this.ip.toString());
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
        this.reserved = null;
        this.reserved_by = null;
        return this;
    }

    protected IP_Address accept(String string, NetDB_Datastore netDB_Datastore, Integer n, Timestamp timestamp, Record_Type record_Type) throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.bind(netDB_Datastore);
        Integer n2 = this.active_int();
        Interface_IP_Address.PTR_PREF pTR_PREF = null;
        if (this instanceof Interface_IP_Address) {
            pTR_PREF = ((Interface_IP_Address)this).pref;
        }
        if (pTR_PREF == null) {
            pTR_PREF = Interface_IP_Address.DEFAULT_PREF;
        }
        netDB_Datastore.ip_address().accept(string, this.address().toString(), n2, pTR_PREF.value(), n, timestamp, record_Type.toString());
        return this;
    }

    protected IP_Address delete(String string, Timestamp timestamp) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB_Datastore netDB_Datastore = this.get_datastore();
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        this.verify_or_die();
        netDB_Datastore.ip_address().delete(string, timestamp, this.id);
        this.flag_as_modified().flag_as_user_created();
        return this;
    }

    protected void commit(String string, NetDB_Datastore netDB_Datastore, IP_Address iP_Address, Integer n, Timestamp timestamp, Record_Type record_Type) throws Exception, No_Datastore_Defined, Insufficient_Information {
        int n2;
        Object object;
        Object object2;
        this.bind(netDB_Datastore);
        if (iP_Address == EMPTY) {
            this.reserve(string, netDB_Datastore);
            this.accept(string, netDB_Datastore, n, timestamp, record_Type);
        } else {
            this.verify_or_die();
            if (this.compare(iP_Address, Attribute.COMPARISON_TYPE.SINGLE_VALUES) != 0) {
                object2 = this.active_int();
                object = null;
                if (this instanceof Interface_IP_Address) {
                    object = ((Interface_IP_Address)this).pref;
                }
                if (object == null) {
                    object = Interface_IP_Address.DEFAULT_PREF;
                }
                netDB_Datastore.ip_address().update(string, timestamp, this.id, (Integer)object2, ((Interface_IP_Address.PTR_PREF)((Object)object)).value());
            }
        }
        object2 = Multi_Value_Attribute.compare_for_commit(this.names, iP_Address.names);
        object = ((Comparison_Result)object2).only_in_set1();
        Vector vector = ((Comparison_Result)object2).both_sets();
        for (n2 = 0; n2 < ((Vector)object).size(); ++n2) {
            ((A_Name)((Vector)object).get(n2)).commit(string, netDB_Datastore, A_Name.EMPTY, this.handle(), timestamp, Record_Type.ADDRESS);
        }
        for (n2 = 0; n2 < vector.size(); ++n2) {
            ((A_Name)vector.get(n2)).commit_children(string, netDB_Datastore, (A_Name)((Comparison_Result)object2).both_sets_alternate(n2), this.id, timestamp, Record_Type.ADDRESS);
        }
    }
}

