/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.IP;

import java.math.BigInteger;
import stanford.netdb.IP.IP;
import stanford.netdb.IP.Prefix;

public class IPaddress
extends IP {
    private static final long serialVersionUID = 1L;
    private int passed_format = 2;
    private BigInteger ip_address = BigInteger.ZERO;
    private static Prefix[] private_prefixes = new Prefix[]{Prefix.create("10.0.0.0/8"), Prefix.create("172.16.0.0/12"), Prefix.create("192.168.0.0/16"), Prefix.create("fe80::/10")};
    public static final IPaddress ZERO = IPaddress.zero();
    private static int default_format = 100;

    public IPaddress(String string) throws Exception {
        int n;
        int n2;
        String string2;
        String[] stringArray;
        String[] stringArray2;
        string = string.trim();
        if (string.matches("(?:(?:25[0-5])|(?:(?:2[0-4]|[01]?[0-9]?)[0-9]))(?:\\.(?:(?:25[0-5])|(?:(?:2[0-4]|[01]?[0-9]?)[0-9]))){3}") || string.matches("(?:[0-9a-fA-F]{1,4}:){6}(?:(?:25[0-5])|(?:(?:2[0-4]|[01]?[0-9]?)[0-9]))(?:\\.(?:(?:25[0-5])|(?:(?:2[0-4]|[01]?[0-9]?)[0-9]))){3}") || string.matches("(?:[0-9a-fA-F]{1,4}(?::[0-9a-fA-F]{1,4})*)?::(?:[0-9a-fA-F]{1,4}:)*(?:(?:25[0-5])|(?:(?:2[0-4]|[01]?[0-9]?)[0-9]))(?:\\.(?:(?:25[0-5])|(?:(?:2[0-4]|[01]?[0-9]?)[0-9]))){3}")) {
            this.passed_format = string.matches("(?:(?:25[0-5])|(?:(?:2[0-4]|[01]?[0-9]?)[0-9]))(?:\\.(?:(?:25[0-5])|(?:(?:2[0-4]|[01]?[0-9]?)[0-9]))){3}") ? 1 : 3;
            stringArray2 = string.split(":");
            stringArray = stringArray2[stringArray2.length - 1].split("\\.");
            string2 = "";
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                if (n2 == 2) {
                    string2 = string2 + ":";
                }
                string2 = string2 + String.format("%02x", new Integer(stringArray[n2]));
            }
            string = string.matches("(?:(?:25[0-5])|(?:(?:2[0-4]|[01]?[0-9]?)[0-9]))(?:\\.(?:(?:25[0-5])|(?:(?:2[0-4]|[01]?[0-9]?)[0-9]))){3}") ? "0000:0000:0000:0000:0000:ffff:" + string.replaceAll(stringArray2[stringArray2.length - 1] + "$", string2) : string.replaceAll(stringArray2[stringArray2.length - 1] + "$", string2);
        }
        stringArray2 = string.split(":");
        stringArray = new String[8];
        string2 = "";
        n2 = 8;
        if (string.matches("^::.+")) {
            ++n2;
        }
        if (!string.matches("(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}") && !string.matches("(?:[0-9a-fA-F]{1,4}(?::[0-9a-fA-F]{1,4})*)?::(?:[0-9a-fA-F]{1,4}(?::[0-9a-fA-F]{1,4})*)?") || stringArray2.length > n2) {
            throw new Exception("IP address '" + string + "' is malformed.");
        }
        for (n = 0; n < stringArray2.length; ++n) {
            if (stringArray2[n].equals("")) {
                n = stringArray2.length;
                continue;
            }
            stringArray[n] = stringArray2[n];
        }
        if (!string.matches(".+::$")) {
            for (n = 1; n < stringArray2.length; ++n) {
                if (stringArray2[stringArray2.length - n].equals("")) {
                    n = stringArray2.length;
                    continue;
                }
                stringArray[stringArray.length - n] = stringArray2[stringArray2.length - n];
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] == null) {
                stringArray[n] = "";
            }
            while (stringArray[n].length() < 4) {
                stringArray[n] = "0" + stringArray[n];
            }
            string2 = string2.concat(stringArray[n]);
        }
        this.ip_address = new BigInteger(string2, 16);
    }

    public IPaddress(BigInteger bigInteger) throws Exception {
        this(bigInteger, 2);
    }

    public IPaddress(BigInteger bigInteger, int n) throws Exception {
        int n2;
        if (n != 1 && n != 2 && n != 3) {
            throw new Exception("Unknown format.");
        }
        if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
            throw new Exception("Cannot create an IP from a negative number.");
        }
        BigInteger bigInteger2 = null;
        if (n == 1) {
            bigInteger2 = bigInteger.subtract(IP.IPv4_prefix_number);
        }
        if (bigInteger2 == null || bigInteger2.compareTo(BigInteger.ZERO) < 0) {
            bigInteger2 = bigInteger;
        }
        int n3 = n2 = n == 1 ? 32 : 128;
        if (bigInteger2.bitLength() > n2) {
            throw new Exception("Address is out of the range for the requested format.");
        }
        this.passed_format = n;
        this.ip_address = bigInteger;
    }

    public IPaddress clone() {
        IPaddress iPaddress = null;
        try {
            iPaddress = new IPaddress(this.ip_address, this.passed_format);
        }
        catch (Exception exception) {
            System.err.println("Unexpected exception caught in clone.\n" + exception.getMessage());
        }
        return iPaddress;
    }

    public static BigInteger difference(IPaddress iPaddress, IPaddress iPaddress2) {
        if (iPaddress == null || iPaddress2 == null) {
            return BigInteger.ZERO;
        }
        return iPaddress.ip_address.subtract(iPaddress2.ip_address);
    }

    public IPaddress add(BigInteger bigInteger) throws Exception {
        return new IPaddress(this.ip_address.add(bigInteger), this.passed_format);
    }

    public IPaddress subtract(BigInteger bigInteger) throws Exception {
        return new IPaddress(this.ip_address.subtract(bigInteger), this.passed_format);
    }

    public IPaddress next() throws Exception {
        return this.add(BigInteger.ONE);
    }

    public IPaddress prev() throws Exception {
        return this.subtract(BigInteger.ONE);
    }

    public static int default_format() {
        return default_format;
    }

    public static void default_compressed() {
        IPaddress.set(8);
        IPaddress.clear(48);
    }

    public static void default_normalized() {
        IPaddress.set(16);
        IPaddress.clear(40);
    }

    public static void default_preferred() {
        IPaddress.set(32);
        IPaddress.clear(24);
    }

    public static void default_passed() {
        IPaddress.set(4);
        IPaddress.clear(3);
    }

    public static void default_IPv4() {
        IPaddress.set(1);
        IPaddress.clear(6);
    }

    public static void default_IPv6() {
        IPaddress.set(2);
        IPaddress.clear(5);
    }

    public static void default_lower() {
        IPaddress.set(64);
        IPaddress.clear(128);
    }

    public static void default_upper() {
        IPaddress.set(128);
        IPaddress.clear(64);
    }

    public int format() {
        return this.passed_format;
    }

    public int family() {
        if (this.passed_format == 1) {
            return 4;
        }
        return 6;
    }

    public Boolean is_private() {
        for (Prefix prefix : private_prefixes) {
            if (!prefix.contains(this)) continue;
            return true;
        }
        return false;
    }

    public Boolean is_not_private() {
        return this.is_private() == false;
    }

    @Override
    public int compare(Object object, Object object2) throws ClassCastException {
        BigInteger bigInteger = IPaddress.compare_type_cast("ip1", object);
        BigInteger bigInteger2 = IPaddress.compare_type_cast("ip2", object2);
        if (bigInteger == null) {
            if (bigInteger2 == null) {
                return 0;
            }
            return -1;
        }
        if (bigInteger2 == null) {
            return 1;
        }
        return bigInteger.compareTo(bigInteger2);
    }

    @Override
    public int compareTo(Object object) {
        return this.compare(this, object);
    }

    protected static BigInteger compare_type_cast(String string, Object object) throws ClassCastException {
        BigInteger bigInteger;
        block14: {
            if (object == null) {
                return null;
            }
            bigInteger = null;
            String string2 = object.getClass().getName();
            try {
                if (string2.endsWith(".IPaddress")) {
                    bigInteger = ((IPaddress)object).ip_address;
                } else if (string2.endsWith(".Prefix")) {
                    bigInteger = ((Prefix)object).address().ip_address;
                } else if (string2.endsWith(".String")) {
                    String string3 = (String)object;
                    bigInteger = string3.indexOf("/") > -1 ? IPaddress.compare_type_cast(string, new Prefix(string3)) : IPaddress.compare_type_cast(string, new IPaddress(string3));
                } else if (string2.endsWith(".BigInteger")) {
                    bigInteger = (BigInteger)object;
                } else if (string2.endsWith(".Integer")) {
                    bigInteger = new BigInteger(object.toString());
                } else if (!IP.SUPPRESS_SORT_ERRORS.booleanValue()) {
                    throw new Exception("Unknown type: '" + string2 + "'");
                }
            }
            catch (Exception exception) {
                if (IP.SUPPRESS_SORT_ERRORS.booleanValue()) break block14;
                throw new ClassCastException(string + " could not be transformed for comparison (" + exception.getMessage() + ").");
            }
        }
        return bigInteger;
    }

    public BigInteger toBigInteger() {
        return this.toBigInteger(0);
    }

    public BigInteger toBigInteger(int n) {
        BigInteger bigInteger = new BigInteger(this.ip_address.toString());
        if (IPaddress.is_set(1, n) && !IPaddress.is_set(2, n)) {
            for (int i = bigInteger.bitLength(); i >= 32; --i) {
                bigInteger = bigInteger.clearBit(i);
            }
        }
        return bigInteger;
    }

    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int n) {
        return this.toString(n, DEFAULT_RADIX);
    }

    public String toString(int n, int n2) {
        int n3;
        if (n == 0) {
            n = default_format;
        }
        if (IPaddress.is_set(4, n) && IPaddress.is_set(3, n)) {
            n = IPaddress.clear(3, n);
        }
        if (IPaddress.is_set(256, n)) {
            if (!IPaddress.is_set(2, n) && !IPaddress.is_set(1, n)) {
                n = IPaddress.set(n, 4);
            }
            if (n2 <= 0) {
                n2 = DEFAULT_RADIX;
            }
            if ((!IPaddress.is_set(2, n) && IPaddress.is_set(1, n) || IPaddress.is_set(4, n) && this.passed_format == 1) && this.ip_address.compareTo(IPv4_prefix_number) > 0) {
                return this.ip_address.subtract(IPv4_prefix_number).toString(n2);
            }
            return this.ip_address.toString(n2);
        }
        if (IPaddress.is_set(32, n) && IPaddress.is_set(24, n)) {
            n = IPaddress.clear(24, n);
        }
        String string = "x";
        if (IPaddress.is_set(128, n) && !IPaddress.is_set(64, n)) {
            string = "X";
        }
        String string2 = String.format("%032" + string, this.ip_address);
        String string3 = "";
        int n4 = 0;
        for (n3 = 0; n3 < 8; ++n3) {
            string3 = string3 + ":" + string2.substring(n4, n4 + 4);
            n4 += 4;
        }
        string3 = string3.replaceFirst(":", "");
        int n5 = n3 = IPaddress.is_set(3, n) ? 0 : 1;
        if (IPaddress.is_set(3, n, true) || n3 != 0 && this.passed_format == 3) {
            String string4 = IPaddress.v4_toString(string3, n);
            string3 = string3.replaceAll(":[0-9a-fA-F]{4}:[0-9a-fA-F]{4}$", "");
            String string5 = IPaddress.v6_toString(string3, n);
            return string5.replaceAll("::$", ":") + ":" + string4;
        }
        if (IPaddress.is_set(1, n) || n3 != 0 && this.passed_format == 1) {
            return IPaddress.v4_toString(string3, n);
        }
        return IPaddress.v6_toString(string3, n);
    }

    private static String v4_toString(String string, int n) {
        String[] stringArray = string.split(":");
        String string2 = stringArray[stringArray.length - 2] + stringArray[stringArray.length - 1];
        String string3 = "";
        int n2 = 0;
        int n3 = 0;
        while (n2 < 4) {
            String string4 = string2.substring(n3, n3 + 2);
            string3 = string3 + Integer.parseInt(string4, 16) + ".";
            ++n2;
            n3 += 2;
        }
        string3 = string3.substring(0, string3.length() - 1);
        if (IPaddress.is_set(16, n)) {
            stringArray = string3.split("\\.");
            string3 = String.format("%03d.%03d.%03d.%03d", new Integer(stringArray[0]), new Integer(stringArray[1]), new Integer(stringArray[2]), new Integer(stringArray[3]));
        }
        return string3;
    }

    private static String v6_toString(String string, int n) {
        String string2 = string;
        if (!IPaddress.is_set(16, n)) {
            string2 = string2.replaceAll("^00?0?0?", "");
            string2 = string2.replaceAll("^:", "0:");
            string2 = string2.replaceAll(":00?0?0?", ":");
            string2 = string2.replaceAll(":$", ":0");
            string2 = string2.replaceAll("::", ":0:");
            string2 = string2.replaceAll("::", ":0:");
            if (!IPaddress.is_set(32, n)) {
                String string3 = "0:0";
                while (string2.matches("(^" + string3 + ".*)|" + "(.*:" + string3 + ":.*)|" + "(.*:" + string3 + "$)")) {
                    string3 = string3.concat(":0");
                }
                if (!(string3 = string3.replaceFirst("0:", "")).equals("0")) {
                    string2 = string2.replaceFirst("(^" + string3 + ")|(:" + string3 + ":)|(:" + string3 + "$)", "::");
                    string2 = string2.replace(":::", "::");
                }
                if (string2.equals(":")) {
                    string2 = "::";
                }
            }
        }
        return string2;
    }

    private static void set(int n) {
        default_format = IP.set(n, default_format);
    }

    private static void clear(int n) {
        default_format = IP.clear(n, default_format);
    }

    private static final IPaddress zero() {
        IPaddress iPaddress = null;
        try {
            iPaddress = new IPaddress(BigInteger.ZERO);
        }
        catch (Exception exception) {
            System.err.println("Error initializing the static variable IPaddress.ZERO (" + exception.getMessage() + ").");
            System.exit(1);
        }
        return iPaddress;
    }
}

