/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb.IP;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Comparator;

public abstract class IP
implements Comparator,
Serializable {
    private static final long serialVersionUID = 1L;
    public static Boolean SUPPRESS_SORT_ERRORS = false;
    public static final int IPv4 = 1;
    public static final int IPv6 = 2;
    public static final int IPv64 = 3;
    public static final int PASSED = 4;
    public static final int COMPRESSED = 8;
    public static final int NORMALIZED = 16;
    public static final int PREFERRED = 32;
    public static final int LOWER = 64;
    public static final int UPPER = 128;
    public static final int RADIX = 256;
    public static int DEFAULT_RADIX = 32;
    public static final String IPv4_prefix = "0000:0000:0000:0000:0000:ffff";
    public static final String IPv4_prefix_short = "::ffff";
    public static final String IPv4_normal_prefix = "0000:0000:0000:0000:0000:ffff".replace(":", "");
    public static final BigInteger IPv4_prefix_number = new BigInteger("ffff00000000", 16);
    public static final String v4_set = "(?:(?:25[0-5])|(?:(?:2[0-4]|[01]?[0-9]?)[0-9]))";
    public static final String v6_set = "[0-9a-fA-F]{1,4}";
    public static final String IPv4_regex = "(?:(?:25[0-5])|(?:(?:2[0-4]|[01]?[0-9]?)[0-9]))(?:\\.(?:(?:25[0-5])|(?:(?:2[0-4]|[01]?[0-9]?)[0-9]))){3}";
    public static final String IPv6_regex_not_compressed = "(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}";
    public static final String IPv6_regex_6hex_4dec = "(?:[0-9a-fA-F]{1,4}:){6}(?:(?:25[0-5])|(?:(?:2[0-4]|[01]?[0-9]?)[0-9]))(?:\\.(?:(?:25[0-5])|(?:(?:2[0-4]|[01]?[0-9]?)[0-9]))){3}";
    public static final String IPv6_regex_compressed = "(?:[0-9a-fA-F]{1,4}(?::[0-9a-fA-F]{1,4})*)?::(?:[0-9a-fA-F]{1,4}(?::[0-9a-fA-F]{1,4})*)?";
    public static final String IPv6_regex_6hex_4dec_compressed = "(?:[0-9a-fA-F]{1,4}(?::[0-9a-fA-F]{1,4})*)?::(?:[0-9a-fA-F]{1,4}:)*(?:(?:25[0-5])|(?:(?:2[0-4]|[01]?[0-9]?)[0-9]))(?:\\.(?:(?:25[0-5])|(?:(?:2[0-4]|[01]?[0-9]?)[0-9]))){3}";
    public static final String IPv6_regex = "(?:(?:[0-9a-fA-F]{1,4}:){6}(?:(?:25[0-5])|(?:(?:2[0-4]|[01]?[0-9]?)[0-9]))(?:\\.(?:(?:25[0-5])|(?:(?:2[0-4]|[01]?[0-9]?)[0-9]))){3})|(?:(?:[0-9a-fA-F]{1,4}(?::[0-9a-fA-F]{1,4})*)?::(?:[0-9a-fA-F]{1,4}:)*(?:(?:25[0-5])|(?:(?:2[0-4]|[01]?[0-9]?)[0-9]))(?:\\.(?:(?:25[0-5])|(?:(?:2[0-4]|[01]?[0-9]?)[0-9]))){3})|(?:(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4})|(?:(?:[0-9a-fA-F]{1,4}(?::[0-9a-fA-F]{1,4})*)?::(?:[0-9a-fA-F]{1,4}(?::[0-9a-fA-F]{1,4})*)?)";
    public static final int IPv4_bits = 32;
    public static final int IPv6_bits = 128;
    protected static final int IPv4_segments = 4;
    protected static final int IPv4_segment_length = 3;
    protected static final int IPv6_segments = 8;
    protected static final int IPv6_segment_length = 4;
    protected static final int IPv6_normal_length = 32;

    protected static int set(int n, int n2) {
        return n2 | n;
    }

    protected static int clear(int n, int n2) {
        if ((n & n2) > 0) {
            n2 &= ~n;
        }
        return n2;
    }

    protected static boolean is_set(int n, int n2) {
        return IP.is_set(n, n2, false);
    }

    protected static boolean is_set(int n, int n2, boolean bl) {
        return bl && (n & n2) == n || !bl && (n & n2) > 0;
    }

    public abstract String toString(int var1);

    public String toCompressedString() {
        return this.toCompressedString(0);
    }

    public String toNormalizedString() {
        return this.toNormalizedString(0);
    }

    public String toPreferredString() {
        return this.toPreferredString(0);
    }

    public String toPassedString() {
        return this.toPassedString(0);
    }

    public String toIPv4String() {
        return this.toIPv4String(0);
    }

    public String toIPv6String() {
        return this.toIPv6String(0);
    }

    public String toCompressedString(int n) {
        n = IP.clear(48, n);
        return this.toString(n | 8);
    }

    public String toNormalizedString(int n) {
        n = IP.clear(40, n);
        return this.toString(n | 0x10);
    }

    public String toPreferredString(int n) {
        n = IP.clear(24, n);
        return this.toString(n | 0x20);
    }

    public String toPassedString(int n) {
        n = IP.clear(3, n);
        return this.toString(n | 4);
    }

    public String toIPv4String(int n) {
        n = IP.clear(2, n);
        return this.toString(n | 1);
    }

    public String toIPv6String(int n) {
        n = IP.clear(1, n);
        return this.toString(n | 2);
    }

    public boolean lt(IP iP) {
        return this.compare(this, iP) < 0;
    }

    public boolean lte(IP iP) {
        return this.compare(this, iP) <= 0;
    }

    public boolean gt(IP iP) {
        return this.compare(this, iP) > 0;
    }

    public boolean gte(IP iP) {
        return this.compare(this, iP) >= 0;
    }

    public boolean equals(IP iP) {
        return this.compare(this, iP) == 0;
    }

    public static int cmp(IP iP, IP iP2) {
        if (iP != null) {
            return iP.compare(iP, iP2);
        }
        if (iP2 != null) {
            return iP2.compare(iP, iP2);
        }
        return 0;
    }

    public abstract int compare(Object var1, Object var2);

    public abstract int compareTo(Object var1);
}

