/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import stanford.netdb.Field;
import stanford.netdb.Group_FS_Parameters;
import stanford.netdb.Group_SS_Result;
import stanford.netdb.Lockable;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Privilege;
import stanford.netdb.Record_Type;
import stanford.netdb.User;
import stanford.netdb.exceptions.Exception_Formatter;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.exceptions.Record_Not_Found;

public class Group
extends Lockable<Group> {
    public static String template_name = "templates/toString/group.tmpl";
    private static final long serialVersionUID = 1L;
    private Integer id = null;
    private String name = null;
    private String comment = null;

    public Group() {
        this.init();
    }

    public Group(String string) {
        this.init(string);
    }

    public Group(String string, String string2) {
        this.init(string, string2);
    }

    public Group(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
        this.init();
    }

    public Group(NetDB_Datastore netDB_Datastore, String string) {
        super(netDB_Datastore);
        this.init(string);
    }

    public Group(NetDB_Datastore netDB_Datastore, String string, String string2) {
        super(netDB_Datastore);
        this.init(string, string2);
    }

    private void init() {
        this.init(null, null);
    }

    private void init(String string) {
        this.init(string, null);
    }

    private void init(String string, String string2) {
        if (string != null) {
            this.name(string);
        }
        if (string2 != null) {
            this.comment(string2);
        }
    }

    public Integer id() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.verify_or_die();
        return this.id;
    }

    public String name() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.name, NetDB.unset_string, "name");
        return this.name;
    }

    public String comment() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.comment, NetDB.unset_string, "comment");
        return this.comment;
    }

    @Override
    public String handle() {
        return this.name;
    }

    @Override
    protected Group id(Integer n) {
        this.id = n;
        return this;
    }

    public Group name(String string) {
        this.name = string;
        return this;
    }

    public Group comment(String string) {
        this.comment = string;
        return this;
    }

    @Override
    public Group unlink() {
        super.unlink();
        this.id = null;
        return this;
    }

    @Override
    public String single_value_attributes() {
        return this.name;
    }

    @Override
    protected void initialize_member_data() {
        super.initialize_member_data();
        if (this.name == null) {
            this.name = NetDB.unset_string;
        }
        if (this.comment == null) {
            this.comment = NetDB.unset_string;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        super.flag_field_as_defined(field);
        if (field == Field.NAME) {
            if (NetDB.unset_string.equals(this.name)) {
                this.name = null;
            }
        } else if (field == Field.COMMENT && NetDB.unset_string.equals(this.comment)) {
            this.comment = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        super.clear_default_member_data();
        if (NetDB.unset_string.equals(this.name)) {
            this.name = null;
        }
        if (NetDB.unset_string.equals(this.comment)) {
            this.comment = null;
        }
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return Lockable.toString(fORMAT, template_name, "group", this, bl);
    }

    protected static Group extract(NetDB_Datastore netDB_Datastore, Hashtable hashtable) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Group group = new Group(netDB_Datastore);
        group.flag_as_system_created();
        group.extract(hashtable);
        return group;
    }

    @Override
    protected Group extract(Hashtable hashtable) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (hashtable == null) {
            return this;
        }
        super.extract(hashtable);
        this.name((String)hashtable.get("name"));
        hashtable.remove("name");
        this.comment((String)hashtable.get("comment"));
        hashtable.remove("comment");
        hashtable.remove("id");
        NetDB.unhandled_keys(hashtable, "Group.extract");
        return this;
    }

    private void verify_or_die() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.id = this.verify_or_die(this.handle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer verify_or_die(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.datastore == null) {
            this.datastore = this.get_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        if (this.id != null && this.id != NetDB.unset_integer) {
            return this.id;
        }
        String string2 = "";
        try {
            string2 = this.datastore.start_transaction(NetDB.current_method_name());
            Integer n = this.datastore.owner().verify_or_die(string2, string);
            return n;
        }
        finally {
            this.datastore.rollback_transaction(string2);
        }
    }

    public static Boolean has_access() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(Record_Type.GROUP);
    }

    public static Boolean has_access(User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(user, Record_Type.GROUP);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, Record_Type.GROUP);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, user, Record_Type.GROUP);
    }

    public static Boolean has_access(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Group.has_access(null, null, string);
    }

    public static Boolean has_access(User user, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Group.has_access(null, user, string);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Group.has_access(netDB_Datastore, null, string);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, User user, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (netDB_Datastore == null) {
            netDB_Datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        if (user == null && (user = netDB_Datastore.operating_user()) == null) {
            throw new Insufficient_Information("A user must be specified, or an operating user must be set.");
        }
        if (Group.has_access(netDB_Datastore, user).booleanValue()) {
            String string2 = string.toLowerCase();
            for (Group group : user.owners()) {
                if (!group.handle().toLowerCase().equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Boolean has_access(NetDB_Datastore netDB_Datastore, Integer n, String string, Integer n2) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Object object;
        if (netDB_Datastore == null) {
            netDB_Datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        if (n == null) {
            object = netDB_Datastore.operating_user();
            if (object == null) {
                throw new Insufficient_Information("A user must be specified, or an operating user must be set.");
            }
            n = ((User)object).id();
        }
        object = "";
        try {
            object = netDB_Datastore.start_transaction(NetDB.current_method_name());
            Boolean bl = netDB_Datastore.owner().check_access((String)object, n, n2, string);
            return bl;
        }
        finally {
            netDB_Datastore.rollback_transaction((String)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Timestamp lock_record() throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        this.verify_or_die();
        Boolean bl = null;
        String string = "";
        try {
            string = this.datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            Hashtable hashtable = this.datastore.owner().lock_record(string, this.id);
            this.lock((Timestamp)hashtable.get("locked"));
            this.locked_by(this.datastore.operating_user().id());
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    this.datastore.rollback_transaction(string);
                } else {
                    this.datastore.end_transaction(string);
                }
            }
        }
        return this.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group unlock() throws Exception, No_Datastore_Defined {
        NetDB_Datastore.defined_or_die(this.datastore);
        Boolean bl = null;
        String string = "";
        try {
            string = this.datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            this.datastore.owner().unlock_record(string, this.lock(), this.id);
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    this.datastore.rollback_transaction(string);
                } else {
                    this.datastore.end_transaction(string);
                }
            }
        }
        this.lock(null);
        this.locked_by(null);
        return this;
    }

    public static Group load(Boolean bl, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return Group.load(NetDB.default_datastore(), bl, string);
    }

    public static Group load(NetDB_Datastore netDB_Datastore, Boolean bl, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        Group group = new Group(netDB_Datastore);
        group.name(string);
        if (bl.booleanValue()) {
            group.lock_record();
        }
        group.load_object(string);
        return group;
    }

    public static Group load(String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return Group.load(NetDB.default_datastore(), string);
    }

    public static Group load(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        Group group = new Group(netDB_Datastore);
        group.load_object(string);
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void load_object(String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        if ((string == null || string.trim().equals("")) && this.id == null) {
            throw Insufficient_Information.missing_handle();
        }
        this.id = this.verify_or_die(string);
        String string2 = "";
        try {
            string2 = this.datastore.start_transaction(NetDB.current_method_name());
            Hashtable hashtable = this.datastore.owner().info(string2, this.id);
            this.extract(hashtable);
            this.flag_as_system_created().flag_as_loaded();
        }
        finally {
            this.datastore.rollback_transaction(string2);
        }
    }

    public static Collection<Group> list() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Group.list(NetDB.default_datastore());
    }

    public static Collection<Group> list(Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Group.list(NetDB.default_datastore(), bl);
    }

    public static Collection<Group> list(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Group.list(netDB_Datastore, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Group> list(NetDB_Datastore netDB_Datastore, Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Integer n = null;
        if (!bl.booleanValue() && netDB_Datastore.operating_user() != null) {
            n = netDB_Datastore.operating_user().id();
        }
        Vector<Group> vector = new Vector<Group>();
        Hashtable hashtable = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            hashtable = n != null ? netDB_Datastore.owner().list(string, n) : netDB_Datastore.simple_search().get_groups(string);
        }
        finally {
            netDB_Datastore.rollback_transaction(string);
        }
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                Group group = new Group(netDB_Datastore, string2);
                if (n != null) {
                    group.comment((String)hashtable.get(string2));
                }
                group.flag_as_system_created();
                vector.add(group);
            }
        }
        Collections.sort(vector);
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Boolean bl = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            this.verify_or_die();
            netDB_Datastore.owner().delete(string, this.lock(), this.id);
            this.flag_as_modified().flag_as_user_created();
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
    }

    public static void delete(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Group.delete(NetDB.default_datastore(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Boolean bl = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            Group group = new Group(netDB_Datastore, string);
            group.lock_record();
            group.delete();
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string2);
                } else {
                    netDB_Datastore.end_transaction(string2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group commit(NetDB_Datastore netDB_Datastore, Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        this.bind(netDB_Datastore);
        Boolean bl2 = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl2 = false;
            Insufficient_Information.defined_or_die(this.name, "name");
            if (this.created_by_user().booleanValue()) {
                Hashtable hashtable = netDB_Datastore.owner().insert(string, this.name, this.comment);
                this.id = new Integer((String)hashtable.get("id"));
                super.lock((Timestamp)hashtable.get("locked"));
                super.locked_by(netDB_Datastore.operating_user().id());
            } else {
                netDB_Datastore.owner().update(string, this.lock(), this.id, this.name, this.comment);
            }
            this.flag_as_system_created().flag_as_loaded();
            bl2 = true;
        }
        finally {
            if (bl2 != null) {
                if (!bl2.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
        if (bl.booleanValue()) {
            try {
                this.unlock();
            }
            catch (Exception exception) {
                this.logger.warning("Unlock exception: " + Exception_Formatter.stack_trace(exception));
            }
        }
        return this;
    }

    public static Collection<Group_SS_Result> search() throws Exception, No_Datastore_Defined {
        return Group.search(NetDB.default_datastore(), null);
    }

    public static Collection<Group_SS_Result> search(String string) throws Exception, No_Datastore_Defined {
        return Group.search(NetDB.default_datastore(), string);
    }

    public static Collection<Group_SS_Result> search(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Group.search(netDB_Datastore, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Group_SS_Result> search(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined {
        if (netDB_Datastore == null) {
            netDB_Datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Hashtable hashtable = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            hashtable = string != null ? netDB_Datastore.simple_search().get_groups(string2, string) : netDB_Datastore.simple_search().get_groups(string2);
        }
        finally {
            netDB_Datastore.rollback_transaction(string2);
        }
        Vector<Group_SS_Result> vector = new Vector<Group_SS_Result>();
        for (String string3 : hashtable.keySet()) {
            vector.add(new Group_SS_Result(string3));
        }
        Collections.sort(vector, new Group_SS_Result(""));
        return vector;
    }

    public static Collection<Group> full_search(Group_FS_Parameters group_FS_Parameters) throws Exception {
        return Group.full_search(NetDB.default_datastore(), group_FS_Parameters);
    }

    public static Collection<Group> full_search(NetDB_Datastore netDB_Datastore, Group_FS_Parameters group_FS_Parameters) throws Exception {
        return group_FS_Parameters.search(netDB_Datastore);
    }
}

