/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

public enum Field {
    ABBREV("Abbrev", "", "Abbreviation", ""),
    ACCESS_GROUP("Access Group", "", "", ""),
    ACTION("Action", "", "", ""),
    ACTIVE("Active", "", "", ""),
    ADDRESS("Address", "", "IP Address", ""),
    ADDRESS_NAME("Address Name", "", "IP Address Name", ""),
    ADDRESS_SPACE("Address Space", "", "IP Address Space", ""),
    ADDRESS_SPACE_DHCP_SETTING("AS DHCP Setting", "", "Address Space DHCP Setting", ""),
    ADDRESS_SPACE_OWNER("AS Owner", "", "Address Space Owner", ""),
    ADDRESS_SPACE_COMMENT("AS Comment", "", "Address Space Comment", ""),
    ADMIN("Admin", "", "Administrator", ""),
    ALIAS("Alias", "", "", ""),
    ALL_GROUPS("All Groups", "All Groups", "All Groups", "All Groups"),
    ALL_RECORDS("All Records", "All Records", "All Records", "All Records"),
    APPLICATION("Application", "", "", ""),
    CODE("Code", "", "", ""),
    COMMENT("Comment", "", "", ""),
    CONSULTANT("Consultant", "", "", ""),
    CREATED_AT("Created At", "", "", ""),
    CREATED_BY("Created By", "", "", ""),
    CREATE_NAMES("Create Names", "Create Names", "Create Names in Domain", "Create Names in Domain"),
    CUSTOM_TAG("Custom Tag", "", "", ""),
    DATE_OF_ACTION("Date of Action", "Dates of Action", "", ""),
    DEFAULT_ACCESS("Default Access", "", "", ""),
    DEFAULT_DOMAIN("Default Domain", "", "", ""),
    DEFAULT_GROUP("Default Group", "", "", ""),
    DELEGATED("Delegated", "Delegated", "Delegated", "Delegated"),
    DENY_DHCP("Deny DHCP", "Deny DHCP", "Deny DHCP", "Deny DHCP"),
    DENY_DNS("Deny DNS", "Deny DNS", "Deny DNS", "Deny DNS"),
    DEPARTMENT("Department", "", "", ""),
    DHCP("DHCP", "DHCP", "DHCP", "DHCP"),
    DHCP_SERVICE("DHCP Service", "", "", ""),
    DHCP_SETTING("DHCP Setting", "", "", ""),
    DIR_ID("Dir ID", "", "Directory ID", ""),
    DISPLAY_NAME("Display Name", "", "", ""),
    DOMAIN("Domain", "", "", ""),
    EMAIL("Email", "", "", ""),
    EXPIRATION("Expiration", "", "Expiration Date", ""),
    EXTKEY("Extkey", "", "External Key", ""),
    HIGH_RES("High Res", "", "High Reserve", ""),
    HW_ADDRESS("HW Address", "", "", ""),
    ID("ID", "", "", ""),
    IDENTITY("Identity", "", "", ""),
    INTERFACE("Interface", "", "", ""),
    INTERFACE_TYPE("Interface Type", "", "", ""),
    INTERFACE_NAME("Interface Name", "", "", ""),
    IPC_ADDRESS("IPC Address", "", "", ""),
    IPC_NAME("IPC Name", "", "", ""),
    LAST_LOGIN("Last Login", "", "", ""),
    LAST_NAME("Last Name", "", "", ""),
    LIMITED("Limited", "", "", ""),
    LOCATION("Location", "", "", ""),
    LOCK("Lock", "", "", ""),
    LOCKED_BY("Locked By", "", "", ""),
    LOW_RES("Low Res", "", "Low Reserve", ""),
    MAKE("Make", "", "", ""),
    MEMBER("Member", "", "", ""),
    MODEL("Model", "", "", ""),
    MODEL_TYPE("Model Type", "", "", ""),
    MODIFIED_AT("Modified At", "", "", ""),
    MODIFIED_BY("Modified By", "", "", ""),
    MX("MX", "", "Mail Exchanger", ""),
    NAME("Name", "", "", ""),
    NETID("NetID", "", "", ""),
    NODE("Node", "", "", ""),
    NODE_TYPE("Node Type", "", "", ""),
    OS("OS", "", "", ""),
    OWNER("Owner", "", "", ""),
    PHONE("Phone", "", "", ""),
    PLURAL("Plural", "", "", ""),
    POOL("Pool", "", "", ""),
    PREF("Pref", "", "Preference", ""),
    PREFIX("Prefix", "", "", ""),
    PRIMARY("Primary", "", "", ""),
    PRIVILEGE("Privilege", "", "", ""),
    RANK("Rank", "", "", ""),
    REG_ID("Reg ID", "", "", ""),
    RESERVED("Reserved", "", "", ""),
    RESERVED_BY("Reserved By", "", "", ""),
    ROAM("Roam", "", "", ""),
    ROOM("Room", "", "", ""),
    SERVICE("Service", "", "", ""),
    SITE("Site", "", "", ""),
    STARTING_ADDRESS("Starting Address", "", "", ""),
    STATE("State", "", "", ""),
    TYPE("Type", "", "", ""),
    USER("User", "", "", ""),
    USER_NAME("User Name", "", "", ""),
    USE_AS_NAME("Use as Name", "", "Use Domain as Name", ""),
    VLAN("VLAN", "", "", "");

    private String display = "";
    private String plural = "";
    private String long_name = "";
    private String long_plural = "";

    private Field(String string2, String string3, String string4, String string5) {
        this.display = string2;
        this.plural = string3;
        this.long_name = string4;
        this.long_plural = string5;
    }

    public String toString() {
        return this.display;
    }

    private String pluralize(String string) {
        if (string.endsWith("s")) {
            return string + "es";
        }
        if (string.endsWith("y")) {
            return string.substring(0, string.length() - 1) + "ies";
        }
        return string + "s";
    }

    public String plural() {
        if (this.plural != null) {
            return this.plural;
        }
        return this.pluralize(this.display);
    }

    public String long_name() {
        if (this.long_name != null) {
            return this.long_name;
        }
        return this.display;
    }

    public String long_plural() {
        if (this.long_plural != null) {
            return this.long_plural;
        }
        return this.pluralize(this.long_name());
    }

    public String lc() {
        return this.lc(true);
    }

    public String lc(Boolean bl) {
        String string = this.display.toLowerCase();
        if (bl.booleanValue()) {
            string = string.replaceAll(" +", "_");
        }
        return string;
    }

    public static Field find(String string) {
        Field field = null;
        try {
            field = Field.valueOf(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (field == null) {
            String string2 = string.toLowerCase();
            for (Field field2 : Field.values()) {
                if (!field2.lc(false).equals(string2) && !field2.lc(true).equals(string2)) continue;
                field = field2;
                break;
            }
        }
        return field;
    }
}

