/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.sql.Timestamp;
import java.util.Hashtable;
import stanford.netdb.Field;
import stanford.netdb.Name;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Record_Type;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;

public class Domain_Name
extends Name<Domain_Name> {
    public static String template_name = "templates/toString/domain_name.tmpl";
    private static final long serialVersionUID = 1L;
    protected static final Domain_Name EMPTY = new Domain_Name();
    private static final String DNS_TYPE = "SOA";

    protected Domain_Name() {
    }

    public Domain_Name(String string) {
        super(string);
    }

    public Domain_Name(String string, String string2) {
        super(string, string2);
    }

    protected Domain_Name(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
    }

    public Domain_Name(NetDB_Datastore netDB_Datastore, String string) {
        super(netDB_Datastore, string);
    }

    public Domain_Name(NetDB_Datastore netDB_Datastore, String string, String string2) {
        super(netDB_Datastore, string, string2);
    }

    @Override
    protected String dns_type() {
        return DNS_TYPE;
    }

    @Override
    protected void initialize_member_data() {
        super.initialize_member_data();
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        super.flag_field_as_defined(field);
    }

    @Override
    protected void clear_default_member_data() {
        super.clear_default_member_data();
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return Name.toString(fORMAT, template_name, "domain_name", this, bl);
    }

    protected static Domain_Name extract(NetDB_Datastore netDB_Datastore, Hashtable hashtable) {
        Domain_Name domain_Name = new Domain_Name(netDB_Datastore);
        domain_Name.flag_as_system_created();
        domain_Name.extract(hashtable);
        return domain_Name;
    }

    @Override
    protected Domain_Name extract(Hashtable hashtable) {
        if (hashtable == null) {
            return this;
        }
        super.extract(hashtable);
        String string = null;
        if ((this.name == null || this.name.equals("")) && this.domain != null) {
            string = this.domain;
        } else if ((this.domain == null || this.domain.equals("")) && this.name != null) {
            string = this.name;
        }
        if (string != null) {
            this.name(Name.get_host(string));
            this.domain(Name.get_domain(string), false);
        }
        NetDB.unhandled_keys(hashtable, "Domain_Name.extract");
        return this;
    }

    @Override
    public Domain_Name reserve(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return (Domain_Name)super.reserve(netDB_Datastore, DNS_TYPE);
    }

    @Override
    public Domain_Name unreserve(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return (Domain_Name)super.unreserve(netDB_Datastore, DNS_TYPE);
    }

    @Override
    protected void commit(String string, NetDB_Datastore netDB_Datastore, Domain_Name domain_Name, Integer n, Timestamp timestamp, Record_Type record_Type) throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.accept(string, netDB_Datastore, record_Type, n, timestamp);
    }

    @Override
    protected void commit(String string, NetDB_Datastore netDB_Datastore, Domain_Name domain_Name, String string2, Timestamp timestamp, Record_Type record_Type) throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.accept(string, netDB_Datastore, record_Type, string2, timestamp);
    }
}

