/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import stanford.netdb.Domain;
import stanford.netdb.Domain_Name;
import stanford.netdb.FS_Boolean;
import stanford.netdb.Field;
import stanford.netdb.Full_Search_Parameters;
import stanford.netdb.Group;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.middleware.Result_Hash;

public class Domain_FS_Parameters
extends Full_Search_Parameters<Domain_FS_Parameters, Domain> {
    private static final long serialVersionUID = 1L;
    private static final String INCLUDE_NAME = "displayOrder.txt.1.Domain Name";
    private static final String INCLUDE_LIMITED = "displayOrder.b.2.Limited Domain";
    private static final String INCLUDE_DELEGATED = "displayOrder.b.2.Delegated Domain";
    private static final String INCLUDE_USE_AS_NAME = "displayOrder.txt.4.Use as Name";
    private static final String INCLUDE_CREATE_NAMES_IN = "displayOrder.txt.4.Assign Names";
    private static final String ID_COLUMN = "ID";
    private static final String HANDLE_COLUMN = "handle";
    private static final String NAME_COLUMN = "Domain Name";
    private static final String LIMITED_COLUMN = "Limited Domain";
    private static final String DELEGATED_COLUMN = "Delegated Domain";
    private static final String USE_AS_NAME_COLUMN = "Use as Name";
    private static final String CREATE_NAMES_IN_COLUMN = "Assign Names";
    private static final String GROUP_COLUMN = "Groups";
    private static final String COMMENT_COLUMN = "Comment";
    private String name = "";
    private FS_Boolean limited = FS_Boolean.EITHER;
    private FS_Boolean delegated = FS_Boolean.EITHER;
    private String use_as_name = "";
    private String create_names_in = "";

    public Domain_FS_Parameters() {
        this.INCLUDE_MODIFIED_BY = "displayOrder.txt.7.Modified By";
        this.INCLUDE_MODIFIED = "displayOrder.tst.8.Date Modified";
        this.INCLUDE_CREATED_BY = "displayOrder.txt.9.Created By";
        this.INCLUDE_CREATED = "displayOrder.tst.10.Date Created";
        this.INCLUDE_OWNER = "displayOrder.txt.4.Group";
        this.INCLUDE_COMMENT = "displayOrder.txt.5.Comment";
        this.include_fields.put(INCLUDE_NAME, Boolean.FALSE);
        this.include_fields.put(INCLUDE_LIMITED, Boolean.FALSE);
        this.include_fields.put(INCLUDE_DELEGATED, Boolean.FALSE);
        this.include_fields.put(INCLUDE_USE_AS_NAME, Boolean.FALSE);
        this.include_fields.put(INCLUDE_CREATE_NAMES_IN, Boolean.FALSE);
        this.include_fields.put(this.INCLUDE_MODIFIED_BY, Boolean.FALSE);
        this.include_fields.put(this.INCLUDE_MODIFIED, Boolean.FALSE);
        this.include_fields.put(this.INCLUDE_CREATED_BY, Boolean.FALSE);
        this.include_fields.put(this.INCLUDE_CREATED, Boolean.FALSE);
        this.include_fields.put(this.INCLUDE_OWNER, Boolean.FALSE);
        this.include_fields.put(this.INCLUDE_COMMENT, Boolean.FALSE);
    }

    public String name() {
        return this.name;
    }

    public Boolean include_name() {
        return (Boolean)this.include_fields.get(INCLUDE_NAME);
    }

    public Boolean limited() {
        return this.limited.value();
    }

    public Boolean include_limited() {
        return (Boolean)this.include_fields.get(INCLUDE_LIMITED);
    }

    public Boolean delegated() {
        return this.delegated.value();
    }

    public Boolean include_delegated() {
        return (Boolean)this.include_fields.get(INCLUDE_DELEGATED);
    }

    public String use_as_name() {
        return this.use_as_name;
    }

    public Boolean include_use_as_name() {
        return (Boolean)this.include_fields.get(INCLUDE_USE_AS_NAME);
    }

    public String create_names_in() {
        return this.create_names_in;
    }

    public Boolean include_create_names_in() {
        return (Boolean)this.include_fields.get(INCLUDE_CREATE_NAMES_IN);
    }

    public Domain_FS_Parameters name(String string) {
        if (string == null) {
            string = "";
        }
        this.name = string;
        return this;
    }

    public Domain_FS_Parameters name(String string, Boolean bl) {
        this.name(string);
        this.include_name(bl);
        return this;
    }

    public Domain_FS_Parameters include_name(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_NAME, bl);
        return this;
    }

    public Domain_FS_Parameters limited(Boolean bl) {
        this.limited = new FS_Boolean(bl);
        return this;
    }

    public Domain_FS_Parameters limited(Boolean bl, Boolean bl2) {
        this.limited(bl);
        this.include_limited(bl2);
        return this;
    }

    public Domain_FS_Parameters include_limited(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_LIMITED, bl);
        return this;
    }

    public Domain_FS_Parameters delegated(Boolean bl) {
        this.delegated = new FS_Boolean(bl);
        return this;
    }

    public Domain_FS_Parameters delegated(Boolean bl, Boolean bl2) {
        this.delegated(bl);
        this.include_delegated(bl2);
        return this;
    }

    public Domain_FS_Parameters include_delegated(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_DELEGATED, bl);
        return this;
    }

    public Domain_FS_Parameters use_as_name(String string) {
        if (string == null) {
            string = "";
        }
        this.use_as_name = string;
        return this;
    }

    public Domain_FS_Parameters use_as_name(String string, Boolean bl) {
        this.use_as_name(string);
        this.include_use_as_name(bl);
        return this;
    }

    public Domain_FS_Parameters include_use_as_name(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_USE_AS_NAME, bl);
        return this;
    }

    public Domain_FS_Parameters create_names_in(String string) {
        if (string == null) {
            string = "";
        }
        this.create_names_in = string;
        return this;
    }

    public Domain_FS_Parameters create_names_in(String string, Boolean bl) {
        this.create_names_in(string);
        this.include_create_names_in(bl);
        return this;
    }

    public Domain_FS_Parameters include_create_names_in(Boolean bl) {
        if (bl == null) {
            bl = false;
        }
        this.include_fields.put(INCLUDE_CREATE_NAMES_IN, bl);
        return this;
    }

    @Override
    protected String get_SQL(String string) throws Exception {
        Hashtable<String, String> hashtable = this.legacy_search_params();
        String string2 = "SELECT DISTINCT id \"ID\", domain \"handle\"" + (hashtable.get(INCLUDE_NAME).equals("-1") ? "" : ", domain \"Domain Name\"") + (hashtable.get(INCLUDE_LIMITED).equals("-1") ? "" : ", decode(limited, 1, 'Y', 'N') \"Limited Domain\"") + (hashtable.get(INCLUDE_DELEGATED).equals("-1") ? "" : ", decode(delegated, 1, 'Y', 'N') \"Delegated Domain\"") + (hashtable.get(INCLUDE_USE_AS_NAME).equals("-1") ? "" : ", useAsName \"Use as Name\"") + (hashtable.get(INCLUDE_CREATE_NAMES_IN).equals("-1") ? "" : ", assignNamesIn \"Assign Names\"") + (hashtable.get(this.INCLUDE_OWNER).equals("-1") ? "" : ", owner \"Groups\"") + (hashtable.get(this.INCLUDE_COMMENT).equals("-1") ? "" : ", nvl(comments, ' ') \"Comment\"") + this.modBlock(hashtable) + " FROM " + hashtable.get("fs.table") + " WHERE ID IN ( SELECT unique(id) FROM ";
        Vector vector = new Vector();
        this.assmDisplayOrder(vector, hashtable);
        Vector<Exception> vector2 = new Vector<Exception>();
        string2 = string2 + this.assmCommonSQL(hashtable, vector2) + " ) ";
        return string2;
    }

    @Override
    protected Vector<Domain> process_results(NetDB_Datastore netDB_Datastore, Result_Hash result_Hash) throws Exception {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = -1;
        int n12 = -1;
        int n13 = -1;
        int n14 = 0;
        for (String object2 : result_Hash.get_vector("column_names")) {
            if (object2.equals(ID_COLUMN)) {
                n = n14;
            } else if (object2.equals(HANDLE_COLUMN)) {
                n2 = n14;
            } else if (object2.equals(NAME_COLUMN)) {
                n3 = n14;
            } else if (object2.equals(LIMITED_COLUMN)) {
                n4 = n14;
            } else if (object2.equals(DELEGATED_COLUMN)) {
                n5 = n14;
            } else if (object2.equals(USE_AS_NAME_COLUMN)) {
                n6 = n14;
            } else if (object2.equals(CREATE_NAMES_IN_COLUMN)) {
                n7 = n14;
            } else if (object2.equals(GROUP_COLUMN)) {
                n8 = n14;
            } else if (object2.equals(COMMENT_COLUMN)) {
                n9 = n14;
            } else if (object2.equals("Modified By")) {
                n10 = n14;
            } else if (object2.equals("Date Modified")) {
                n11 = n14;
            } else if (object2.equals("Created By")) {
                n12 = n14;
            } else if (object2.equals("Date Created")) {
                n13 = n14;
            } else {
                netDB_Datastore.logger().severe("'" + object2 + "' was encountered and not expected.  The data will not be processed.  The '" + this.getClass().getName() + "' class will need to be updated before it will be processed.");
            }
            ++n14;
        }
        Hashtable hashtable = new Hashtable();
        Vector<Domain> vector = new Vector<Domain>();
        for (Vector vector2 : (Vector)result_Hash.get("resultSet")) {
            Comparable<Boolean> comparable;
            String string;
            Comparable<BigDecimal> comparable2;
            Domain domain = null;
            String string2 = (String)vector2.get(n2);
            domain = (Domain)hashtable.get(string2);
            if (domain == null) {
                comparable2 = new Domain_Name(netDB_Datastore, string2);
                ((NetDB)comparable2).flag_as_system_created();
                domain = new Domain(netDB_Datastore);
                domain.name((Domain_Name)comparable2);
                domain.flag_as_system_created();
                vector.add(domain);
                hashtable.put(string2, domain);
            }
            if ((comparable2 = (BigDecimal)vector2.get(n)) != null) {
                domain.id(new Integer(((BigDecimal)comparable2).intValue()));
            }
            if (n4 != -1) {
                string = (String)vector2.get(n4);
                comparable = false;
                if ("Y".equals(string)) {
                    comparable = true;
                }
                domain.limited((Boolean)comparable);
            }
            if (n5 != -1) {
                string = (String)vector2.get(n5);
                comparable = false;
                if ("Y".equals(string)) {
                    comparable = true;
                }
                domain.delegated((Boolean)comparable);
            }
            if (n6 != -1) {
                string = (String)vector2.get(n6);
                if (string != null && (string = string.trim()).length() > 0) {
                    comparable = new Group(netDB_Datastore, string);
                    ((NetDB)comparable).flag_as_system_created();
                    domain.grant_access((Group)comparable, Domain.ACCESS_TYPE.USE_DOMAIN_AS_NAME);
                }
                domain.flag_field_as_defined(Field.USE_AS_NAME);
            }
            if (n7 != -1) {
                string = (String)vector2.get(n7);
                if (string != null && (string = string.trim()).length() > 0) {
                    comparable = new Group(netDB_Datastore, string);
                    ((NetDB)comparable).flag_as_system_created();
                    domain.grant_access((Group)comparable, Domain.ACCESS_TYPE.CREATE_NAMES_IN_DOMAIN);
                }
                domain.flag_field_as_defined(Field.CREATE_NAMES);
            }
            if (n8 != -1) {
                string = (String)vector2.get(n8);
                if (string != null && (string = string.trim()).length() > 0) {
                    comparable = new Group(netDB_Datastore, string);
                    ((NetDB)comparable).flag_as_system_created();
                    domain.add_owner((Group)comparable);
                }
                domain.flag_field_as_defined(Field.OWNER);
            }
            if (n9 != -1) {
                string = (String)vector2.get(n9);
                if (string != null && (string = string.trim()).length() > 0) {
                    domain.comment(string);
                }
                domain.flag_field_as_defined(Field.COMMENT);
            }
            super.process_common_results(domain, vector2, n11, n10, n13, n12);
        }
        Collections.sort(vector);
        return vector;
    }

    @Override
    protected String child_params() {
        String string = "";
        return string;
    }

    public Hashtable<String, String> legacy_search_params() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("fs.table", "FS_Domain");
        for (String string : this.include_fields.keySet()) {
            String string2 = "-1";
            if (((Boolean)this.include_fields.get(string)).booleanValue()) {
                string2 = "1";
            }
            hashtable.put(string, string2);
        }
        hashtable.put("txt.lower(fqdn)", this.name.toLowerCase());
        hashtable.put("txt.lower(useAsName)", this.use_as_name.toLowerCase());
        hashtable.put("txt.lower(assignNamesIn)", this.create_names_in.toLowerCase());
        hashtable.put("rb.b.limited", this.limited.sql_string());
        hashtable.put("rb.b.delegated", this.delegated.sql_string());
        super.legacy_search_params(hashtable);
        hashtable.put("txt.lower(owner)", this.owner.toLowerCase());
        hashtable.put("txt.lower(comments)", this.comment.toLowerCase());
        return hashtable;
    }
}

