/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import stanford.netdb.Attribute;
import stanford.netdb.Comparison_Result;
import stanford.netdb.Domain_FS_Parameters;
import stanford.netdb.Domain_Name;
import stanford.netdb.Domain_SS_Result;
import stanford.netdb.Field;
import stanford.netdb.Group;
import stanford.netdb.Lockable;
import stanford.netdb.Multi_Value_Attribute;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Privilege;
import stanford.netdb.Record_Type;
import stanford.netdb.User;
import stanford.netdb.exceptions.Exception_Formatter;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.exceptions.Record_Not_Found;

public class Domain
extends Lockable<Domain> {
    public static String template_name = "templates/toString/domain.tmpl";
    private static final long serialVersionUID = 1L;
    private Integer id = null;
    private Domain_Name name = null;
    private Boolean limited = null;
    private Boolean delegated = null;
    private String comment = null;
    private Multi_Value_Attribute<Group> create_names_in_groups = null;
    private Multi_Value_Attribute<Group> use_as_name_groups = null;

    public Domain() {
        this.init();
    }

    public Domain(Domain_Name domain_Name) {
        this.init(domain_Name);
    }

    public Domain(Domain_Name domain_Name, Boolean bl, Boolean bl2, String string) {
        this.init(domain_Name, bl, bl2, string);
    }

    public Domain(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
        this.init();
    }

    public Domain(NetDB_Datastore netDB_Datastore, Domain_Name domain_Name) {
        super(netDB_Datastore);
        this.init(domain_Name);
    }

    public Domain(NetDB_Datastore netDB_Datastore, Domain_Name domain_Name, Boolean bl, Boolean bl2, String string) {
        super(netDB_Datastore);
        this.init(domain_Name, bl, bl2, string);
    }

    private void init() {
        this.init(null, null, null, null);
    }

    private void init(Domain_Name domain_Name) {
        this.init(domain_Name, null, null, null);
    }

    private void init(Domain_Name domain_Name, Boolean bl, Boolean bl2, String string) {
        if (domain_Name != null) {
            this.name(domain_Name);
        }
        if (bl != null) {
            this.limited(bl);
        }
        if (bl2 != null) {
            this.delegated(bl2);
        }
        if (string != null) {
            this.comment(string);
        }
    }

    public Integer id() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.verify_or_die();
        return this.id;
    }

    public Domain_Name name() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.name, NetDB.unset_domain_name, "name");
        return this.name;
    }

    public Boolean is_limited() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.limited, NetDB.unset_boolean, "limited");
        return this.limited;
    }

    public Boolean is_delegated() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.delegated, NetDB.unset_boolean, "delegated");
        return this.delegated;
    }

    public Boolean limited() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this.is_limited();
    }

    public Boolean delegated() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this.is_delegated();
    }

    public String comment() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.comment, NetDB.unset_string, "comment");
        return this.comment;
    }

    public Collection<Group> get_acl(ACCESS_TYPE aCCESS_TYPE) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (aCCESS_TYPE == ACCESS_TYPE.MODIFY_DOMAIN) {
            this.internal_complete(this.groups, NetDB.unset_mva_group, "groups");
            if (this.groups == null || this.groups == NetDB.unset_mva_group) {
                return new Multi_Value_Attribute().all_values();
            }
            return this.groups.all_values();
        }
        if (aCCESS_TYPE == ACCESS_TYPE.CREATE_NAMES_IN_DOMAIN) {
            this.internal_complete(this.create_names_in_groups, NetDB.unset_mva_group, "create_names_in_groups");
            if (this.create_names_in_groups == null || this.create_names_in_groups == NetDB.unset_mva_group) {
                return new Multi_Value_Attribute().all_values();
            }
            return this.create_names_in_groups.all_values();
        }
        if (aCCESS_TYPE == ACCESS_TYPE.USE_DOMAIN_AS_NAME) {
            this.internal_complete(this.use_as_name_groups, NetDB.unset_mva_group, "use_as_name_groups");
            if (this.use_as_name_groups == null || this.use_as_name_groups == NetDB.unset_mva_group) {
                return new Multi_Value_Attribute().all_values();
            }
            return this.use_as_name_groups.all_values();
        }
        return null;
    }

    @Override
    public String handle() {
        return this.name.handle();
    }

    @Override
    protected Domain id(Integer n) {
        this.id = n;
        return this;
    }

    public Domain name(Domain_Name domain_Name) {
        this.name = domain_Name;
        return this;
    }

    public Domain limited(Boolean bl) {
        this.limited = bl;
        return this;
    }

    public Domain delegated(Boolean bl) {
        this.delegated = bl;
        return this;
    }

    public Domain comment(String string) {
        this.comment = string;
        return this;
    }

    public Domain grant_access(Group group, ACCESS_TYPE aCCESS_TYPE) {
        if (aCCESS_TYPE == ACCESS_TYPE.MODIFY_DOMAIN) {
            if (this.groups == null || this.groups == NetDB.unset_mva_group) {
                this.groups = new Multi_Value_Attribute();
            }
            this.groups.add(group);
        } else if (aCCESS_TYPE == ACCESS_TYPE.CREATE_NAMES_IN_DOMAIN) {
            if (this.create_names_in_groups == null || this.create_names_in_groups == NetDB.unset_mva_group) {
                this.create_names_in_groups = new Multi_Value_Attribute();
            }
            this.create_names_in_groups.add(group);
        } else if (aCCESS_TYPE == ACCESS_TYPE.USE_DOMAIN_AS_NAME) {
            if (this.use_as_name_groups == null || this.use_as_name_groups == NetDB.unset_mva_group) {
                this.use_as_name_groups = new Multi_Value_Attribute();
            }
            this.use_as_name_groups.add(group);
        }
        return this;
    }

    public Domain grant_access(Collection<Group> collection, ACCESS_TYPE aCCESS_TYPE) {
        Iterator<Group> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.grant_access(iterator.next(), aCCESS_TYPE);
        }
        return this;
    }

    public Domain revoke_access(Group group, ACCESS_TYPE aCCESS_TYPE) {
        if (aCCESS_TYPE == ACCESS_TYPE.MODIFY_DOMAIN) {
            if (this.groups != null) {
                this.groups.remove(group, (Boolean)true);
            }
        } else if (aCCESS_TYPE == ACCESS_TYPE.CREATE_NAMES_IN_DOMAIN) {
            if (this.create_names_in_groups != null) {
                this.create_names_in_groups.remove(group, (Boolean)true);
            }
        } else if (aCCESS_TYPE == ACCESS_TYPE.USE_DOMAIN_AS_NAME && this.use_as_name_groups != null) {
            this.use_as_name_groups.remove(group, (Boolean)true);
        }
        return this;
    }

    public Domain revoke_access(Collection<Group> collection, ACCESS_TYPE aCCESS_TYPE) {
        Iterator<Group> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.revoke_access(iterator.next(), aCCESS_TYPE);
        }
        return this;
    }

    @Override
    public Domain bind(NetDB_Datastore netDB_Datastore) throws No_Datastore_Defined {
        super.bind(netDB_Datastore);
        this.bind_children(this.create_names_in_groups, netDB_Datastore);
        this.bind_children(this.use_as_name_groups, netDB_Datastore);
        return this;
    }

    @Override
    public Domain unbind() {
        super.unbind();
        this.unbind_children(this.create_names_in_groups);
        this.unbind_children(this.use_as_name_groups);
        return this;
    }

    @Override
    public Domain unlink() {
        super.unlink();
        this.unlink_children(this.create_names_in_groups);
        this.unlink_children(this.use_as_name_groups);
        this.id = null;
        return this;
    }

    @Override
    public String single_value_attributes() {
        String string = "";
        if (this.name != null) {
            string = this.name.single_value_attributes();
        }
        return string + " " + this.limited + " " + this.delegated + " " + this.comment;
    }

    @Override
    protected void initialize_member_data() {
        super.initialize_member_data();
        if (this.id == null) {
            this.id = NetDB.unset_integer;
        }
        if (this.name == null) {
            this.name = NetDB.unset_domain_name;
        }
        if (this.limited == null) {
            this.limited = NetDB.unset_boolean;
        }
        if (this.delegated == null) {
            this.delegated = NetDB.unset_boolean;
        }
        if (this.comment == null) {
            this.comment = NetDB.unset_string;
        }
        if (this.create_names_in_groups == null) {
            this.create_names_in_groups = NetDB.unset_mva_group;
        }
        if (this.use_as_name_groups == null) {
            this.use_as_name_groups = NetDB.unset_mva_group;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        super.flag_field_as_defined(field);
        if (field == Field.NAME) {
            if (this.name == NetDB.unset_domain_name) {
                this.name = null;
            }
        } else if (field == Field.LIMITED) {
            if (this.limited == NetDB.unset_boolean) {
                this.limited = null;
            }
        } else if (field == Field.DELEGATED) {
            if (this.delegated == NetDB.unset_boolean) {
                this.delegated = null;
            }
        } else if (field == Field.COMMENT) {
            if (NetDB.unset_string.equals(this.comment)) {
                this.comment = null;
            }
        } else if (field == Field.CREATE_NAMES) {
            if (this.create_names_in_groups == NetDB.unset_mva_group) {
                this.create_names_in_groups = null;
            }
        } else if (field == Field.USE_AS_NAME && this.use_as_name_groups == NetDB.unset_mva_group) {
            this.use_as_name_groups = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        super.clear_default_member_data();
        if (this.id == NetDB.unset_integer) {
            this.id = null;
        }
        if (this.name == NetDB.unset_domain_name) {
            this.name = null;
        }
        if (this.limited == NetDB.unset_boolean) {
            this.limited = null;
        }
        if (this.delegated == NetDB.unset_boolean) {
            this.delegated = null;
        }
        if (NetDB.unset_string.equals(this.comment)) {
            this.comment = null;
        }
        if (this.create_names_in_groups == NetDB.unset_mva_group) {
            this.create_names_in_groups = null;
        }
        if (this.use_as_name_groups == NetDB.unset_mva_group) {
            this.use_as_name_groups = null;
        }
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return Lockable.toString(fORMAT, template_name, "domain", this, bl);
    }

    protected static Domain extract(NetDB_Datastore netDB_Datastore, Hashtable hashtable) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Domain domain = new Domain(netDB_Datastore);
        domain.flag_as_system_created();
        domain.extract(hashtable);
        return domain;
    }

    @Override
    protected Domain extract(Hashtable hashtable) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Object object;
        Enumeration enumeration;
        Object object2;
        Object object3;
        if (hashtable == null) {
            return this;
        }
        this.groups = new Multi_Value_Attribute();
        this.create_names_in_groups = new Multi_Value_Attribute();
        this.use_as_name_groups = new Multi_Value_Attribute();
        super.extract(hashtable);
        this.name(Domain_Name.extract(this.datastore, hashtable));
        this.comment((String)hashtable.get("comment"));
        hashtable.remove("comment");
        this.delegated((Boolean)hashtable.get("delegated?"));
        hashtable.remove("delegated?");
        this.limited((Boolean)hashtable.get("limited?"));
        hashtable.remove("limited?");
        Hashtable hashtable2 = (Hashtable)hashtable.get("groups");
        if (hashtable2 != null) {
            object3 = hashtable2.keys();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                enumeration = new Group(this.datastore, (String)object2);
                ((NetDB)((Object)enumeration)).flag_as_system_created();
                this.grant_access((Group)((Object)enumeration), ACCESS_TYPE.MODIFY_DOMAIN);
            }
        }
        hashtable.remove("groups");
        object3 = (Hashtable)hashtable.get("useAsName");
        if (object3 != null) {
            object2 = ((Hashtable)object3).keys();
            while (object2.hasMoreElements()) {
                enumeration = (String)object2.nextElement();
                object = new Group(this.datastore, (String)((Object)enumeration));
                ((NetDB)object).flag_as_system_created();
                this.grant_access((Group)object, ACCESS_TYPE.USE_DOMAIN_AS_NAME);
            }
        }
        hashtable.remove("useAsName");
        object2 = (Hashtable)hashtable.get("assign");
        if (object2 != null) {
            enumeration = ((Hashtable)object2).keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                Group group = new Group(this.datastore, (String)object);
                group.flag_as_system_created();
                this.grant_access(group, ACCESS_TYPE.CREATE_NAMES_IN_DOMAIN);
            }
        }
        hashtable.remove("assign");
        hashtable.remove("id");
        NetDB.unhandled_keys(hashtable, "Domain.extract");
        return this;
    }

    private void verify_or_die() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.id = this.verify_or_die(this.handle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer verify_or_die(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.datastore == null) {
            this.datastore = this.get_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        if (this.id != null && this.id != NetDB.unset_integer) {
            return this.id;
        }
        String string2 = "";
        try {
            string2 = this.datastore.start_transaction(NetDB.current_method_name());
            Integer n = this.datastore.domain().verify_or_die(string2, string);
            return n;
        }
        finally {
            this.datastore.rollback_transaction(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean usable() throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        if (this.datastore.operating_user() == null) {
            throw new Insufficient_Information("The operating user has not been set.");
        }
        this.verify_or_die();
        String string = "";
        try {
            string = this.datastore.start_transaction(NetDB.current_method_name());
            Boolean bl = this.datastore.domain().can_use(string, this.datastore.operating_user().id(), this.id);
            return bl;
        }
        finally {
            this.datastore.rollback_transaction(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean usable_as_name() throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        if (this.datastore.operating_user() == null) {
            throw new Insufficient_Information("The operating user has not been set.");
        }
        this.verify_or_die();
        String string = "";
        try {
            string = this.datastore.start_transaction(NetDB.current_method_name());
            Boolean bl = this.datastore.domain().can_use_as_name(string, this.datastore.operating_user().id(), this.id);
            return bl;
        }
        finally {
            this.datastore.rollback_transaction(string);
        }
    }

    public static Boolean has_access() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(Record_Type.DOMAIN);
    }

    public static Boolean has_access(User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(user, Record_Type.DOMAIN);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, Record_Type.DOMAIN);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, user, Record_Type.DOMAIN);
    }

    public static Boolean has_access(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Domain.has_access(null, null, string);
    }

    public static Boolean has_access(User user, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Domain.has_access(null, user, string);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Domain.has_access(netDB_Datastore, null, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean has_access(NetDB_Datastore netDB_Datastore, User user, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (netDB_Datastore == null) {
            netDB_Datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        if (user == null && (user = netDB_Datastore.operating_user()) == null) {
            throw new Insufficient_Information("A user must be specified, or an operating user must be set.");
        }
        Integer n = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            n = netDB_Datastore.domain().verify_or_die(string2, string);
        }
        catch (Exception exception) {
            Boolean bl = false;
            return bl;
        }
        finally {
            netDB_Datastore.rollback_transaction(string2);
        }
        if (Domain.has_access(netDB_Datastore, user).booleanValue() && Group.has_access(netDB_Datastore, user.id(), Record_Type.DOMAIN.toString(), n).booleanValue()) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Timestamp lock_record() throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        this.verify_or_die();
        Boolean bl = null;
        String string = "";
        try {
            string = this.datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            Hashtable hashtable = this.datastore.domain().lock_record(string, this.id);
            this.lock((Timestamp)hashtable.get("locked"));
            this.locked_by(this.datastore.operating_user().id());
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    this.datastore.rollback_transaction(string);
                } else {
                    this.datastore.end_transaction(string);
                }
            }
        }
        return this.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Domain unlock() throws Exception, No_Datastore_Defined {
        NetDB_Datastore.defined_or_die(this.datastore);
        Boolean bl = null;
        String string = "";
        try {
            string = this.datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            this.datastore.domain().unlock_record(string, this.lock(), this.id);
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    this.datastore.rollback_transaction(string);
                } else {
                    this.datastore.end_transaction(string);
                }
            }
        }
        this.lock(null);
        this.locked_by(null);
        return this;
    }

    public static Domain load(Boolean bl, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return Domain.load(NetDB.default_datastore(), bl, string);
    }

    public static Domain load(NetDB_Datastore netDB_Datastore, Boolean bl, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        Domain domain = new Domain(netDB_Datastore);
        Domain_Name domain_Name = new Domain_Name(netDB_Datastore, string);
        domain_Name.flag_as_system_created();
        domain.name(domain_Name);
        if (bl.booleanValue()) {
            domain.lock_record();
        }
        domain.load_object(string);
        return domain;
    }

    public static Domain load(String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return Domain.load(NetDB.default_datastore(), string);
    }

    public static Domain load(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        Domain domain = new Domain(netDB_Datastore);
        domain.load_object(string);
        return domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void load_object(String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        if ((string == null || string.trim().equals("")) && this.id == null) {
            throw Insufficient_Information.missing_handle();
        }
        this.id = this.verify_or_die(string);
        String string2 = "";
        try {
            string2 = this.datastore.start_transaction(NetDB.current_method_name());
            Hashtable hashtable = this.datastore.domain().info(string2, this.id);
            this.extract(hashtable);
            this.flag_as_system_created().flag_as_loaded();
        }
        finally {
            this.datastore.rollback_transaction(string2);
        }
    }

    public static Collection<Domain> list() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Domain.list(NetDB.default_datastore());
    }

    public static Collection<Domain> list(Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Domain.list(NetDB.default_datastore(), bl);
    }

    public static Collection<Domain> list(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Domain.list(netDB_Datastore, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Domain> list(NetDB_Datastore netDB_Datastore, Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Integer n = null;
        if (!bl.booleanValue() && netDB_Datastore.operating_user() != null) {
            n = netDB_Datastore.operating_user().id();
        }
        Vector<Domain> vector = new Vector<Domain>();
        Hashtable hashtable = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            hashtable = n != null ? netDB_Datastore.domain().list(string, n) : netDB_Datastore.domain().list(string);
        }
        finally {
            netDB_Datastore.rollback_transaction(string);
        }
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                Domain domain = new Domain(netDB_Datastore);
                domain.name(new Domain_Name(netDB_Datastore, string2));
                String string3 = (String)hashtable.get(string2);
                if (string3 != null) {
                    domain.id = Integer.parseInt(string3);
                }
                domain.name.flag_as_system_created();
                domain.flag_as_system_created();
                vector.add(domain);
            }
        }
        Collections.sort(vector);
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Boolean bl = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            this.verify_or_die(this.handle());
            netDB_Datastore.domain().delete(string, this.lock(), this.id);
            this.flag_as_modified().flag_as_user_created();
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
    }

    public static void delete(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Domain.delete(NetDB.default_datastore(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Boolean bl = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            Domain domain = new Domain(netDB_Datastore, new Domain_Name(netDB_Datastore, string));
            domain.lock_record();
            domain.delete();
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string2);
                } else {
                    netDB_Datastore.end_transaction(string2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Domain commit(NetDB_Datastore netDB_Datastore, Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        this.bind(netDB_Datastore);
        Domain domain = null;
        Boolean bl2 = null;
        String string = "";
        if (this.name == null) {
            throw new Insufficient_Information("The domain must have a name.");
        }
        try {
            int n;
            Object object;
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl2 = false;
            if (this.created_by_user().booleanValue()) {
                domain = new Domain();
                this.name.reserve(netDB_Datastore);
                object = netDB_Datastore.domain().insert(string, this.name.full_name(), NetDB.boolean_to_integer(this.limited), NetDB.boolean_to_integer(this.delegated), this.comment);
                this.id = new Integer((String)((Hashtable)object).get("id"));
                super.lock((Timestamp)((Hashtable)object).get("locked"));
                super.locked_by(netDB_Datastore.operating_user().id());
                this.name.commit(string, netDB_Datastore, Domain_Name.EMPTY, this.id, this.lock(), Record_Type.DOMAIN);
            } else {
                domain = Domain.load(netDB_Datastore, netDB_Datastore.domain().handle(string, this.id));
                if (!domain.name.name().equals(this.name.name())) {
                    netDB_Datastore.name().update_domain_name(string, this.lock(), domain.name.id(), this.name.name());
                }
                netDB_Datastore.domain().update(string, this.lock(), this.id, this.name.full_name(), NetDB.boolean_to_integer(this.limited), NetDB.boolean_to_integer(this.delegated), this.comment);
            }
            object = this.handle();
            Timestamp timestamp = this.lock();
            Comparison_Result comparison_Result = Multi_Value_Attribute.compare_for_commit(this.groups, domain.groups, Attribute.COMPARISON_TYPE.UNIQUE_IDENTIFER);
            Comparison_Result comparison_Result2 = Multi_Value_Attribute.compare_for_commit(this.create_names_in_groups, domain.create_names_in_groups, Attribute.COMPARISON_TYPE.UNIQUE_IDENTIFER);
            Comparison_Result comparison_Result3 = Multi_Value_Attribute.compare_for_commit(this.use_as_name_groups, domain.use_as_name_groups, Attribute.COMPARISON_TYPE.UNIQUE_IDENTIFER);
            Vector vector = comparison_Result.only_in_set1();
            Vector vector2 = comparison_Result.only_in_set2();
            Vector vector3 = comparison_Result2.only_in_set1();
            Vector vector4 = comparison_Result2.only_in_set2();
            Vector vector5 = comparison_Result3.only_in_set1();
            Vector vector6 = comparison_Result3.only_in_set2();
            for (n = 0; n < vector.size(); ++n) {
                netDB_Datastore.owner().add(string, timestamp, ((Group)vector.get(n)).handle(), this.id, ACCESS_TYPE.MODIFY_DOMAIN.toString());
            }
            for (n = 0; n < vector2.size(); ++n) {
                netDB_Datastore.owner().remove(string, timestamp, ((Group)vector2.get(n)).handle(), this.id, ACCESS_TYPE.MODIFY_DOMAIN.toString());
            }
            for (n = 0; n < vector4.size(); ++n) {
                netDB_Datastore.owner().remove(string, timestamp, ((Group)vector4.get(n)).handle(), this.id, ACCESS_TYPE.CREATE_NAMES_IN_DOMAIN.toString());
            }
            for (n = 0; n < vector3.size(); ++n) {
                netDB_Datastore.owner().add(string, timestamp, ((Group)vector3.get(n)).handle(), this.id, ACCESS_TYPE.CREATE_NAMES_IN_DOMAIN.toString());
            }
            for (n = 0; n < vector6.size(); ++n) {
                netDB_Datastore.owner().remove(string, timestamp, ((Group)vector6.get(n)).handle(), this.id, ACCESS_TYPE.USE_DOMAIN_AS_NAME.toString());
            }
            for (n = 0; n < vector5.size(); ++n) {
                netDB_Datastore.owner().add(string, timestamp, ((Group)vector5.get(n)).handle(), this.id, ACCESS_TYPE.USE_DOMAIN_AS_NAME.toString());
            }
            netDB_Datastore.domain().verify_and_log(string, this.id);
            this.flag_as_system_created().flag_as_loaded();
            bl2 = true;
        }
        finally {
            if (bl2 != null) {
                if (!bl2.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
        if (bl.booleanValue()) {
            try {
                this.unlock();
            }
            catch (Exception exception) {
                this.logger.warning("Unlock exception: " + Exception_Formatter.stack_trace(exception));
            }
        }
        return this;
    }

    public static Collection<Domain_SS_Result> search(String string) throws Exception, No_Datastore_Defined {
        return Domain.search(NetDB.default_datastore(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Domain_SS_Result> search(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined {
        if (netDB_Datastore == null) {
            netDB_Datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Hashtable hashtable = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            hashtable = netDB_Datastore.simple_search().get_domains(string2, string);
        }
        finally {
            netDB_Datastore.rollback_transaction(string2);
        }
        Vector<Domain_SS_Result> vector = new Vector<Domain_SS_Result>();
        for (String string3 : hashtable.keySet()) {
            vector.add(new Domain_SS_Result(string3));
        }
        Collections.sort(vector, new Domain_SS_Result(""));
        return vector;
    }

    public static Collection<Domain> full_search(Domain_FS_Parameters domain_FS_Parameters) throws Exception {
        return Domain.full_search(NetDB.default_datastore(), domain_FS_Parameters);
    }

    public static Collection<Domain> full_search(NetDB_Datastore netDB_Datastore, Domain_FS_Parameters domain_FS_Parameters) throws Exception {
        return domain_FS_Parameters.search(netDB_Datastore);
    }

    public static enum ACCESS_TYPE {
        MODIFY_DOMAIN("domain"),
        CREATE_NAMES_IN_DOMAIN("domain_assign"),
        USE_DOMAIN_AS_NAME("domain_use");

        private String value = null;

        private ACCESS_TYPE(String string2) {
            this.value = string2;
        }

        public String toString() {
            return this.value;
        }
    }
}

