/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import stanford.netdb.Comparison_Result;
import stanford.netdb.Consultant;
import stanford.netdb.Field;
import stanford.netdb.Multi_Value_Attribute;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Privilege;
import stanford.netdb.Record;
import stanford.netdb.Record_Type;
import stanford.netdb.User;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.exceptions.Record_Not_Found;

public class Department
extends Record<Department> {
    public static String template_name = "templates/toString/department.tmpl";
    private static final long serialVersionUID = 1L;
    private Integer id = null;
    private String name = null;
    private String reg_id = null;
    private Multi_Value_Attribute<Consultant> consultants = null;

    public Department() {
        this.init();
    }

    public Department(String string) {
        this.init(string);
    }

    public Department(String string, String string2) {
        this.init(string, string2);
    }

    public Department(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
        this.init();
    }

    public Department(NetDB_Datastore netDB_Datastore, String string) {
        super(netDB_Datastore);
        this.init(string);
    }

    public Department(NetDB_Datastore netDB_Datastore, String string, String string2) {
        super(netDB_Datastore);
        this.init(string, string2);
    }

    private void init() {
        this.init(null, null);
    }

    private void init(String string) {
        this.init(string, null);
    }

    private void init(String string, String string2) {
        if (string != null) {
            this.name(string);
        }
        if (string2 != null) {
            this.reg_id(string2);
        }
    }

    public Integer id() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.verify_or_die();
        return this.id;
    }

    public String name() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.name, NetDB.unset_string, "name");
        return this.name;
    }

    public String regID() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this.reg_id();
    }

    public String reg_id() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.reg_id, NetDB.unset_string, "reg_id");
        return this.reg_id;
    }

    public Collection<Consultant> consultants() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.consultants, NetDB.unset_mva_consultant, "consultants");
        if (this.consultants == null || this.consultants == NetDB.unset_mva_consultant) {
            return new Multi_Value_Attribute().all_values();
        }
        return this.consultants.all_values();
    }

    @Override
    public String handle() {
        return this.name;
    }

    public Department name(String string) {
        this.name = string;
        return this;
    }

    public Department regID(String string) {
        return this.reg_id(string);
    }

    public Department reg_id(String string) {
        this.reg_id = string;
        return this;
    }

    public Department add_consultant(Consultant consultant) {
        if (this.consultants == null || this.consultants == NetDB.unset_mva_consultant) {
            this.consultants = new Multi_Value_Attribute();
        }
        this.consultants.add(consultant);
        return this;
    }

    public Department add_consultants(Collection<Consultant> collection) {
        Iterator<Consultant> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add_consultant(iterator.next());
        }
        return this;
    }

    public Department remove_consultant(Consultant consultant) {
        if (this.consultants != null) {
            this.consultants.remove(consultant);
        }
        return this;
    }

    public Department remove_consultants(Collection<Consultant> collection) {
        Iterator<Consultant> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.remove_consultant(iterator.next());
        }
        return this;
    }

    @Override
    public Department bind(NetDB_Datastore netDB_Datastore) throws No_Datastore_Defined {
        super.bind(netDB_Datastore);
        this.bind_children(this.consultants, netDB_Datastore);
        return this;
    }

    @Override
    public Department unbind() {
        super.unbind();
        this.unbind_children(this.consultants);
        return this;
    }

    @Override
    public Department unlink() {
        super.unlink();
        this.unlink_children(this.consultants);
        this.id = null;
        return this;
    }

    @Override
    public String single_value_attributes() {
        return this.name + " " + this.reg_id;
    }

    @Override
    protected void initialize_member_data() {
        super.initialize_member_data();
        if (this.name == null) {
            this.name = NetDB.unset_string;
        }
        if (this.reg_id == null) {
            this.reg_id = NetDB.unset_string;
        }
        if (this.consultants == null) {
            this.consultants = NetDB.unset_mva_consultant;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        super.flag_field_as_defined(field);
        if (field == Field.NAME) {
            if (NetDB.unset_string.equals(this.name)) {
                this.name = null;
            }
        } else if (field == Field.REG_ID) {
            if (NetDB.unset_string.equals(this.reg_id)) {
                this.reg_id = null;
            }
        } else if (field == Field.CONSULTANT && this.consultants == NetDB.unset_mva_consultant) {
            this.consultants = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        super.clear_default_member_data();
        if (NetDB.unset_string.equals(this.name)) {
            this.name = null;
        }
        if (NetDB.unset_string.equals(this.reg_id)) {
            this.reg_id = null;
        }
        if (this.consultants == NetDB.unset_mva_consultant) {
            this.consultants = null;
        }
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return Record.toString(fORMAT, template_name, "department", this, bl);
    }

    protected static Department extract(NetDB_Datastore netDB_Datastore, Hashtable hashtable) {
        Department department = new Department(netDB_Datastore);
        department.flag_as_system_created();
        department.extract(hashtable);
        return department;
    }

    protected Department extract(Hashtable hashtable) {
        Object object;
        Object object2;
        if (hashtable == null) {
            return this;
        }
        this.consultants = new Multi_Value_Attribute();
        String string = (String)hashtable.get("object");
        if ("node".equals(string)) {
            this.name((String)hashtable.get("dept"));
            hashtable.remove("dept");
        } else {
            object2 = (String)hashtable.get("name");
            if (object2 != null) {
                this.name((String)object2);
            }
            hashtable.remove("name");
            object = (String)hashtable.get("id");
            if (object != null) {
                this.id = Integer.parseInt((String)object);
            }
            hashtable.remove("id");
        }
        this.reg_id((String)hashtable.get("RegID"));
        hashtable.remove("RegID");
        object2 = (Hashtable)hashtable.get("consultants");
        if (object2 != null) {
            object = ((Hashtable)object2).keys();
            while (object.hasMoreElements()) {
                String string2 = (String)object.nextElement();
                Consultant consultant = Consultant.extract(this.datastore, (Hashtable)((Hashtable)object2).get(string2));
                consultant.flag_as_system_created();
                this.add_consultant(consultant);
            }
        }
        hashtable.remove("consultants");
        NetDB.unhandled_keys(hashtable, "Department.extract");
        return this;
    }

    private void verify_or_die() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.id = this.verify_or_die(this.handle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer verify_or_die(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.datastore == null) {
            this.datastore = this.get_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        String string2 = "";
        try {
            string2 = this.datastore.start_transaction(NetDB.current_method_name());
            Integer n = this.datastore.organization().verify_or_die(string2, string);
            return n;
        }
        finally {
            this.datastore.rollback_transaction(string2);
        }
    }

    public static Boolean has_access() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(Record_Type.DEPARTMENT);
    }

    public static Boolean has_access(User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(user, Record_Type.DEPARTMENT);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, Record_Type.DEPARTMENT);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, user, Record_Type.DEPARTMENT);
    }

    public static Department load(String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return Department.load(NetDB.default_datastore(), string);
    }

    public static Department load(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        Department department = new Department(netDB_Datastore);
        department.load_object(string);
        return department;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void load_object(String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        if (string == null || string.trim().equals("")) {
            throw Insufficient_Information.missing_handle();
        }
        if (this.id == null) {
            this.id = this.verify_or_die(string);
            if (this.id == null) {
                throw new Record_Not_Found("'" + string + "' was not found in the database.");
            }
        }
        String string2 = "";
        try {
            string2 = this.datastore.start_transaction(NetDB.current_method_name());
            Hashtable hashtable = this.datastore.organization().info(string2, this.id);
            this.flag_as_system_created();
            this.extract(hashtable);
            this.flag_as_loaded();
        }
        finally {
            this.datastore.rollback_transaction(string2);
        }
    }

    public static Collection<Department> list() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Department.list(NetDB.default_datastore());
    }

    public static Collection<Department> list(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Department.list(NetDB.default_datastore(), string);
    }

    public static Collection<Department> list(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Department.list(netDB_Datastore, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Department> list(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Vector<Department> vector = new Vector<Department>();
        Hashtable hashtable = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            hashtable = string != null ? netDB_Datastore.organization().list(string2, string) : netDB_Datastore.organization().list(string2);
        }
        finally {
            netDB_Datastore.rollback_transaction(string2);
        }
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                Department department = Department.extract(netDB_Datastore, (Hashtable)hashtable.get(string3));
                vector.add(department);
            }
        }
        Collections.sort(vector);
        return vector;
    }

    @Override
    public void delete() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.delete(this.get_datastore());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Boolean bl = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            this.verify_or_die();
            netDB_Datastore.organization().delete(string, this.id);
            this.flag_as_modified().flag_as_user_created();
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
    }

    public static void delete(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Department.delete(NetDB.default_datastore(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Boolean bl = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            Department department = new Department(netDB_Datastore, string);
            department.delete();
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string2);
                } else {
                    netDB_Datastore.end_transaction(string2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Department commit(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.bind(netDB_Datastore);
        Department department = null;
        Boolean bl = null;
        String string = "";
        try {
            Consultant consultant;
            int n;
            Object object;
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            Insufficient_Information.defined_or_die(this.name, "name");
            if (this.created_by_user().booleanValue()) {
                department = new Department();
                object = netDB_Datastore.organization().insert(string, this.name, this.reg_id);
                this.id = new Integer((String)((Hashtable)object).get("id"));
            } else {
                department = Department.load(netDB_Datastore, netDB_Datastore.organization().handle(string, this.id));
                if (this.compare(department) != 0) {
                    netDB_Datastore.organization().update(string, this.id, this.name, this.reg_id);
                }
            }
            object = Multi_Value_Attribute.compare_for_commit(this.consultants, department.consultants);
            Vector vector = ((Comparison_Result)object).only_in_set1();
            Vector vector2 = ((Comparison_Result)object).only_in_set2();
            Vector vector3 = ((Comparison_Result)object).both_sets();
            for (n = 0; n < vector2.size(); ++n) {
                netDB_Datastore.organization().consultant(string, "delete", ((Consultant)vector2.get(n)).id(), this.name);
            }
            for (n = 0; n < vector.size(); ++n) {
                consultant = (Consultant)vector.get(n);
                netDB_Datastore.organization().consultant(string, "insert", consultant.id(), this.name, NetDB.boolean_to_integer(consultant.is_primary()));
            }
            for (n = 0; n < vector3.size(); ++n) {
                consultant = (Consultant)vector3.get(n);
                netDB_Datastore.organization().consultant(string, "update", consultant.id(), this.name, NetDB.boolean_to_integer(consultant.is_primary()));
            }
            this.flag_as_system_created().flag_as_loaded();
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Department supplant(Department department) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB_Datastore netDB_Datastore = this.get_datastore();
        Boolean bl = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            if (this.created_by_user().booleanValue()) {
                throw new Exception("You must load the record that is being supplanted.");
            }
            this.verify_or_die();
            department.verify_or_die();
            netDB_Datastore.organization().supplant(string, this.id, department.id);
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
        return department;
    }
}

