/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import stanford.netdb.Field;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Person;
import stanford.netdb.Privilege;
import stanford.netdb.Record;
import stanford.netdb.Record_Type;
import stanford.netdb.User;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.exceptions.Not_Implemented;

public class DHCP_Service
extends Record<DHCP_Service> {
    public static String template_name = "templates/toString/dhcp_service.tmpl";
    private static final long serialVersionUID = 1L;
    private Integer id = null;
    private String name = null;
    private String comment = null;
    private Person modified_by = null;
    private Timestamp modified_at = null;

    public DHCP_Service() {
        this.init();
    }

    public DHCP_Service(String string) {
        this.init(string);
    }

    public DHCP_Service(String string, String string2) {
        this.init(string, string2);
    }

    public DHCP_Service(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
        this.init();
    }

    public DHCP_Service(NetDB_Datastore netDB_Datastore, String string) {
        super(netDB_Datastore);
        this.init(string);
    }

    public DHCP_Service(NetDB_Datastore netDB_Datastore, String string, String string2) {
        super(netDB_Datastore);
        this.init(string, string2);
    }

    private void init() {
        this.init(null, null, null, null);
    }

    private void init(String string) {
        this.init(string, null, null, null);
    }

    private void init(String string, String string2) {
        this.init(string, string2, null, null);
    }

    private void init(String string, String string2, Person person, Timestamp timestamp) {
        if (string != null) {
            this.name(string);
        }
        if (string2 != null) {
            this.comment(string2);
        }
        if (person != null) {
            this.modified_by(person);
        }
        if (timestamp != null) {
            this.modified_at(timestamp);
        }
    }

    public Integer id() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.id, NetDB.unset_integer, "id");
        return this.id;
    }

    public String name() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.name, NetDB.unset_string, "name");
        return this.name;
    }

    public String comment() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.comment, NetDB.unset_string, "comment");
        return this.comment;
    }

    private Person modified_by() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.modified_by, NetDB.unset_person, "modified_by");
        return this.modified_by;
    }

    private Timestamp modified_at() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.modified_at, NetDB.unset_timestamp, "modified_at");
        return this.modified_at;
    }

    @Override
    public String handle() {
        return this.id.toString();
    }

    public DHCP_Service name(String string) {
        this.name = string;
        return this;
    }

    public DHCP_Service comment(String string) {
        this.comment = string;
        return this;
    }

    private DHCP_Service modified_by(Person person) {
        this.modified_by = person;
        return this;
    }

    private DHCP_Service modified_at(Timestamp timestamp) {
        this.modified_at = timestamp;
        return this;
    }

    @Override
    public DHCP_Service unlink() {
        super.unlink();
        this.id = null;
        return this;
    }

    @Override
    public String single_value_attributes() {
        return this.name + " " + this.comment;
    }

    @Override
    protected void initialize_member_data() {
        super.initialize_member_data();
        if (this.name == null) {
            this.name = NetDB.unset_string;
        }
        if (this.comment == null) {
            this.comment = NetDB.unset_string;
        }
        if (this.modified_at == null) {
            this.modified_at = NetDB.unset_timestamp;
        }
        if (this.modified_by == null) {
            this.modified_by = NetDB.unset_person;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        super.flag_field_as_defined(field);
        if (field == Field.NAME) {
            if (NetDB.unset_string.equals(this.name)) {
                this.name = null;
            }
        } else if (field == Field.COMMENT) {
            if (NetDB.unset_string.equals(this.comment)) {
                this.comment = null;
            }
        } else if (field == Field.MODIFIED_AT) {
            if (this.modified_at == NetDB.unset_timestamp) {
                this.modified_at = null;
            }
        } else if (field == Field.MODIFIED_BY && this.modified_by == NetDB.unset_person) {
            this.modified_by = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        super.clear_default_member_data();
        if (NetDB.unset_string.equals(this.name)) {
            this.name = null;
        }
        if (NetDB.unset_string.equals(this.comment)) {
            this.comment = null;
        }
        if (this.modified_at == NetDB.unset_timestamp) {
            this.modified_at = null;
        }
        if (this.modified_by == NetDB.unset_person) {
            this.modified_by = null;
        }
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return Record.toString(fORMAT, template_name, "dhcp_service", this, bl);
    }

    protected static DHCP_Service extract(NetDB_Datastore netDB_Datastore, Hashtable hashtable) {
        DHCP_Service dHCP_Service = new DHCP_Service(netDB_Datastore);
        dHCP_Service.flag_as_system_created();
        dHCP_Service.extract(hashtable);
        return dHCP_Service;
    }

    protected DHCP_Service extract(Hashtable hashtable) {
        if (hashtable == null) {
            return this;
        }
        String string = (String)hashtable.get("id");
        if (string != null) {
            this.id = Integer.parseInt(string);
        }
        hashtable.remove("id");
        this.name = (String)hashtable.get("name");
        hashtable.remove("name");
        this.comment = (String)hashtable.get("comment");
        hashtable.remove("comment");
        NetDB.unhandled_keys(hashtable, "DHCP_Service.extract");
        return this;
    }

    public static Boolean has_access() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(Record_Type.DHCP_SERVICE);
    }

    public static Boolean has_access(User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(user, Record_Type.DHCP_SERVICE);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, Record_Type.DHCP_SERVICE);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, user, Record_Type.DHCP_SERVICE);
    }

    public static Collection<DHCP_Service> list() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return DHCP_Service.list(NetDB.default_datastore());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<DHCP_Service> list(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Vector<DHCP_Service> vector = new Vector<DHCP_Service>();
        Hashtable hashtable = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            hashtable = netDB_Datastore.dhcp_service().list(string);
        }
        finally {
            netDB_Datastore.rollback_transaction(string);
        }
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                DHCP_Service dHCP_Service = DHCP_Service.extract(netDB_Datastore, (Hashtable)hashtable.get(string2));
                dHCP_Service.flag_as_system_created().flag_as_loaded();
                vector.add(dHCP_Service);
            }
        }
        Collections.sort(vector);
        return vector;
    }

    @Override
    protected void load_object(String string) throws Not_Implemented {
        throw new Not_Implemented("This class cannot currently be loaded.");
    }

    @Override
    public void delete(NetDB_Datastore netDB_Datastore) throws Not_Implemented {
        throw new Not_Implemented("This class cannot currently be deleted.");
    }

    public static void delete(String string) throws Not_Implemented {
        DHCP_Service.delete(NetDB.default_datastore(), string);
    }

    public static void delete(NetDB_Datastore netDB_Datastore, String string) throws Not_Implemented {
        throw new Not_Implemented("This class cannot currently be deleted.");
    }

    @Override
    public DHCP_Service commit(NetDB_Datastore netDB_Datastore) throws Not_Implemented {
        throw new Not_Implemented("This class cannot currently be committed.");
    }
}

