/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import stanford.netdb.Admin_Team_FS_Parameters;
import stanford.netdb.Admin_Team_SS_Result;
import stanford.netdb.Attribute;
import stanford.netdb.Comparison_Result;
import stanford.netdb.Department;
import stanford.netdb.Field;
import stanford.netdb.Group;
import stanford.netdb.Lockable;
import stanford.netdb.Multi_Value_Attribute;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Person;
import stanford.netdb.Privilege;
import stanford.netdb.Record_Type;
import stanford.netdb.User;
import stanford.netdb.exceptions.Exception_Formatter;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.exceptions.Record_Not_Found;

public class Admin_Team
extends Lockable<Admin_Team> {
    public static String template_name = "templates/toString/admin_team.tmpl";
    private static final long serialVersionUID = 1L;
    private Integer id = null;
    private String name = null;
    private String email = null;
    private String phone = null;
    private String comment = null;
    private Multi_Value_Attribute<Person> members = null;
    private Multi_Value_Attribute<Department> departments = null;

    public Admin_Team() {
        this.init();
    }

    public Admin_Team(String string, String string2, String string3) {
        this.init(string, string2, string3);
    }

    public Admin_Team(String string, String string2, String string3, String string4) {
        this.init(string, string2, string3, string4);
    }

    public Admin_Team(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
        this.init();
    }

    public Admin_Team(NetDB_Datastore netDB_Datastore, String string, String string2, String string3) {
        super(netDB_Datastore);
        this.init(string, string2, string3);
    }

    public Admin_Team(NetDB_Datastore netDB_Datastore, String string, String string2, String string3, String string4) {
        super(netDB_Datastore);
        this.init(string, string2, string3, string4);
    }

    private void init() {
        this.init(null, null, null, null);
    }

    private void init(String string, String string2, String string3) {
        this.init(string, string2, string3, null);
    }

    private void init(String string, String string2, String string3, String string4) {
        if (string != null) {
            this.name(string);
        }
        if (string2 != null) {
            this.email(string2);
        }
        if (string3 != null) {
            this.phone(string3);
        }
        if (string4 != null) {
            this.comment(string4);
        }
    }

    public Integer id() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.verify_or_die();
        return this.id;
    }

    public String name() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.name, NetDB.unset_string, "name");
        return this.name;
    }

    public String email() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.email, NetDB.unset_string, "email");
        return this.email;
    }

    public String phone() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.phone, NetDB.unset_string, "phone");
        return this.phone;
    }

    public String comment() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.comment, NetDB.unset_string, "comment");
        return this.comment;
    }

    public Collection<Person> members() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.members, NetDB.unset_mva_person, "members");
        if (this.members == null || this.members == NetDB.unset_mva_person) {
            return new Multi_Value_Attribute().all_values();
        }
        return this.members.all_values();
    }

    public Collection<Department> departments() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.departments, NetDB.unset_mva_department, "departments");
        if (this.departments == null || this.departments == NetDB.unset_mva_department) {
            return new Multi_Value_Attribute().all_values();
        }
        return this.departments.all_values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String handle() throws Exception {
        block7: {
            String string = "";
            try {
                NetDB_Datastore.defined_or_die(this.datastore);
                string = this.datastore.start_transaction(NetDB.current_method_name());
                if (this.name != null) break block7;
                if (this.id != null && this.id != NetDB.unset_integer) {
                    this.name = this.datastore.admin_team().handle(string, this.id);
                    if (this.name == null) {
                        throw new Record_Not_Found("ID '" + this.id + "' was not found in the database.");
                    }
                    break block7;
                }
                throw new Insufficient_Information("The handle was not found and could not be loaded.");
            }
            catch (Exception exception) {
            }
            finally {
                this.datastore.rollback_transaction(string);
            }
        }
        return this.name;
    }

    @Override
    protected Admin_Team id(Integer n) {
        this.id = n;
        return this;
    }

    public Admin_Team name(String string) {
        this.name = string;
        return this;
    }

    public Admin_Team email(String string) {
        this.email = string;
        return this;
    }

    public Admin_Team phone(String string) {
        this.phone = string;
        return this;
    }

    public Admin_Team comment(String string) {
        this.comment = string;
        return this;
    }

    public Admin_Team add_member(Person person) {
        if (this.members == null || this.members == NetDB.unset_mva_person) {
            this.members = new Multi_Value_Attribute();
        }
        this.members.add(person);
        return this;
    }

    public Admin_Team add_members(Collection<Person> collection) {
        Iterator<Person> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add_member(iterator.next());
        }
        return this;
    }

    public Admin_Team remove_member(Person person) {
        if (this.members != null) {
            this.members.remove(person);
        }
        return this;
    }

    public Admin_Team remove_members(Collection<Person> collection) {
        Iterator<Person> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.remove_member(iterator.next());
        }
        return this;
    }

    public Admin_Team add_department(Department department) {
        if (this.departments == null || this.departments == NetDB.unset_mva_department) {
            this.departments = new Multi_Value_Attribute();
        }
        this.departments.add(department);
        return this;
    }

    public Admin_Team add_departments(Collection<Department> collection) {
        Iterator<Department> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add_department(iterator.next());
        }
        return this;
    }

    public Admin_Team remove_department(Department department) {
        if (this.departments != null) {
            this.departments.remove(department, (Boolean)true);
        }
        return this;
    }

    public Admin_Team remove_departments(Collection<Department> collection) {
        Iterator<Department> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.remove_department(iterator.next());
        }
        return this;
    }

    @Override
    public Admin_Team bind(NetDB_Datastore netDB_Datastore) throws No_Datastore_Defined {
        super.bind(netDB_Datastore);
        this.bind_children(this.members, netDB_Datastore);
        this.bind_children(this.departments, netDB_Datastore);
        return this;
    }

    @Override
    public Admin_Team unbind() {
        super.unbind();
        this.unbind_children(this.members);
        this.unbind_children(this.departments);
        return this;
    }

    @Override
    public Admin_Team unlink() {
        super.unlink();
        this.unlink_children(this.members);
        this.unlink_children(this.departments);
        this.id = null;
        return this;
    }

    @Override
    public String single_value_attributes() {
        return this.name + " " + this.email + " " + this.phone + " " + this.comment;
    }

    @Override
    protected void initialize_member_data() {
        super.initialize_member_data();
        if (this.name == null) {
            this.name = NetDB.unset_string;
        }
        if (this.email == null) {
            this.email = NetDB.unset_string;
        }
        if (this.phone == null) {
            this.phone = NetDB.unset_string;
        }
        if (this.comment == null) {
            this.comment = NetDB.unset_string;
        }
        if (this.members == null) {
            this.members = NetDB.unset_mva_person;
        }
        if (this.departments == null) {
            this.departments = NetDB.unset_mva_department;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        super.flag_field_as_defined(field);
        if (field == Field.NAME) {
            if (NetDB.unset_string.equals(this.name)) {
                this.name = null;
            }
        } else if (field == Field.EMAIL) {
            if (NetDB.unset_string.equals(this.email)) {
                this.email = null;
            }
        } else if (field == Field.PHONE) {
            if (NetDB.unset_string.equals(this.phone)) {
                this.phone = null;
            }
        } else if (field == Field.COMMENT) {
            if (NetDB.unset_string.equals(this.comment)) {
                this.comment = null;
            }
        } else if (field == Field.MEMBER) {
            if (this.members == NetDB.unset_mva_person) {
                this.members = null;
            }
        } else if (field == Field.DEPARTMENT && this.departments == NetDB.unset_mva_department) {
            this.departments = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        super.clear_default_member_data();
        if (NetDB.unset_string.equals(this.name)) {
            this.name = null;
        }
        if (NetDB.unset_string.equals(this.email)) {
            this.email = null;
        }
        if (NetDB.unset_string.equals(this.phone)) {
            this.phone = null;
        }
        if (NetDB.unset_string.equals(this.comment)) {
            this.comment = null;
        }
        if (this.members == NetDB.unset_mva_person) {
            this.members = null;
        }
        if (this.departments == NetDB.unset_mva_department) {
            this.departments = null;
        }
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return Lockable.toString(fORMAT, template_name, "admin_team", this, bl);
    }

    protected static Admin_Team extract(NetDB_Datastore netDB_Datastore, Hashtable hashtable) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Admin_Team admin_Team = new Admin_Team(netDB_Datastore);
        admin_Team.flag_as_system_created();
        admin_Team.extract(hashtable);
        return admin_Team;
    }

    @Override
    protected Admin_Team extract(Hashtable hashtable) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Object object;
        Enumeration enumeration;
        Object object2;
        Object object3;
        if (hashtable == null) {
            return this;
        }
        this.groups = new Multi_Value_Attribute();
        this.members = new Multi_Value_Attribute();
        this.departments = new Multi_Value_Attribute();
        super.extract(hashtable);
        this.name((String)hashtable.get("name"));
        hashtable.remove("name");
        this.email((String)hashtable.get("email"));
        hashtable.remove("email");
        this.phone((String)hashtable.get("phone"));
        hashtable.remove("phone");
        this.comment((String)hashtable.get("comment"));
        hashtable.remove("comment");
        Hashtable hashtable2 = (Hashtable)hashtable.get("groups");
        if (hashtable2 != null) {
            object3 = hashtable2.keys();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                enumeration = new Group(this.datastore, (String)object2);
                ((NetDB)((Object)enumeration)).flag_as_system_created();
                this.add_owner((Group)((Object)enumeration));
            }
        }
        hashtable.remove("groups");
        object3 = (Hashtable)hashtable.get("departments");
        if (object3 != null) {
            object2 = ((Hashtable)object3).keys();
            while (object2.hasMoreElements()) {
                enumeration = (String)object2.nextElement();
                object = new Department(this.datastore, (String)((Object)enumeration));
                ((NetDB)object).flag_as_system_created();
                this.add_department((Department)object);
            }
        }
        hashtable.remove("departments");
        object2 = (Hashtable)hashtable.get("members");
        if (object2 != null) {
            enumeration = ((Hashtable)object2).keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                this.add_member(Person.extract(this.datastore, (Hashtable)((Hashtable)object2).get(object)));
            }
        }
        hashtable.remove("members");
        hashtable.remove("id");
        NetDB.unhandled_keys(hashtable, "Admin_Team.extract");
        return this;
    }

    private void verify_or_die() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.id = this.verify_or_die(this.handle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer verify_or_die(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.datastore == null) {
            this.datastore = this.get_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        if (this.id != null && this.id != NetDB.unset_integer) {
            return this.id;
        }
        String string2 = "";
        try {
            string2 = this.datastore.start_transaction(NetDB.current_method_name());
            Integer n = this.datastore.admin_team().verify_or_die(string2, string);
            return n;
        }
        finally {
            this.datastore.rollback_transaction(string2);
        }
    }

    public static Boolean has_access() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(Record_Type.ADMIN_TEAM);
    }

    public static Boolean has_access(User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(user, Record_Type.ADMIN_TEAM);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, Record_Type.ADMIN_TEAM);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, User user) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Privilege.has_access(netDB_Datastore, user, Record_Type.ADMIN_TEAM);
    }

    public static Boolean has_access(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Admin_Team.has_access(null, null, string);
    }

    public static Boolean has_access(User user, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Admin_Team.has_access(null, user, string);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Admin_Team.has_access(netDB_Datastore, null, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean has_access(NetDB_Datastore netDB_Datastore, User user, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (netDB_Datastore == null) {
            netDB_Datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        if (user == null && (user = netDB_Datastore.operating_user()) == null) {
            throw new Insufficient_Information("A user must be specified, or an operating user must be set.");
        }
        Integer n = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            n = netDB_Datastore.admin_team().verify_or_die(string2, string);
        }
        catch (Exception exception) {
            Boolean bl = false;
            return bl;
        }
        finally {
            netDB_Datastore.rollback_transaction(string2);
        }
        if (Admin_Team.has_access(netDB_Datastore, user).booleanValue() && Group.has_access(netDB_Datastore, user.id(), Record_Type.ADMIN_TEAM.toString(), n).booleanValue()) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Timestamp lock_record() throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        this.verify_or_die();
        Boolean bl = null;
        String string = "";
        try {
            string = this.datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            Hashtable hashtable = this.datastore.admin_team().lock_record(string, this.id);
            this.lock((Timestamp)hashtable.get("locked"));
            this.locked_by(this.datastore.operating_user().id());
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    this.datastore.rollback_transaction(string);
                } else {
                    this.datastore.end_transaction(string);
                }
            }
        }
        return this.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Admin_Team unlock() throws Exception, No_Datastore_Defined {
        NetDB_Datastore.defined_or_die(this.datastore);
        Boolean bl = null;
        String string = "";
        try {
            string = this.datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            this.datastore.admin_team().unlock_record(string, this.lock(), this.id);
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    this.datastore.rollback_transaction(string);
                } else {
                    this.datastore.end_transaction(string);
                }
            }
        }
        this.lock(null);
        this.locked_by(null);
        return this;
    }

    public static Admin_Team load(Boolean bl, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return Admin_Team.load(NetDB.default_datastore(), bl, string);
    }

    public static Admin_Team load(NetDB_Datastore netDB_Datastore, Boolean bl, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        Admin_Team admin_Team = new Admin_Team(netDB_Datastore);
        admin_Team.name(string);
        if (bl.booleanValue()) {
            admin_Team.lock_record();
        }
        admin_Team.load_object(string);
        return admin_Team;
    }

    public static Admin_Team load(String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        return Admin_Team.load(NetDB.default_datastore(), string);
    }

    public static Admin_Team load(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        Admin_Team admin_Team = new Admin_Team(netDB_Datastore);
        admin_Team.load_object(string);
        return admin_Team;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void load_object(String string) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        if ((string == null || string.trim().equals("")) && this.id == null) {
            throw Insufficient_Information.missing_handle();
        }
        String string2 = "";
        try {
            string2 = this.datastore.start_transaction(NetDB.current_method_name());
            this.id = this.verify_or_die(string);
            Hashtable hashtable = this.datastore.admin_team().info(string2, this.id);
            this.extract(hashtable);
            this.flag_as_system_created().flag_as_loaded();
        }
        finally {
            this.datastore.rollback_transaction(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Boolean bl = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            this.verify_or_die();
            netDB_Datastore.admin_team().delete(string, this.lock(), this.id);
            this.flag_as_modified().flag_as_user_created();
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
    }

    public static void delete(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Admin_Team.delete(NetDB.default_datastore(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Boolean bl = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            Admin_Team admin_Team = new Admin_Team(netDB_Datastore);
            admin_Team.name(string);
            admin_Team.lock_record();
            admin_Team.delete();
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string2);
                } else {
                    netDB_Datastore.end_transaction(string2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Admin_Team commit(NetDB_Datastore netDB_Datastore, Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        this.bind(netDB_Datastore);
        Admin_Team admin_Team = null;
        Boolean bl2 = null;
        String string = "";
        try {
            int n;
            Object object;
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            bl2 = false;
            if (this.created_by_user().booleanValue()) {
                admin_Team = new Admin_Team();
                object = netDB_Datastore.admin_team().insert(string, this.name, this.email, this.phone, this.comment);
                this.id = new Integer((String)((Hashtable)object).get("id"));
                super.lock((Timestamp)((Hashtable)object).get("locked"));
                super.locked_by(netDB_Datastore.operating_user().id());
            } else {
                admin_Team = Admin_Team.load(netDB_Datastore, netDB_Datastore.admin_team().handle(string, this.id));
                netDB_Datastore.admin_team().update(string, this.lock(), this.id, this.name, this.email, this.phone, this.comment);
            }
            object = this.handle();
            Timestamp timestamp = this.lock();
            Comparison_Result comparison_Result = Multi_Value_Attribute.compare_for_commit(this.groups, admin_Team.groups, Attribute.COMPARISON_TYPE.UNIQUE_IDENTIFER);
            Comparison_Result comparison_Result2 = Multi_Value_Attribute.compare_for_commit(this.members, admin_Team.members);
            Comparison_Result comparison_Result3 = Multi_Value_Attribute.compare_for_commit(this.departments, admin_Team.departments, Attribute.COMPARISON_TYPE.UNIQUE_IDENTIFER);
            Vector vector = comparison_Result.only_in_set1();
            Vector vector2 = comparison_Result.only_in_set2();
            Vector vector3 = comparison_Result2.only_in_set1();
            Vector vector4 = comparison_Result2.only_in_set2();
            Vector vector5 = comparison_Result3.only_in_set1();
            Vector vector6 = comparison_Result3.only_in_set2();
            for (n = 0; n < vector.size(); ++n) {
                netDB_Datastore.owner().add(string, timestamp, ((Group)vector.get(n)).handle(), this.id, Record_Type.ADMIN_TEAM.toString());
            }
            for (n = 0; n < vector2.size(); ++n) {
                netDB_Datastore.owner().remove(string, timestamp, ((Group)vector2.get(n)).handle(), this.id, Record_Type.ADMIN_TEAM.toString());
            }
            for (n = 0; n < vector3.size(); ++n) {
                netDB_Datastore.admin_team().member(string, "add", timestamp, this.id, ((Person)vector3.get(n)).id());
            }
            for (n = 0; n < vector4.size(); ++n) {
                netDB_Datastore.admin_team().member(string, "remove", timestamp, this.id, ((Person)vector4.get(n)).id());
            }
            for (n = 0; n < vector5.size(); ++n) {
                netDB_Datastore.admin_team().org(string, "add", timestamp, this.id, ((Department)vector5.get(n)).id());
            }
            for (n = 0; n < vector6.size(); ++n) {
                netDB_Datastore.admin_team().org(string, "remove", timestamp, this.id, ((Department)vector6.get(n)).id());
            }
            netDB_Datastore.admin_team().verify_and_log(string, this.id);
            this.flag_as_system_created().flag_as_loaded();
            bl2 = true;
        }
        finally {
            if (bl2 != null) {
                if (!bl2.booleanValue()) {
                    netDB_Datastore.rollback_transaction(string);
                } else {
                    netDB_Datastore.end_transaction(string);
                }
            }
        }
        if (bl.booleanValue()) {
            try {
                this.unlock();
            }
            catch (Exception exception) {
                this.logger.warning("Unlock exception: " + Exception_Formatter.stack_trace(exception));
            }
        }
        return this;
    }

    public static Collection<Admin_Team_SS_Result> search() throws Exception, No_Datastore_Defined {
        return Admin_Team.search(NetDB.default_datastore(), null);
    }

    public static Collection<Admin_Team_SS_Result> search(String string) throws Exception, No_Datastore_Defined {
        return Admin_Team.search(NetDB.default_datastore(), string);
    }

    public static Collection<Admin_Team_SS_Result> search(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined {
        return Admin_Team.search(netDB_Datastore, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Admin_Team_SS_Result> search(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined {
        if (netDB_Datastore == null) {
            netDB_Datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        Hashtable hashtable = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            hashtable = string != null ? netDB_Datastore.simple_search().get_ateams(string2, string) : netDB_Datastore.simple_search().get_ateams(string2);
        }
        finally {
            netDB_Datastore.rollback_transaction(string2);
        }
        Vector<Admin_Team_SS_Result> vector = new Vector<Admin_Team_SS_Result>();
        for (String string3 : hashtable.keySet()) {
            vector.add(new Admin_Team_SS_Result(string3));
        }
        Collections.sort(vector, new Admin_Team_SS_Result(""));
        return vector;
    }

    public static Collection<Admin_Team> full_search(Admin_Team_FS_Parameters admin_Team_FS_Parameters) throws Exception {
        return Admin_Team.full_search(NetDB.default_datastore(), admin_Team_FS_Parameters);
    }

    public static Collection<Admin_Team> full_search(NetDB_Datastore netDB_Datastore, Admin_Team_FS_Parameters admin_Team_FS_Parameters) throws Exception {
        return admin_Team_FS_Parameters.search(netDB_Datastore);
    }
}

