/*
 * Decompiled with CFR 0.152.
 */
package stanford.netdb;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import stanford.netdb.Attribute;
import stanford.netdb.Comparison_Result;
import stanford.netdb.DHCP_Setting;
import stanford.netdb.Defaults;
import stanford.netdb.Field;
import stanford.netdb.Group;
import stanford.netdb.IP.IPaddress;
import stanford.netdb.IP.Prefix;
import stanford.netdb.IP_Address;
import stanford.netdb.IP_Pool;
import stanford.netdb.Multi_Value_Attribute;
import stanford.netdb.NetDB;
import stanford.netdb.NetDB_Datastore;
import stanford.netdb.Network;
import stanford.netdb.Record_Type;
import stanford.netdb.User;
import stanford.netdb.exceptions.Exception_Formatter;
import stanford.netdb.exceptions.Insufficient_Information;
import stanford.netdb.exceptions.No_Datastore_Defined;
import stanford.netdb.exceptions.Record_Not_Found;

public class Address_Space
extends NetDB<Address_Space> {
    public static String template_name = "templates/toString/address_space.tmpl";
    private static final long serialVersionUID = 1L;
    protected static final Address_Space EMPTY = new Address_Space();
    private Integer id = null;
    private Prefix prefix = null;
    private BigInteger low_res = null;
    private BigInteger high_res = null;
    private String comment = null;
    private Multi_Value_Attribute<IP_Pool> pools = null;
    private Multi_Value_Attribute<DHCP_Setting> settings = null;
    private Multi_Value_Attribute<Group> groups = null;
    private Network parent = null;

    public Address_Space() {
        this.init();
    }

    protected Address_Space(Prefix prefix) {
        this.init(prefix);
    }

    public Address_Space(String string, BigInteger bigInteger, BigInteger bigInteger2) throws Exception {
        this(new Prefix(string), bigInteger, bigInteger2);
    }

    public Address_Space(Prefix prefix, BigInteger bigInteger, BigInteger bigInteger2) {
        this.init(prefix, bigInteger, bigInteger2);
    }

    public Address_Space(String string, Integer n, Integer n2) throws Exception {
        this(new Prefix(string), n, n2);
    }

    public Address_Space(Prefix prefix, Integer n, Integer n2) {
        this.init(prefix, n, n2);
    }

    public Address_Space(String string, BigInteger bigInteger, BigInteger bigInteger2, String string2) throws Exception {
        this(new Prefix(string), bigInteger, bigInteger2, string2);
    }

    public Address_Space(Prefix prefix, BigInteger bigInteger, BigInteger bigInteger2, String string) {
        this.init(prefix, bigInteger, bigInteger2, string);
    }

    public Address_Space(String string, Integer n, Integer n2, String string2) throws Exception {
        this(new Prefix(string), n, n2, string2);
    }

    public Address_Space(Prefix prefix, Integer n, Integer n2, String string) {
        this.init(prefix, n, n2, string);
    }

    public Address_Space(NetDB_Datastore netDB_Datastore) {
        super(netDB_Datastore);
        this.init();
    }

    protected Address_Space(NetDB_Datastore netDB_Datastore, Prefix prefix) {
        super(netDB_Datastore);
        this.init(prefix);
    }

    public Address_Space(NetDB_Datastore netDB_Datastore, String string, BigInteger bigInteger, BigInteger bigInteger2) throws Exception {
        this(netDB_Datastore, new Prefix(string), bigInteger, bigInteger2);
    }

    public Address_Space(NetDB_Datastore netDB_Datastore, Prefix prefix, BigInteger bigInteger, BigInteger bigInteger2) {
        super(netDB_Datastore);
        this.init(prefix, bigInteger, bigInteger2);
    }

    public Address_Space(NetDB_Datastore netDB_Datastore, String string, Integer n, Integer n2) throws Exception {
        this(netDB_Datastore, new Prefix(string), n, n2);
    }

    public Address_Space(NetDB_Datastore netDB_Datastore, Prefix prefix, Integer n, Integer n2) {
        super(netDB_Datastore);
        this.init(prefix, n, n2);
    }

    public Address_Space(NetDB_Datastore netDB_Datastore, String string, BigInteger bigInteger, BigInteger bigInteger2, String string2) throws Exception {
        this(netDB_Datastore, new Prefix(string), bigInteger, bigInteger2, string2);
    }

    public Address_Space(NetDB_Datastore netDB_Datastore, Prefix prefix, BigInteger bigInteger, BigInteger bigInteger2, String string) {
        super(netDB_Datastore);
        this.init(prefix, bigInteger, bigInteger2, string);
    }

    public Address_Space(NetDB_Datastore netDB_Datastore, String string, Integer n, Integer n2, String string2) throws Exception {
        this(netDB_Datastore, new Prefix(string), n, n2, string2);
    }

    public Address_Space(NetDB_Datastore netDB_Datastore, Prefix prefix, Integer n, Integer n2, String string) {
        super(netDB_Datastore);
        this.init(prefix, n, n2, string);
    }

    private void init() {
        this.init(null, (BigInteger)null, (BigInteger)null, null);
    }

    private void init(Prefix prefix) {
        this.init(prefix, (BigInteger)null, (BigInteger)null, null);
    }

    private void init(Prefix prefix, BigInteger bigInteger, BigInteger bigInteger2) {
        this.init(prefix, bigInteger, bigInteger2, null);
    }

    private void init(Prefix prefix, Integer n, Integer n2) {
        this.init(prefix, n, n2, null);
    }

    private void init(Prefix prefix, BigInteger bigInteger, BigInteger bigInteger2, String string) {
        if (prefix != null) {
            this.prefix(prefix);
        }
        if (bigInteger != null) {
            this.low_res(bigInteger);
        }
        if (bigInteger2 != null) {
            this.high_res(bigInteger2);
        }
        if (string != null) {
            this.comment(string);
        }
    }

    private void init(Prefix prefix, Integer n, Integer n2, String string) {
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        if (n != null) {
            bigInteger = new BigInteger(n.toString());
        }
        if (n2 != null) {
            bigInteger2 = new BigInteger(n2.toString());
        }
        this.init(prefix, bigInteger, bigInteger2, string);
    }

    public Integer id() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.verify_or_die();
        return this.id;
    }

    public Prefix prefix() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.prefix, NetDB.unset_prefix, "prefix");
        return this.prefix;
    }

    public BigInteger low_res() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.low_res, NetDB.unset_biginteger, "low_res");
        return this.low_res;
    }

    public BigInteger high_res() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.high_res, NetDB.unset_biginteger, "high_res");
        return this.high_res;
    }

    public String comment() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.comment, NetDB.unset_string, "comment");
        return this.comment;
    }

    public Collection<IP_Pool> pools() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.pools, NetDB.unset_mva_ip_pool, "pools");
        if (this.pools == null || this.pools == NetDB.unset_mva_ip_pool) {
            return new Multi_Value_Attribute().all_values();
        }
        return this.pools.all_values();
    }

    public Collection<DHCP_Setting> DHCP_settings() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return this.dhcp_settings();
    }

    public Collection<DHCP_Setting> dhcp_settings() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.settings, NetDB.unset_mva_dhcp_setting, "settings");
        if (this.settings == null || this.settings == NetDB.unset_mva_dhcp_setting) {
            return new Multi_Value_Attribute().all_values();
        }
        return this.settings.all_values();
    }

    public Collection<Group> get_acl() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.internal_complete(this.groups, NetDB.unset_mva_group, "groups");
        if (this.groups == null || this.groups == NetDB.unset_mva_group) {
            return new Multi_Value_Attribute().all_values();
        }
        return this.groups.all_values();
    }

    @Override
    public String handle() {
        return this.prefix.toString();
    }

    protected Network parent() {
        return this.parent;
    }

    protected Timestamp lock() {
        if (this.parent != null) {
            return this.parent.lock();
        }
        return null;
    }

    protected Address_Space id(Integer n) {
        this.id = n;
        return this;
    }

    public Address_Space prefix(Prefix prefix) {
        this.prefix = prefix;
        return this;
    }

    public Address_Space low_res(BigInteger bigInteger) {
        this.low_res = bigInteger;
        return this;
    }

    public Address_Space high_res(BigInteger bigInteger) {
        this.high_res = bigInteger;
        return this;
    }

    public Address_Space comment(String string) {
        this.comment = string;
        return this;
    }

    public Address_Space add_pool(IP_Pool iP_Pool) {
        if (this.pools == null || this.pools == NetDB.unset_mva_ip_pool) {
            this.pools = new Multi_Value_Attribute();
        }
        this.pools.add(iP_Pool);
        return this;
    }

    public Address_Space add_pools(Collection<IP_Pool> collection) {
        Iterator<IP_Pool> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add_pool(iterator.next());
        }
        return this;
    }

    public Address_Space remove_pool(IP_Pool iP_Pool) {
        if (this.pools != null) {
            this.pools.remove(iP_Pool);
        }
        return this;
    }

    public Address_Space remove_pools(Collection<IP_Pool> collection) {
        Iterator<IP_Pool> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.remove_pool(iterator.next());
        }
        return this;
    }

    public Address_Space add_DHCP_setting(DHCP_Setting dHCP_Setting) {
        return this.add_dhcp_setting(dHCP_Setting);
    }

    public Address_Space add_dhcp_setting(DHCP_Setting dHCP_Setting) {
        if (this.settings == null || this.settings == NetDB.unset_mva_dhcp_setting) {
            this.settings = new Multi_Value_Attribute();
        }
        this.settings.add(dHCP_Setting);
        return this;
    }

    public Address_Space add_DHCP_settings(Collection<DHCP_Setting> collection) {
        return this.add_dhcp_settings(collection);
    }

    public Address_Space add_dhcp_settings(Collection<DHCP_Setting> collection) {
        Iterator<DHCP_Setting> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add_dhcp_setting(iterator.next());
        }
        return this;
    }

    public Address_Space remove_DHCP_setting(DHCP_Setting dHCP_Setting) {
        return this.remove_dhcp_setting(dHCP_Setting);
    }

    public Address_Space remove_dhcp_setting(DHCP_Setting dHCP_Setting) {
        if (this.settings != null) {
            this.settings.remove(dHCP_Setting, (Boolean)true);
        }
        return this;
    }

    public Address_Space remove_DHCP_settings(Collection<DHCP_Setting> collection) {
        return this.remove_dhcp_settings(collection);
    }

    public Address_Space remove_dhcp_settings(Collection<DHCP_Setting> collection) {
        Iterator<DHCP_Setting> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.remove_dhcp_setting(iterator.next());
        }
        return this;
    }

    public Address_Space grant_access(Group group) {
        if (this.groups == null || this.groups == NetDB.unset_mva_group) {
            this.groups = new Multi_Value_Attribute();
        }
        this.groups.add(group);
        return this;
    }

    public Address_Space grant_access(Collection<Group> collection) {
        Iterator<Group> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.grant_access(iterator.next());
        }
        return this;
    }

    public Address_Space revoke_access(Group group) {
        if (this.groups != null) {
            this.groups.remove(group, (Boolean)true);
        }
        return this;
    }

    public Address_Space revoke_access(Collection<Group> collection) {
        Iterator<Group> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.revoke_access(iterator.next());
        }
        return this;
    }

    protected Address_Space parent(Network network) {
        this.parent = network;
        return this;
    }

    @Override
    public Address_Space bind(NetDB_Datastore netDB_Datastore) throws No_Datastore_Defined {
        super.bind(netDB_Datastore);
        this.bind_children(this.pools, netDB_Datastore);
        this.bind_children(this.settings, netDB_Datastore);
        this.bind_children(this.groups, netDB_Datastore);
        return this;
    }

    @Override
    public Address_Space unbind() {
        super.unbind();
        this.unbind_children(this.pools);
        this.unbind_children(this.settings);
        this.unbind_children(this.groups);
        return this;
    }

    @Override
    public Address_Space unlink() {
        super.unlink();
        this.unlink_children(this.pools);
        this.unlink_children(this.settings);
        this.unlink_children(this.groups);
        this.id = null;
        return this;
    }

    @Override
    public String single_value_attributes() {
        String string = "";
        if (this.prefix != null) {
            string = this.prefix.toString();
        }
        return string + " " + this.low_res + " " + this.high_res + " " + this.comment;
    }

    @Override
    protected void initialize_member_data() {
        if (this.prefix == null) {
            this.prefix = NetDB.unset_prefix;
        }
        if (this.low_res == null) {
            this.low_res = NetDB.unset_biginteger;
        }
        if (this.high_res == null) {
            this.high_res = NetDB.unset_biginteger;
        }
        if (this.comment == null) {
            this.comment = NetDB.unset_string;
        }
        if (this.pools == null) {
            this.pools = NetDB.unset_mva_ip_pool;
        }
        if (this.settings == null) {
            this.settings = NetDB.unset_mva_dhcp_setting;
        }
        if (this.groups == null) {
            this.groups = NetDB.unset_mva_group;
        }
    }

    @Override
    protected void flag_field_as_defined(Field field) {
        if (field == Field.PREFIX) {
            if (this.prefix == NetDB.unset_prefix) {
                this.prefix = null;
            }
        } else if (field == Field.LOW_RES) {
            if (this.low_res == NetDB.unset_biginteger) {
                this.low_res = null;
            }
        } else if (field == Field.HIGH_RES) {
            if (this.high_res == NetDB.unset_biginteger) {
                this.high_res = null;
            }
        } else if (field == Field.COMMENT) {
            if (NetDB.unset_string.equals(this.comment)) {
                this.comment = null;
            }
        } else if (field == Field.POOL) {
            if (this.pools == NetDB.unset_mva_ip_pool) {
                this.pools = null;
            }
        } else if (field == Field.DHCP_SETTING) {
            if (this.settings == NetDB.unset_mva_dhcp_setting) {
                this.settings = null;
            }
        } else if (field == Field.OWNER && this.groups == NetDB.unset_mva_group) {
            this.groups = null;
        }
    }

    @Override
    protected void clear_default_member_data() {
        if (this.prefix == NetDB.unset_prefix) {
            this.prefix = null;
        }
        if (this.low_res == NetDB.unset_biginteger) {
            this.low_res = null;
        }
        if (this.high_res == NetDB.unset_biginteger) {
            this.high_res = null;
        }
        if (NetDB.unset_string.equals(this.comment)) {
            this.comment = null;
        }
        if (this.pools == NetDB.unset_mva_ip_pool) {
            this.pools = null;
        }
        if (this.settings == NetDB.unset_mva_dhcp_setting) {
            this.settings = null;
        }
        if (this.groups == NetDB.unset_mva_group) {
            this.groups = null;
        }
    }

    @Override
    protected Address_Space flag_as_user_created() {
        super.flag_as_user_created();
        if (this.pools != null) {
            for (IP_Pool iP_Pool : this.pools.all_values(true)) {
                iP_Pool.flag_as_user_created();
            }
        }
        return this;
    }

    @Override
    protected Address_Space flag_as_modified() {
        super.flag_as_modified();
        if (this.pools != null) {
            for (IP_Pool iP_Pool : this.pools.all_values(true)) {
                iP_Pool.flag_as_modified();
            }
        }
        return this;
    }

    @Override
    protected Address_Space flag_as_system_created() {
        super.flag_as_system_created();
        if (this.pools != null) {
            for (IP_Pool iP_Pool : this.pools.all_values(true)) {
                iP_Pool.flag_as_system_created();
            }
        }
        return this;
    }

    @Override
    protected Address_Space flag_as_loaded() {
        super.flag_as_loaded();
        if (this.pools != null) {
            for (IP_Pool iP_Pool : this.pools.all_values(true)) {
                iP_Pool.flag_as_loaded();
            }
        }
        return this;
    }

    @Override
    public String toString(NetDB.FORMAT fORMAT, Boolean bl) throws Exception {
        return NetDB.toString(fORMAT, template_name, "address_space", this, bl);
    }

    protected static Address_Space extract(NetDB_Datastore netDB_Datastore, Hashtable hashtable) {
        Address_Space address_Space = new Address_Space(netDB_Datastore);
        address_Space.flag_as_system_created();
        address_Space.extract(hashtable);
        return address_Space;
    }

    protected Address_Space extract(Hashtable hashtable) {
        Object object;
        Object object2;
        Object object3;
        if (hashtable == null) {
            return this;
        }
        this.pools = new Multi_Value_Attribute();
        this.settings = new Multi_Value_Attribute();
        this.groups = new Multi_Value_Attribute();
        this.id((Integer)hashtable.get("id"));
        hashtable.remove("id");
        this.low_res = (BigInteger)hashtable.get("low_res");
        hashtable.remove("low_res");
        this.high_res = (BigInteger)hashtable.get("high_res");
        hashtable.remove("high_res");
        this.comment = (String)hashtable.get("comment");
        hashtable.remove("comment");
        String string = (String)hashtable.get("addr_space_prefix");
        if (string == null) {
            string = (String)hashtable.get("prefix");
        }
        try {
            this.prefix = new Prefix(string);
        }
        catch (Exception exception) {
            this.logger().fine(Exception_Formatter.stack_trace(exception));
        }
        if (this.id == null && string != null && !string.equals("")) {
            try {
                this.id = this.verify_or_die(string);
            }
            catch (Exception exception) {
                this.logger().fine(Exception_Formatter.stack_trace(exception));
            }
        }
        hashtable.remove("prefix");
        hashtable.remove("addr_space_prefix");
        Hashtable hashtable2 = (Hashtable)hashtable.get("groups");
        if (hashtable2 != null) {
            object3 = hashtable2.keys();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                object = new Group(this.datastore, (String)object2);
                ((NetDB)object).flag_as_system_created();
                this.grant_access((Group)object);
            }
        }
        hashtable.remove("groups");
        object3 = (Hashtable)hashtable.get("dhcp_options");
        if (object3 != null) {
            object2 = ((Hashtable)object3).keys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                this.add_dhcp_setting(DHCP_Setting.extract(this.datastore, (Hashtable)((Hashtable)object3).get(object)));
            }
        }
        hashtable.remove("dhcp_options");
        object2 = (Hashtable)hashtable.get("dhcp_addresses");
        if (object2 != null) {
            object = IP_Pool.extract(this.datastore, (Hashtable)object2);
            ((IP_Pool)object).id(this.id);
            this.add_pool((IP_Pool)object);
        }
        hashtable.remove("dhcp_addresses");
        hashtable.remove("ip_addr_space");
        hashtable.remove("str_ip_address");
        hashtable.remove("addr_space_ip");
        hashtable.remove("prefix_length");
        NetDB.unhandled_keys(hashtable, "Address_Space.extract");
        return this;
    }

    private void verify_or_die() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.id = this.verify_or_die(this.handle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer verify_or_die(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (this.datastore == null) {
            this.datastore = this.get_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        if (this.id != null && this.id != NetDB.unset_integer) {
            return this.id;
        }
        String string2 = "";
        try {
            string2 = this.datastore.start_transaction(NetDB.current_method_name());
            Integer n = this.datastore.address_space().verify_or_die(string2, string);
            return n;
        }
        finally {
            this.datastore.rollback_transaction(string2);
        }
    }

    public static Boolean has_access(String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Address_Space.has_access(null, null, string);
    }

    public static Boolean has_access(User user, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Address_Space.has_access(null, user, string);
    }

    public static Boolean has_access(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Address_Space.has_access(netDB_Datastore, null, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean has_access(NetDB_Datastore netDB_Datastore, User user, String string) throws Exception, No_Datastore_Defined, Insufficient_Information {
        if (netDB_Datastore == null) {
            netDB_Datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        if (user == null && (user = netDB_Datastore.operating_user()) == null) {
            throw new Insufficient_Information("A user must be specified, or an operating user must be set.");
        }
        Integer n = null;
        Integer n2 = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            n = netDB_Datastore.address_space().verify_or_die(string2, string);
            n2 = netDB_Datastore.address_space().get_parent_id(string2, n);
        }
        catch (Exception exception) {
            Boolean bl = false;
            return bl;
        }
        finally {
            netDB_Datastore.rollback_transaction(string2);
        }
        if (Network.has_access(netDB_Datastore, user).booleanValue() && Group.has_access(netDB_Datastore, user.id(), Record_Type.ADDRESS_SPACE.toString(), n).booleanValue()) {
            return true;
        }
        return false;
    }

    @Override
    protected Address_Space complete_object() throws Exception, No_Datastore_Defined, Insufficient_Information {
        this.load_object(this.id());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load_object(Integer n) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        if (this.datastore == null) {
            this.datastore = NetDB.default_datastore();
        }
        NetDB_Datastore.defined_or_die(this.datastore);
        if (n == null) {
            throw Insufficient_Information.missing_information("ID");
        }
        String string = "";
        try {
            string = this.datastore.start_transaction(NetDB.current_method_name());
            Hashtable hashtable = this.datastore.address_space().info(string, n);
            this.flag_as_system_created();
            this.extract(hashtable);
            this.flag_as_loaded();
        }
        finally {
            this.datastore.rollback_transaction(string);
        }
    }

    public static Collection<Address_Space> list() throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Address_Space.list(NetDB.default_datastore());
    }

    public static Collection<Address_Space> list(Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Address_Space.list(NetDB.default_datastore(), bl);
    }

    public static Collection<Address_Space> list(NetDB_Datastore netDB_Datastore) throws Exception, No_Datastore_Defined, Insufficient_Information {
        return Address_Space.list(netDB_Datastore, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Address_Space> list(NetDB_Datastore netDB_Datastore, Boolean bl) throws Exception, No_Datastore_Defined, Insufficient_Information {
        Integer n = null;
        if (!bl.booleanValue() && netDB_Datastore.operating_user() != null) {
            n = netDB_Datastore.operating_user().id();
        }
        Vector<Address_Space> vector = new Vector<Address_Space>();
        Hashtable hashtable = null;
        String string = "";
        try {
            string = netDB_Datastore.start_transaction(NetDB.current_method_name());
            hashtable = n != null ? netDB_Datastore.address_space().list(string, n) : netDB_Datastore.address_space().list(string);
        }
        finally {
            netDB_Datastore.rollback_transaction(string);
        }
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                Address_Space address_Space = Address_Space.extract(netDB_Datastore, (Hashtable)hashtable.get(string2));
                vector.add(address_Space);
            }
        }
        Collections.sort(vector);
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Address_Space move(Network network) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        NetDB_Datastore.defined_or_die(this.datastore);
        Boolean bl = null;
        String string = "";
        try {
            string = this.datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            this.verify_or_die();
            this.datastore.address_space().move(string, this.lock(), this.id, network.id(), network.lock());
            Boolean bl2 = this.parent.has_been_loaded();
            Boolean bl3 = network.has_been_loaded();
            this.parent.remove_address_space(this);
            network.add_address_space(this);
            if (bl2.booleanValue()) {
                this.parent.flag_as_loaded();
            }
            if (bl3.booleanValue()) {
                network.flag_as_loaded();
            }
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    this.datastore.rollback_transaction(string);
                } else {
                    this.datastore.end_transaction(string);
                }
            }
        }
        return this;
    }

    public Collection<Address_Space> resize(Integer n) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        Collection<Address_Space> collection = null;
        if (this.prefix.prefix_length() > n) {
            collection = new Vector<Address_Space>();
            collection.add(this.join(n));
        } else if (this.prefix.prefix_length() < n) {
            collection = this.split(n);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Address_Space join(Integer n) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        NetDB_Datastore.defined_or_die(this.datastore);
        Prefix prefix = new Prefix(this.prefix.address().toString(), n);
        Address_Space address_Space = new Address_Space(this.datastore, prefix, Defaults.DefaultLowRes(this.datastore), Defaults.DefaultHighRes(this.datastore));
        Boolean bl = null;
        String string = "";
        try {
            string = this.datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            this.datastore.address_space().validate_join(string, prefix.toString(), this.parent.id());
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    this.datastore.rollback_transaction(string);
                } else {
                    this.datastore.end_transaction(string);
                }
            }
        }
        Vector vector = (Vector)this.parent.address_spaces();
        Network network = this.parent;
        for (int i = 0; i < vector.size(); ++i) {
            Address_Space address_Space2 = (Address_Space)vector.get(i);
            Prefix prefix2 = address_Space2.prefix();
            if (!prefix.contains(prefix2.address()) || !prefix.contains(prefix2.broadcast())) continue;
            address_Space.grant_access(address_Space2.get_acl());
            address_Space.add_dhcp_settings(address_Space2.dhcp_settings());
            address_Space.add_pools(address_Space2.pools());
            if (address_Space2.comment() != null) {
                address_Space.comment(address_Space.comment() + address_Space2.comment());
            }
            if (prefix.address().compareTo(prefix2.address()) == 0) {
                address_Space.low_res(address_Space2.low_res());
            }
            if (prefix.broadcast().compareTo(prefix2.broadcast()) == 0) {
                address_Space.high_res(address_Space2.high_res());
            }
            network.remove_address_space(address_Space2);
        }
        network.add_address_space(address_Space);
        return address_Space;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Address_Space> split(Integer n) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        Object object;
        int n2;
        Object object2;
        NetDB_Datastore.defined_or_die(this.datastore);
        Object object3 = new Vector<Prefix>();
        ((Vector)object3).add(this.prefix);
        int n3 = n;
        for (int i = this.prefix.prefix_length(); i < n3; ++i) {
            object2 = new Vector();
            for (n2 = 0; n2 < ((Vector)object3).size(); ++n2) {
                object = ((Prefix)((Vector)object3).get(n2)).split();
                for (int j = 0; j < ((Prefix[])object).length; ++j) {
                    ((Vector)object2).add(object[j]);
                }
            }
            object3 = object2;
        }
        Boolean bl = null;
        object2 = "";
        try {
            object2 = this.datastore.start_transaction(NetDB.current_method_name());
            bl = false;
            for (n2 = 0; n2 < ((Vector)object3).size(); ++n2) {
                this.datastore.address_space().validate_split((String)object2, ((Prefix)((Vector)object3).get(n2)).toString());
            }
            bl = true;
        }
        finally {
            if (bl != null) {
                if (!bl.booleanValue()) {
                    this.datastore.rollback_transaction((String)object2);
                } else {
                    this.datastore.end_transaction((String)object2);
                }
            }
        }
        IPaddress iPaddress = this.prefix.address();
        object = this.prefix.broadcast();
        Vector<Address_Space> vector = new Vector<Address_Space>();
        for (int i = 0; i < ((Vector)object3).size(); ++i) {
            Prefix prefix = (Prefix)((Vector)object3).get(i);
            Address_Space address_Space = new Address_Space(this.datastore, prefix, Defaults.DefaultLowRes(this.datastore), Defaults.DefaultHighRes(this.datastore));
            if (prefix.address().compareTo(iPaddress) == 0) {
                address_Space.low_res(this.low_res);
            }
            if (prefix.broadcast().compareTo(object) == 0) {
                address_Space.high_res(this.high_res);
            }
            address_Space.grant_access(this.get_acl());
            address_Space.add_dhcp_settings(this.dhcp_settings());
            address_Space.comment(this.comment);
            vector.add(address_Space);
        }
        Vector vector2 = (Vector)this.pools.all_values();
        for (int i = 0; i < vector2.size(); ++i) {
            int n4 = 0;
            IP_Pool iP_Pool = (IP_Pool)vector2.get(i);
            IP_Pool iP_Pool2 = null;
            Vector vector3 = (Vector)iP_Pool.addresses();
            for (int j = 0; j < vector3.size(); ++j) {
                IP_Address iP_Address = (IP_Address)vector3.get(j);
                boolean bl2 = false;
                while (!vector.get(n4).prefix().contains(iP_Address.address())) {
                    iP_Pool2 = null;
                    if (++n4 <= vector.size()) continue;
                    if (bl2) {
                        throw new Exception("Unable to find a prefix containing the address '" + iP_Address.toString() + "'.");
                    }
                    n4 = 0;
                    bl2 = true;
                }
                if (iP_Pool2 == null) {
                    iP_Pool2 = new IP_Pool(this.datastore, iP_Pool.comment());
                    iP_Pool2.add_dhcp_settings(iP_Pool.dhcp_settings());
                    vector.get(n4).add_pool(iP_Pool2);
                }
                iP_Pool2.add_address(iP_Address);
            }
        }
        this.parent.add_address_spaces(vector);
        this.parent.remove_address_space(this);
        return vector;
    }

    public static Address_Space containing(IP_Address iP_Address) throws Exception, No_Datastore_Defined {
        return Address_Space.containing(NetDB.default_datastore(), iP_Address);
    }

    public static Address_Space containing(String string) throws Exception, No_Datastore_Defined {
        return Address_Space.containing(NetDB.default_datastore(), string);
    }

    public static Address_Space containing(NetDB_Datastore netDB_Datastore, IP_Address iP_Address) throws Exception, No_Datastore_Defined {
        return Address_Space.containing(netDB_Datastore, iP_Address.address().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Address_Space containing(NetDB_Datastore netDB_Datastore, String string) throws Exception, No_Datastore_Defined {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        if (string == null || string.trim().equals("")) {
            return null;
        }
        Integer n = null;
        String string2 = "";
        try {
            string2 = netDB_Datastore.start_transaction(NetDB.current_method_name());
            n = netDB_Datastore.address_space().containing(string2, string);
        }
        finally {
            netDB_Datastore.rollback_transaction(string2);
        }
        Address_Space address_Space = new Address_Space();
        address_Space.load_object(n);
        return address_Space;
    }

    protected void delete(String string, Timestamp timestamp) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        this.delete(string, this.get_datastore(), timestamp);
    }

    protected void delete(String string, NetDB_Datastore netDB_Datastore, Timestamp timestamp) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        NetDB_Datastore.defined_or_die(netDB_Datastore);
        this.verify_or_die();
        netDB_Datastore.address_space().delete(string, timestamp, this.id);
        this.flag_as_modified().flag_as_user_created();
    }

    protected void delete_children(String string, Address_Space address_Space, Timestamp timestamp) throws Exception, No_Datastore_Defined, Insufficient_Information {
        int n;
        Comparison_Result comparison_Result = Multi_Value_Attribute.compare_for_commit(this.pools, address_Space.pools);
        Vector vector = comparison_Result.only_in_set2();
        Vector vector2 = comparison_Result.both_sets();
        for (n = 0; n < vector2.size(); ++n) {
            ((IP_Pool)vector2.get(n)).delete_children(string, (IP_Pool)comparison_Result.both_sets_alternate(n), timestamp);
        }
        for (n = 0; n < vector.size(); ++n) {
            ((IP_Pool)vector.get(n)).delete(string, timestamp);
        }
    }

    protected void commit(String string, NetDB_Datastore netDB_Datastore, Address_Space address_Space, Integer n, Timestamp timestamp) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        this.bind(netDB_Datastore);
        if (this.prefix == null) {
            throw new Insufficient_Information("Address spaces must have a prefix.");
        }
        Integer n2 = null;
        Integer n3 = null;
        if (this.low_res != null) {
            n2 = new Integer(this.low_res.toString());
        }
        if (this.high_res != null) {
            n3 = new Integer(this.high_res.toString());
        }
        if (address_Space == EMPTY) {
            Hashtable hashtable = netDB_Datastore.address_space().insert(string, timestamp, this.prefix.toString(), n, this.comment, n2, n3);
            this.id = new Integer((String)hashtable.get("id"));
        } else if (this.compare(address_Space) != 0) {
            netDB_Datastore.address_space().update(string, timestamp, this.id, this.prefix.toString(), n, timestamp, this.comment, n2, n3);
        }
        this.commit_children(string, netDB_Datastore, address_Space, n, timestamp);
    }

    protected void commit_children(String string, NetDB_Datastore netDB_Datastore, Address_Space address_Space, Integer n, Timestamp timestamp) throws Exception, No_Datastore_Defined, Insufficient_Information, Record_Not_Found {
        int n2;
        Serializable serializable;
        Serializable serializable2;
        int n3;
        Serializable serializable3;
        int n4;
        Comparison_Result comparison_Result = Multi_Value_Attribute.compare_for_commit(this.pools, address_Space.pools);
        Vector vector = comparison_Result.only_in_set1();
        Vector vector2 = comparison_Result.both_sets();
        for (n4 = 0; n4 < vector.size(); ++n4) {
            serializable3 = (IP_Pool)vector.get(n4);
            ((IP_Pool)serializable3).id(this.id);
            ((IP_Pool)serializable3).commit(string, netDB_Datastore, IP_Pool.EMPTY, n, timestamp);
        }
        for (n4 = 0; n4 < vector2.size(); ++n4) {
            serializable3 = (IP_Pool)vector2.get(n4);
            ((IP_Pool)serializable3).id(this.id);
            ((IP_Pool)serializable3).commit(string, netDB_Datastore, (IP_Pool)comparison_Result.both_sets_alternate(n4), n, timestamp);
        }
        Comparison_Result comparison_Result2 = Multi_Value_Attribute.compare_for_commit(this.settings, address_Space.settings);
        serializable3 = comparison_Result2.only_in_set1();
        Vector vector3 = comparison_Result2.only_in_set2();
        Vector vector4 = comparison_Result2.both_sets();
        for (n3 = 0; n3 < vector3.size(); ++n3) {
            netDB_Datastore.dhcp_option().remove(string, timestamp, this.id, Record_Type.ADDRESS_SPACE.toString(), ((DHCP_Setting)vector3.get(n3)).handle());
        }
        for (n3 = 0; n3 < ((Vector)serializable3).size(); ++n3) {
            netDB_Datastore.dhcp_option().add(string, timestamp, this.id, Record_Type.ADDRESS_SPACE.toString(), ((DHCP_Setting)((Vector)serializable3).get(n3)).handle(), ((DHCP_Setting)((Vector)serializable3).get(n3)).value());
        }
        for (n3 = 0; n3 < vector4.size(); ++n3) {
            serializable2 = (DHCP_Setting)vector4.get(n3);
            serializable = (DHCP_Setting)comparison_Result2.both_sets_alternate(n3);
            String string2 = ((DHCP_Setting)serializable2).value();
            String string3 = ((DHCP_Setting)serializable).value();
            if (string2 == null || string3 == null || string2.equals(string3)) continue;
            netDB_Datastore.dhcp_option().remove(string, timestamp, this.id, Record_Type.ADDRESS_SPACE.toString(), ((DHCP_Setting)serializable2).handle());
            netDB_Datastore.dhcp_option().add(string, timestamp, this.id, Record_Type.ADDRESS_SPACE.toString(), ((DHCP_Setting)serializable).handle(), string3);
        }
        Comparison_Result comparison_Result3 = Multi_Value_Attribute.compare_for_commit(this.groups, address_Space.groups, Attribute.COMPARISON_TYPE.UNIQUE_IDENTIFER);
        serializable2 = comparison_Result3.only_in_set1();
        serializable = comparison_Result3.only_in_set2();
        for (n2 = 0; n2 < ((Vector)serializable).size(); ++n2) {
            netDB_Datastore.owner().remove(string, timestamp, ((Group)((Vector)serializable).get(n2)).handle(), this.id, Record_Type.ADDRESS_SPACE.toString());
        }
        for (n2 = 0; n2 < ((Vector)serializable2).size(); ++n2) {
            netDB_Datastore.owner().add(string, timestamp, ((Group)((Vector)serializable2).get(n2)).handle(), this.id, Record_Type.ADDRESS_SPACE.toString());
        }
    }
}

