[[_TOC_]]

# Overview

The `check_cert_chain_expiration` Nagios plugin checks all the
certificates in a certificate chain sent by a TLS-enable service and looks
for the certificate in that chain that is expiring soonest. If that
soonest-expiring certificate is expired or is expiring within the warn or
critical time period limits, the plugin alerts appropriately. See the
usage string below for how to set the warn or critical limits.

# Usage string

```
check_cert_chain_expiration v1.1
This plugin tests the expiration of ALL certificates in the chain
from a live site.

Usage:
   check_cert_chain_expiration -H <host> [-p <port>] [-w <warn time>] [-c <critical time>]

Options:
   -h, --help
      Print detailed help screen
   -V, --version
       Print version information
   -H, --host
      Hostname to query (REQUIRED)
   -p, --port
       SSL port to use (defaults to 443)
   -c, --critical
       Maximum age before sending a CRITICAL (in seconds) (defaults to one month)
   -w, --warn
       Maximum age before sending a WARN (in seconds) (defaults to two months)

Note:
   1. If no certificates are returned this test returns UNKNOWN.
   2. The server MUST support SNI.

Examples:

   # Send WARNING if any certificate in the certificate chain is within
   # 3 weeks of expiring, and send CRITICAL if any certificate in the
   # certificate chain is within 1 week of expiring.
   #
   # 3 weeks = 1,814,400 seconds
   # 1 week  =   604,800 seconds
   check_cert_chain_expiration -H example.com -w 1814400 -c 604800

   # Use defalts for WARNING and CRITICAL but use port 8443 rather than the
   # default of 443.
   check_cert_chain_expiration -H example.com -p 8443
```

# Example Nagios settings

## Define the Nagios command

(This will only be done once per Nagios instance.)  We define the commands
to call the `check_cert_chain_expiration` plugin:
```
define command {
    command_name    check_cert_chain_expiration
    command_line    $USER1$/check_cert_chain_expiration -H $HOSTADDRESS$ $ARG1$
}

# Use this command if you need to explicitly specify the host.
define command {
    command_name    check_cert_chain_expiration_1
    command_line    $USER1$/check_cert_chain_expiration -H $ARG1$ $ARG2$
}
```

## Defining a service check

Here is an example Nagios service definition; certificates don't expire suddenly, so
we check the certificate chain for expiration only once every 2 hours (120 minutes):
```
define service {
    use                 default-service-template
    hostgroup_name      all-web-servers
    service_description certificate chain expiration check
    check_command       check_cert_chain_expiration!-p 443
    check_interval      120
    contact_groups      webserver-contactgroup
}
```
